/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class WithQueryCommand
implements LanguageObject,
SubqueryContainer<QueryCommand> {
    private GroupSymbol groupSymbol;
    private List<ElementSymbol> columns;
    private QueryCommand queryExpression;

    public WithQueryCommand(GroupSymbol groupSymbol, List<ElementSymbol> columns, QueryCommand queryExpression) {
        this.groupSymbol = groupSymbol;
        this.columns = columns;
        this.queryExpression = queryExpression;
    }

    public GroupSymbol getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setColumns(List<ElementSymbol> columns) {
        this.columns = columns;
    }

    public List<ElementSymbol> getColumns() {
        return this.columns;
    }

    @Override
    public QueryCommand getCommand() {
        return this.queryExpression;
    }

    @Override
    public void setCommand(QueryCommand command) {
        this.queryExpression = command;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public WithQueryCommand clone() {
        return new WithQueryCommand(this.groupSymbol.clone(), LanguageObject.Util.deepClone(this.columns, ElementSymbol.class), (QueryCommand)this.queryExpression.clone());
    }

    public int hashCode() {
        return this.groupSymbol.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WithQueryCommand)) {
            return false;
        }
        WithQueryCommand other = (WithQueryCommand)obj;
        return EquivalenceUtil.areEqual((Object)this.groupSymbol, (Object)other.getGroupSymbol()) && EquivalenceUtil.areEqual(this.columns, other.getColumns()) && EquivalenceUtil.areEqual((Object)this.queryExpression, (Object)other.queryExpression);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

