/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.xml.DocumentInProgress;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;

public class AddCommentInstruction
extends ProcessorInstruction {
    private String commentText;

    public AddCommentInstruction(String commentText) {
        this.commentText = commentText;
    }

    @Override
    public XMLContext process(XMLProcessorEnvironment env, XMLContext context) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        DocumentInProgress doc = env.getDocumentInProgress();
        doc.addComment(this.commentText);
        LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"COMMENT"});
        env.incrementCurrentProgramCounter();
        return context;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("COMMENT");
        return str.toString();
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("COMMENT");
        props.addProperty("Message", this.commentText);
        return props;
    }
}

