/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingCommentNode;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.processor.xml.AddCommentInstruction;
import org.teiid.query.processor.xml.AddNodeInstruction;
import org.teiid.query.processor.xml.NodeDescriptor;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.sql.symbol.ElementSymbol;

public class TagBuilderVisitor
extends MappingVisitor {
    ProcessorInstruction tag;

    @Override
    public void visit(MappingAttribute attribute) {
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor(attribute);
        if (attribute.getNameInSource() != null) {
            ElementSymbol symbol = attribute.getElementSymbol();
            this.tag = new AddNodeInstruction(descriptor, symbol);
        } else {
            this.tag = new AddNodeInstruction(descriptor);
        }
    }

    @Override
    public void visit(MappingCommentNode comment) {
        this.tag = new AddCommentInstruction(comment.getComment());
    }

    @Override
    public void visit(MappingElement element) {
        this.visitNode(element);
    }

    @Override
    public void visit(MappingRecursiveElement element) {
        this.visitNode(element);
    }

    void visitNode(MappingElement element) {
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor(element);
        if (element.getNameInSource() != null) {
            ElementSymbol symbol = element.getElementSymbol();
            this.tag = new AddNodeInstruction(descriptor, symbol);
        } else {
            this.tag = new AddNodeInstruction(descriptor);
        }
        if (element.isNillable()) {
            NodeDescriptor nillDescriptor = NodeDescriptor.createNillableNode();
            ((AddNodeInstruction)this.tag).setNillableDescriptor(nillDescriptor);
        }
    }

    public static ProcessorInstruction buildTag(MappingNode node) {
        TagBuilderVisitor visitor = new TagBuilderVisitor();
        node.acceptVisitor(visitor);
        return visitor.tag;
    }
}

