/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Navigator;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.xml.QueryUtil;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class SourceNodePlannerVisitor
extends MappingVisitor {
    private XMLPlannerEnvironment planEnv;

    public SourceNodePlannerVisitor(XMLPlannerEnvironment planEnv) {
        this.planEnv = planEnv;
    }

    @Override
    public void visit(MappingSourceNode sourceNode) {
        try {
            String groupName = sourceNode.getResultName();
            GroupSymbol groupSymbol = null;
            GroupSymbol newGroupSymbol = null;
            try {
                groupSymbol = QueryUtil.createResolvedGroup(groupName, (QueryMetadataInterface)this.planEnv.getGlobalMetadata());
                newGroupSymbol = this.createAlternateGroup(groupSymbol, sourceNode);
            }
            catch (QueryMetadataException e) {
                boolean isExcluded = false;
                for (MappingNode current = sourceNode; current != null; current = current.getParent()) {
                    if (!current.isExcluded()) continue;
                    isExcluded = true;
                    break;
                }
                if (!isExcluded) {
                    throw e;
                }
                sourceNode.getParent().getChildren().remove(sourceNode);
                sourceNode.getChildren().clear();
                return;
            }
            String newGroup = newGroupSymbol.getName();
            ResultSetInfo rsInfo = sourceNode.getResultSetInfo();
            Query baseQuery = QueryUtil.wrapQuery(new UnaryFromClause(new GroupSymbol(newGroup)), newGroup);
            baseQuery.getSelect().clearSymbols();
            for (ElementSymbol ses : ResolverUtil.resolveElementsInGroup(groupSymbol, this.planEnv.getGlobalMetadata())) {
                baseQuery.getSelect().addSymbol(new ElementSymbol(newGroup + "." + ses.getShortName()));
            }
            rsInfo.setCommand(baseQuery);
            QueryNode modifiedNode = QueryUtil.getQueryNode(newGroup, this.planEnv.getGlobalMetadata());
            Command command = QueryUtil.getQuery(newGroup, modifiedNode, this.planEnv);
            MappingSourceNode parent = sourceNode.getParentSourceNode();
            Collection<ElementSymbol> bindings = QueryUtil.getBindingElements(modifiedNode);
            rsInfo.setInputSet(!bindings.isEmpty());
            if (!(rsInfo.hasInputSet() && this.canRaiseInputset(command, bindings) && this.areBindingsOnlyToNode(modifiedNode, parent))) {
                return;
            }
            Query transformationQuery = (Query)command;
            Criteria criteria = transformationQuery.getCriteria();
            Criteria nonInputsetCriteria = null;
            Criteria inputSetCriteria = null;
            for (Criteria conjunct : Criteria.separateCriteriaByAnd(criteria)) {
                List<ElementSymbol> references = QueryUtil.getBindingsReferences(conjunct, bindings);
                if (references.isEmpty()) {
                    nonInputsetCriteria = Criteria.combineCriteria(nonInputsetCriteria, conjunct);
                    continue;
                }
                inputSetCriteria = Criteria.combineCriteria(inputSetCriteria, conjunct);
            }
            if (inputSetCriteria == null) {
                return;
            }
            transformationQuery.setCriteria(nonInputsetCriteria);
            boolean addedProjectedSymbol = this.convertCriteria(newGroupSymbol, transformationQuery, inputSetCriteria, this.planEnv.getGlobalMetadata(), sourceNode.getSymbolMap());
            if (addedProjectedSymbol && transformationQuery.getSelect().isDistinct()) {
                transformationQuery.getSelect().setDistinct(false);
                baseQuery.getSelect().setDistinct(true);
            }
            String inlineViewName = this.planEnv.getAliasName(newGroup);
            transformationQuery = QueryUtil.wrapQuery(new SubqueryFromClause(inlineViewName, (Command)transformationQuery), inlineViewName);
            QueryNode relationalNode = new QueryNode(SQLStringVisitor.getSQLString(transformationQuery));
            this.planEnv.addQueryNodeToMetadata(newGroupSymbol.getMetadataID(), relationalNode);
            QueryUtil.markBindingsAsNonExternal(inputSetCriteria, bindings);
            baseQuery.setCriteria(inputSetCriteria);
            rsInfo.setCriteriaRaised(true);
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private boolean areBindingsOnlyToNode(QueryNode modifiedNode, MappingSourceNode sourceNode) throws TeiidComponentException {
        List<Expression> bindings = QueryResolver.parseBindings(modifiedNode);
        String nodeStr = sourceNode.getActualResultSetName() + ".";
        for (Expression ses : bindings) {
            ElementSymbol binding;
            if (ses instanceof AliasSymbol) {
                ses = ((AliasSymbol)ses).getSymbol();
            }
            if ((binding = (ElementSymbol)ses).getName().startsWith(nodeStr)) continue;
            return false;
        }
        return true;
    }

    static String getNewName(String groupName, TempMetadataStore store) {
        int index = 1;
        String newGroup = null;
        do {
            newGroup = (groupName + "_" + index++).toUpperCase();
        } while (store.getData().containsKey(newGroup));
        return newGroup;
    }

    private GroupSymbol createAlternateGroup(GroupSymbol oldSymbol, MappingSourceNode sourceNode) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(oldSymbol, this.planEnv.getGlobalMetadata());
        TempMetadataStore store = this.planEnv.getGlobalMetadata().getMetadataStore();
        String newGroup = SourceNodePlannerVisitor.getNewName(oldSymbol.getName(), store);
        GroupSymbol newGroupSymbol = new GroupSymbol(newGroup);
        newGroupSymbol.setMetadataID(store.addTempGroup(newGroup, elements));
        sourceNode.setSymbolMap(QueryUtil.createSymbolMap(oldSymbol, newGroup, elements));
        QueryNode oldQueryNode = QueryUtil.getQueryNode(oldSymbol.getName(), this.planEnv.getGlobalMetadata());
        QueryNode modifiedNode = new QueryNode(oldQueryNode.getQuery());
        SourceNodePlannerVisitor.mapBindings(sourceNode, oldQueryNode, modifiedNode);
        this.planEnv.addQueryNodeToMetadata(newGroupSymbol.getMetadataID(), modifiedNode);
        return newGroupSymbol;
    }

    static void mapBindings(MappingSourceNode sourceNode, QueryNode oldQueryNode, QueryNode modifiedNode) throws TeiidComponentException {
        if (oldQueryNode.getBindings() != null) {
            ArrayList<String> bindings = new ArrayList<String>();
            for (Expression ses : QueryResolver.parseBindings(oldQueryNode)) {
                String name = Symbol.getName(ses);
                boolean useName = false;
                if (ses instanceof AliasSymbol) {
                    ses = ((AliasSymbol)ses).getSymbol();
                    useName = true;
                }
                ElementSymbol es = (ElementSymbol)ses;
                if (!useName) {
                    bindings.add(sourceNode.getMappedSymbol(es).toString());
                    continue;
                }
                bindings.add(new AliasSymbol(name, sourceNode.getMappedSymbol(es)).toString());
            }
            modifiedNode.setBindings(bindings);
        }
    }

    private boolean canRaiseInputset(Command command, Collection<ElementSymbol> bindings) {
        if (!(command instanceof Query)) {
            return false;
        }
        Query query = (Query)command;
        Criteria crit = query.getCriteria();
        if (crit != null && (query.getGroupBy() != null || query.getHaving() != null || query.getLimit() != null)) {
            return false;
        }
        query.setCriteria(null);
        query.setOrderBy(null);
        List<ElementSymbol> references = QueryUtil.getBindingsReferences(query, bindings);
        query.setCriteria(crit);
        return references.isEmpty();
    }

    private boolean convertCriteria(GroupSymbol newGroupSymbol, Query transformationQuery, Criteria criteria, TempMetadataAdapter metadata, Map symbolMap) {
        String groupName = newGroupSymbol.getName();
        Collection<ElementSymbol> elementsInCriteria = ElementCollectorVisitor.getElements((LanguageObject)criteria, true);
        HashMap<ElementSymbol, ElementSymbol> mappedElements = new HashMap<ElementSymbol, ElementSymbol>();
        List<Expression> projectedSymbols = transformationQuery.getProjectedSymbols();
        boolean addedProjectedSymbol = false;
        for (ElementSymbol symbol : elementsInCriteria) {
            if (symbol.isExternalReference()) continue;
            if (projectedSymbols.contains(symbol)) {
                mappedElements.put(symbol, new ElementSymbol(groupName + "." + symbol.getShortName()));
                continue;
            }
            AliasSymbol alias = this.getMachingAlias(projectedSymbols, symbol);
            if (alias != null) {
                mappedElements.put(symbol, new ElementSymbol(groupName + "." + alias.getShortName()));
                continue;
            }
            String name = SourceNodePlannerVisitor.getNewSymbolName(newGroupSymbol.getName(), symbol, symbolMap);
            AliasSymbol selectSymbol = new AliasSymbol(name, symbol);
            transformationQuery.getSelect().addSymbol(selectSymbol);
            addedProjectedSymbol = true;
            metadata.getMetadataStore().addElementSymbolToTempGroup(newGroupSymbol.getName(), selectSymbol);
            ElementSymbol upperSymbol = new ElementSymbol(groupName + "." + selectSymbol.getShortName());
            mappedElements.put(symbol, upperSymbol);
            symbolMap.put(upperSymbol, upperSymbol);
        }
        ExpressionMappingVisitor.mapExpressions(criteria, mappedElements);
        return addedProjectedSymbol;
    }

    static String getNewSymbolName(String newGroupName, ElementSymbol elementSymbol, Map symbolMap) {
        int index = 1;
        String newSymbolName = elementSymbol.getShortName();
        while (symbolMap.values().contains(new ElementSymbol(newGroupName + "." + newSymbolName))) {
            newSymbolName = elementSymbol.getShortName() + "_" + index++;
        }
        return newSymbolName;
    }

    private AliasSymbol getMachingAlias(List<Expression> elementsInGroup, ElementSymbol symbol) {
        for (Expression element : elementsInGroup) {
            AliasSymbol alias;
            if (!(element instanceof AliasSymbol) || !(alias = (AliasSymbol)element).getSymbol().equals(symbol)) continue;
            return alias;
        }
        return null;
    }

    public static MappingDocument raiseInputSet(MappingDocument doc, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        SourceNodePlannerVisitor real = new SourceNodePlannerVisitor(planEnv);
        SourceNodePlannerVisitor.planWalk(doc, real);
        return doc;
    }

    private static void planWalk(MappingDocument doc, MappingVisitor visitor) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        try {
            Navigator walker = new Navigator(true, visitor){

                @Override
                protected void walkChildNodes(MappingNode element) {
                    ArrayList<MappingNode> children = new ArrayList<MappingNode>(element.getNodeChildren());
                    Iterator i = children.iterator();
                    while (i.hasNext() && !this.shouldAbort()) {
                        MappingNode node = (MappingNode)i.next();
                        node.acceptVisitor(this);
                    }
                }
            };
            doc.acceptVisitor(walker);
        }
        catch (TeiidRuntimeException e) {
            if (e.getCause() instanceof QueryPlannerException) {
                throw (QueryPlannerException)((Object)e.getCause());
            }
            if (e.getCause() instanceof QueryMetadataException) {
                throw (QueryMetadataException)((Object)e.getCause());
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            throw e;
        }
    }
}

