/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.util.CommandContext;

public class RulePlanUnions
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        this.optimizeUnions(plan, metadata, capabilitiesFinder);
        return plan;
    }

    private void optimizeUnions(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder) throws QueryMetadataException, TeiidComponentException {
        for (PlanNode unionNode : NodeEditor.findAllNodes(plan, 256, 257)) {
            List<PlanNode> accessNodes = NodeEditor.findAllNodes(unionNode, 1);
            Object id = this.getModelId(metadata, accessNodes, capabilitiesFinder);
            if (id != null) continue;
            LinkedHashMap<Object, List<PlanNode>> sourceNodes = new LinkedHashMap<Object, List<PlanNode>>();
            boolean all = unionNode.hasBooleanProperty(NodeConstants.Info.USE_ALL);
            SetQuery.Operation op = (SetQuery.Operation)((Object)unionNode.getProperty(NodeConstants.Info.SET_OPERATION));
            this.collectUnionSources(metadata, capabilitiesFinder, unionNode, sourceNodes, all, op);
            if (sourceNodes.size() == 1) continue;
            boolean shouldRebuild = false;
            for (Map.Entry entry : sourceNodes.entrySet()) {
                if (entry.getKey() == null || ((List)entry.getValue()).size() <= 1 || !CapabilitiesUtil.supportsSetOp(entry.getKey(), (SetQuery.Operation)((Object)unionNode.getProperty(NodeConstants.Info.SET_OPERATION)), metadata, capabilitiesFinder)) continue;
                shouldRebuild = true;
                break;
            }
            if (!shouldRebuild) continue;
            LinkedList<PlanNode> sourceUnions = new LinkedList<PlanNode>();
            for (Map.Entry entry : sourceNodes.entrySet()) {
                List sources = (List)entry.getValue();
                sourceUnions.add(RulePlanUnions.buildUnionTree(unionNode, sources));
            }
            PlanNode tempRoot = RulePlanUnions.buildUnionTree(unionNode, sourceUnions);
            unionNode.removeAllChildren();
            unionNode.addChildren(tempRoot.removeAllChildren());
        }
    }

    static PlanNode buildUnionTree(PlanNode rootUnionNode, List<PlanNode> sources) {
        PlanNode root = null;
        for (PlanNode source : sources) {
            if (root == null) {
                root = source;
                continue;
            }
            PlanNode union = NodeFactory.getNewNode(256);
            union.setProperty(NodeConstants.Info.SET_OPERATION, rootUnionNode.getProperty(NodeConstants.Info.SET_OPERATION));
            union.setProperty(NodeConstants.Info.USE_ALL, rootUnionNode.getProperty(NodeConstants.Info.USE_ALL));
            union.addLastChild(root);
            union.addLastChild(source);
            root = union;
        }
        return root;
    }

    private void collectUnionSources(QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, PlanNode unionNode, Map<Object, List<PlanNode>> sourceNodes, boolean all, SetQuery.Operation setOp) throws QueryMetadataException, TeiidComponentException {
        for (PlanNode child : unionNode.getChildren()) {
            Object id;
            List<PlanNode> accessNodes;
            if (child.getType() == 256) {
                if (!all && SetQuery.Operation.UNION == child.getProperty(NodeConstants.Info.SET_OPERATION)) {
                    child.setProperty(NodeConstants.Info.USE_ALL, Boolean.TRUE);
                }
                if ((!all || child.hasBooleanProperty(NodeConstants.Info.USE_ALL)) && setOp.equals(child.getProperty(NodeConstants.Info.SET_OPERATION)) && setOp != SetQuery.Operation.EXCEPT) {
                    accessNodes = NodeEditor.findAllNodes(child, 1);
                    id = this.getModelId(metadata, accessNodes, capabilitiesFinder);
                    if (id != null) {
                        RulePlanUnions.buildModelMap(metadata, capabilitiesFinder, sourceNodes, child, id);
                        continue;
                    }
                    this.collectUnionSources(metadata, capabilitiesFinder, child, sourceNodes, all, setOp);
                    continue;
                }
                this.optimizeUnions(child, metadata, capabilitiesFinder);
                continue;
            }
            accessNodes = NodeEditor.findAllNodes(child, 1);
            id = this.getModelId(metadata, accessNodes, capabilitiesFinder);
            RulePlanUnions.buildModelMap(metadata, capabilitiesFinder, sourceNodes, child, id);
            if (id != null) continue;
            this.optimizeUnions(child, metadata, capabilitiesFinder);
        }
    }

    private Object getModelId(QueryMetadataInterface metadata, List<PlanNode> accessNodes, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        Object modelID = null;
        for (PlanNode accessNode : accessNodes) {
            Object accessModelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
            if (accessModelID == null) {
                return null;
            }
            if (modelID == null) {
                modelID = accessModelID;
            }
            if (CapabilitiesUtil.isSameConnector(modelID, accessModelID, metadata, capFinder)) continue;
            return null;
        }
        return modelID;
    }

    static void buildModelMap(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, Map<Object, List<PlanNode>> accessMap, PlanNode node, Object accessModelID) throws QueryMetadataException, TeiidComponentException {
        List<PlanNode> accessNodes = accessMap.get(accessModelID);
        if (accessNodes == null) {
            for (Map.Entry<Object, List<PlanNode>> entry : accessMap.entrySet()) {
                if (accessModelID != entry.getKey() && !CapabilitiesUtil.isSameConnector(accessModelID, entry.getKey(), metadata, capFinder)) continue;
                accessNodes = entry.getValue();
                break;
            }
            if (accessNodes == null) {
                accessNodes = new ArrayList<PlanNode>();
                accessMap.put(accessModelID, accessNodes);
            }
        }
        accessNodes.add(node);
    }

    public String toString() {
        return "PlanUnions";
    }
}

