/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.aggregate;

import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.function.aggregate.AggregateFunction;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.util.CommandContext;

public class RankingFunction
extends AggregateFunction {
    private int count = 0;
    private int lastCount = 0;
    private AggregateSymbol.Type type;

    public RankingFunction(AggregateSymbol.Type function) {
        this.type = function;
    }

    @Override
    public void reset() {
        this.count = 0;
        this.lastCount = 0;
    }

    @Override
    public void addInputDirect(List<?> tuple, CommandContext commandContext) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException {
        if (this.type == AggregateSymbol.Type.RANK) {
            ++this.count;
        }
    }

    @Override
    public Object getResult(CommandContext commandContext) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException {
        if (this.type == AggregateSymbol.Type.DENSE_RANK) {
            ++this.count;
            return this.count;
        }
        int result = ++this.lastCount;
        this.lastCount = this.count;
        return result;
    }
}

