/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.object.metadata;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.ScriptException;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.query.eval.TeiidScriptEngine;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.object.ObjectConnection;
import org.teiid.translator.object.ObjectExecutionFactory;

public class JavaBeanMetadataProcessor {
    public static final String KEY_ASSOSIATED_WITH_FOREIGN_TABLE = "assosiated_with_table";
    public static final String ENTITYCLASS = "entity_class";
    public static final String GET = "get";
    public static final String IS = "is";
    public static final String VIEWTABLE_SUFFIX = "View";
    public static final String OBJECT_COL_SUFFIX = "Object";
    protected boolean isUpdatable = false;
    private TeiidScriptEngine engine = new TeiidScriptEngine();

    public void getMetadata(MetadataFactory mf, ObjectConnection conn, ObjectExecutionFactory env) {
        Map<String, Class<?>> cacheTypes = conn.getCacheNameClassTypeMapping();
        for (String cacheName : cacheTypes.keySet()) {
            Class<?> type = cacheTypes.get(cacheName);
            String pkField = conn.getPkField(cacheName);
            this.createSourceTable(mf, type, cacheName, pkField);
        }
    }

    private Table createSourceTable(MetadataFactory mf, Class<?> entity, String cacheName, String pkField) {
        Map methods;
        String tableName = this.getTableName(entity);
        Table table = mf.getSchema().getTable(tableName);
        if (table != null) {
            return table;
        }
        table = mf.addTable(tableName);
        table.setSupportsUpdate(this.isUpdateable(entity));
        table.setNameInSource(cacheName);
        table.setProperty(ENTITYCLASS, entity.getName());
        String columnName = tableName + OBJECT_COL_SUFFIX;
        this.addColumn(mf, entity, entity, columnName, "this", Column.SearchType.Unsearchable, table);
        try {
            methods = this.engine.getMethodMap(entity);
        }
        catch (ScriptException e) {
            throw new MetadataException((Throwable)e);
        }
        Method pkMethod = null;
        if (pkField != null && (pkMethod = (Method)methods.get(pkField)) != null) {
            this.addColumn(mf, entity, pkMethod.getReturnType(), pkField, pkField, Column.SearchType.Searchable, table);
        }
        LinkedHashMap methodsToAdd = new LinkedHashMap();
        for (Map.Entry entry : methods.entrySet()) {
            String name = (String)methodsToAdd.get(entry.getValue());
            if (name != null && name.length() <= ((String)entry.getKey()).length() || entry.getValue() == pkMethod || ((Method)entry.getValue()).getDeclaringClass() == Object.class || ((Method)entry.getValue()).getName().equals("toString") || ((Method)entry.getValue()).getName().equals("hashCode") || TypeFacility.getRuntimeType(((Method)entry.getValue()).getReturnType()) == Object.class) continue;
            methodsToAdd.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : methodsToAdd.entrySet()) {
            this.addColumn(mf, entity, ((Method)entry.getKey()).getReturnType(), (String)entry.getValue(), (String)entry.getValue(), Column.SearchType.Unsearchable, table);
        }
        return table;
    }

    protected String getTableName(Class<?> entity) {
        return entity.getSimpleName();
    }

    protected boolean isUpdateable(Class<?> entity) {
        return this.isUpdatable;
    }

    protected boolean isUpdateable(Class<?> entity, String columnName) {
        return this.isUpdatable;
    }

    protected Column addColumn(MetadataFactory mf, Class<?> entity, Class<?> type, String attributeName, String nis, Column.SearchType searchType, Table entityTable) {
        Column c = entityTable.getColumnByName(attributeName);
        if (c != null) {
            return c;
        }
        c = mf.addColumn(attributeName, TypeFacility.getDataTypeName((Class)TypeFacility.getRuntimeType(type)), (ColumnSet)entityTable);
        if (nis != null) {
            c.setNameInSource(nis);
        }
        c.setUpdatable(this.isUpdateable(entity, attributeName));
        c.setSearchType(searchType);
        c.setNativeType(type.getName());
        if (type.isPrimitive()) {
            c.setNullType(BaseColumn.NullType.No_Nulls);
        }
        return c;
    }
}

