/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.object.infinispan;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.teiid.language.AndOr;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Exists;
import org.teiid.language.Expression;
import org.teiid.language.In;
import org.teiid.language.Like;
import org.teiid.language.Literal;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.object.CacheContainerWrapper;
import org.teiid.translator.object.ObjectExecution;
import org.teiid.translator.object.ObjectPlugin;

public final class LuceneSearch {
    public static List<Object> performSearch(Select command, Class<?> type, String cacheName, CacheContainerWrapper cache) throws TranslatorException {
        SearchManager searchManager = Search.getSearchManager((Cache)((Cache)cache.getCache(cacheName)));
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(type).get();
        BooleanJunction junction = queryBuilder.bool();
        boolean createdQueries = LuceneSearch.buildQueryFromWhereClause(command.getWhere(), (BooleanJunction<BooleanJunction>)junction, queryBuilder);
        Query query = null;
        query = createdQueries ? junction.createQuery() : queryBuilder.all().createQuery();
        CacheQuery cacheQuery = searchManager.getQuery(query, new Class[]{type});
        List results = cacheQuery.list();
        if (results == null || results.isEmpty()) {
            return Collections.emptyList();
        }
        return results;
    }

    private static boolean buildQueryFromWhereClause(Condition criteria, BooleanJunction<BooleanJunction> junction, QueryBuilder queryBuilder) throws TranslatorException {
        boolean createdQueries = false;
        BooleanJunction<BooleanJunction> inUse = junction;
        if (criteria instanceof AndOr) {
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Parsing compound criteria."});
            AndOr crit = (AndOr)criteria;
            AndOr.Operator op = crit.getOperator();
            switch (op) {
                case AND: {
                    BooleanJunction leftAnd = queryBuilder.bool();
                    boolean andLeftHasQueries = LuceneSearch.buildQueryFromWhereClause(crit.getLeftCondition(), (BooleanJunction<BooleanJunction>)leftAnd, queryBuilder);
                    BooleanJunction rightAnd = queryBuilder.bool();
                    boolean andRightHasQueries = LuceneSearch.buildQueryFromWhereClause(crit.getRightCondition(), (BooleanJunction<BooleanJunction>)rightAnd, queryBuilder);
                    if (andLeftHasQueries && andRightHasQueries) {
                        leftAnd.must(rightAnd.createQuery());
                        inUse.should(leftAnd.createQuery());
                    } else if (andLeftHasQueries) {
                        inUse.should(leftAnd.createQuery());
                    } else if (andRightHasQueries) {
                        inUse.should(rightAnd.createQuery());
                    }
                    createdQueries = andLeftHasQueries ? andLeftHasQueries : andRightHasQueries;
                    break;
                }
                case OR: {
                    boolean orLeftHasQueries = LuceneSearch.buildQueryFromWhereClause(crit.getLeftCondition(), inUse, queryBuilder);
                    boolean orRightHasQueries = LuceneSearch.buildQueryFromWhereClause(crit.getRightCondition(), inUse, queryBuilder);
                    createdQueries = orLeftHasQueries ? orLeftHasQueries : orRightHasQueries;
                    break;
                }
                default: {
                    String msg = ObjectPlugin.Util.getString("LuceneSearch.invalidOperator", new Object[]{op, "And, Or"});
                    throw new TranslatorException(msg);
                }
            }
        } else if (criteria instanceof Comparison) {
            createdQueries = LuceneSearch.visit((Comparison)criteria, inUse, queryBuilder);
        } else if (criteria instanceof Exists) {
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Parsing EXISTS criteria: NOT IMPLEMENTED YET"});
        } else if (criteria instanceof Like) {
            createdQueries = LuceneSearch.visit((Like)criteria, inUse, queryBuilder);
        } else if (criteria instanceof In) {
            createdQueries = LuceneSearch.visit((In)criteria, inUse, queryBuilder);
        }
        return createdQueries;
    }

    public static boolean visit(Comparison obj, BooleanJunction<BooleanJunction> junction, QueryBuilder queryBuilder) throws TranslatorException {
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Parsing Comparison criteria."});
        Comparison.Operator op = obj.getOperator();
        Expression lhs = obj.getLeftExpression();
        Expression rhs = obj.getRightExpression();
        if (lhs instanceof ColumnReference && rhs instanceof ColumnReference || lhs instanceof Literal && rhs instanceof Literal) {
            return false;
        }
        Object value = null;
        Column mdIDElement = null;
        Literal literal = null;
        if (lhs instanceof ColumnReference) {
            mdIDElement = ((ColumnReference)lhs).getMetadataObject();
            literal = (Literal)rhs;
            value = literal.getValue();
        } else if (rhs instanceof ColumnReference) {
            mdIDElement = ((ColumnReference)rhs).getMetadataObject();
            literal = (Literal)lhs;
            value = literal.getValue();
        }
        if (value == null) {
            String msg = ObjectPlugin.Util.getString("LuceneSearch.unsupportedComparingByNull");
            throw new TranslatorException(msg);
        }
        value = LuceneSearch.escapeReservedChars(value);
        switch (op) {
            case NE: {
                LuceneSearch.createEqualsQuery(mdIDElement, value, false, true, junction, queryBuilder);
                break;
            }
            case EQ: {
                LuceneSearch.createEqualsQuery(mdIDElement, value, true, false, junction, queryBuilder);
                break;
            }
            case GT: {
                LuceneSearch.createRangeAboveQuery(mdIDElement, value, junction, queryBuilder);
                break;
            }
            case LT: {
                LuceneSearch.createRangeBelowQuery(mdIDElement, value, junction, queryBuilder);
                break;
            }
            default: {
                String msg = ObjectPlugin.Util.getString("LuceneSearch.invalidOperator", new Object[]{op, "NE, EQ, GT, LT"});
                throw new TranslatorException(msg);
            }
        }
        return true;
    }

    public static boolean visit(In obj, BooleanJunction<BooleanJunction> junction, QueryBuilder queryBuilder) throws TranslatorException {
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Parsing IN criteria."});
        Expression lhs = obj.getLeftExpression();
        Column mdIDElement = ((ColumnReference)lhs).getMetadataObject();
        List rhsList = obj.getRightExpressions();
        boolean createdQuery = false;
        for (Expression expr : rhsList) {
            if (expr instanceof Literal) {
                Literal literal = (Literal)expr;
                LuceneSearch.createEqualsQuery(mdIDElement, LuceneSearch.escapeReservedChars(literal.getValue()), false, false, junction, queryBuilder);
                createdQuery = true;
                continue;
            }
            String msg = ObjectPlugin.Util.getString("LuceneSearch.Unsupported_expression", new Object[]{expr, "IN"});
            throw new TranslatorException(msg);
        }
        return createdQuery;
    }

    public static boolean visit(Like obj, BooleanJunction<BooleanJunction> junction, QueryBuilder queryBuilder) throws TranslatorException {
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Parsing LIKE criteria."});
        Expression lhs = obj.getLeftExpression();
        Expression rhs = obj.getRightExpression();
        Column c = null;
        Expression literalExp = null;
        if (lhs instanceof ColumnReference) {
            c = ((ColumnReference)lhs).getMetadataObject();
            literalExp = rhs;
        } else {
            c = ((ColumnReference)rhs).getMetadataObject();
            literalExp = lhs;
        }
        String value = null;
        if (!(literalExp instanceof Literal)) {
            String msg = ObjectPlugin.Util.getString("LuceneSearch.Unsupported_expression", new Object[]{literalExp.toString(), "LIKE"});
            throw new TranslatorException(msg);
        }
        value = (String)LuceneSearch.escapeReservedChars(((Literal)literalExp).getValue());
        LuceneSearch.createLikeQuery(c, value.replaceAll("%", ""), junction, queryBuilder);
        return true;
    }

    protected static Object escapeReservedChars(Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        String expr = (String)value;
        StringBuffer sb = new StringBuffer();
        block7: for (int i = 0; i < expr.length(); ++i) {
            char curChar = expr.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    private static Query createEqualsQuery(Column column, Object value, boolean and, boolean not, BooleanJunction<BooleanJunction> junction, QueryBuilder queryBuilder) {
        Query queryKey = queryBuilder.keyword().onField(ObjectExecution.getNameInSource((AbstractMetadataRecord)column)).matching((Object)value.toString()).createQuery();
        if (not) {
            junction.must(queryKey).not();
        } else if (and) {
            junction.must(queryKey);
        } else {
            junction.should(queryKey);
        }
        return queryKey;
    }

    private static Query createRangeAboveQuery(Column column, Object value, BooleanJunction<BooleanJunction> junction, QueryBuilder queryBuilder) {
        Query queryKey = queryBuilder.range().onField(ObjectExecution.getNameInSource((AbstractMetadataRecord)column)).above((Object)value.toString()).excludeLimit().createQuery();
        junction.must(queryKey);
        return queryKey;
    }

    private static Query createRangeBelowQuery(Column column, Object value, BooleanJunction<BooleanJunction> junction, QueryBuilder queryBuilder) {
        Query queryKey = queryBuilder.range().onField(ObjectExecution.getNameInSource((AbstractMetadataRecord)column)).below((Object)value.toString()).excludeLimit().createQuery();
        junction.must(queryKey);
        return queryKey;
    }

    private static Query createLikeQuery(Column column, String value, BooleanJunction<BooleanJunction> junction, QueryBuilder queryBuilder) {
        Query queryKey = queryBuilder.phrase().onField(ObjectExecution.getNameInSource((AbstractMetadataRecord)column)).sentence(value).createQuery();
        junction.should(queryKey);
        return queryKey;
    }
}

