/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.object;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.util.Assertion;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Expression;
import org.teiid.language.In;
import org.teiid.language.Literal;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.object.CacheContainerWrapper;

public class SearchByKey {
    public List<Object> search(Select command, Class<?> rootClass, String cacheName, CacheContainerWrapper cache) throws TranslatorException {
        Condition criterion = command.getWhere();
        ArrayList<Object> results = new ArrayList<Object>();
        if (criterion == null) {
            this.addAll(cache, cacheName, rootClass, results);
            return results;
        }
        if (criterion instanceof Comparison && ((Comparison)criterion).getOperator() == Comparison.Operator.EQ) {
            Comparison obj = (Comparison)criterion;
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Parsing Comparison criteria."});
            Expression rhs = obj.getRightExpression();
            Literal literal = (Literal)rhs;
            Object v = cache.get(cacheName, literal.getValue());
            if (v != null) {
                results.add(v);
            }
        } else {
            Assertion.assertTrue((boolean)(criterion instanceof In), (String)("unexpected condition " + criterion));
            In obj = (In)criterion;
            Assertion.assertTrue((!obj.isNegated() ? 1 : 0) != 0);
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Parsing IN criteria."});
            List rhsList = obj.getRightExpressions();
            for (Expression expr : rhsList) {
                Literal literal = (Literal)expr;
                Object v = cache.get(cacheName, literal.getValue());
                if (v == null) continue;
                results.add(v);
            }
        }
        return results;
    }

    protected void addAll(CacheContainerWrapper cache, String cacheName, Class<?> rootClass, List<Object> results) throws TranslatorException {
        results.addAll(cache.getAll(cacheName));
    }
}

