/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.object;

import java.util.List;
import javax.resource.cci.ConnectionFactory;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.object.ObjectConnection;
import org.teiid.translator.object.ObjectExecution;
import org.teiid.translator.object.SearchByKey;
import org.teiid.translator.object.metadata.JavaBeanMetadataProcessor;

@Translator(name="map-cache", description="Searches a Map for Objects")
public class ObjectExecutionFactory
extends ExecutionFactory<ConnectionFactory, ObjectConnection> {
    public static final int MAX_SET_SIZE = 10000;

    public ObjectExecutionFactory() {
        this.setSourceRequiredForMetadata(false);
        this.setMaxInCriteriaSize(10000);
        this.setMaxDependentInPredicates(1);
        this.setSupportsOrderBy(false);
        this.setSupportsSelectDistinct(false);
        this.setSupportsInnerJoins(false);
        this.setSupportsFullOuterJoins(false);
        this.setSupportsOuterJoins(false);
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, ObjectConnection connection) throws TranslatorException {
        return new ObjectExecution((Select)command, metadata, this, connection, executionContext);
    }

    public boolean supportsInnerJoins() {
        return false;
    }

    public boolean supportsOuterJoins() {
        return false;
    }

    public boolean supportsFullOuterJoins() {
        return false;
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public List<Object> search(Select command, String cacheName, ObjectConnection connection, ExecutionContext executionContext) throws TranslatorException {
        SearchByKey sbk = new SearchByKey();
        Class<?> type = connection.getType(cacheName);
        return sbk.search(command, type, cacheName, connection.getCacheContainer());
    }

    public void getMetadata(MetadataFactory metadataFactory, ObjectConnection connection) throws TranslatorException {
        if (connection != null) {
            JavaBeanMetadataProcessor processor = new JavaBeanMetadataProcessor();
            processor.getMetadata(metadataFactory, connection, this);
        }
    }
}

