/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.object;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.teiid.language.ColumnReference;
import org.teiid.language.DerivedColumn;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.query.eval.TeiidScriptEngine;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.object.ObjectConnection;
import org.teiid.translator.object.ObjectExecutionFactory;

public class ObjectExecution
implements ResultSetExecution {
    private static final String OBJECT_NAME = "o";
    protected Select query;
    protected ObjectConnection connection;
    private ArrayList<CompiledScript> projects;
    private ScriptContext sc = new SimpleScriptContext();
    private static TeiidScriptEngine scriptEngine = new TeiidScriptEngine();
    private Iterator<Object> resultsIt = null;
    private ObjectExecutionFactory factory;
    private ExecutionContext executionContext;

    public ObjectExecution(Select query, RuntimeMetadata metadata, ObjectExecutionFactory factory, ObjectConnection connection, ExecutionContext executionContext) throws TranslatorException {
        this.factory = factory;
        this.query = query;
        this.connection = connection;
        this.executionContext = executionContext;
        this.projects = new ArrayList(query.getDerivedColumns().size());
        for (DerivedColumn dc : query.getDerivedColumns()) {
            ColumnReference cr = (ColumnReference)dc.getExpression();
            String name = null;
            if (cr.getMetadataObject() != null) {
                Column c = cr.getMetadataObject();
                name = ObjectExecution.getNameInSource((AbstractMetadataRecord)c);
            } else {
                name = cr.getName();
            }
            if (name.equalsIgnoreCase("this")) {
                this.projects.add(null);
                continue;
            }
            try {
                this.projects.add(scriptEngine.compile("o." + name));
            }
            catch (ScriptException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
    }

    public void execute() throws TranslatorException {
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"ObjectExecution command:", this.query.toString(), "using connection:", this.connection.getClass().getName()});
        String nameInSource = ObjectExecution.getNameInSource((AbstractMetadataRecord)((NamedTable)this.query.getFrom().get(0)).getMetadataObject());
        List<Object> results = this.factory.search(this.query, nameInSource, this.connection, this.executionContext);
        if (results != null && results.size() > 0) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"ObjectExecution number of returned objects is :", results.size()});
        } else {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"ObjectExecution number of objects returned is : 0"});
            results = Collections.emptyList();
        }
        this.resultsIt = results.iterator();
    }

    public List<Object> next() throws TranslatorException, DataNotAvailableException {
        if (this.resultsIt.hasNext()) {
            ArrayList<Object> r = new ArrayList<Object>(this.projects.size());
            Object o = this.resultsIt.next();
            this.sc.setAttribute(OBJECT_NAME, o, 100);
            for (CompiledScript cs : this.projects) {
                if (cs == null) {
                    r.add(o);
                    continue;
                }
                try {
                    r.add(cs.eval(this.sc));
                }
                catch (ScriptException e) {
                    throw new TranslatorException((Throwable)e);
                }
            }
            return r;
        }
        return null;
    }

    public void close() {
        this.query = null;
        this.connection = null;
        this.resultsIt = null;
    }

    public void cancel() throws TranslatorException {
    }

    public static String getNameInSource(AbstractMetadataRecord c) {
        String name = c.getNameInSource();
        if (name == null || name.trim().isEmpty()) {
            return c.getName();
        }
        return name;
    }
}

