/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.util.Arrays;
import java.util.Properties;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.ConnectionProfile;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.net.ServerConnection;

public class EmbeddedProfile
implements ConnectionProfile {
    public static final String USE_CALLING_THREAD = "useCallingThread";
    public static final String WAIT_FOR_LOAD = "waitForLoad";
    public static final String TRANSPORT_NAME = "transportName";

    @Override
    public ConnectionImpl connect(String url, Properties info) throws TeiidSQLException {
        try {
            ServerConnection sc = this.createServerConnection(info);
            return new ConnectionImpl(sc, info, url);
        }
        catch (TeiidRuntimeException e) {
            throw TeiidSQLException.create(e);
        }
        catch (TeiidException e) {
            throw TeiidSQLException.create(e);
        }
    }

    protected ServerConnection createServerConnection(Properties info) throws TeiidException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Module module = Module.getCallerModuleLoader().loadModule(ModuleIdentifier.create((String)"org.jboss.teiid"));
            Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
            ServerConnection serverConnection = (ServerConnection)ReflectionHelper.create("org.teiid.transport.LocalServerConnection", Arrays.asList(info, PropertiesUtils.getBooleanProperty(info, USE_CALLING_THREAD, true)), Thread.currentThread().getContextClassLoader());
            return serverConnection;
        }
        catch (ModuleLoadException e) {
            throw new TeiidRuntimeException(JDBCPlugin.Event.TEIID20008, e, JDBCPlugin.Util.gs(JDBCPlugin.Event.TEIID20008, new Object[0]));
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

