/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.teiid.client.BatchSerializer;
import org.teiid.client.metadata.ParameterInfo;
import org.teiid.client.plan.Annotation;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.util.ExceptionHolder;
import org.teiid.core.TeiidException;
import org.teiid.core.util.ExternalizeUtil;
import org.teiid.core.util.MultiArrayOutputStream;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.netty.handler.codec.serialization.CompactObjectInputStream;
import org.teiid.netty.handler.codec.serialization.CompactObjectOutputStream;

public class ResultsMessage
implements Externalizable {
    static final long serialVersionUID = 3546924172976187793L;
    private List<? extends List<?>> results;
    private String[] columnNames;
    private String[] dataTypes;
    private PlanNode planDescription;
    private TeiidException exception;
    private List<Throwable> warnings;
    private int firstRow = 0;
    private int lastRow;
    private int finalRow = -1;
    private List<ParameterInfo> parameters;
    private String debugLog;
    private byte clientSerializationVersion;
    private Collection<Annotation> annotations;
    private boolean isUpdateResult;
    private int updateCount = -1;
    private boolean delayDeserialization;
    byte[] resultBytes;

    public ResultsMessage() {
    }

    public ResultsMessage(List<? extends List<?>> results, String[] columnNames, String[] dataTypes) {
        this.results = results;
        this.setFirstRow(1);
        this.setLastRow(results.size());
        this.columnNames = columnNames;
        this.dataTypes = dataTypes;
    }

    public List<? extends List<?>> getResultsList() {
        return this.results;
    }

    public List<?>[] getResults() {
        return this.results.toArray(new List[this.results.size()]);
    }

    public void processResults() throws TeiidSQLException {
        if (this.results == null && this.resultBytes != null) {
            try {
                CompactObjectInputStream ois = new CompactObjectInputStream(new ByteArrayInputStream(this.resultBytes), ResultsMessage.class.getClassLoader());
                this.results = BatchSerializer.readBatch(ois, this.dataTypes);
            }
            catch (IOException e) {
                throw TeiidSQLException.create(e);
            }
            catch (ClassNotFoundException e) {
                throw TeiidSQLException.create(e);
            }
            finally {
                this.resultBytes = null;
            }
        }
    }

    public void setResults(List<?>[] results) {
        this.results = Arrays.asList(results);
    }

    public void setResults(List<? extends List<?>> results) {
        this.results = results;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getDataTypes() {
        return this.dataTypes;
    }

    public TeiidException getException() {
        return this.exception;
    }

    public int getFinalRow() {
        return this.finalRow;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public PlanNode getPlanDescription() {
        return this.planDescription;
    }

    public List<Throwable> getWarnings() {
        return this.warnings;
    }

    public void setException(Throwable e) {
        this.exception = e instanceof TeiidException ? (TeiidException)e : new TeiidException(e, e.getMessage());
    }

    public void setFinalRow(int i) {
        this.finalRow = i;
    }

    public void setFirstRow(int i) {
        this.firstRow = i;
    }

    public void setLastRow(int i) {
        this.lastRow = i;
    }

    public void setPlanDescription(PlanNode object) {
        this.planDescription = object;
    }

    public void setWarnings(List<Throwable> list) {
        this.warnings = list;
    }

    public List getParameters() {
        return this.parameters;
    }

    public void setParameters(List list) {
        this.parameters = list;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setDataTypes(String[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        List holderList;
        this.columnNames = ExternalizeUtil.readStringArray(in);
        this.dataTypes = ExternalizeUtil.readStringArray(in);
        this.results = BatchSerializer.readBatch(in, this.dataTypes);
        this.planDescription = (PlanNode)in.readObject();
        ExceptionHolder holder = (ExceptionHolder)in.readObject();
        if (holder != null) {
            this.exception = (TeiidException)holder.getException();
        }
        if (this.results == null && this.exception == null) {
            int length = in.readInt();
            this.resultBytes = new byte[length];
            in.readFully(this.resultBytes);
        }
        if ((holderList = (List)in.readObject()) != null) {
            this.warnings = ExceptionHolder.toThrowables(holderList);
        }
        this.firstRow = in.readInt();
        this.lastRow = in.readInt();
        this.finalRow = in.readInt();
        this.parameters = ExternalizeUtil.readList(in, ParameterInfo.class);
        this.debugLog = (String)in.readObject();
        this.annotations = ExternalizeUtil.readList(in, Annotation.class);
        this.isUpdateResult = in.readBoolean();
        if (this.isUpdateResult) {
            try {
                this.updateCount = in.readInt();
            }
            catch (OptionalDataException e) {
            }
            catch (EOFException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizeUtil.writeArray(out, this.columnNames);
        ExternalizeUtil.writeArray(out, this.dataTypes);
        if (this.delayDeserialization) {
            BatchSerializer.writeBatch(out, this.dataTypes, null, this.clientSerializationVersion);
        } else {
            BatchSerializer.writeBatch(out, this.dataTypes, this.results, this.clientSerializationVersion);
        }
        out.writeObject(this.planDescription);
        if (this.exception != null) {
            out.writeObject(new ExceptionHolder(this.exception));
        } else {
            out.writeObject(this.exception);
        }
        if (this.delayDeserialization && this.results != null) {
            MultiArrayOutputStream baos = new MultiArrayOutputStream(8192);
            CompactObjectOutputStream oos = new CompactObjectOutputStream(baos);
            BatchSerializer.writeBatch(oos, this.dataTypes, this.results, this.clientSerializationVersion);
            oos.close();
            out.writeInt(baos.getCount());
            baos.writeTo(out);
        }
        if (this.warnings != null) {
            out.writeObject(ExceptionHolder.toExceptionHolders(this.warnings));
        } else {
            out.writeObject(this.warnings);
        }
        out.writeInt(this.firstRow);
        out.writeInt(this.lastRow);
        out.writeInt(this.finalRow);
        ExternalizeUtil.writeList(out, this.parameters);
        out.writeObject(this.debugLog);
        ExternalizeUtil.writeCollection(out, this.annotations);
        out.writeBoolean(this.isUpdateResult);
        if (this.isUpdateResult) {
            out.writeInt(this.updateCount);
        }
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    public String getDebugLog() {
        return this.debugLog;
    }

    public void setAnnotations(Collection<Annotation> collection) {
        this.annotations = collection;
    }

    public void setDebugLog(String string) {
        this.debugLog = string;
    }

    public String toString() {
        return new StringBuffer("ResultsMessage rowCount=").append(this.results == null ? 0 : this.results.size()).append(" finalRow=").append(this.finalRow).toString();
    }

    public void setUpdateResult(boolean isUpdateResult) {
        this.isUpdateResult = isUpdateResult;
    }

    public boolean isUpdateResult() {
        return this.isUpdateResult;
    }

    public byte getClientSerializationVersion() {
        return this.clientSerializationVersion;
    }

    public void setClientSerializationVersion(byte clientSerializationVersion) {
        this.clientSerializationVersion = clientSerializationVersion;
    }

    public void setUpdateCount(int updateCount) {
        this.updateCount = updateCount;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public void setDelayDeserialization(boolean delayDeserialization) {
        this.delayDeserialization = delayDeserialization;
    }
}

