/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution;

import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.resource.ResourceException;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.language.AggregateFunction;
import org.teiid.language.ColumnReference;
import org.teiid.language.Expression;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.SalesForcePlugin;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.translator.salesforce.execution.visitors.JoinQueryVisitor;
import org.teiid.translator.salesforce.execution.visitors.SelectVisitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryExecutionImpl
implements ResultSetExecution {
    private static final String AGGREGATE_RESULT = "AggregateResult";
    private static final Pattern dateTimePattern = Pattern.compile("^(?:(\\d{4}-\\d{2}-\\d{2})T)?(\\d{2}:\\d{2}:\\d{2}(?:.\\d+)?)(.*)");
    private static final String SF_ID = "sf:Id";
    private static final String SF_TYPE = "sf:type";
    private static final String SF_S_OBJECT = "sf:sObject";
    private static final String XSI_TYPE = "xsi:type";
    private static final String XSI_NIL = "xsi:nil";
    private SalesforceConnection connection;
    private RuntimeMetadata metadata;
    private ExecutionContext context;
    private SelectVisitor visitor;
    private QueryResult results;
    private List<List<Object>> resultBatch;
    private String connectionIdentifier;
    private String connectorIdentifier;
    private String requestIdentifier;
    private String partIdentifier;
    private String logPreamble;
    private QueryExpression query;
    Map<String, Map<String, Integer>> sObjectToResponseField = new HashMap<String, Map<String, Integer>>();
    private int topResultIndex = 0;
    private Calendar cal;

    public QueryExecutionImpl(QueryExpression command, SalesforceConnection connection, RuntimeMetadata metadata, ExecutionContext context) {
        this.connection = connection;
        this.metadata = metadata;
        this.context = context;
        this.query = command;
        this.connectionIdentifier = context.getConnectionId();
        this.connectorIdentifier = context.getConnectorIdentifier();
        this.requestIdentifier = context.getRequestId();
        this.partIdentifier = context.getPartIdentifier();
    }

    public void cancel() throws TranslatorException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.cancel")});
    }

    public void close() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.close")});
    }

    public void execute() throws TranslatorException {
        try {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.getLogPreamble(), "Incoming Query:", this.query});
            List from = ((Select)this.query).getFrom();
            if (from.get(0) instanceof Join) {
                this.visitor = new JoinQueryVisitor(this.metadata);
                this.visitor.visitNode((LanguageObject)this.query);
                String finalQuery = this.visitor.getQuery().trim();
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.getLogPreamble(), "Executing Query:", finalQuery});
                this.results = this.connection.query(finalQuery, this.context.getBatchSize(), this.visitor.getQueryAll());
            } else {
                this.visitor = new SelectVisitor(this.metadata);
                this.visitor.visitNode((LanguageObject)this.query);
                if (this.visitor.canRetrieve()) {
                    this.results = this.connection.retrieve(this.visitor.getRetrieveFieldList(), this.visitor.getTableName(), this.visitor.getIdInCriteria());
                } else {
                    String finalQuery = this.visitor.getQuery().trim();
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.getLogPreamble(), "Executing Query:", finalQuery});
                    this.results = this.connection.query(finalQuery, this.context.getBatchSize(), this.visitor.getQueryAll());
                }
            }
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public List next() throws TranslatorException, DataNotAvailableException {
        List<Object> result = this.getRow(this.results);
        return result;
    }

    private List<Object> getRow(QueryResult result) throws TranslatorException {
        List<Object> row;
        if (null == this.resultBatch) {
            this.loadBatch();
        }
        if (this.resultBatch.size() == this.topResultIndex) {
            row = null;
        } else {
            row = this.resultBatch.get(this.topResultIndex);
            ++this.topResultIndex;
            if (this.resultBatch.size() == this.topResultIndex && !result.isDone()) {
                this.loadBatch();
            }
        }
        return row;
    }

    private void loadBatch() throws TranslatorException {
        try {
            if (null != this.resultBatch) {
                this.results = this.connection.queryMore(this.results.getQueryLocator(), this.context.getBatchSize());
            }
            this.resultBatch = new ArrayList<List<Object>>();
            this.topResultIndex = 0;
            for (SObject sObject : this.results.getRecords()) {
                List<Object[]> result = this.getObjectData(sObject);
                Iterator<Object[]> i = result.iterator();
                while (i.hasNext()) {
                    this.resultBatch.add(Arrays.asList(i.next()));
                }
            }
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private List<Object[]> getObjectData(SObject sObject) throws TranslatorException {
        List topFields = sObject.getAny();
        this.logAndMapFields(sObject.getType(), topFields);
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (this.visitor instanceof JoinQueryVisitor) {
            for (int i = 0; i < topFields.size(); ++i) {
                Element element = (Element)topFields.get(i);
                this.extactJoinResults(element, result);
            }
        }
        return this.extractDataFromFields(sObject, topFields, result);
    }

    private void extactJoinResults(Element node, List<Object[]> result) throws TranslatorException {
        if (this.isSObject(node)) {
            this.extractValuesFromElement(node, result);
        } else {
            NodeList children = node.getChildNodes();
            if (null != children && children.getLength() > 0) {
                for (int i = 0; i < children.getLength(); ++i) {
                    Node item = children.item(i);
                    if (!(item instanceof Element)) continue;
                    Element childElement = (Element)item;
                    if (this.isSObject(childElement)) {
                        this.extractValuesFromElement(childElement, result);
                        continue;
                    }
                    if (item.getChildNodes().getLength() <= 0) continue;
                    this.extactJoinResults(childElement, result);
                }
            }
        }
    }

    private List<Object[]> extractValuesFromElement(Element sObject, List<Object[]> result) throws TranslatorException {
        Element typeElement = (Element)sObject.getElementsByTagName(SF_TYPE).item(0);
        String sObjectName = typeElement.getFirstChild().getNodeValue();
        Object[] row = new Object[this.visitor.getSelectSymbolCount()];
        for (int j = 0; j < this.visitor.getSelectSymbolCount(); ++j) {
            Column element = ((ColumnReference)this.visitor.getSelectSymbolMetadata(j)).getMetadataObject();
            ColumnSet table = element.getParent();
            if (!table.getNameInSource().equals(sObjectName)) continue;
            Integer index = this.visitor.getSelectSymbolIndex(sObjectName + ':' + element.getNameInSource());
            if (null == index) {
                if (element.getNameInSource().equalsIgnoreCase("id")) {
                    this.setElementValueInColumn(j, sObject.getElementsByTagName(SF_ID), row);
                    continue;
                }
                throw new TranslatorException(SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.missing.field") + element.getNameInSource());
            }
            Node cell = sObject.getElementsByTagName("sf:" + element.getNameInSource()).item(0);
            this.setElementValueInColumn(j, cell, row);
        }
        result.add(row);
        return result;
    }

    private List<Object[]> extractDataFromFields(SObject sObject, List<Object> fields, List<Object[]> result) throws TranslatorException {
        Map<String, Integer> fieldToIndexMap = this.sObjectToResponseField.get(sObject.getType());
        int aggCount = 0;
        for (int j = 0; j < this.visitor.getSelectSymbolCount(); ++j) {
            Expression ex = this.visitor.getSelectSymbolMetadata(j);
            if (ex instanceof ColumnReference) {
                Column element = ((ColumnReference)ex).getMetadataObject();
                Table table = (Table)element.getParent();
                if (!table.getNameInSource().equals(sObject.getType()) && !AGGREGATE_RESULT.equalsIgnoreCase(sObject.getType())) continue;
                Integer index = fieldToIndexMap.get(element.getNameInSource());
                if (null == index) {
                    if (element.getNameInSource().equalsIgnoreCase("id")) {
                        this.setValueInColumn(j, sObject.getId(), result);
                        continue;
                    }
                    throw new TranslatorException(SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.missing.field") + element.getNameInSource());
                }
                Object cell = this.getCellDatum(element.getNameInSource(), element.getJavaType(), (Element)fields.get(index));
                this.setValueInColumn(j, cell, result);
                continue;
            }
            if (!(ex instanceof AggregateFunction)) continue;
            String name = "expr" + aggCount++;
            Integer index = fieldToIndexMap.get(name);
            if (null == index) {
                throw new TranslatorException(SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.missing.field") + ex);
            }
            Object cell = this.getCellDatum(name, ex.getType(), (Element)fields.get(index));
            this.setValueInColumn(j, cell, result);
        }
        return result;
    }

    private void setElementValueInColumn(int columnIndex, Object value, Object[] row) {
        if (value instanceof Element) {
            Element element = (Element)value;
            if (!Boolean.parseBoolean(element.getAttribute(XSI_NIL))) {
                row[columnIndex] = element.getFirstChild() != null ? element.getFirstChild().getNodeValue() : "";
            }
        } else {
            row[columnIndex] = value;
        }
    }

    private void setValueInColumn(int columnIndex, Object value, List<Object[]> result) {
        if (result.isEmpty()) {
            Object[] row = new Object[this.visitor.getSelectSymbolCount()];
            result.add(row);
        }
        for (Object[] row : result) {
            row[columnIndex] = value;
        }
    }

    private void logAndMapFields(String sObjectName, List<Object> fields) throws TranslatorException {
        if (!this.sObjectToResponseField.containsKey(sObjectName)) {
            this.logFields(sObjectName, fields);
            HashMap<String, Integer> responseFieldToIndexMap = new HashMap<String, Integer>();
            for (int x = 0; x < fields.size(); ++x) {
                Element element = (Element)fields.get(x);
                responseFieldToIndexMap.put(element.getLocalName(), x);
            }
            this.sObjectToResponseField.put(sObjectName, responseFieldToIndexMap);
        }
    }

    private void logFields(String sObjectName, List<Object> fields) {
        if (!LogManager.isMessageToBeRecorded((String)"org.teiid.CONNECTOR", (int)5)) {
            return;
        }
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"SalesForce Object Name = " + sObjectName});
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"FieldCount = " + fields.size()});
        for (int i = 0; i < fields.size(); ++i) {
            Element element = (Element)fields.get(i);
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Field # " + i + " is " + element.getLocalName()});
        }
    }

    private Object getCellDatum(String name, Class<?> type, Element elem) throws TranslatorException {
        if (!name.equals(elem.getLocalName())) {
            throw new TranslatorException(SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.column.mismatch1") + name + SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.column.mismatch2") + elem.getLocalName());
        }
        if (Boolean.parseBoolean(elem.getAttribute(XSI_NIL))) {
            return null;
        }
        String value = elem.getTextContent();
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            if (type == String.class) {
                return value;
            }
            return null;
        }
        if (type.equals(Timestamp.class) || type.equals(Time.class)) {
            if (this.cal == null) {
                this.cal = Calendar.getInstance();
            }
            return QueryExecutionImpl.parseDateTime(value, type, this.cal);
        }
        return value;
    }

    static Object parseDateTime(String value, Class<?> type, Calendar cal) throws TranslatorException {
        try {
            Matcher m = dateTimePattern.matcher(value);
            if (m.matches()) {
                String date = m.group(1);
                String time = m.group(2);
                String timeZone = m.group(3);
                Date d = null;
                if (date == null) {
                    int milli = time.lastIndexOf(46);
                    if (milli > 0) {
                        time = time.substring(0, milli);
                    }
                    d = Time.valueOf(time);
                } else {
                    d = Timestamp.valueOf(date + " " + time);
                }
                TimeZone tz = null;
                if (timeZone != null) {
                    tz = timeZone.equals("Z") ? TimeZone.getTimeZone("GMT") : (timeZone.contains(":") ? TimeZone.getTimeZone("GMT" + timeZone) : TimeZone.getTimeZone(timeZone));
                    cal.setTimeZone(tz);
                } else {
                    cal = null;
                }
                return TimestampWithTimezone.create((Date)d, (TimeZone)TimeZone.getDefault(), (Calendar)cal, type);
            }
            throw new TranslatorException(SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.datatime.parse") + value);
        }
        catch (IllegalArgumentException e) {
            throw new TranslatorException((Throwable)e, SalesForcePlugin.Util.getString("SalesforceQueryExecutionImpl.datatime.parse") + value);
        }
    }

    private boolean isSObject(Element element) {
        String type = element.getAttribute(XSI_TYPE);
        return type != null && type.equals(SF_S_OBJECT);
    }

    private String getLogPreamble() {
        if (null == this.logPreamble) {
            StringBuffer preamble = new StringBuffer();
            preamble.append(this.connectorIdentifier);
            preamble.append('.');
            preamble.append(this.connectionIdentifier);
            preamble.append('.');
            preamble.append(this.requestIdentifier);
            preamble.append('.');
            preamble.append(this.partIdentifier);
            preamble.append(": ");
            this.logPreamble = preamble.toString();
        }
        return this.logPreamble;
    }
}

