/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.resource.ResourceException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.execution.ProcedureExecutionParent;
import org.teiid.translator.salesforce.execution.SalesforceProcedureExecution;
import org.teiid.translator.salesforce.execution.UpdatedResult;

public class GetUpdatedExecutionImpl
implements SalesforceProcedureExecution {
    private ProcedureExecutionParent parent;
    private UpdatedResult updatedResult;
    private int idIndex = 0;
    DatatypeFactory factory;

    public GetUpdatedExecutionImpl(ProcedureExecutionParent procedureExecutionParent) throws TranslatorException {
        this.parent = procedureExecutionParent;
        try {
            this.factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new TranslatorException(e.getMessage());
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
    }

    @Override
    public void execute(ProcedureExecutionParent procedureExecutionParent) throws TranslatorException {
        try {
            Call command = this.parent.getCommand();
            List params = command.getArguments();
            Argument object = (Argument)params.get(0);
            String objectName = (String)object.getArgumentValue().getValue();
            Argument start = (Argument)params.get(1);
            Timestamp startTime = (Timestamp)start.getArgumentValue().getValue();
            GregorianCalendar tempCalendar = (GregorianCalendar)GregorianCalendar.getInstance();
            tempCalendar.setTime(startTime);
            XMLGregorianCalendar startCalendar = this.factory.newXMLGregorianCalendar(tempCalendar);
            Argument end = (Argument)params.get(2);
            Timestamp endTime = (Timestamp)end.getArgumentValue().getValue();
            tempCalendar = (GregorianCalendar)GregorianCalendar.getInstance();
            tempCalendar.setTime(endTime);
            XMLGregorianCalendar endCalendar = this.factory.newXMLGregorianCalendar(tempCalendar);
            this.updatedResult = this.parent.getConnection().getUpdated(objectName, startCalendar, endCalendar);
        }
        catch (ResourceException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public List<Timestamp> getOutputParameterValues() {
        ArrayList<Timestamp> result = new ArrayList<Timestamp>(1);
        result.add(new Timestamp(this.updatedResult.getLatestDateCovered().getTimeInMillis()));
        return result;
    }

    @Override
    public List<?> next() {
        ArrayList<String> result = null;
        if (this.updatedResult.getIDs() != null && this.idIndex < this.updatedResult.getIDs().size()) {
            result = new ArrayList<String>(1);
            result.add(this.updatedResult.getIDs().get(this.idIndex));
            ++this.idIndex;
        }
        return result;
    }
}

