/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.salesforce.execution;

import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import java.util.ArrayList;
import javax.resource.ResourceException;
import org.teiid.core.BundleUtil;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.salesforce.SalesForceExecutionFactory;
import org.teiid.translator.salesforce.SalesForcePlugin;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.translator.salesforce.Util;
import org.teiid.translator.salesforce.execution.visitors.IQueryProvidingVisitor;

public abstract class AbstractUpdateExecution
implements UpdateExecution {
    protected SalesForceExecutionFactory executionFactory;
    protected SalesforceConnection connection;
    protected RuntimeMetadata metadata;
    protected ExecutionContext context;
    protected Command command;
    protected int result;

    public AbstractUpdateExecution(SalesForceExecutionFactory ef, Command command, SalesforceConnection salesforceConnection, RuntimeMetadata metadata, ExecutionContext context) {
        this.executionFactory = ef;
        this.connection = salesforceConnection;
        this.metadata = metadata;
        this.context = context;
        this.command = command;
    }

    public void cancel() throws TranslatorException {
    }

    public void close() {
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return new int[]{this.result};
    }

    public RuntimeMetadata getMetadata() {
        return this.metadata;
    }

    public SalesforceConnection getConnection() {
        return this.connection;
    }

    String[] getIDs(Condition criteria, IQueryProvidingVisitor visitor) throws TranslatorException {
        String[] Ids = null;
        if (visitor.hasOnlyIDCriteria()) {
            try {
                String Id = ((Comparison)criteria).getRightExpression().toString();
                Id = Util.stripQutes(Id);
                Ids = new String[]{Id};
            }
            catch (ClassCastException cce) {
                throw new RuntimeException(SalesForcePlugin.Util.gs((BundleUtil.Event)SalesForcePlugin.Event.TEIID13008, new Object[0]));
            }
        }
        if (visitor.hasCriteria()) {
            try {
                String query = visitor.getQuery();
                QueryResult results = this.getConnection().query(query, this.context.getBatchSize(), Boolean.FALSE);
                if (results != null && results.getSize() > 0) {
                    ArrayList<String> idList = new ArrayList<String>(results.getRecords().size());
                    for (int i = 0; i < results.getRecords().size(); ++i) {
                        SObject sObject = (SObject)results.getRecords().get(i);
                        idList.add(sObject.getId());
                    }
                    Ids = idList.toArray(new String[0]);
                }
            }
            catch (ResourceException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
        return Ids;
    }
}

