/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.TeiidSQLException;

final class DataTypeTransformer {
    private DataTypeTransformer() {
    }

    static final BigDecimal getBigDecimal(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, BigDecimal.class);
    }

    static final <T> T transform(Object value, Class<T> targetType) throws SQLException {
        if (value == null || targetType.isAssignableFrom(value.getClass())) {
            return targetType.cast(value);
        }
        if (targetType == byte[].class) {
            if (value instanceof Blob) {
                Blob blob = (Blob)value;
                long length = blob.length();
                if (length > Integer.MAX_VALUE) {
                    throw new TeiidSQLException(JDBCPlugin.Util.getString("DataTypeTransformer.blob_too_big"));
                }
                return targetType.cast(blob.getBytes(1L, (int)length));
            }
            if (value instanceof String) {
                return targetType.cast(((String)value).getBytes());
            }
            if (value instanceof BinaryType) {
                return targetType.cast(((BinaryType)value).getBytesDirect());
            }
        } else if (targetType == String.class) {
            if (value instanceof SQLXML) {
                return targetType.cast(((SQLXML)value).getString());
            }
            if (value instanceof Clob) {
                Clob c = (Clob)value;
                long length = c.length();
                if (length == 0L) {
                    return targetType.cast("");
                }
                return targetType.cast(c.getSubString(1L, length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length));
            }
        }
        try {
            return targetType.cast(DataTypeManager.transformValue(DataTypeManager.convertToRuntimeType(value, true), DataTypeTransformer.getRuntimeType(targetType)));
        }
        catch (Exception e) {
            String valueStr = value.toString();
            if (valueStr.length() > 20) {
                valueStr = valueStr.substring(0, 20) + "...";
            }
            String msg = JDBCPlugin.Util.getString("DataTypeTransformer.Err_converting", valueStr, targetType.getSimpleName());
            throw TeiidSQLException.create(e, msg);
        }
    }

    static final <T> Class<?> getRuntimeType(Class<T> type) {
        Class<Object> runtimeType = type;
        if (!DataTypeManager.getAllDataTypeClasses().contains(type)) {
            runtimeType = type == Clob.class ? DataTypeManager.DefaultDataClasses.CLOB : (type == Blob.class ? DataTypeManager.DefaultDataClasses.BLOB : (type == SQLXML.class ? DataTypeManager.DefaultDataClasses.XML : (type == byte[].class ? DataTypeManager.DefaultDataClasses.VARBINARY : DataTypeManager.DefaultDataClasses.OBJECT)));
        }
        return runtimeType;
    }

    static final boolean getBoolean(Object value) throws SQLException {
        if (value == null) {
            return false;
        }
        return DataTypeTransformer.transform(value, Boolean.class);
    }

    static final byte getByte(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(value, Byte.class);
    }

    static final byte[] getBytes(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, byte[].class);
    }

    static final Character getCharacter(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Character.class);
    }

    static final Date getDate(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Date.class);
    }

    static final double getDouble(Object value) throws SQLException {
        if (value == null) {
            return 0.0;
        }
        return DataTypeTransformer.transform(value, Double.class);
    }

    static final float getFloat(Object value) throws SQLException {
        if (value == null) {
            return 0.0f;
        }
        return DataTypeTransformer.transform(value, Float.class).floatValue();
    }

    static final int getInteger(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(value, Integer.class);
    }

    static final long getLong(Object value) throws SQLException {
        if (value == null) {
            return 0L;
        }
        return DataTypeTransformer.transform(value, Long.class);
    }

    static final short getShort(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        return DataTypeTransformer.transform(value, Short.class);
    }

    static final Time getTime(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Time.class);
    }

    static final Timestamp getTimestamp(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Timestamp.class);
    }

    static final String getString(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, String.class);
    }

    static final Blob getBlob(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Blob.class);
    }

    static final Clob getClob(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, Clob.class);
    }

    static final SQLXML getSQLXML(Object value) throws SQLException {
        return DataTypeTransformer.transform(value, SQLXML.class);
    }

    static final Reader getCharacterStream(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Clob) {
            return ((Clob)value).getCharacterStream();
        }
        if (value instanceof SQLXML) {
            return ((SQLXML)value).getCharacterStream();
        }
        return new StringReader(DataTypeTransformer.getString(value));
    }

    static final InputStream getAsciiStream(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Clob) {
            return ((Clob)value).getAsciiStream();
        }
        if (value instanceof SQLXML) {
            return new ReaderInputStream(((SQLXML)value).getCharacterStream(), Charset.forName("ASCII"));
        }
        return new ByteArrayInputStream(DataTypeTransformer.getString(value).getBytes(Charset.forName("ASCII")));
    }

    static final NClob getNClob(Object value) throws SQLException {
        final Clob clob = DataTypeTransformer.getClob(value);
        if (clob == null) {
            return null;
        }
        if (clob instanceof NClob) {
            return (NClob)clob;
        }
        return (NClob)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{NClob.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke((Object)clob, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        });
    }
}

