/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.teradata;

import java.util.ArrayList;
import java.util.List;
import org.teiid.language.AndOr;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Expression;
import org.teiid.language.In;
import org.teiid.language.LanguageFactory;
import org.teiid.language.Literal;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.teradata.TeradataExecutionFactory;

public class TeradataSQLConversionVisitor
extends SQLConversionVisitor {
    public TeradataSQLConversionVisitor(TeradataExecutionFactory ef) {
        super(ef);
    }

    @Override
    public void visit(In obj) {
        List exprs = obj.getRightExpressions();
        boolean decompose = false;
        for (Expression expr : exprs) {
            if (expr instanceof Literal) continue;
            decompose = true;
            break;
        }
        if (decompose) {
            Comparison.Operator opCode;
            ArrayList<Expression> literals = new ArrayList<Expression>();
            Comparison.Operator operator = opCode = obj.isNegated() ? Comparison.Operator.NE : Comparison.Operator.EQ;
            if (exprs.size() > 1) {
                Comparison left = null;
                for (Expression expr : obj.getRightExpressions()) {
                    if (expr instanceof Literal) {
                        literals.add(expr);
                        continue;
                    }
                    if (left == null) {
                        left = LanguageFactory.INSTANCE.createCompareCriteria(opCode, obj.getLeftExpression(), expr);
                        continue;
                    }
                    left = LanguageFactory.INSTANCE.createAndOr(obj.isNegated() ? AndOr.Operator.AND : AndOr.Operator.OR, (Condition)left, (Condition)LanguageFactory.INSTANCE.createCompareCriteria(opCode, obj.getLeftExpression(), expr));
                }
                if (!literals.isEmpty()) {
                    left = LanguageFactory.INSTANCE.createAndOr(obj.isNegated() ? AndOr.Operator.AND : AndOr.Operator.OR, (Condition)left, (Condition)new In(obj.getLeftExpression(), literals, obj.isNegated()));
                }
                this.buffer.append("(");
                super.visit((AndOr)left);
                this.buffer.append(")");
            } else {
                super.visit(LanguageFactory.INSTANCE.createCompareCriteria(opCode, obj.getLeftExpression(), (Expression)exprs.get(0)));
            }
        } else {
            super.visit(obj);
        }
    }
}

