/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.GeneratedKeys;
import org.teiid.core.BundleUtil;
import org.teiid.language.BatchedCommand;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.Command;
import org.teiid.language.Insert;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.jdbc.JDBCBaseExecution;
import org.teiid.translator.jdbc.JDBCExecutionException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCPlugin;
import org.teiid.translator.jdbc.TranslatedCommand;

public class JDBCUpdateExecution
extends JDBCBaseExecution
implements UpdateExecution {
    private int[] result;

    public JDBCUpdateExecution(Command command, Connection connection, ExecutionContext context, JDBCExecutionFactory env) {
        super(command, connection, context, env);
    }

    public void execute() throws TranslatorException {
        if (this.command instanceof BatchedUpdates) {
            this.result = this.execute((BatchedUpdates)this.command);
        } else {
            TranslatedCommand translatedComm = this.translateCommand(this.command);
            this.result = this.executeTranslatedCommand(translatedComm);
        }
    }

    public int[] execute(BatchedUpdates batchedCommand) throws TranslatorException {
        boolean succeeded = false;
        boolean commitType = this.getAutoCommit(null);
        Command[] commands = batchedCommand.getUpdateCommands().toArray(new Command[batchedCommand.getUpdateCommands().size()]);
        int[] results = new int[commands.length];
        TranslatedCommand tCommand = null;
        try {
            if (commitType) {
                this.connection.setAutoCommit(false);
            }
            ArrayList<TranslatedCommand> executedCmds = new ArrayList<TranslatedCommand>();
            TranslatedCommand previousCommand = null;
            for (int i = 0; i < commands.length; ++i) {
                tCommand = this.translateCommand(commands[i]);
                if (tCommand.isPrepared()) {
                    PreparedStatement pstmt = null;
                    if (previousCommand != null && previousCommand.isPrepared() && previousCommand.getSql().equals(tCommand.getSql())) {
                        pstmt = (PreparedStatement)this.statement;
                    } else {
                        if (!executedCmds.isEmpty()) {
                            this.executeBatch(i, results, executedCmds);
                        }
                        pstmt = this.getPreparedStatement(tCommand.getSql());
                    }
                    this.bind(pstmt, tCommand.getPreparedValues(), null);
                    pstmt.addBatch();
                } else {
                    if (previousCommand != null && previousCommand.isPrepared()) {
                        this.executeBatch(i, results, executedCmds);
                        this.getStatement();
                    }
                    if (this.statement == null) {
                        this.getStatement();
                    }
                    this.statement.addBatch(tCommand.getSql());
                }
                executedCmds.add(tCommand);
                previousCommand = tCommand;
            }
            if (!executedCmds.isEmpty()) {
                this.executeBatch(commands.length, results, executedCmds);
            }
            succeeded = true;
            if (commitType) {
                this.restoreAutoCommit(!succeeded, null);
            }
        }
        catch (SQLException e) {
            try {
                throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11011, e, tCommand);
            }
            catch (Throwable throwable) {
                if (commitType) {
                    this.restoreAutoCommit(!succeeded, null);
                }
                throw throwable;
            }
        }
        return results;
    }

    private void executeBatch(int commandCount, int[] results, List<TranslatedCommand> commands) throws TranslatorException {
        try {
            int[] batchResults = this.statement.executeBatch();
            this.addStatementWarnings();
            for (int j = 0; j < batchResults.length; ++j) {
                results[commandCount - 1 - j] = batchResults[batchResults.length - 1 - j];
            }
            commands.clear();
        }
        catch (SQLException err) {
            throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11012, err, commands.toArray(new TranslatedCommand[commands.size()]));
        }
    }

    private int[] executeTranslatedCommand(TranslatedCommand translatedComm) throws TranslatorException {
        int[] nArray;
        block21: {
            String sql = translatedComm.getSql();
            boolean commitType = false;
            boolean succeeded = false;
            try {
                int updateCount = 0;
                if (!translatedComm.isPrepared()) {
                    updateCount = this.context.getCommandContext().isReturnAutoGeneratedKeys() && this.executionFactory.supportsGeneratedKeys(this.context, this.command) ? this.getStatement().executeUpdate(sql, 1) : this.getStatement().executeUpdate(sql);
                    this.addStatementWarnings();
                } else {
                    block20: {
                        PreparedStatement pstatement = this.getPreparedStatement(sql);
                        Iterator vi = null;
                        if (this.command instanceof BatchedCommand) {
                            BatchedCommand batchCommand = (BatchedCommand)this.command;
                            vi = batchCommand.getParameterValues();
                        }
                        if (vi != null) {
                            commitType = this.getAutoCommit(translatedComm);
                            if (commitType) {
                                this.connection.setAutoCommit(false);
                            }
                            int maxBatchSize = this.command instanceof Insert ? this.executionFactory.getMaxPreparedInsertBatchSize() : Integer.MAX_VALUE;
                            boolean done = false;
                            while (!done) {
                                for (int i = 0; i < maxBatchSize; ++i) {
                                    if (!vi.hasNext()) {
                                        if (i != 0) {
                                            done = true;
                                            break;
                                        }
                                        break block20;
                                    }
                                    List values = (List)vi.next();
                                    this.bind(pstatement, translatedComm.getPreparedValues(), values);
                                }
                                int[] results = pstatement.executeBatch();
                                for (int i = 0; i < results.length; ++i) {
                                    updateCount += results[i];
                                }
                            }
                        } else {
                            this.bind(pstatement, translatedComm.getPreparedValues(), null);
                            updateCount = pstatement.executeUpdate();
                            this.addStatementWarnings();
                        }
                    }
                    succeeded = true;
                }
                if (this.executionFactory.supportsGeneratedKeys() && this.context.getCommandContext().isReturnAutoGeneratedKeys() && this.command instanceof Insert) {
                    ResultSet keys = this.getStatement().getGeneratedKeys();
                    ResultSetMetaData rsmd = keys.getMetaData();
                    int cols = rsmd.getColumnCount();
                    Class[] columnDataTypes = new Class[cols];
                    String[] columnNames = new String[cols];
                    for (int i = 0; i < cols; ++i) {
                        columnDataTypes[i] = TypeFacility.getDataTypeClass((String)TypeFacility.getDataTypeNameFromSQLType((int)rsmd.getColumnType(i + 1)));
                        columnNames[i] = rsmd.getColumnName(i + 1);
                    }
                    GeneratedKeys generatedKeys = this.context.getCommandContext().returnGeneratedKeys(columnNames, columnDataTypes);
                    while (keys.next()) {
                        ArrayList<Object> vals = new ArrayList<Object>(columnDataTypes.length);
                        for (int i = 0; i < columnDataTypes.length; ++i) {
                            Object value = this.executionFactory.retrieveValue(keys, i + 1, columnDataTypes[i]);
                            vals.add(value);
                        }
                        generatedKeys.addKey(vals);
                    }
                }
                nArray = new int[]{updateCount};
                if (!commitType) break block21;
                this.restoreAutoCommit(!succeeded, translatedComm);
            }
            catch (SQLException err) {
                try {
                    throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11013, err, translatedComm);
                }
                catch (Throwable throwable) {
                    if (commitType) {
                        this.restoreAutoCommit(!succeeded, translatedComm);
                    }
                    throw throwable;
                }
            }
        }
        return nArray;
    }

    private boolean getAutoCommit(TranslatedCommand tCommand) throws TranslatorException {
        try {
            return this.connection.getAutoCommit();
        }
        catch (SQLException err) {
            throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11014, err, tCommand);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restoreAutoCommit(boolean exceptionOccurred, TranslatedCommand tCommand) throws TranslatorException {
        try {
            if (exceptionOccurred) {
                this.connection.rollback();
            }
        }
        catch (SQLException err) {
            try {
                throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11015, err, tCommand);
            }
            catch (Throwable throwable) {
                try {
                    this.connection.commit();
                    this.connection.setAutoCommit(true);
                    throw throwable;
                }
                catch (SQLException err2) {
                    throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11016, err2, tCommand);
                }
            }
        }
        try {
            this.connection.commit();
            this.connection.setAutoCommit(true);
            return;
        }
        catch (SQLException err) {
            throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11016, err, tCommand);
        }
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return this.result;
    }
}

