/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import javax.sql.rowset.serial.SerialStruct;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BinaryType;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Limit;
import org.teiid.language.QueryExpression;
import org.teiid.language.SetQuery;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCDirectQueryExecution;
import org.teiid.translator.jdbc.JDBCMetdataProcessor;
import org.teiid.translator.jdbc.JDBCPlugin;
import org.teiid.translator.jdbc.JDBCProcedureExecution;
import org.teiid.translator.jdbc.JDBCQueryExecution;
import org.teiid.translator.jdbc.JDBCUpdateExecution;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.Version;

@Translator(name="jdbc-ansi", description="JDBC ANSI translator, can used with any ANSI compatible JDBC Driver")
public class JDBCExecutionFactory
extends ExecutionFactory<DataSource, Connection> {
    public static final int DEFAULT_MAX_IN_CRITERIA = 1000;
    public static final int DEFAULT_MAX_DEPENDENT_PREDICATES = 50;
    private static final Map<Class<?>, Integer> TYPE_CODE_MAP = new HashMap();
    private static final int INTEGER_CODE = 0;
    private static final int LONG_CODE = 1;
    private static final int DOUBLE_CODE = 2;
    private static final int BIGDECIMAL_CODE = 3;
    private static final int SHORT_CODE = 4;
    private static final int FLOAT_CODE = 5;
    private static final int TIME_CODE = 6;
    private static final int DATE_CODE = 7;
    private static final int TIMESTAMP_CODE = 8;
    private static final int BLOB_CODE = 9;
    private static final int CLOB_CODE = 10;
    private static final int BOOLEAN_CODE = 11;
    private static final ThreadLocal<MessageFormat> COMMENT;
    public static final TimeZone DEFAULT_TIME_ZONE;
    private Map<String, FunctionModifier> functionModifiers = new TreeMap<String, FunctionModifier>(String.CASE_INSENSITIVE_ORDER);
    private boolean useBindVariables = true;
    private String databaseTimeZone;
    private boolean trimStrings;
    private boolean useCommentsInSourceQuery;
    private Version version;
    private int maxInsertBatchSize = 2048;
    private DatabaseCalender databaseCalender;
    private boolean supportsGeneratedKeys;
    private StructRetrieval structRetrieval = StructRetrieval.OBJECT;
    private AtomicBoolean initialConnection = new AtomicBoolean(true);

    public JDBCExecutionFactory() {
        this.setSupportsFullOuterJoins(true);
        this.setSupportsOrderBy(true);
        this.setSupportsOuterJoins(true);
        this.setSupportsSelectDistinct(true);
        this.setSupportsInnerJoins(true);
        this.setMaxInCriteriaSize(1000);
        this.setMaxDependentInPredicates(50);
    }

    public void start() throws TranslatorException {
        super.start();
        this.databaseCalender = new DatabaseCalender(this.databaseTimeZone);
    }

    @TranslatorProperty(display="Database Version", description="Database Version")
    public String getDatabaseVersion() {
        return this.version.toString();
    }

    public void setDatabaseVersion(String version) {
        this.version = Version.getVersion(version);
    }

    public void setDatabaseVersion(Version version) {
        this.version = version;
    }

    protected Version getVersion() {
        if (this.version == null) {
            return Version.DEFAULT_VERSION;
        }
        return this.version;
    }

    @TranslatorProperty(display="Use Bind Variables", description="Use prepared statements and bind variables", advanced=true)
    public boolean useBindVariables() {
        return this.useBindVariables;
    }

    public void setUseBindVariables(boolean useBindVariables) {
        this.useBindVariables = useBindVariables;
    }

    @TranslatorProperty(display="Database time zone", description="Time zone of the database, if different than Integration Server", advanced=true)
    public String getDatabaseTimeZone() {
        return this.databaseTimeZone;
    }

    public void setDatabaseTimeZone(String databaseTimeZone) {
        this.databaseTimeZone = databaseTimeZone;
    }

    @TranslatorProperty(display="Trim string flag", description="Right Trim fixed character types returned as Strings - note that the native type must be char or nchar and the source must support the rtrim function.", advanced=true)
    public boolean isTrimStrings() {
        return this.trimStrings;
    }

    public void setTrimStrings(boolean trimStrings) {
        this.trimStrings = trimStrings;
    }

    @TranslatorProperty(display="Use informational comments in Source Queries", description="This will embed a /*comment*/ leading comment with session/request id in source SQL query for informational purposes", advanced=true)
    public boolean useCommentsInSourceQuery() {
        return this.useCommentsInSourceQuery;
    }

    public void setUseCommentsInSourceQuery(boolean useCommentsInSourceQuery) {
        this.useCommentsInSourceQuery = useCommentsInSourceQuery;
    }

    public boolean isSourceRequired() {
        return true;
    }

    public boolean isSourceRequiredForCapabilities() {
        return this.isSourceRequired() && this.version == null && this.usesDatabaseVersion();
    }

    protected boolean usesDatabaseVersion() {
        return false;
    }

    public void initCapabilities(Connection connection) throws TranslatorException {
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            String fullVersion = metadata.getDatabaseProductVersion();
            this.setDatabaseVersion(fullVersion);
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Setting the database version to", fullVersion});
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        this.obtainedConnection(conn);
        return new JDBCQueryExecution((Command)command, conn, executionContext, this);
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        this.obtainedConnection(conn);
        return new JDBCDirectQueryExecution(arguments, command, conn, executionContext, this);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        this.obtainedConnection(conn);
        return new JDBCProcedureExecution((Command)command, conn, executionContext, this);
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        this.obtainedConnection(conn);
        return new JDBCUpdateExecution(command, conn, executionContext, this);
    }

    public Connection getConnection(DataSource ds) throws TranslatorException {
        try {
            return ds.getConnection();
        }
        catch (SQLException e) {
            throw new TranslatorException((BundleUtil.Event)JDBCPlugin.Event.TEIID11009, (Throwable)e);
        }
    }

    public void closeConnection(Connection connection, DataSource factory) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Throwable)e, (Object[])new Object[]{"Error closing"});
        }
    }

    public void getMetadata(MetadataFactory metadataFactory, Connection conn) throws TranslatorException {
        try {
            if (conn == null) {
                throw new TranslatorException((BundleUtil.Event)JDBCPlugin.Event.TEIID11018, JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11018, new Object[0]));
            }
            JDBCMetdataProcessor metadataProcessor = this.createMetadataProcessor();
            PropertiesUtils.setBeanProperties((Object)metadataProcessor, (Properties)metadataFactory.getModelProperties(), (String)"importer");
            metadataProcessor.getConnectorMetadata(conn, metadataFactory);
        }
        catch (SQLException e) {
            throw new TranslatorException((BundleUtil.Event)JDBCPlugin.Event.TEIID11010, (Throwable)e);
        }
    }

    protected JDBCMetdataProcessor createMetadataProcessor() {
        JDBCMetdataProcessor metadataProcessor = new JDBCMetdataProcessor();
        return metadataProcessor;
    }

    public List<String> getSupportedFunctions() {
        return this.getDefaultSupportedFunctions();
    }

    public List<String> getDefaultSupportedFunctions() {
        return Arrays.asList("+", "-", "*", "/");
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsAggregatesAvg() {
        return true;
    }

    public boolean supportsAggregatesCount() {
        return true;
    }

    public boolean supportsAggregatesCountStar() {
        return true;
    }

    public boolean supportsAggregatesDistinct() {
        return true;
    }

    public boolean supportsAggregatesMax() {
        return true;
    }

    public boolean supportsAggregatesMin() {
        return true;
    }

    public boolean supportsAggregatesSum() {
        return true;
    }

    public boolean supportsAliasedTable() {
        return true;
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    public boolean supportsExistsCriteria() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsInCriteriaSubquery() {
        return true;
    }

    public boolean supportsIsNullCriteria() {
        return true;
    }

    public boolean supportsLikeCriteria() {
        return true;
    }

    public boolean supportsLikeCriteriaEscapeCharacter() {
        return true;
    }

    public boolean supportsNotCriteria() {
        return true;
    }

    public boolean supportsOrCriteria() {
        return true;
    }

    public boolean supportsOrderByUnrelated() {
        return true;
    }

    public boolean supportsQuantifiedCompareCriteriaAll() {
        return true;
    }

    public boolean supportsScalarSubqueries() {
        return true;
    }

    public boolean supportsSearchedCaseExpressions() {
        return true;
    }

    public boolean supportsSelfJoins() {
        return true;
    }

    public boolean supportsInlineViews() {
        return false;
    }

    public boolean supportsQuantifiedCompareCriteriaSome() {
        return true;
    }

    public boolean supportsSetQueryOrderBy() {
        return true;
    }

    public boolean supportsUnions() {
        return true;
    }

    public boolean supportsBulkUpdate() {
        return true;
    }

    public boolean supportsBatchedUpdates() {
        return true;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsHaving() {
        return true;
    }

    public boolean supportsSelectExpression() {
        return true;
    }

    public boolean supportsInsertWithQueryExpression() {
        return true;
    }

    @TranslatorProperty(display="Max Prepared Insert Batch Size", description="The max size of a prepared insert batch.  Default 2048.", advanced=true)
    public int getMaxPreparedInsertBatchSize() {
        return this.maxInsertBatchSize;
    }

    public void setMaxPreparedInsertBatchSize(int maxInsertBatchSize) {
        if (maxInsertBatchSize < 1) {
            throw new AssertionError((Object)"Max prepared batch insert size must be greater than 0");
        }
        this.maxInsertBatchSize = maxInsertBatchSize;
    }

    public Calendar getDatabaseCalendar() {
        return (Calendar)this.databaseCalender.get();
    }

    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        List<?> parts = null;
        if (obj instanceof Function) {
            Function function = (Function)obj;
            if (this.functionModifiers != null) {
                String name = function.getName();
                while (true) {
                    FunctionModifier modifier;
                    if ((modifier = this.functionModifiers.get(name)) != null) {
                        parts = modifier.translate(function);
                    } else {
                        int index = name.indexOf(46);
                        if (index >= 0 && index != name.length() - 1) {
                            name = name.substring(index + 1);
                            continue;
                        }
                    }
                    break;
                }
            }
        } else if (obj instanceof Command) {
            parts = this.translateCommand((Command)obj, context);
        } else if (obj instanceof Limit) {
            parts = this.translateLimit((Limit)obj, context);
        } else if (obj instanceof ColumnReference) {
            ColumnReference elem = (ColumnReference)obj;
            if (this.isTrimStrings() && elem.getType() == TypeFacility.RUNTIME_TYPES.STRING && elem.getMetadataObject() != null && ("char".equalsIgnoreCase(elem.getMetadataObject().getNativeType()) || "nchar".equalsIgnoreCase(elem.getMetadataObject().getNativeType()))) {
                return Arrays.asList(this.getLanguageFactory().createFunction("rtrim", new Expression[]{elem}, TypeFacility.RUNTIME_TYPES.STRING));
            }
        }
        return parts;
    }

    public List<?> translateCommand(Command command, ExecutionContext context) {
        return null;
    }

    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        return null;
    }

    public Map<String, FunctionModifier> getFunctionModifiers() {
        return this.functionModifiers;
    }

    public void registerFunctionModifier(String name, FunctionModifier modifier) {
        this.functionModifiers.put(name, modifier);
    }

    public String translateLiteralBoolean(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return "1";
        }
        return "0";
    }

    public String translateLiteralDate(Date dateValue) {
        return "{d '" + this.formatDateValue(dateValue) + "'}";
    }

    public String translateLiteralTime(Time timeValue) {
        if (!this.hasTimeType()) {
            return this.translateLiteralTimestamp(new Timestamp(timeValue.getTime()));
        }
        return "{t '" + this.formatDateValue(timeValue) + "'}";
    }

    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "{ts '" + this.formatDateValue(timestampValue) + "'}";
    }

    public String formatDateValue(java.util.Date dateObject) {
        if (dateObject instanceof Timestamp && this.getTimestampNanoPrecision() < 9) {
            Timestamp ts = (Timestamp)dateObject;
            Timestamp newTs = new Timestamp(ts.getTime());
            if (this.getTimestampNanoPrecision() > 0) {
                int mask = (int)Math.pow(10.0, 9 - this.getTimestampNanoPrecision());
                newTs.setNanos(ts.getNanos() / mask * mask);
            } else {
                newTs.setNanos(0);
            }
            dateObject = newTs;
        }
        return this.getTypeFacility().convertDate(dateObject, DEFAULT_TIME_ZONE, this.getDatabaseCalendar(), dateObject.getClass()).toString();
    }

    public boolean addSourceComment() {
        return this.useCommentsInSourceQuery();
    }

    public boolean useAsInGroupAlias() {
        return true;
    }

    public boolean usePreparedStatements() {
        return this.useBindVariables();
    }

    public boolean useParensForSetQueries() {
        return false;
    }

    public boolean hasTimeType() {
        return true;
    }

    public String getSetOperationString(SetQuery.Operation operation) {
        return operation.toString();
    }

    public String getSourceComment(ExecutionContext context, Command command) {
        if (this.addSourceComment() && context != null) {
            return COMMENT.get().format(new Object[]{context.getConnectionId(), context.getRequestId(), context.getPartIdentifier()});
        }
        return "";
    }

    public String replaceElementName(String group, String element) {
        return null;
    }

    public int getTimestampNanoPrecision() {
        return 9;
    }

    public ResultSet executeStoredProcedure(CallableStatement statement, List<Argument> preparedValues, Class<?> returnType) throws SQLException {
        int update_count;
        int index = 1;
        if (returnType != null) {
            this.registerSpecificTypeOfOutParameter(statement, returnType, index++);
        }
        for (Argument param : preparedValues) {
            if (param.getDirection() == Argument.Direction.INOUT) {
                this.registerSpecificTypeOfOutParameter(statement, param.getType(), index);
            } else if (param.getDirection() == Argument.Direction.OUT) {
                this.registerSpecificTypeOfOutParameter(statement, param.getType(), index++);
            }
            if (param.getDirection() != Argument.Direction.IN && param.getDirection() != Argument.Direction.INOUT) continue;
            this.bindValue(statement, param.getArgumentValue().getValue(), param.getType(), index++);
        }
        boolean resultSetNext = statement.execute();
        while (!resultSetNext && (update_count = statement.getUpdateCount()) != -1) {
            resultSetNext = statement.getMoreResults();
        }
        return statement.getResultSet();
    }

    protected void registerSpecificTypeOfOutParameter(CallableStatement statement, Class<?> runtimeType, int index) throws SQLException {
        int typeToSet = TypeFacility.getSQLTypeFromRuntimeType(runtimeType);
        statement.registerOutParameter(index, typeToSet);
    }

    public void bindValue(PreparedStatement stmt, Object param, Class<?> paramType, int i) throws SQLException {
        int type = TypeFacility.getSQLTypeFromRuntimeType(paramType);
        if (param == null) {
            stmt.setNull(i, type);
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.DATE)) {
            stmt.setDate(i, (Date)param, this.getDatabaseCalendar());
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.TIME)) {
            stmt.setTime(i, (Time)param, this.getDatabaseCalendar());
            return;
        }
        if (paramType.equals(TypeFacility.RUNTIME_TYPES.TIMESTAMP)) {
            stmt.setTimestamp(i, (Timestamp)param, this.getDatabaseCalendar());
            return;
        }
        if (TypeFacility.RUNTIME_TYPES.BIG_DECIMAL.equals(paramType)) {
            stmt.setBigDecimal(i, (BigDecimal)param);
            return;
        }
        if (this.useStreamsForLobs()) {
            if (param instanceof Blob) {
                Blob blob = (Blob)param;
                stmt.setBinaryStream(i, blob.getBinaryStream(), blob.length());
                return;
            }
            if (param instanceof Clob) {
                Clob clob = (Clob)param;
                stmt.setCharacterStream(i, clob.getCharacterStream(), clob.length());
                return;
            }
        }
        if (TypeFacility.RUNTIME_TYPES.BIG_INTEGER.equals(paramType)) {
            param = new BigDecimal((BigInteger)param);
        } else if (TypeFacility.RUNTIME_TYPES.FLOAT.equals(paramType)) {
            param = new Double(((Float)param).doubleValue());
        } else if (TypeFacility.RUNTIME_TYPES.CHAR.equals(paramType)) {
            param = ((Character)param).toString();
        } else if (paramType.equals(TypeFacility.RUNTIME_TYPES.VARBINARY)) {
            param = ((BinaryType)param).getBytesDirect();
        }
        stmt.setObject(i, param, type);
    }

    public boolean useStreamsForLobs() {
        return false;
    }

    public Object retrieveValue(ResultSet results, int columnIndex, Class<?> expectedType) throws SQLException {
        Integer code = TYPE_CODE_MAP.get(expectedType);
        if (code != null) {
            switch (code) {
                case 0: {
                    int value = results.getInt(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 1: {
                    long value = results.getLong(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 2: {
                    double value = results.getDouble(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 3: {
                    return results.getBigDecimal(columnIndex);
                }
                case 4: {
                    short value = results.getShort(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 5: {
                    float value = results.getFloat(columnIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return Float.valueOf(value);
                }
                case 6: {
                    return results.getTime(columnIndex, this.getDatabaseCalendar());
                }
                case 7: {
                    return results.getDate(columnIndex, this.getDatabaseCalendar());
                }
                case 8: {
                    return results.getTimestamp(columnIndex, this.getDatabaseCalendar());
                }
                case 9: {
                    try {
                        return results.getBlob(columnIndex);
                    }
                    catch (SQLException e) {
                        try {
                            return results.getBytes(columnIndex);
                        }
                        catch (SQLException e2) {
                            break;
                        }
                    }
                }
                case 10: {
                    try {
                        return results.getClob(columnIndex);
                    }
                    catch (SQLException e) {
                        break;
                    }
                }
                case 11: {
                    return results.getBoolean(columnIndex);
                }
            }
        }
        Object result = results.getObject(columnIndex);
        if (expectedType == TypeFacility.RUNTIME_TYPES.OBJECT) {
            return this.convertObject(result);
        }
        return result;
    }

    public Object retrieveValue(CallableStatement results, int parameterIndex, Class<?> expectedType) throws SQLException {
        Integer code = TYPE_CODE_MAP.get(expectedType);
        if (code != null) {
            switch (code) {
                case 0: {
                    int value = results.getInt(parameterIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 1: {
                    long value = results.getLong(parameterIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 2: {
                    double value = results.getDouble(parameterIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return new Double(value);
                }
                case 3: {
                    return results.getBigDecimal(parameterIndex);
                }
                case 4: {
                    short value = results.getShort(parameterIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return value;
                }
                case 5: {
                    float value = results.getFloat(parameterIndex);
                    if (results.wasNull()) {
                        return null;
                    }
                    return new Float(value);
                }
                case 6: {
                    return results.getTime(parameterIndex, this.getDatabaseCalendar());
                }
                case 7: {
                    return results.getDate(parameterIndex, this.getDatabaseCalendar());
                }
                case 8: {
                    return results.getTimestamp(parameterIndex, this.getDatabaseCalendar());
                }
                case 9: {
                    try {
                        return results.getBlob(parameterIndex);
                    }
                    catch (SQLException e) {
                        try {
                            return results.getBytes(parameterIndex);
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                    }
                }
                case 10: {
                    try {
                        return results.getClob(parameterIndex);
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                case 11: {
                    return results.getBoolean(parameterIndex);
                }
            }
        }
        Object result = results.getObject(parameterIndex);
        if (expectedType == TypeFacility.RUNTIME_TYPES.OBJECT) {
            return this.convertObject(result);
        }
        return result;
    }

    protected Object convertObject(Object object) throws SQLException {
        if (object instanceof Struct) {
            switch (this.structRetrieval) {
                case OBJECT: {
                    return object;
                }
                case ARRAY: {
                    return new ArrayImpl(((Struct)object).getAttributes());
                }
                case COPY: {
                    return new SerialStruct((Struct)object, Collections.<String, Class<?>>emptyMap());
                }
            }
        }
        return object;
    }

    protected void afterInitialConnectionObtained(Connection connection) {
        try {
            StringBuffer sb = new StringBuffer(((Object)((Object)this)).getClass().getSimpleName());
            DatabaseMetaData dbmd = connection.getMetaData();
            sb.append(" Commit=").append(connection.getAutoCommit());
            sb.append(";DatabaseProductName=").append(dbmd.getDatabaseProductName());
            sb.append(";DatabaseProductVersion=").append(dbmd.getDatabaseProductVersion());
            sb.append(";DriverMajorVersion=").append(dbmd.getDriverMajorVersion());
            sb.append(";DriverMajorVersion=").append(dbmd.getDriverMinorVersion());
            sb.append(";DriverName=").append(dbmd.getDriverName());
            sb.append(";DriverVersion=").append(dbmd.getDriverVersion());
            sb.append(";IsolationLevel=").append(dbmd.getDefaultTransactionIsolation());
            this.supportsGeneratedKeys = dbmd.supportsGetGeneratedKeys();
            LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)sb.toString());
        }
        catch (SQLException e) {
            LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)JDBCPlugin.Util.gs((BundleUtil.Event)JDBCPlugin.Event.TEIID11002, new Object[0]));
        }
    }

    public void obtainedConnection(Connection connection) {
        if (this.initialConnection.compareAndSet(true, false)) {
            this.afterInitialConnectionObtained(connection);
        }
    }

    public SQLConversionVisitor getSQLConversionVisitor() {
        return new SQLConversionVisitor(this);
    }

    public boolean useParensForJoins() {
        return false;
    }

    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        return ExecutionFactory.NullOrder.LOW;
    }

    public boolean useSelectLimit() {
        return false;
    }

    public static List<String> parseName(String tableName, char escape, char delim) {
        boolean quoted = false;
        boolean escaped = false;
        LinkedList<String> nameParts = new LinkedList<String>();
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < tableName.length(); ++i) {
            char c = tableName.charAt(i);
            if (quoted) {
                if (c == escape) {
                    if (escaped) {
                        current.append(c);
                    }
                    escaped = !escaped;
                    continue;
                }
                if (c == delim) {
                    if (escaped) {
                        escaped = false;
                        quoted = false;
                        nameParts.add(current.toString());
                        current = new StringBuilder();
                        continue;
                    }
                    current.append(c);
                    continue;
                }
                current.append(c);
                continue;
            }
            if (c == escape) {
                if (current.length() == 0) {
                    quoted = true;
                    continue;
                }
                current.append(c);
                continue;
            }
            if (c == delim) {
                quoted = false;
                nameParts.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            nameParts.add(current.toString());
        }
        return nameParts;
    }

    public String getLikeRegexString() {
        return "LIKE_REGEX";
    }

    public void setFetchSize(Command command, ExecutionContext context, Statement statement, int fetchSize) throws SQLException {
        statement.setFetchSize(fetchSize);
    }

    public boolean supportsGeneratedKeys() {
        return this.supportsGeneratedKeys;
    }

    @TranslatorProperty(display="Struct retrieval", description="Struct retrieval mode (OBJECT, COPY, ARRAY)", advanced=true)
    public StructRetrieval getStructRetrieval() {
        return this.structRetrieval;
    }

    public void setStructRetrieval(StructRetrieval structRetrieval) {
        this.structRetrieval = structRetrieval;
    }

    protected boolean supportsGeneratedKeys(ExecutionContext context, Command command) {
        return this.supportsGeneratedKeys() && command instanceof Insert;
    }

    static {
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.INTEGER, new Integer(0));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.LONG, new Integer(1));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.DOUBLE, new Integer(2));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.BIG_DECIMAL, new Integer(3));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.SHORT, new Integer(4));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.FLOAT, new Integer(5));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.TIME, new Integer(6));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.DATE, new Integer(7));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.TIMESTAMP, new Integer(8));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.BLOB, new Integer(9));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.CLOB, new Integer(10));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.BOOLEAN, new Integer(11));
        TYPE_CODE_MAP.put(TypeFacility.RUNTIME_TYPES.BYTE, new Integer(4));
        COMMENT = new ThreadLocal<MessageFormat>(){

            @Override
            protected MessageFormat initialValue() {
                return new MessageFormat("/*teiid sessionid:{0}, requestid:{1}.{2}*/ ");
            }
        };
        DEFAULT_TIME_ZONE = TimeZone.getDefault();
    }

    static class DatabaseCalender
    extends ThreadLocal<Calendar> {
        private String timeZone;

        public DatabaseCalender(String tz) {
            this.timeZone = tz;
        }

        @Override
        protected Calendar initialValue() {
            TimeZone tz;
            if (this.timeZone != null && this.timeZone.trim().length() > 0 && !DEFAULT_TIME_ZONE.hasSameRules(tz = TimeZone.getTimeZone(this.timeZone))) {
                return Calendar.getInstance(tz);
            }
            return Calendar.getInstance();
        }
    }

    public static enum StructRetrieval {
        OBJECT,
        COPY,
        ARRAY;

    }
}

