/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.language.Function;
import org.teiid.translator.jdbc.FunctionModifier;

public class ExtractFunctionModifier
extends FunctionModifier {
    public static final String YEAR = "YEAR";
    public static final String QUARTER = "QUARTER";
    public static final String MONTH = "MONTH";
    public static final String DAYOFYEAR = "DOY";
    public static final String DAY = "DAY";
    public static final String WEEK = "WEEK";
    public static final String DAYOFWEEK = "DOW";
    public static final String HOUR = "HOUR";
    public static final String MINUTE = "MINUTE";
    public static final String SECOND = "SECOND";
    public static final String MILLISECONDS = "MILLISECONDS";
    private static Map<String, String> FUNCTION_PART_MAP = new HashMap<String, String>();

    @Override
    public List<?> translate(Function function) {
        List args = function.getParameters();
        ArrayList<String> objs = new ArrayList<String>();
        objs.add("EXTRACT(");
        objs.add(FUNCTION_PART_MAP.get(function.getName().toLowerCase()));
        objs.add(" ");
        objs.add("FROM");
        objs.add(" ");
        objs.add((String)args.get(0));
        objs.add(")");
        if (function.getName().toLowerCase().equals("dayofweek")) {
            objs.add(0, "(");
            objs.add(" + 1)");
        }
        return objs;
    }

    static {
        FUNCTION_PART_MAP.put("week", WEEK);
        FUNCTION_PART_MAP.put("dayofweek", DAYOFWEEK);
        FUNCTION_PART_MAP.put("dayofyear", DAYOFYEAR);
        FUNCTION_PART_MAP.put("year", YEAR);
        FUNCTION_PART_MAP.put("quarter", QUARTER);
        FUNCTION_PART_MAP.put("month", MONTH);
        FUNCTION_PART_MAP.put("dayofmonth", DAY);
        FUNCTION_PART_MAP.put("hour", HOUR);
        FUNCTION_PART_MAP.put("minute", MINUTE);
        FUNCTION_PART_MAP.put("second", SECOND);
    }
}

