/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.mongodb;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.Arrays;
import java.util.List;
import javax.resource.ResourceException;
import org.teiid.core.BundleUtil;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.resource.spi.BasicConnection;

public class MongoDBConnectionImpl
extends BasicConnection
implements MongoDBConnection {
    static final BundleUtil UTIL = BundleUtil.getBundleUtil(MongoDBConnectionImpl.class);
    private MongoClient client;
    private String database;

    public MongoDBConnectionImpl(String database, List<ServerAddress> servers, MongoCredential credential, MongoClientOptions options) {
        this.client = credential == null ? new MongoClient(servers, options) : new MongoClient(servers, Arrays.asList(credential), options);
        this.database = database;
    }

    public DB getDatabase() {
        return this.client.getDB(this.database);
    }

    public void close() throws ResourceException {
        if (this.client != null) {
            this.client.close();
        }
    }
}

