/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jpa;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.EntityManagerFactory;
import javax.persistence.ManyToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.core4j.Enumerable;
import org.core4j.Predicate1;
import org.odata4j.core.OFuncs;
import org.odata4j.core.OPredicates;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmAssociationSet;
import org.odata4j.edm.EdmAssociationSetEnd;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmDecorator;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmGenerator;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.producer.jpa.JPAMember;

public class JPAEdmGenerator
implements EdmGenerator {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final EntityManagerFactory emf;
    private final String namespace;

    public JPAEdmGenerator(EntityManagerFactory emf, String namespace) {
        this.emf = emf;
        this.namespace = namespace;
    }

    protected EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    protected String getNamespace() {
        return this.namespace;
    }

    protected String getEntityContainerName() {
        return this.getNamespace() + "Entities";
    }

    protected String getModelSchemaNamespace() {
        return this.getNamespace() + "Model";
    }

    protected String getContainerSchemaNamespace() {
        return this.getNamespace() + "Container";
    }

    @Override
    public EdmDataServices.Builder generateEdm(EdmDecorator decorator) {
        String name;
        String modelNamespace = this.getModelSchemaNamespace();
        ArrayList<EdmEntityType.Builder> edmEntityTypes = new ArrayList<EdmEntityType.Builder>();
        ArrayList<EdmComplexType.Builder> edmComplexTypes = new ArrayList<EdmComplexType.Builder>();
        ArrayList<EdmAssociation.Builder> associations = new ArrayList<EdmAssociation.Builder>();
        ArrayList<EdmEntitySet.Builder> entitySets = new ArrayList<EdmEntitySet.Builder>();
        ArrayList<EdmAssociationSet.Builder> associationSets = new ArrayList<EdmAssociationSet.Builder>();
        Metamodel mm = this.getEntityManagerFactory().getMetamodel();
        for (EmbeddableType et : mm.getEmbeddables()) {
            name = et.getJavaType().getSimpleName();
            List<EdmProperty.Builder> properties = this.getProperties(modelNamespace, (ManagedType<?>)et);
            EdmComplexType.Builder ect = (EdmComplexType.Builder)((EdmComplexType.Builder)((EdmComplexType.Builder)EdmComplexType.newBuilder().setNamespace(modelNamespace)).setName(name)).addProperties(properties);
            edmComplexTypes.add(ect);
        }
        for (EmbeddableType et : mm.getEntities()) {
            name = JPAEdmGenerator.getEntitySetName(et);
            List keys = new ArrayList();
            SingularAttribute idAttribute = null;
            if (et.hasSingleIdAttribute()) {
                idAttribute = JPAEdmGenerator.getIdAttribute(et);
                keys = idAttribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED ? Enumerable.create(this.getProperties(modelNamespace, (ManagedType)idAttribute.getType())).select(OFuncs.name(EdmProperty.Builder.class)).toList() : Enumerable.create((Object[])new String[]{idAttribute.getName()}).toList();
            } else {
                throw new IllegalArgumentException("IdClass not yet supported");
            }
            List<EdmProperty.Builder> properties = this.getProperties(modelNamespace, (ManagedType<?>)et);
            ArrayList<EdmNavigationProperty.Builder> navigationProperties = new ArrayList<EdmNavigationProperty.Builder>();
            EdmEntityType.Builder eet = ((EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setNamespace(modelNamespace)).setName(name)).addKeys(keys).addProperties(properties)).addNavigationProperties(navigationProperties);
            edmEntityTypes.add(eet);
            EdmEntitySet.Builder ees = EdmEntitySet.newBuilder().setName(name).setEntityType(eet);
            entitySets.add(ees);
        }
        Map eetsByName = Enumerable.create(edmEntityTypes).toMap(OFuncs.name(EdmEntityType.Builder.class));
        Map eesByName = Enumerable.create(entitySets).toMap(OFuncs.name(EdmEntitySet.Builder.class));
        for (EntityType et : mm.getEntities()) {
            for (Attribute att : et.getAttributes()) {
                SingularAttribute singularAtt;
                Type singularAttType;
                if (att.isCollection() || !(singularAttType = (singularAtt = (SingularAttribute)att).getType()).getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) continue;
                EntityType singularAttEntityType = (EntityType)singularAttType;
                EdmEntityType.Builder fromEntityType = (EdmEntityType.Builder)eetsByName.get(JPAEdmGenerator.getEntitySetName(et));
                EdmEntityType.Builder toEntityType = (EdmEntityType.Builder)eetsByName.get(JPAEdmGenerator.getEntitySetName(singularAttEntityType));
                EdmAssociation.Builder association = JPAEdmGenerator.defineManyTo(EdmMultiplicity.ZERO_TO_ONE, associations, fromEntityType, toEntityType, modelNamespace, eesByName, associationSets);
                EdmNavigationProperty.Builder navigationProperty = EdmNavigationProperty.newBuilder(singularAtt.getName()).setRelationship(association).setFromTo(association.getEnd1(), association.getEnd2());
                fromEntityType.addNavigationProperties(navigationProperty);
            }
        }
        for (EntityType et : mm.getEntities()) {
            for (Attribute att : et.getAttributes()) {
                if (!att.isCollection()) continue;
                PluralAttribute pluralAtt = (PluralAttribute)att;
                JPAMember m = JPAMember.create(pluralAtt, null);
                ManyToMany manyToMany = m.getAnnotation(ManyToMany.class);
                EntityType pluralAttEntityType = (EntityType)pluralAtt.getElementType();
                final EdmEntityType.Builder fromEntityType = (EdmEntityType.Builder)eetsByName.get(JPAEdmGenerator.getEntitySetName(et));
                final EdmEntityType.Builder toEntityType = (EdmEntityType.Builder)eetsByName.get(JPAEdmGenerator.getEntitySetName(pluralAttEntityType));
                try {
                    EdmAssociationEnd.Builder toRole;
                    EdmAssociationEnd.Builder fromRole;
                    EdmAssociation.Builder association = (EdmAssociation.Builder)Enumerable.create(associations).firstOrNull((Predicate1)new Predicate1<EdmAssociation.Builder>(){

                        public boolean apply(EdmAssociation.Builder input) {
                            return input.getEnd1().getType().getFullyQualifiedTypeName().equals(toEntityType.getFullyQualifiedTypeName()) && input.getEnd2().getType().getFullyQualifiedTypeName().equals(fromEntityType.getFullyQualifiedTypeName());
                        }
                    });
                    if (association == null) {
                        if (manyToMany != null) {
                            association = JPAEdmGenerator.defineManyTo(EdmMultiplicity.MANY, associations, fromEntityType, toEntityType, modelNamespace, eesByName, associationSets);
                            fromRole = association.getEnd1();
                            toRole = association.getEnd2();
                        } else {
                            association = JPAEdmGenerator.defineManyTo(EdmMultiplicity.ZERO_TO_ONE, associations, toEntityType, fromEntityType, modelNamespace, eesByName, associationSets);
                            fromRole = association.getEnd2();
                            toRole = association.getEnd1();
                        }
                    } else {
                        fromRole = association.getEnd2();
                        toRole = association.getEnd1();
                    }
                    EdmNavigationProperty.Builder navigationProperty = EdmNavigationProperty.newBuilder(pluralAtt.getName()).setRelationship(association).setFromTo(fromRole, toRole);
                    fromEntityType.addNavigationProperties(navigationProperty);
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, "Exception building Edm associations: " + e.getMessage(), e);
                }
            }
        }
        EdmEntityContainer.Builder container = EdmEntityContainer.newBuilder().setName(this.getEntityContainerName()).setIsDefault(true).addEntitySets(entitySets).addAssociationSets(associationSets);
        EdmSchema.Builder modelSchema = EdmSchema.newBuilder().setNamespace(modelNamespace).addEntityTypes(edmEntityTypes).addComplexTypes(edmComplexTypes).addAssociations(associations);
        EdmSchema.Builder containerSchema = EdmSchema.newBuilder().setNamespace(this.getContainerSchemaNamespace()).addEntityContainers(container);
        return EdmDataServices.newBuilder().addSchemas(containerSchema, modelSchema);
    }

    protected EdmSimpleType<?> toEdmType(SingularAttribute<?, ?> sa) {
        TemporalType temporal;
        Class javaType = sa.getType().getJavaType();
        EdmSimpleType<Object> type = EdmSimpleType.forJavaType(javaType);
        if (type == EdmSimpleType.DATETIME && (temporal = this.getTemporalType(sa)) != null && temporal == TemporalType.TIME) {
            type = EdmSimpleType.TIME;
        }
        if (type != null) {
            return type;
        }
        throw new UnsupportedOperationException(javaType.toString());
    }

    protected EdmProperty.Builder toEdmProperty(String modelNamespace, SingularAttribute<?, ?> sa) {
        Column col;
        EdmType type;
        String name = sa.getName();
        if (sa.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
            String simpleName = sa.getJavaType().getSimpleName();
            type = ((EdmComplexType.Builder)((EdmComplexType.Builder)EdmComplexType.newBuilder().setNamespace(modelNamespace)).setName(simpleName)).build();
        } else {
            type = sa.getBindableJavaType().isEnum() ? EdmSimpleType.STRING : this.toEdmType(sa);
        }
        boolean nullable = sa.isOptional();
        Integer maxLength = null;
        if (sa.getJavaMember() instanceof AnnotatedElement && (col = ((AnnotatedElement)((Object)sa.getJavaMember())).getAnnotation(Column.class)) != null) {
            if (Enumerable.create((Object[])new EdmType[]{EdmSimpleType.BINARY, EdmSimpleType.STRING}).contains(type)) {
                maxLength = col.length();
            }
            nullable &= col.nullable();
        }
        return EdmProperty.newBuilder(name).setType(type).setNullable(nullable).setMaxLength(maxLength);
    }

    protected List<EdmProperty.Builder> getProperties(String modelNamespace, ManagedType<?> et) {
        ArrayList<EdmProperty.Builder> properties = new ArrayList<EdmProperty.Builder>();
        for (Attribute att : et.getAttributes()) {
            if (att.isCollection()) continue;
            SingularAttribute sa = (SingularAttribute)att;
            Type type = sa.getType();
            if (sa.isId() && type.getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
                properties.addAll(this.getProperties(modelNamespace, (ManagedType)sa.getType()));
                continue;
            }
            if (!type.getPersistenceType().equals((Object)Type.PersistenceType.BASIC) && !type.getPersistenceType().equals((Object)Type.PersistenceType.EMBEDDABLE)) continue;
            EdmProperty.Builder prop = this.toEdmProperty(modelNamespace, sa);
            properties.add(prop);
        }
        return properties;
    }

    private static EdmAssociation.Builder defineManyTo(EdmMultiplicity toMult, List<EdmAssociation.Builder> associations, EdmEntityType.Builder fromEntityType, EdmEntityType.Builder toEntityType, String modelNamespace, Map<String, EdmEntitySet.Builder> eesByName, List<EdmAssociationSet.Builder> associationSets) {
        EdmMultiplicity fromMult = EdmMultiplicity.MANY;
        String assocName = JPAEdmGenerator.getAssociationName(associations, fromEntityType, toEntityType);
        EdmAssociationEnd.Builder fromAssociationEnd = EdmAssociationEnd.newBuilder().setRole(fromEntityType.getName()).setType(fromEntityType).setMultiplicity(fromMult);
        String toAssociationEndName = toEntityType.getName();
        if (toAssociationEndName.equals(fromEntityType.getName())) {
            toAssociationEndName = toAssociationEndName + "1";
        }
        EdmAssociationEnd.Builder toAssociationEnd = EdmAssociationEnd.newBuilder().setRole(toAssociationEndName).setType(toEntityType).setMultiplicity(toMult);
        EdmAssociation.Builder association = EdmAssociation.newBuilder().setNamespace(modelNamespace).setName(assocName).setEnds(fromAssociationEnd, toAssociationEnd);
        associations.add(association);
        EdmEntitySet.Builder fromEntitySet = eesByName.get(fromEntityType.getName());
        EdmEntitySet.Builder toEntitySet = eesByName.get(toEntityType.getName());
        EdmAssociationSet.Builder associationSet = EdmAssociationSet.newBuilder().setName(assocName).setAssociation(association).setEnds(EdmAssociationSetEnd.newBuilder().setRole(fromAssociationEnd).setEntitySet(fromEntitySet), EdmAssociationSetEnd.newBuilder().setRole(toAssociationEnd).setEntitySet(toEntitySet));
        associationSets.add(associationSet);
        return association;
    }

    public static <X> SingularAttribute<? super X, ?> getIdAttribute(EntityType<X> et) {
        return (SingularAttribute)Enumerable.create((Iterable)et.getSingularAttributes()).firstOrNull(new Predicate1<SingularAttribute<? super X, ?>>(){

            public boolean apply(SingularAttribute<? super X, ?> input) {
                return input.isId();
            }
        });
    }

    public static <X> String getEntitySetName(EntityType<X> et) {
        String name = et.getName();
        int idx = name.lastIndexOf(46);
        return idx > 0 ? name.substring(idx + 1) : name;
    }

    protected static String getAssociationName(List<EdmAssociation.Builder> associations, EdmEntityType.Builder fromEntityType, EdmEntityType.Builder toEntityType) {
        int i = 0;
        while (true) {
            boolean exists;
            String assocName = i == 0 ? String.format("FK_%s_%s", fromEntityType.getName(), toEntityType.getName()) : String.format("FK_%s_%s_%d", fromEntityType.getName(), toEntityType.getName(), i);
            boolean bl = exists = Enumerable.create(associations).where(OPredicates.nameEquals(EdmAssociation.Builder.class, assocName)).count() > 0;
            if (!exists) {
                return assocName;
            }
            ++i;
        }
    }

    protected TemporalType getTemporalType(SingularAttribute<?, ?> sa) {
        Member member = sa.getJavaMember();
        Temporal temporal = null;
        if (member instanceof Field) {
            temporal = ((Field)member).getAnnotation(Temporal.class);
        } else if (member instanceof Method) {
            temporal = ((Method)member).getAnnotation(Temporal.class);
        }
        return temporal == null ? null : temporal.value();
    }
}

