/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jpa;

import javax.persistence.metamodel.EntityType;
import org.odata4j.exceptions.NotFoundException;
import org.odata4j.producer.jpa.Command;
import org.odata4j.producer.jpa.JPAContext;
import org.odata4j.producer.jpa.JPAResults;

public class GetEntityCommand
implements Command {
    private JPAContext.EntityAccessor accessor;

    public GetEntityCommand() {
        this(JPAContext.EntityAccessor.ENTITY);
    }

    public GetEntityCommand(JPAContext.EntityAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public boolean execute(JPAContext context) {
        EntityType<?> jpaEntityType = this.accessor.getEntity(context).getJPAEntityType();
        Object typeSafeEntityKey = this.accessor.getEntity(context).getTypeSafeEntityKey();
        Object jpaEntity = context.getEntityManager().find(jpaEntityType.getJavaType(), typeSafeEntityKey);
        if (jpaEntity == null) {
            throw new NotFoundException(jpaEntityType.getJavaType() + " not found with key " + typeSafeEntityKey);
        }
        this.accessor.getEntity(context).setJpaEntity(jpaEntity);
        context.setResult(JPAResults.entity(this.accessor.getEntity(context).getJpaEntity()));
        return false;
    }
}

