/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jpa;

import javax.persistence.Query;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.jpa.Command;
import org.odata4j.producer.jpa.JPAContext;
import org.odata4j.producer.jpa.JPAResults;

public class ExecuteCountQueryCommand
implements Command {
    @Override
    public boolean execute(JPAContext context) {
        String jpql = context.getJPQLQuery();
        Query tq = context.getEntityManager().createQuery(jpql);
        Long count = (Long)tq.getSingleResult();
        QueryInfo query = context.getQueryInfo();
        if (query != null && query.skip != null) {
            count = Math.max(0L, count - (long)query.skip.intValue());
        }
        if (query != null && query.top != null) {
            count = Math.min(count, (long)query.top.intValue());
        }
        context.setResult(JPAResults.count(count));
        return false;
    }
}

