/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.odata4j.producer.command.ProducerCommandContext;
import org.odata4j.producer.jdbc.JdbcProducerBackend;
import org.odata4j.producer.jdbc.JdbcProducerCommandContext;

public class JdbcProducerBackendInvocationHandler
implements InvocationHandler {
    private final JdbcProducerBackend backend;
    private final Class<?> contextType;
    private final Map<String, Object> fields;
    private Object result;

    public JdbcProducerBackendInvocationHandler(JdbcProducerBackend backend, Class<?> contextType, Object[] args) {
        this.backend = backend;
        this.contextType = contextType;
        if (args != null && args.length > 0) {
            this.fields = new HashMap<String, Object>();
            for (int i = 0; i < args.length; i += 2) {
                this.fields.put((String)args[i], args[i + 1]);
            }
        } else {
            this.fields = null;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method getResult = ProducerCommandContext.class.getMethod("getResult", new Class[0]);
        if (method.equals(getResult)) {
            return this.result;
        }
        Method setResult = ProducerCommandContext.class.getMethod("setResult", Object.class);
        if (method.equals(setResult)) {
            this.result = args[0];
            return null;
        }
        Method toString = Object.class.getMethod("toString", new Class[0]);
        if (method.equals(toString)) {
            return "JdbcProducer proxy for " + this.contextType.getSimpleName();
        }
        if (method.getDeclaringClass().equals(JdbcProducerCommandContext.class)) {
            return method.invoke((Object)this.backend.newJdbcCommandContext(), args);
        }
        if (method.getName().startsWith("get")) {
            String fieldName = method.getName().substring("get".length());
            fieldName = Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1);
            return this.fields.get(fieldName);
        }
        throw new UnsupportedOperationException("TODO implement: " + method.toString());
    }
}

