/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.core4j.Enumerable;
import org.core4j.Predicate1;

public class JdbcModel {
    public final List<JdbcSchema> schemas = new ArrayList<JdbcSchema>();

    public JdbcSchema getOrCreateSchema(String schemaName) {
        JdbcSchema schema = (JdbcSchema)Enumerable.create(this.schemas).firstOrNull(JdbcModel.schemaNameEquals(schemaName));
        if (schema == null) {
            schema = new JdbcSchema();
            schema.schemaName = schemaName;
            this.schemas.add(schema);
        }
        return schema;
    }

    public JdbcTable getOrCreateTable(String schemaName, String tableName) {
        JdbcSchema schema = (JdbcSchema)Enumerable.create(this.schemas).first(JdbcModel.schemaNameEquals(schemaName));
        JdbcTable table = (JdbcTable)Enumerable.create(schema.tables).firstOrNull(JdbcModel.tableNameEquals(tableName));
        if (table == null) {
            table = new JdbcTable();
            table.tableName = tableName;
            schema.tables.add(table);
        }
        return table;
    }

    public JdbcColumn getOrCreateColumn(String schemaName, String tableName, String columnName) {
        JdbcTable table = this.getTable(schemaName, tableName);
        JdbcColumn column = (JdbcColumn)Enumerable.create(table.columns).firstOrNull(JdbcModel.columnNameEquals(columnName));
        if (column == null) {
            column = new JdbcColumn();
            column.columnName = columnName;
            table.columns.add(column);
        }
        return column;
    }

    public static final Predicate1<JdbcSchema> schemaNameEquals(final String schemaName) {
        return new Predicate1<JdbcSchema>(){

            public boolean apply(JdbcSchema schema) {
                return schema.schemaName.equals(schemaName);
            }
        };
    }

    public static final Predicate1<JdbcTable> tableNameEquals(final String tableName) {
        return new Predicate1<JdbcTable>(){

            public boolean apply(JdbcTable table) {
                return table.tableName.equals(tableName);
            }
        };
    }

    public static final Predicate1<JdbcColumn> columnNameEquals(final String columnName) {
        return new Predicate1<JdbcColumn>(){

            public boolean apply(JdbcColumn column) {
                return column.columnName.equals(columnName);
            }
        };
    }

    public JdbcTable getTable(String schemaName, String tableName) {
        return (JdbcTable)Enumerable.create(((JdbcSchema)Enumerable.create(this.schemas).first(JdbcModel.schemaNameEquals((String)schemaName))).tables).first(JdbcModel.tableNameEquals(tableName));
    }

    public JdbcTable findTable(String schemaName, String tableName) {
        JdbcSchema schema = (JdbcSchema)Enumerable.create(this.schemas).firstOrNull(JdbcModel.schemaNameEquals(schemaName));
        return schema == null ? null : (JdbcTable)Enumerable.create(schema.tables).firstOrNull(JdbcModel.tableNameEquals(tableName));
    }

    public static class JdbcColumn {
        public String columnName;
        public int columnType;
        public String columnTypeName;
        public Integer columnSize;
        public boolean isNullable;
        public int ordinalPosition;
    }

    public static class JdbcPrimaryKey {
        public String columnName;
        public int sequenceNumber;
        public String primaryKeyName;
    }

    public static class JdbcTable {
        public String tableName;
        public String tableType;
        public final List<JdbcColumn> columns = new ArrayList<JdbcColumn>();
        public final List<JdbcPrimaryKey> primaryKeys = new ArrayList<JdbcPrimaryKey>();
    }

    public static class JdbcSchema {
        public String schemaName;
        public String catalogName;
        public boolean isDefault;
        public final List<JdbcTable> tables = new ArrayList<JdbcTable>();
    }
}

