/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jdbc;

import java.util.ArrayList;
import org.odata4j.core.ImmutableList;
import org.odata4j.core.OEntity;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmProperty;
import org.odata4j.producer.jdbc.JdbcMetadataMapping;
import org.odata4j.producer.jdbc.JdbcModel;
import org.odata4j.producer.jdbc.SqlStatement;

public class GenerateSqlInsert {
    public SqlStatement generate(JdbcMetadataMapping mapping, EdmEntitySet entitySet, OEntity entity) {
        JdbcModel.JdbcTable table = mapping.getMappedTable(entitySet);
        StringBuilder sql = new StringBuilder("INSERT INTO " + table.tableName + "(");
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        ArrayList<SqlStatement.SqlParameter> params = new ArrayList<SqlStatement.SqlParameter>();
        for (OProperty<?> prop : entity.getProperties()) {
            if (columns.length() > 0) {
                columns.append(", ");
            }
            if (values.length() > 0) {
                values.append(", ");
            }
            EdmProperty edmProp = entitySet.getType().findProperty(prop.getName());
            JdbcModel.JdbcColumn column = mapping.getMappedColumn(edmProp);
            columns.append(column.columnName);
            values.append("?");
            params.add(new SqlStatement.SqlParameter(prop.getValue(), null));
        }
        sql.append((CharSequence)columns);
        sql.append(") VALUES (");
        sql.append((CharSequence)values);
        sql.append(")");
        return new SqlStatement(sql.toString(), ImmutableList.copyOf(params));
    }
}

