/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.inmemory;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.core4j.Enumerable;
import org.odata4j.core.Throwables;

public class BeanModel {
    private static final boolean DUMP = false;
    private final Class<?> beanClass;
    private final Map<String, Method> getters;
    private final Map<String, Method> setters;
    private final Map<String, Class<?>> types;
    private final Map<String, Class<?>> collections;
    private final BeanModel superClass;

    private static void dump(String msg) {
    }

    public BeanModel(Class<?> beanClass) {
        this(beanClass, true);
    }

    public BeanModel(Class<?> beanClass, boolean flatten) {
        BeanModel.dump("bean model: " + beanClass);
        this.beanClass = beanClass;
        this.getters = BeanModel.getBeanGetters(beanClass, flatten);
        this.setters = BeanModel.getBeanSetters(beanClass, flatten);
        this.types = BeanModel.computeTypes(this.getters, this.setters);
        this.collections = this.computeCollections(this.getters, this.setters);
        Class<?> sc = beanClass.getSuperclass();
        this.superClass = !flatten && sc != null ? new BeanModel(sc, flatten) : null;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public BeanModel getSuperClassModel() {
        return this.superClass;
    }

    public Iterable<String> getPropertyNames() {
        ArrayList<String> props = new ArrayList<String>();
        props.addAll(this.types.keySet());
        if (this.superClass != null) {
            Iterable<String> sprops = this.superClass.getPropertyNames();
            for (String p : sprops) {
                props.add(p);
            }
        }
        return props;
    }

    public Class<?> getPropertyType(String propertyName) {
        Class<?> ptype = this.types.get(propertyName);
        if (ptype == null && this.superClass != null) {
            ptype = this.superClass.getPropertyType(propertyName);
        }
        return ptype;
    }

    public Iterable<String> getCollectionNames() {
        ArrayList<String> props = new ArrayList<String>();
        props.addAll(this.collections.keySet());
        if (this.superClass != null) {
            Iterable<String> sprops = this.superClass.getCollectionNames();
            for (String p : sprops) {
                props.add(p);
            }
        }
        return props;
    }

    public Class<?> getCollectionElementType(String collectionName) {
        Class<?> ctype = this.collections.get(collectionName);
        if (ctype == null && this.superClass != null) {
            ctype = this.superClass.getCollectionElementType(collectionName);
        }
        return ctype;
    }

    public boolean canRead(String propertyName) {
        boolean hasGetter = this.getters.containsKey(propertyName);
        if (!hasGetter && this.superClass != null) {
            hasGetter = this.superClass.canRead(propertyName);
        }
        return hasGetter;
    }

    public boolean canWrite(String propertyName) {
        boolean hasSetter = this.setters.containsKey(propertyName);
        if (!hasSetter && this.superClass != null) {
            hasSetter = this.superClass.canWrite(propertyName);
        }
        return hasSetter;
    }

    public Object getPropertyValue(Object target, String propertyName) {
        Method method = this.getGetter(propertyName);
        if (method == null && this.superClass != null) {
            method = this.superClass.getGetter(propertyName);
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return method.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public void setPropertyValue(Object target, String propertyName, Object propertyValue) {
        Method method = this.getSetter(propertyName);
        if (method == null && this.superClass != null) {
            method = this.superClass.getSetter(propertyName);
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            method.invoke(target, propertyValue);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public Iterable<?> getCollectionValue(Object target, String collectionName) {
        Method method = this.getGetter(collectionName);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            Object obj = method.invoke(target, new Object[0]);
            if (obj == null) {
                return null;
            }
            return obj.getClass().isArray() ? Enumerable.create((Object[])((Object[])obj)) : (Iterable)obj;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public <T> void setCollectionValue(Object target, String collectionName, Collection<T> collectionValue) {
        Method method = this.getSetter(collectionName);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            Collection<Object> value = null;
            if (collectionValue != null) {
                Class<?> clazz = method.getParameterTypes()[0];
                if (List.class.isAssignableFrom(clazz)) {
                    value = collectionValue instanceof List ? (List<Object>)collectionValue : new ArrayList<T>(collectionValue);
                } else if (Set.class.isAssignableFrom(clazz)) {
                    value = collectionValue instanceof Set ? (Set<Object>)collectionValue : new HashSet<T>(collectionValue);
                } else {
                    throw new RuntimeException("Unsupported collection type " + collectionValue.getClass());
                }
            }
            method.invoke(target, value);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    private Method getGetter(String propertyName) {
        Method method = this.getters.get(propertyName);
        if (method == null && this.superClass != null) {
            method = this.superClass.getGetter(propertyName);
        }
        if (method == null) {
            throw new IllegalArgumentException("No getter found for propertyName " + propertyName);
        }
        return method;
    }

    private Method getSetter(String propertyName) {
        Method method = this.setters.get(propertyName);
        if (method == null && this.superClass != null) {
            method = this.superClass.getSetter(propertyName);
        }
        if (method == null) {
            throw new IllegalArgumentException("No setter found for propertyName " + propertyName);
        }
        return method;
    }

    private static Map<String, Class<?>> computeTypes(Map<String, Method> getters, Map<String, Method> setters) {
        HashMap rt = new HashMap();
        for (Map.Entry<String, Method> getter : getters.entrySet()) {
            Class<?> getterType = getter.getValue().getReturnType();
            if (BeanModel.isIterable(getterType)) continue;
            rt.put(getter.getKey(), getterType);
        }
        for (Map.Entry<String, Method> setter : setters.entrySet()) {
            String propertyName = setter.getKey();
            Class getterType = (Class)rt.get(propertyName);
            BeanModel.dump("bean prop?: " + propertyName + " getterType: " + getterType);
            if (getterType == null) continue;
            Class<?> setterType = setter.getValue().getParameterTypes()[0];
            if (getterType != null && !getterType.equals(setterType)) {
                throw new RuntimeException(String.format("Inconsistent types for property %s.%s: getter type %s, setter type %s", setters.get(propertyName).getDeclaringClass().getName(), propertyName, getterType.getName(), setterType.getName()));
            }
            BeanModel.dump("bean yes");
            rt.put(propertyName, setterType);
        }
        return rt;
    }

    private Map<String, Class<?>> computeCollections(Map<String, Method> getters2, Map<String, Method> setters2) {
        HashMap rt = new HashMap();
        for (Map.Entry<String, Method> getter : this.getters.entrySet()) {
            Type[] actualTypes;
            String propertyName = getter.getKey();
            Method method = getter.getValue();
            Class<?> getterType = method.getReturnType();
            if (!BeanModel.isIterable(getterType)) continue;
            Class<?> setterType = this.setters.containsKey(propertyName) ? this.setters.get(propertyName).getParameterTypes()[0] : null;
            BeanModel.dump("bean colllectionProp?: " + propertyName + " getterType: " + getterType.getName() + " setterType: " + setterType);
            if (setterType == null) continue;
            if (!getterType.equals(setterType)) {
                throw new RuntimeException(String.format("Inconsistent types for association %s.%s: getter type %s, setter type %s", this.setters.get(propertyName).getDeclaringClass().getName(), propertyName, getterType.getName(), setterType.getName()));
            }
            Type type = method.getGenericReturnType();
            Class<Object> elementClass = type instanceof ParameterizedType ? ((actualTypes = ((ParameterizedType)type).getActualTypeArguments()).length > 0 ? (Class)actualTypes[0] : Object.class) : Object.class;
            BeanModel.dump("bean yes");
            rt.put(propertyName, elementClass);
        }
        return rt;
    }

    private static boolean isIterable(Class<?> clazz) {
        return clazz.isArray() || Iterable.class.isAssignableFrom(clazz);
    }

    private static Map<String, Method> getBeanGetters(Class<?> clazz, boolean flatten) {
        Method[] methods;
        HashMap<String, Method> rt = new HashMap<String, Method>();
        for (Method method : methods = flatten ? clazz.getMethods() : clazz.getDeclaredMethods()) {
            String name;
            BeanModel.dump("bean getter? " + method.getName());
            String methodName = method.getName();
            if (methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE) && !Modifier.isStatic(method.getModifiers())) {
                name = methodName.substring(3);
                rt.put(name, method);
                BeanModel.dump("bean getter yes");
            }
            if (!methodName.startsWith("is") || methodName.length() <= 2 || !Character.isUpperCase(methodName.charAt(2)) || method.getParameterTypes().length != 0 || !method.getReturnType().equals(Boolean.class) && !method.getReturnType().equals(Boolean.TYPE) || Modifier.isStatic(method.getModifiers())) continue;
            name = methodName.substring(2);
            rt.put(name, method);
            BeanModel.dump("bean getter yes");
        }
        return rt;
    }

    private static Map<String, Method> getBeanSetters(Class<?> clazz, boolean flatten) {
        Method[] methods;
        HashMap<String, Method> rt = new HashMap<String, Method>();
        for (Method method : methods = flatten ? clazz.getMethods() : clazz.getDeclaredMethods()) {
            BeanModel.dump("bean setter? " + method.getName());
            String methodName = method.getName();
            if (!methodName.startsWith("set") || methodName.length() <= 3 || !Character.isUpperCase(methodName.charAt(3)) || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.TYPE) || Modifier.isStatic(method.getModifiers())) continue;
            String name = methodName.substring(3);
            rt.put(name, method);
            BeanModel.dump("bean setter yes");
        }
        return rt;
    }

    public Iterable<String> getDeclaredPropertyNames() {
        return this.types.keySet();
    }

    public Iterable<String> getDeclaredCollectionNames() {
        return this.collections.keySet();
    }
}

