/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.odata4j.exceptions.ODataProducerException;
import org.odata4j.producer.ErrorResponseExtension;

public class ErrorResponseExtensions {
    public static final String ODATA4J_DEBUG = "odata4j.debug";

    public static final ErrorResponseExtension returnInnerErrors() {
        return new ErrorResponseExtension(){

            @Override
            public boolean returnInnerError(HttpHeaders httpHeaders, UriInfo uriInfo, ODataProducerException exception) {
                return true;
            }
        };
    }

    public static final ErrorResponseExtension returnInnerErrorsBasedOnDefaultSystemProperty() {
        return ErrorResponseExtensions.returnInnerErrorsBasedOnSystemProperty(ODATA4J_DEBUG);
    }

    public static final ErrorResponseExtension returnInnerErrorsBasedOnSystemProperty(final String propertyName) {
        return new ErrorResponseExtension(){

            @Override
            public boolean returnInnerError(HttpHeaders httpHeaders, UriInfo uriInfo, ODataProducerException exception) {
                return Boolean.parseBoolean(System.getProperty(propertyName));
            }
        };
    }

    public static final ErrorResponseExtension returnInnerErrorsBasedOnDefaultQueryParameter() {
        return ErrorResponseExtensions.returnInnerErrorsBasedOnQueryParameter(ODATA4J_DEBUG);
    }

    public static final ErrorResponseExtension returnInnerErrorsBasedOnQueryParameter(final String queryParameterName) {
        return new ErrorResponseExtension(){

            @Override
            public boolean returnInnerError(HttpHeaders httpHeaders, UriInfo uriInfo, ODataProducerException exception) {
                return Boolean.parseBoolean((String)uriInfo.getQueryParameters().getFirst((Object)queryParameterName));
            }
        };
    }
}

