/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.xml;

import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.core4j.Enumerable;
import org.core4j.Func1;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OLink;
import org.odata4j.core.OLinks;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmStructuralType;
import org.odata4j.edm.EdmType;
import org.odata4j.format.Entry;
import org.odata4j.format.Feed;
import org.odata4j.format.FormatParser;
import org.odata4j.format.xml.FeedCustomizations;
import org.odata4j.format.xml.XmlFormatParser;
import org.odata4j.internal.InternalUtil;
import org.odata4j.stax2.Attribute2;
import org.odata4j.stax2.QName2;
import org.odata4j.stax2.StartElement2;
import org.odata4j.stax2.XMLEvent2;
import org.odata4j.stax2.XMLEventReader2;
import org.odata4j.stax2.XMLEventWriter2;
import org.odata4j.stax2.XMLFactoryProvider2;
import org.odata4j.stax2.util.StaxUtil;

public class AtomFeedFormatParser
extends XmlFormatParser
implements FormatParser<Feed> {
    protected final EdmDataServices metadata;
    protected final String entitySetName;
    protected final OEntityKey entityKey;
    private FeedCustomizations feedCustomizations;
    private static final Pattern ENTITY_SET_NAME = Pattern.compile("\\/([^\\/\\(]+)\\(");

    public AtomFeedFormatParser(EdmDataServices metadata, String entitySetName, OEntityKey entityKey) {
        this.metadata = metadata;
        this.entitySetName = entitySetName;
        this.entityKey = entityKey;
    }

    @Override
    public AtomFeed parse(Reader reader) {
        return this.parseFeed(StaxUtil.newXMLEventReader(reader), this.getEntitySet());
    }

    AtomFeed parseFeed(XMLEventReader2 reader, EdmEntitySet entitySet) {
        AtomFeed feed = new AtomFeed();
        ArrayList<AtomEntry> rt = new ArrayList<AtomEntry>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (AtomFeedFormatParser.isStartElement(event, ATOM_ENTRY)) {
                rt.add(this.parseEntry(reader, event.asStartElement(), entitySet));
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_LINK)) {
                if (!"next".equals(event.asStartElement().getAttributeByName(new QName2("rel")).getValue())) continue;
                feed.next = event.asStartElement().getAttributeByName(new QName2("href")).getValue();
                continue;
            }
            if (!AtomFeedFormatParser.isEndElement(event, ATOM_FEED)) continue;
            break;
        }
        feed.entries = Enumerable.create(rt).cast(Entry.class);
        return feed;
    }

    public static Iterable<OProperty<?>> parseProperties(XMLEventReader2 reader, StartElement2 propertiesElement, EdmDataServices metadata, EdmStructuralType structuralType) {
        ArrayList rt = new ArrayList();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(propertiesElement.getName())) {
                return rt;
            }
            if (!event.isStartElement() || !event.asStartElement().getName().getNamespaceUri().equals("http://schemas.microsoft.com/ado/2007/08/dataservices")) continue;
            String name = event.asStartElement().getName().getLocalPart();
            Attribute2 typeAttribute = event.asStartElement().getAttributeByName(M_TYPE);
            Attribute2 nullAttribute = event.asStartElement().getAttributeByName(M_NULL);
            boolean isNull = nullAttribute != null && "true".equals(nullAttribute.getValue());
            OProperty<Object> op = null;
            EdmType et = null;
            if (typeAttribute != null) {
                String type = typeAttribute.getValue();
                et = metadata.resolveType(type);
                if (et == null) {
                    throw new RuntimeException("unknown property type: " + type);
                }
            } else {
                EdmProperty property = structuralType.findProperty(name);
                et = property != null ? property.getType() : EdmSimpleType.STRING;
            }
            if (et != null && !et.isSimple()) {
                EdmStructuralType est = (EdmStructuralType)et;
                op = OProperties.complex(name, (EdmComplexType)et, isNull ? null : Enumerable.create(AtomFeedFormatParser.parseProperties(reader, event.asStartElement(), metadata, est)).toList());
            } else {
                op = OProperties.parseSimple(name, (EdmSimpleType)et, isNull ? null : reader.getElementText());
            }
            rt.add(op);
        }
        throw new RuntimeException();
    }

    private AtomLink parseAtomLink(XMLEventReader2 reader, StartElement2 linkElement, EdmEntitySet entitySet) {
        XMLEvent2 event;
        AtomLink rt = new AtomLink();
        rt.relation = AtomFeedFormatParser.getAttributeValueIfExists(linkElement, "rel");
        rt.type = AtomFeedFormatParser.getAttributeValueIfExists(linkElement, "type");
        rt.title = AtomFeedFormatParser.getAttributeValueIfExists(linkElement, "title");
        rt.href = AtomFeedFormatParser.getAttributeValueIfExists(linkElement, "href");
        rt.inlineContentExpected = false;
        String navPropertyName = rt.getNavProperty();
        EdmNavigationProperty navProperty = null;
        if (entitySet != null && navPropertyName != null) {
            navProperty = entitySet.getType().findNavigationProperty(navPropertyName);
        }
        EdmEntitySet targetEntitySet = null;
        if (navProperty != null) {
            targetEntitySet = this.metadata.getEdmEntitySet(navProperty.getToRole().getType());
        }
        while (!(!reader.hasNext() || (event = reader.nextEvent()).isEndElement() && event.asEndElement().getName().equals(linkElement.getName()))) {
            if (AtomFeedFormatParser.isStartElement(event, XmlFormatParser.M_INLINE)) {
                rt.inlineContentExpected = true;
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_FEED)) {
                rt.inlineFeed = this.parseFeed(reader, targetEntitySet);
                continue;
            }
            if (!AtomFeedFormatParser.isStartElement(event, ATOM_ENTRY)) continue;
            rt.inlineEntry = this.parseEntry(reader, event.asStartElement(), targetEntitySet);
        }
        return rt;
    }

    private DataServicesAtomEntry parseDSAtomEntry(String etag, EdmEntityType entityType, XMLEventReader2 reader, XMLEvent2 event) {
        List properties = Enumerable.create(AtomFeedFormatParser.parseProperties(reader, event.asStartElement(), this.metadata, entityType)).toList();
        return new DataServicesAtomEntry(etag, properties);
    }

    private static String innerText(XMLEventReader2 reader, StartElement2 element) {
        StringWriter sw = new StringWriter();
        XMLEventWriter2 writer = XMLFactoryProvider2.getInstance().newXMLOutputFactory2().createXMLEventWriter(sw);
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(element.getName())) {
                return sw.toString();
            }
            writer.add(event);
        }
        throw new RuntimeException();
    }

    public static OEntityKey parseEntityKey(String atomEntryId) {
        Matcher m = ENTITY_SET_NAME.matcher(atomEntryId);
        if (!m.find()) {
            throw new RuntimeException("Unable to parse the entity-key from atom entry id: " + atomEntryId);
        }
        return OEntityKey.parse(atomEntryId.substring(m.end() - 1));
    }

    private EdmEntitySet getEntitySet() {
        EdmFunctionImport efi;
        EdmEntitySet entitySet = null;
        if (!this.metadata.getSchemas().isEmpty() && (entitySet = this.metadata.findEdmEntitySet(this.entitySetName)) == null && (efi = this.metadata.findEdmFunctionImport(this.entitySetName)) != null) {
            entitySet = efi.getEntitySet();
        }
        if (entitySet == null) {
            throw new RuntimeException("Could not derive the entity-set " + this.entitySetName);
        }
        return entitySet;
    }

    private AtomEntry parseEntry(XMLEventReader2 reader, StartElement2 entryElement, EdmEntitySet entitySet) {
        String id = null;
        String categoryTerm = null;
        String categoryScheme = null;
        String title = null;
        String summary = null;
        String updated = null;
        String contentType = null;
        ArrayList<AtomLink> atomLinks = new ArrayList<AtomLink>();
        String etag = AtomFeedFormatParser.getAttributeValueIfExists(entryElement, M_ETAG);
        AtomEntry rt = null;
        block0: while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(entryElement.getName())) {
                rt.id = id;
                rt.title = title;
                rt.summary = summary;
                rt.updated = updated;
                rt.categoryScheme = categoryScheme;
                rt.categoryTerm = categoryTerm;
                rt.contentType = contentType;
                rt.atomLinks = atomLinks;
                if (rt instanceof DataServicesAtomEntry) {
                    DataServicesAtomEntry dsae = rt;
                    OEntity entity = this.entityFromAtomEntry(this.metadata, entitySet, dsae);
                    dsae.setEntity(entity);
                }
                return rt;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_ID)) {
                id = reader.getElementText();
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_TITLE)) {
                title = reader.getElementText();
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_SUMMARY)) {
                summary = reader.getElementText();
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_UPDATED)) {
                updated = reader.getElementText();
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_CATEGORY)) {
                categoryTerm = AtomFeedFormatParser.getAttributeValueIfExists(event.asStartElement(), "term");
                categoryScheme = AtomFeedFormatParser.getAttributeValueIfExists(event.asStartElement(), "scheme");
                if (categoryTerm == null) continue;
                entitySet = this.metadata.getEdmEntitySet((EdmEntityType)this.metadata.findEdmEntityType(categoryTerm));
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_LINK)) {
                AtomLink link = this.parseAtomLink(reader, event.asStartElement(), entitySet);
                atomLinks.add(link);
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, M_PROPERTIES)) {
                rt = this.parseDSAtomEntry(etag, entitySet.getType(), reader, event);
                continue;
            }
            if (!AtomFeedFormatParser.isStartElement(event, ATOM_CONTENT)) continue;
            contentType = AtomFeedFormatParser.getAttributeValueIfExists(event.asStartElement(), "type");
            if ("application/xml".equals(contentType)) {
                StartElement2 contentElement = event.asStartElement();
                StartElement2 valueElement = null;
                while (reader.hasNext()) {
                    XMLEvent2 event2 = reader.nextEvent();
                    if (valueElement == null && event2.isStartElement()) {
                        valueElement = event2.asStartElement();
                        if (AtomFeedFormatParser.isStartElement(event2, M_PROPERTIES)) {
                            rt = this.parseDSAtomEntry(etag, entitySet.getType(), reader, event2);
                        } else {
                            BasicAtomEntry bae = new BasicAtomEntry();
                            bae.content = AtomFeedFormatParser.innerText(reader, event2.asStartElement());
                            rt = bae;
                        }
                    }
                    if (!event2.isEndElement() || !event2.asEndElement().getName().equals(contentElement.getName())) continue;
                    continue block0;
                }
                continue;
            }
            BasicAtomEntry bae = new BasicAtomEntry();
            bae.content = AtomFeedFormatParser.innerText(reader, event.asStartElement());
            rt = bae;
        }
        throw new RuntimeException();
    }

    private OEntity entityFromAtomEntry(EdmDataServices metadata, EdmEntitySet entitySet, DataServicesAtomEntry dsae) {
        OEntityKey key;
        FeedCustomizations.FeedCustomization fc;
        EdmEntityType entityType = entitySet.getType();
        List<OProperty<?>> props = dsae.properties;
        if (this.feedCustomizations == null) {
            this.feedCustomizations = new FeedCustomizations(metadata);
        }
        if ((fc = this.feedCustomizations.get(entitySet.getType())) != null) {
            if (fc.syndicationTitle != null && !fc.syndicationTitle.keepInContent) {
                props.add(OProperties.string(fc.syndicationTitle.propertyName, dsae.title));
            }
            if (fc.syndicationSummary != null && !fc.syndicationSummary.keepInContent) {
                props.add(OProperties.string(fc.syndicationSummary.propertyName, dsae.summary));
            }
        }
        if (dsae.categoryTerm != null && (entityType = (EdmEntityType)metadata.findEdmEntityType(dsae.categoryTerm)) == null) {
            throw new RuntimeException("Unable to resolve entity type " + dsae.categoryTerm);
        }
        OEntityKey oEntityKey = dsae.id != null ? (dsae.id.endsWith(")") ? AtomFeedFormatParser.parseEntityKey(dsae.id) : OEntityKey.infer(entitySet, props)) : (key = null);
        if (key == null) {
            key = this.entityKey;
        }
        if (key == null) {
            return OEntities.createRequest(entitySet, props, this.toOLinks(metadata, entitySet, dsae.atomLinks), dsae.title, dsae.categoryTerm);
        }
        return OEntities.create(entitySet, entityType, key, dsae.etag, props, this.toOLinks(metadata, entitySet, dsae.atomLinks), dsae.title, dsae.categoryTerm);
    }

    private List<OLink> toOLinks(final EdmDataServices metadata, EdmEntitySet fromRoleEntitySet, List<AtomLink> links) {
        ArrayList<OLink> rt = new ArrayList<OLink>(links.size());
        for (AtomLink link : links) {
            EdmEntitySet toRoleEntitySet;
            EdmNavigationProperty navProperty;
            if (!link.relation.startsWith("http://schemas.microsoft.com/ado/2007/08/dataservices/related/")) continue;
            if (link.type.equals("application/atom+xml;type=feed")) {
                if (link.inlineContentExpected) {
                    List relatedEntities = null;
                    if (link.inlineFeed != null && link.inlineFeed.entries != null) {
                        navProperty = fromRoleEntitySet != null ? fromRoleEntitySet.getType().findNavigationProperty(link.getNavProperty()) : null;
                        toRoleEntitySet = metadata != null && navProperty != null ? metadata.getEdmEntitySet(navProperty.getToRole().getType()) : null;
                        relatedEntities = Enumerable.create(link.inlineFeed.entries).cast(DataServicesAtomEntry.class).select((Func1)new Func1<DataServicesAtomEntry, OEntity>(){

                            public OEntity apply(DataServicesAtomEntry input) {
                                return AtomFeedFormatParser.this.entityFromAtomEntry(metadata, toRoleEntitySet, input);
                            }
                        }).toList();
                    }
                    rt.add(OLinks.relatedEntitiesInline(link.relation, link.title, link.href, relatedEntities));
                    continue;
                }
                rt.add(OLinks.relatedEntities(link.relation, link.title, link.href));
                continue;
            }
            if (!link.type.equals("application/atom+xml;type=entry")) continue;
            if (link.inlineContentExpected) {
                OEntity relatedEntity = null;
                if (link.inlineEntry != null) {
                    navProperty = fromRoleEntitySet != null ? fromRoleEntitySet.getType().findNavigationProperty(link.getNavProperty()) : null;
                    toRoleEntitySet = metadata != null && navProperty != null ? metadata.getEdmEntitySet(navProperty.getToRole().getType()) : null;
                    relatedEntity = this.entityFromAtomEntry(metadata, toRoleEntitySet, (DataServicesAtomEntry)link.inlineEntry);
                }
                rt.add(OLinks.relatedEntityInline(link.relation, link.title, link.href, relatedEntity));
                continue;
            }
            rt.add(OLinks.relatedEntity(link.relation, link.title, link.href));
        }
        return rt;
    }

    public static class DataServicesAtomEntry
    extends AtomEntry {
        public final String etag;
        public final List<OProperty<?>> properties;
        private OEntity entity;

        private DataServicesAtomEntry(String etag, List<OProperty<?>> properties) {
            this.etag = etag;
            this.properties = properties;
        }

        public String toString() {
            return InternalUtil.reflectionToString(this);
        }

        @Override
        public OEntity getEntity() {
            return this.entity;
        }

        void setEntity(OEntity entity) {
            this.entity = entity;
        }
    }

    static class BasicAtomEntry
    extends AtomEntry {
        public String content;

        BasicAtomEntry() {
        }

        public String toString() {
            return InternalUtil.reflectionToString(this);
        }

        @Override
        public OEntity getEntity() {
            return null;
        }
    }

    static class AtomLink {
        public String relation;
        public String title;
        public String type;
        public String href;
        public AtomFeed inlineFeed;
        public AtomEntry inlineEntry;
        public boolean inlineContentExpected;

        AtomLink() {
        }

        public String getNavProperty() {
            if (this.relation != null && this.relation.startsWith("http://schemas.microsoft.com/ado/2007/08/dataservices/related/")) {
                return this.relation.substring("http://schemas.microsoft.com/ado/2007/08/dataservices/related/".length());
            }
            return null;
        }
    }

    static abstract class AtomEntry
    implements Entry {
        public String id;
        public String title;
        public String summary;
        public String updated;
        public String categoryTerm;
        public String categoryScheme;
        public String contentType;
        public List<AtomLink> atomLinks;

        AtomEntry() {
        }

        @Override
        public String getUri() {
            return null;
        }

        public String getETag() {
            return null;
        }

        public String getType() {
            return "application/atom+xml";
        }
    }

    public static class AtomFeed
    implements Feed {
        public String next;
        public Iterable<Entry> entries;

        @Override
        public Iterable<Entry> getEntries() {
            return this.entries;
        }

        @Override
        public String getNext() {
            return this.next;
        }
    }
}

