/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.json;

import java.io.Writer;
import java.math.BigDecimal;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.odata4j.core.Guid;
import org.odata4j.core.OCollection;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.OEntity;
import org.odata4j.core.OLink;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperty;
import org.odata4j.core.ORelatedEntitiesLinkInline;
import org.odata4j.core.ORelatedEntityLinkInline;
import org.odata4j.core.OSimpleObject;
import org.odata4j.core.UnsignedByte;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.json.JsonWriter;
import org.odata4j.internal.InternalUtil;
import org.odata4j.repack.org.apache.commons.codec.binary.Base64;

public abstract class JsonFormatWriter<T>
implements FormatWriter<T> {
    private final String jsonpCallback;

    public JsonFormatWriter(String jsonpCallback) {
        this.jsonpCallback = jsonpCallback;
    }

    protected abstract void writeContent(UriInfo var1, JsonWriter var2, T var3);

    @Override
    public String getContentType() {
        return this.jsonpCallback == null ? "application/json;charset=utf-8" : "text/javascript;charset=utf-8";
    }

    protected String getJsonpCallback() {
        return this.jsonpCallback;
    }

    @Override
    public void write(UriInfo uriInfo, Writer w, T target) {
        JsonWriter jw = new JsonWriter(w);
        if (this.getJsonpCallback() != null) {
            jw.startCallback(this.getJsonpCallback());
        }
        jw.startObject();
        jw.writeName("d");
        this.writeContent(uriInfo, jw, target);
        jw.endObject();
        if (this.getJsonpCallback() != null) {
            jw.endCallback();
        }
    }

    protected void writeProperty(JsonWriter jw, OProperty<?> prop) {
        jw.writeName(prop.getName());
        this.writeValue(jw, prop.getType(), prop.getValue());
    }

    protected void writeValue(JsonWriter jw, EdmType type, Object pvalue) {
        if (pvalue == null) {
            jw.writeNull();
        } else if (type.equals(EdmSimpleType.BINARY)) {
            jw.writeString(Base64.encodeBase64String((byte[])pvalue));
        } else if (type.equals(EdmSimpleType.BOOLEAN)) {
            jw.writeBoolean((Boolean)((Object)pvalue));
        } else if (type.equals(EdmSimpleType.BYTE)) {
            jw.writeNumber(((UnsignedByte)((Object)pvalue)).intValue());
        } else if (type.equals(EdmSimpleType.SBYTE)) {
            jw.writeNumber(((Byte)((Object)pvalue)).byteValue());
        } else if (type.equals(EdmSimpleType.DATETIME)) {
            jw.writeRaw(InternalUtil.formatDateTimeForJson((LocalDateTime)pvalue));
        } else if (type.equals(EdmSimpleType.DECIMAL)) {
            jw.writeString(((BigDecimal)((Object)pvalue)).toPlainString());
        } else if (type.equals(EdmSimpleType.DOUBLE)) {
            jw.writeString(pvalue.toString());
        } else if (type.equals(EdmSimpleType.GUID)) {
            jw.writeString(((Guid)((Object)pvalue)).toString());
        } else if (type.equals(EdmSimpleType.INT16)) {
            jw.writeNumber(((Short)((Object)pvalue)).shortValue());
        } else if (type.equals(EdmSimpleType.INT32)) {
            jw.writeNumber((Integer)((Object)pvalue));
        } else if (type.equals(EdmSimpleType.INT64)) {
            jw.writeString(pvalue.toString());
        } else if (type.equals(EdmSimpleType.SINGLE)) {
            jw.writeNumber(((Float)((Object)pvalue)).floatValue());
        } else if (type.equals(EdmSimpleType.TIME)) {
            jw.writeRaw(InternalUtil.formatTimeForJson((LocalTime)pvalue));
        } else if (type.equals(EdmSimpleType.DATETIMEOFFSET)) {
            jw.writeRaw(InternalUtil.formatDateTimeOffsetForJson((DateTime)pvalue));
        } else if (type instanceof EdmComplexType || type instanceof EdmSimpleType && !((EdmSimpleType)type).isSimple()) {
            if (pvalue instanceof OComplexObject) {
                pvalue = ((OComplexObject)((Object)pvalue)).getProperties();
            }
            this.writeComplexObject(jw, null, type.getFullyQualifiedTypeName(), pvalue);
        } else if (type instanceof EdmCollectionType) {
            this.writeCollection(jw, (EdmCollectionType)type, (OCollection)((Object)pvalue));
        } else {
            String value = pvalue.toString();
            jw.writeString(value);
        }
    }

    protected void writeCollection(JsonWriter jw, EdmCollectionType type, OCollection<? extends OObject> coll) {
        jw.startObject();
        jw.writeName("results");
        jw.startArray();
        boolean isFirst = true;
        for (OObject oObject : coll) {
            if (isFirst) {
                isFirst = false;
            } else {
                jw.writeSeparator();
            }
            if (oObject instanceof OComplexObject) {
                this.writeComplexObject(jw, null, oObject.getType().getFullyQualifiedTypeName(), ((OComplexObject)oObject).getProperties());
                continue;
            }
            if (!(oObject instanceof OSimpleObject)) continue;
            this.writeValue(jw, oObject.getType(), ((OSimpleObject)oObject).getValue());
        }
        jw.endArray();
        jw.endObject();
    }

    protected void writeComplexObject(JsonWriter jw, String complexObjectName, String fullyQualifiedTypeName, List<OProperty<?>> props) {
        jw.startObject();
        if (complexObjectName != null) {
            jw.writeName(complexObjectName);
            jw.startObject();
        }
        this.writeOProperties(jw, props);
        if (complexObjectName != null) {
            jw.endObject();
        }
        jw.endObject();
    }

    protected void writeOEntity(UriInfo uriInfo, JsonWriter jw, OEntity oe, EdmEntitySet ees, boolean isResponse) {
        jw.startObject();
        String baseUri = null;
        if (isResponse && oe.getEntityType() != null) {
            baseUri = uriInfo.getBaseUri().toString();
            jw.writeName("__metadata");
            jw.startObject();
            String absId = baseUri + InternalUtil.getEntityRelId(oe);
            jw.writeName("uri");
            jw.writeString(absId);
            jw.writeSeparator();
            jw.writeName("type");
            jw.writeString(oe.getEntityType().getFullyQualifiedTypeName());
            jw.endObject();
            jw.writeSeparator();
        }
        this.writeOProperties(jw, oe.getProperties());
        this.writeLinks(jw, oe, uriInfo, isResponse);
        jw.endObject();
    }

    protected void writeLinks(JsonWriter jw, OEntity oe, UriInfo uriInfo, boolean isResponse) {
        if (oe.getLinks() != null) {
            for (OLink link : oe.getLinks()) {
                if (isResponse) {
                    this.writeResponseLink(jw, link, oe, uriInfo);
                    continue;
                }
                this.writeRequestLink(jw, link, oe, uriInfo);
            }
        }
    }

    protected void writeResponseLink(JsonWriter jw, OLink link, OEntity oe, UriInfo uriInfo) {
        jw.writeSeparator();
        jw.writeName(link.getTitle());
        if (link.isInline()) {
            if (link.isCollection()) {
                jw.startObject();
                jw.writeName("results");
                jw.startArray();
                if (((ORelatedEntitiesLinkInline)link).getRelatedEntities() != null) {
                    boolean isFirstInlinedEntity = true;
                    for (OEntity re : ((ORelatedEntitiesLinkInline)link).getRelatedEntities()) {
                        if (isFirstInlinedEntity) {
                            isFirstInlinedEntity = false;
                        } else {
                            jw.writeSeparator();
                        }
                        this.writeOEntity(uriInfo, jw, re, re.getEntitySet(), true);
                    }
                }
                jw.endArray();
                jw.endObject();
            } else {
                OEntity re = ((ORelatedEntityLinkInline)link).getRelatedEntity();
                if (re == null) {
                    jw.writeNull();
                } else {
                    this.writeOEntity(uriInfo, jw, re, re.getEntitySet(), true);
                }
            }
        } else {
            jw.startObject();
            jw.writeName("__deferred");
            jw.startObject();
            String absId = uriInfo.getBaseUri().toString() + InternalUtil.getEntityRelId(oe);
            jw.writeName("uri");
            jw.writeString(absId + "/" + link.getTitle());
            jw.endObject();
            jw.endObject();
        }
    }

    protected void writeRequestLink(JsonWriter jw, OLink link, OEntity oe, UriInfo uriInfo) {
        jw.writeSeparator();
        jw.writeName(link.getTitle());
        if (link.isInline()) {
            if (link.isCollection()) {
                jw.startArray();
                if (((ORelatedEntitiesLinkInline)link).getRelatedEntities() != null) {
                    List<OEntity> relEntities = ((ORelatedEntitiesLinkInline)link).getRelatedEntities();
                    int size = relEntities.size();
                    for (int i = 0; i < size; ++i) {
                        OEntity relEntity = relEntities.get(i);
                        this.writeOEntity(uriInfo, jw, relEntity, relEntity.getEntitySet(), false);
                        if (i >= size - 1) continue;
                        jw.writeSeparator();
                    }
                }
                jw.endArray();
            } else {
                OEntity relEntity = ((ORelatedEntityLinkInline)link).getRelatedEntity();
                if (relEntity == null) {
                    jw.writeNull();
                } else {
                    this.writeOEntity(uriInfo, jw, relEntity, relEntity.getEntitySet(), false);
                }
            }
        } else {
            this.writeInlineLink(jw, link);
        }
    }

    private void writeInlineLink(JsonWriter jw, OLink link) {
        jw.startObject();
        jw.writeName("__metadata");
        jw.startObject();
        jw.writeName("uri");
        jw.writeString(link.getHref());
        jw.endObject();
        jw.endObject();
    }

    protected void writeOProperties(JsonWriter jw, List<OProperty<?>> properties) {
        boolean isFirst = true;
        for (OProperty<?> prop : properties) {
            if (isFirst) {
                isFirst = false;
            } else {
                jw.writeSeparator();
            }
            this.writeProperty(jw, prop);
        }
    }
}

