/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import org.core4j.Enumerable;
import org.odata4j.consumer.AbstractConsumerEntityRequest;
import org.odata4j.consumer.ConsumerQueryLinksRequest;
import org.odata4j.consumer.ODataClient;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.core.OEntityId;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.exceptions.ODataProducerException;

public class ConsumerUpdateLinkRequest
extends AbstractConsumerEntityRequest<Void> {
    private final String targetNavProp;
    private final Object[] oldTargetKeyValues;
    private final OEntityId newTargetEntity;

    public ConsumerUpdateLinkRequest(ODataClient client, String serviceRootUri, EdmDataServices metadata, OEntityId sourceEntity, OEntityId newTargetEntity, String targetNavProp, Object ... oldTargetKeyValues) {
        super(client, serviceRootUri, metadata, sourceEntity.getEntitySetName(), sourceEntity.getEntityKey());
        this.targetNavProp = targetNavProp;
        this.oldTargetKeyValues = oldTargetKeyValues;
        this.newTargetEntity = newTargetEntity;
    }

    @Override
    public Void execute() throws ODataProducerException {
        String path = Enumerable.create(this.getSegments()).join("/");
        path = (String)ConsumerQueryLinksRequest.linksPath(this.targetNavProp, this.oldTargetKeyValues).apply((Object)path);
        ODataClientRequest request = ODataClientRequest.put(this.getServiceRootUri() + path, this.toSingleLink(this.newTargetEntity));
        this.getClient().updateLink(request);
        return null;
    }
}

