/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.util.ArrayList;
import java.util.List;
import org.teiid.metadata.Column;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Table;

public class ForeignKey
extends KeyRecord {
    private static final long serialVersionUID = -8835750783230001311L;
    private String uniqueKeyID;
    private KeyRecord primaryKey;
    private String referenceTableName;
    private List<String> referenceColumns;
    public static final String ALLOW_JOIN = "{http://www.teiid.org/ext/relational/2012}allow-join";

    public ForeignKey() {
        super(KeyRecord.Type.Foreign);
    }

    public String getUniqueKeyID() {
        return this.uniqueKeyID;
    }

    public void setUniqueKeyID(String keyID) {
        this.uniqueKeyID = keyID;
    }

    public KeyRecord getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(KeyRecord primaryKey) {
        this.primaryKey = primaryKey;
        if (this.primaryKey != null) {
            this.referenceColumns = new ArrayList<String>();
            for (Column c : primaryKey.getColumns()) {
                this.referenceColumns.add(c.getName());
            }
            if (primaryKey.getParent() != null) {
                this.referenceTableName = ((Table)primaryKey.getParent()).getName();
            }
            this.uniqueKeyID = primaryKey.getUUID();
        } else {
            this.referenceColumns = null;
            this.referenceTableName = null;
            this.uniqueKeyID = null;
        }
    }

    public String getReferenceTableName() {
        if (this.referenceTableName == null && this.primaryKey != null) {
            this.referenceTableName = ((Table)this.primaryKey.getParent()).getName();
        }
        return this.referenceTableName;
    }

    public void setReferenceTableName(String tableName) {
        this.referenceTableName = tableName;
    }

    public List<String> getReferenceColumns() {
        return this.referenceColumns;
    }

    public void setReferenceColumns(List<String> referenceColumns) {
        this.referenceColumns = referenceColumns;
    }
}

