/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ldap;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapContext;
import org.teiid.core.BundleUtil;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.ldap.IQueryToLdapSearchParser;
import org.teiid.translator.ldap.LDAPExecutionFactory;
import org.teiid.translator.ldap.LDAPPlugin;
import org.teiid.translator.ldap.LDAPQueryExecution;
import org.teiid.translator.ldap.LDAPSearchDetails;

public class LDAPSyncQueryExecution
implements ResultSetExecution {
    protected LdapContext ldapConnection;
    private Select query;
    protected LDAPExecutionFactory executionFactory;
    protected ExecutionContext executionContext;
    protected LDAPQueryExecution delegate;

    public LDAPSyncQueryExecution(Select query, LDAPExecutionFactory factory, ExecutionContext context, LdapContext connection) {
        this.ldapConnection = connection;
        this.query = query;
        this.executionFactory = factory;
        this.executionContext = context;
    }

    public void execute() throws TranslatorException {
        IQueryToLdapSearchParser parser = new IQueryToLdapSearchParser(this.executionFactory);
        LDAPSearchDetails searchDetails = parser.translateSQLQueryToLDAPSearch(this.query);
        LdapContext context = this.createSearchContext(searchDetails.getContextName());
        SearchControls ctrls = this.setSearchControls(searchDetails);
        this.delegate = new LDAPQueryExecution(context, searchDetails, ctrls, this.executionFactory, this.executionContext);
        this.delegate.execute();
    }

    protected LdapContext createSearchContext(String contextName) throws TranslatorException {
        try {
            return (LdapContext)this.ldapConnection.lookup(contextName);
        }
        catch (NamingException ne) {
            if (contextName != null) {
                LogManager.logError((String)"org.teiid.CONNECTOR", (Object)LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12002, new Object[]{contextName}));
            }
            String msg = LDAPPlugin.Util.getString("LDAPSyncQueryExecution.createContextError");
            throw new TranslatorException(msg);
        }
    }

    private SearchControls setSearchControls(LDAPSearchDetails searchDetails) {
        SearchControls ctrls = new SearchControls();
        ArrayList<Column> modelAttrList = searchDetails.getElementList();
        String[] attrs = new String[modelAttrList.size()];
        for (int i = 0; i < attrs.length; ++i) {
            attrs[i] = IQueryToLdapSearchParser.getNameFromElement(modelAttrList.get(i));
        }
        ctrls.setSearchScope(searchDetails.getSearchScope());
        ctrls.setReturningAttributes(attrs);
        long limit = searchDetails.getCountLimit();
        if (limit != -1L) {
            ctrls.setCountLimit(limit);
        }
        return ctrls;
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        return this.delegate.next();
    }

    public void cancel() throws TranslatorException {
        this.delegate.cancel();
    }

    public void close() {
        this.delegate.close();
    }

    LDAPQueryExecution getDelegate() {
        return this.delegate;
    }
}

