/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ldap;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.ldap.SortKey;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.language.AndOr;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Exists;
import org.teiid.language.Expression;
import org.teiid.language.In;
import org.teiid.language.Like;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Not;
import org.teiid.language.OrderBy;
import org.teiid.language.Select;
import org.teiid.language.SortSpecification;
import org.teiid.language.TableReference;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.ldap.LDAPExecutionFactory;
import org.teiid.translator.ldap.LDAPPlugin;
import org.teiid.translator.ldap.LDAPSearchDetails;

public class IQueryToLdapSearchParser {
    private static final String ATTRIBUTES = "attributes";
    private static final String COUNT_LIMIT = "count-limit";
    private static final String TIMEOUT = "timeout";
    private static final String SEARCH_SCOPE = "search-scope";
    private static final String CRITERIA = "filter";
    private static final String CONTEXT_NAME = "context-name";
    LDAPExecutionFactory executionFactory;

    public IQueryToLdapSearchParser(LDAPExecutionFactory factory) {
        this.executionFactory = factory;
    }

    public LDAPSearchDetails translateSQLQueryToLDAPSearch(Select query) throws TranslatorException {
        ArrayList<Column> elementList = this.getElementsFromSelectSymbols(query);
        List fromList = query.getFrom();
        Iterator itr = fromList.iterator();
        if (!itr.hasNext()) {
            String msg = LDAPPlugin.Util.getString("IQueryToLdapSearchParser.noTablesInFromError");
            throw new TranslatorException(msg);
        }
        TableReference fItm = (TableReference)itr.next();
        if (itr.hasNext()) {
            String msg = LDAPPlugin.Util.getString("IQueryToLdapSearchParser.multiItemsInFromError");
            throw new TranslatorException(msg);
        }
        LDAPSearchDetails sd = null;
        String contextName = this.getContextNameFromFromItem(fItm);
        int searchScope = this.getSearchScopeFromFromItem(fItm);
        String classRestriction = this.getRestrictToNamedClass(fItm);
        List<String> searchStringList = new LinkedList<String>();
        searchStringList = this.getSearchFilterFromWhereClause(query.getWhere(), searchStringList);
        StringBuilder filterBuilder = new StringBuilder();
        for (String string : searchStringList) {
            filterBuilder.append(string);
        }
        if (classRestriction != null && classRestriction.trim().length() > 0) {
            filterBuilder.insert(0, "(&").append("(objectClass=").append(classRestriction).append("))");
        }
        OrderBy orderBy = query.getOrderBy();
        SortKey[] sortKeys = this.getSortKeysFromOrderByClause(orderBy);
        Limit limit = query.getLimit();
        long countLimit = -1L;
        if (limit != null) {
            countLimit = limit.getRowLimit();
        }
        sd = new LDAPSearchDetails(contextName, searchScope, filterBuilder.toString(), sortKeys, countLimit, elementList, 0);
        sd.printDetailsToLog();
        return sd;
    }

    private SortKey[] getSortKeysFromOrderByClause(OrderBy orderBy) throws TranslatorException {
        SortKey[] sortKeys = null;
        if (orderBy != null) {
            List orderItems = orderBy.getSortSpecifications();
            if (orderItems == null) {
                return null;
            }
            SortKey sortKey = null;
            sortKeys = new SortKey[orderItems.size()];
            Iterator orderItr = orderItems.iterator();
            int i = 0;
            while (orderItr.hasNext()) {
                SortSpecification item = (SortSpecification)orderItr.next();
                String itemName = this.getExpressionString(item.getExpression());
                LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Adding sort key for item: " + itemName});
                if (item.getOrdering() == SortSpecification.Ordering.ASC) {
                    LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"with ASC ordering."});
                    sortKey = new SortKey(itemName, true, null);
                } else if (item.getOrdering() == SortSpecification.Ordering.DESC) {
                    LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"with DESC ordering."});
                    sortKey = new SortKey(itemName, false, null);
                }
                sortKeys[i] = sortKey;
                ++i;
            }
        }
        return sortKeys;
    }

    private String getContextNameFromFromItem(TableReference fromItem) throws TranslatorException {
        String contextName;
        if (fromItem instanceof NamedTable) {
            String[] nameInSourceArray;
            Table group = ((NamedTable)fromItem).getMetadataObject();
            String nameInSource = group.getNameInSource();
            if (nameInSource == null) {
                nameInSource = "";
            }
            if ((contextName = (nameInSourceArray = nameInSource.split("\\?"))[0]).equals("")) {
                contextName = this.executionFactory.getSearchDefaultBaseDN();
            }
        } else {
            String msg = LDAPPlugin.Util.getString("IQueryToLdapSearchParser.groupCountExceededError");
            throw new TranslatorException(msg);
        }
        if (contextName == null || contextName.equals("")) {
            String msg = LDAPPlugin.Util.getString("IQueryToLdapSearchParser.baseContextNameError");
            throw new TranslatorException(msg);
        }
        return contextName;
    }

    private String getRestrictToNamedClass(TableReference fromItem) throws TranslatorException {
        String namedClass = null;
        if (fromItem instanceof NamedTable) {
            String[] nameInSourceArray;
            Table mdIDGroup = ((NamedTable)fromItem).getMetadataObject();
            String nameInSource = mdIDGroup.getNameInSource();
            if (nameInSource == null) {
                nameInSource = "";
            }
            if ((nameInSourceArray = nameInSource.split("\\?")).length >= 3) {
                namedClass = nameInSourceArray[2];
            }
            if (namedClass == null || namedClass.equals("")) {
                namedClass = !this.executionFactory.isRestrictToObjectClass() ? "" : mdIDGroup.getName();
            }
        } else {
            String msg = LDAPPlugin.Util.getString("IQueryToLdapSearchParser.groupCountExceededError");
            throw new TranslatorException(msg);
        }
        return namedClass;
    }

    private int getSearchScopeFromFromItem(TableReference fromItem) throws TranslatorException {
        String searchScopeString = "";
        int searchScope = 1;
        if (fromItem instanceof NamedTable) {
            String[] nameInSourceArray;
            Table group = ((NamedTable)fromItem).getMetadataObject();
            String nameInSource = group.getNameInSource();
            if (nameInSource == null) {
                nameInSource = "";
            }
            if ((nameInSourceArray = nameInSource.split("\\?")).length >= 2) {
                searchScopeString = nameInSourceArray[1];
            }
            if (searchScopeString.equals("")) {
                LDAPExecutionFactory.SearchDefaultScope searchDefaultScope = this.executionFactory.getSearchDefaultScope();
                if (searchDefaultScope != null) {
                    searchScopeString = searchDefaultScope.name();
                }
                if (searchScopeString == null) {
                    searchScopeString = "";
                }
            }
            if (searchScopeString.equals("SUBTREE_SCOPE")) {
                searchScope = 2;
            } else if (searchScopeString.equals("ONELEVEL_SCOPE")) {
                searchScope = 1;
            } else if (searchScopeString.equals("OBJECT_SCOPE")) {
                searchScope = 0;
            }
        } else {
            String msg = LDAPPlugin.Util.getString("IQueryToLdapSearchParser.groupCountExceededError");
            throw new TranslatorException(msg);
        }
        return searchScope;
    }

    private String parseCompoundCriteriaOp(AndOr.Operator op) throws TranslatorException {
        switch (op) {
            case AND: {
                return "&";
            }
            case OR: {
                return "|";
            }
        }
        String msg = LDAPPlugin.Util.getString("IQueryToLdapSearchParser.criteriaNotParsableError");
        throw new TranslatorException(msg);
    }

    private String getExpressionString(Expression e) throws TranslatorException {
        String expressionName = null;
        if (e instanceof ColumnReference) {
            Column mdIDElement = ((ColumnReference)e).getMetadataObject();
            expressionName = mdIDElement.getNameInSource();
            if (expressionName == null || expressionName.equals("")) {
                expressionName = mdIDElement.getName();
            }
        } else if (e instanceof Literal) {
            expressionName = IQueryToLdapSearchParser.getExpressionString((Literal)e);
        } else {
            String msg = LDAPPlugin.Util.getString("IQueryToLdapSearchParser.unsupportedElementError", new Object[]{e.getClass().getSimpleName()});
            throw new TranslatorException(msg + e.toString());
        }
        expressionName = IQueryToLdapSearchParser.escapeReservedChars(expressionName);
        return expressionName;
    }

    static String getExpressionString(Literal l) {
        if (l.getValue() instanceof Timestamp) {
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Found an expression that uses timestamp; converting to LDAP string format."});
            Timestamp ts = (Timestamp)l.getValue();
            Date dt = new Date(ts.getTime());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss'Z'");
            String expressionName = sdf.format(dt);
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Timestamp to string is: " + expressionName});
            return expressionName;
        }
        if (l.getValue() != null) {
            return l.getValue().toString();
        }
        return "null";
    }

    static String escapeReservedChars(String expr) {
        StringBuffer sb = new StringBuffer();
        block7: for (int i = 0; i < expr.length(); ++i) {
            char curChar = expr.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    private List<String> getSearchFilterFromWhereClause(Condition criteria, List<String> filterList) throws TranslatorException {
        if (criteria == null) {
            filterList.add("(objectClass=*)");
        }
        boolean isNegated = false;
        if (criteria instanceof AndOr) {
            AndOr crit = (AndOr)criteria;
            AndOr.Operator op = crit.getOperator();
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Parsing compound criteria."});
            String stringOp = this.parseCompoundCriteriaOp(op);
            filterList.add("(");
            filterList.add(stringOp);
            filterList.addAll(this.getSearchFilterFromWhereClause(crit.getLeftCondition(), new LinkedList<String>()));
            filterList.addAll(this.getSearchFilterFromWhereClause(crit.getRightCondition(), new LinkedList<String>()));
            filterList.add(")");
        } else if (criteria instanceof Comparison) {
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Parsing compare criteria."});
            Comparison.Operator op = ((Comparison)criteria).getOperator();
            isNegated = op == Comparison.Operator.NE || op == Comparison.Operator.GT || op == Comparison.Operator.LT;
            Expression lhs = ((Comparison)criteria).getLeftExpression();
            Expression rhs = ((Comparison)criteria).getRightExpression();
            String lhsString = this.getExpressionString(lhs);
            String rhsString = this.getExpressionString(rhs);
            if (lhsString == null || rhsString == null) {
                String msg = LDAPPlugin.Util.getString("IQueryToLdapSearchParser.missingNISError");
                throw new TranslatorException(msg);
            }
            this.addCompareCriteriaToList(filterList, op, lhsString, rhsString);
        } else if (criteria instanceof Exists) {
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Parsing EXISTS criteria: NOT IMPLEMENTED YET"});
        } else if (criteria instanceof Like) {
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Parsing LIKE criteria."});
            isNegated = ((Like)criteria).isNegated();
            Comparison.Operator op = Comparison.Operator.EQ;
            Expression lhs = ((Like)criteria).getLeftExpression();
            Expression rhs = ((Like)criteria).getRightExpression();
            String lhsString = this.getExpressionString(lhs);
            String rhsString = this.getExpressionString(rhs);
            rhsString = rhsString.replace("%", "*");
            this.addCompareCriteriaToList(filterList, op, lhsString, rhsString);
        } else if (criteria instanceof In) {
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Parsing IN criteria."});
            isNegated = ((In)criteria).isNegated();
            Expression lhs = ((In)criteria).getLeftExpression();
            List rhsList = ((In)criteria).getRightExpressions();
            this.processInCriteriaList(filterList, rhsList, lhs);
        } else if (criteria instanceof Not) {
            LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Parsing NOT criteria."});
            isNegated = true;
            filterList.addAll(this.getSearchFilterFromWhereClause(((Not)criteria).getCriteria(), new LinkedList<String>()));
        }
        if (isNegated) {
            filterList.add(0, "(");
            filterList.add(1, "!");
            filterList.add(")");
        }
        return filterList;
    }

    private void processInCriteriaList(List<String> filterList, List<Expression> rhsList, Expression lhs) throws TranslatorException {
        if (rhsList.size() == 0) {
            return;
        }
        filterList.add("(");
        filterList.add(this.parseCompoundCriteriaOp(AndOr.Operator.OR));
        Iterator<Expression> rhsItr = rhsList.iterator();
        while (rhsItr.hasNext()) {
            this.addCompareCriteriaToList(filterList, Comparison.Operator.EQ, this.getExpressionString(lhs), this.getExpressionString(rhsItr.next()));
        }
        filterList.add(")");
    }

    private void addCompareCriteriaToList(List<String> filterList, Comparison.Operator op, String lhs, String rhs) throws TranslatorException {
        filterList.add("(");
        filterList.add(lhs);
        switch (op) {
            case NE: 
            case EQ: {
                filterList.add("=");
                break;
            }
            case LT: 
            case GE: {
                filterList.add(">=");
                break;
            }
            case GT: 
            case LE: {
                filterList.add("<=");
                break;
            }
            default: {
                String msg = LDAPPlugin.Util.getString("IQueryToLdapSearchParser.criteriaNotSupportedError");
                throw new TranslatorException(msg);
            }
        }
        filterList.add(rhs);
        filterList.add(")");
    }

    public static String getNameFromElement(Column e) {
        String ldapAttributeName = null;
        ldapAttributeName = e.getNameInSource();
        if (ldapAttributeName == null || ldapAttributeName.equals("")) {
            ldapAttributeName = e.getName();
        }
        return ldapAttributeName;
    }

    private ArrayList<Column> getElementsFromSelectSymbols(Select query) {
        ArrayList<Column> selectElementList = new ArrayList<Column>();
        Iterator selectSymbolItr = query.getDerivedColumns().iterator();
        while (selectSymbolItr.hasNext()) {
            Column e = this.getElementFromSymbol((DerivedColumn)selectSymbolItr.next());
            selectElementList.add(e);
        }
        return selectElementList;
    }

    private Column getElementFromSymbol(DerivedColumn symbol) {
        ColumnReference expr = (ColumnReference)symbol.getExpression();
        return expr.getMetadataObject();
    }

    public LDAPSearchDetails buildRequest(String query) throws TranslatorException {
        ArrayList<String> attributes = new ArrayList<String>();
        ArrayList<Column> columns = new ArrayList<Column>();
        String contextName = null;
        String criteria = "";
        String searchScope = this.executionFactory.getSearchDefaultScope().name();
        int timeLimit = 0;
        long countLimit = -1L;
        List parts = StringUtil.tokenize((String)query, (char)';');
        for (String var : parts) {
            int index = var.indexOf(61);
            if (index == -1) {
                throw new TranslatorException(LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12013, new Object[]{var}));
            }
            String key = var.substring(0, index).trim();
            String value = var.substring(index + 1).trim();
            if (key.equalsIgnoreCase(CONTEXT_NAME)) {
                contextName = value;
                continue;
            }
            if (key.equalsIgnoreCase(CRITERIA)) {
                criteria = value;
                continue;
            }
            if (key.equalsIgnoreCase(SEARCH_SCOPE)) {
                searchScope = value;
                continue;
            }
            if (key.equalsIgnoreCase(TIMEOUT)) {
                timeLimit = Integer.parseInt(value);
                continue;
            }
            if (key.equalsIgnoreCase(COUNT_LIMIT)) {
                countLimit = Long.parseLong(value);
                continue;
            }
            if (key.equalsIgnoreCase(ATTRIBUTES)) {
                StringTokenizer attrTokens = new StringTokenizer(value, ",");
                while (attrTokens.hasMoreElements()) {
                    String name = attrTokens.nextToken().trim();
                    attributes.add(name);
                    Column column = new Column();
                    column.setName(name);
                    Datatype type = new Datatype();
                    type.setName("object");
                    type.setJavaClassName(Object.class.getCanonicalName());
                    column.setDatatype(type, true);
                    columns.add(column);
                }
                continue;
            }
            throw new TranslatorException(LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12013, new Object[]{var}));
        }
        int searchScopeInt = this.buildSearchScope(searchScope);
        return new LDAPSearchDetails(contextName, searchScopeInt, criteria, null, countLimit, columns, timeLimit);
    }

    private int buildSearchScope(String searchScope) {
        int searchScopeInt = 0;
        if (searchScope.equalsIgnoreCase("OBJECT_SCOPE")) {
            searchScopeInt = 0;
        } else if (searchScope.equalsIgnoreCase("ONELEVEL_SCOPE")) {
            searchScopeInt = 1;
        } else if (searchScope.equalsIgnoreCase("SUBTREE_SCOPE")) {
            searchScopeInt = 2;
        }
        return searchScopeInt;
    }
}

