/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol;

import java.io.Closeable;
import java.io.IOException;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.ProtocolConnectionUtils;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;

public class ProtocolConnectionManager {
    private ConnectTask connectTask;
    private volatile boolean shutdown;
    private volatile Connection connection;
    public static final ConnectTask DISCONNECTED = new ConnectTask(){

        @Override
        public ConnectionOpenHandler getConnectionOpenedHandler() {
            return new ConnectionOpenHandler(){

                @Override
                public void connectionOpened(Connection connection) throws IOException {
                }
            };
        }

        @Override
        public Connection connect() throws IOException {
            throw ProtocolMessages.MESSAGES.channelClosed();
        }

        @Override
        public ConnectTask connectionClosed() {
            return this;
        }

        @Override
        public void shutdown() {
        }
    };

    protected ProtocolConnectionManager(ConnectTask initial) {
        if (initial == null) {
            ProtocolMessages.MESSAGES.nullVar("connectTask");
        }
        this.connectTask = initial;
    }

    public boolean isConnected() {
        return this.connection != null && !this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connect() throws IOException {
        Connection connection;
        ProtocolConnectionManager protocolConnectionManager = this;
        synchronized (protocolConnectionManager) {
            if (this.shutdown) {
                throw ProtocolMessages.MESSAGES.channelClosed();
            }
            connection = this.connection;
            if (connection == null) {
                connection = this.connectTask.connect();
                if (connection == null) {
                    throw ProtocolMessages.MESSAGES.channelClosed();
                }
                boolean ok = false;
                try {
                    ConnectionOpenHandler openHandler = this.connectTask.getConnectionOpenedHandler();
                    openHandler.connectionOpened(connection);
                    ok = true;
                    this.connection = connection;
                    connection.addCloseHandler((CloseHandler)new CloseHandler<Connection>(){

                        public void handleClose(Connection closed, IOException exception) {
                            ProtocolConnectionManager.this.onConnectionClose(closed);
                        }
                    });
                }
                finally {
                    if (!ok) {
                        StreamUtils.safeClose((Closeable)connection);
                    }
                }
            }
        }
        return connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Connection connection;
        ProtocolConnectionManager protocolConnectionManager = this;
        synchronized (protocolConnectionManager) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            connection = this.connection;
            if (this.connectTask != null) {
                this.connectTask.shutdown();
            }
        }
        StreamUtils.safeClose((Closeable)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnectionClose(Connection closed) {
        ProtocolConnectionManager protocolConnectionManager = this;
        synchronized (protocolConnectionManager) {
            if (this.connection == closed) {
                this.connection = null;
                if (this.shutdown) {
                    this.connectTask = DISCONNECTED;
                    return;
                }
                ConnectTask previous = this.connectTask;
                this.connectTask = previous.connectionClosed();
            }
        }
    }

    public static ProtocolConnectionManager create(Connection connection, ConnectionOpenHandler openHandler) {
        return ProtocolConnectionManager.create(new EstablishedConnection(connection, openHandler));
    }

    public static ProtocolConnectionManager create(ProtocolConnectionConfiguration configuration, ConnectionOpenHandler openHandler) {
        return ProtocolConnectionManager.create(new EstablishingConnection(configuration, openHandler));
    }

    public static ProtocolConnectionManager create(ProtocolConnectionConfiguration configuration, ConnectionOpenHandler openHandler, ConnectTask next) {
        return ProtocolConnectionManager.create(new EstablishingConnection(configuration, openHandler, next));
    }

    public static ProtocolConnectionManager create(ConnectTask connectTask) {
        return new ProtocolConnectionManager(connectTask);
    }

    static class EstablishedConnection
    implements ConnectTask {
        private final Connection connection;
        private final ConnectionOpenHandler openHandler;

        private EstablishedConnection(Connection connection, ConnectionOpenHandler openHandler) {
            this.connection = connection;
            this.openHandler = openHandler;
        }

        @Override
        public ConnectionOpenHandler getConnectionOpenedHandler() {
            return this.openHandler;
        }

        @Override
        public Connection connect() throws IOException {
            return this.connection;
        }

        @Override
        public ConnectTask connectionClosed() {
            return DISCONNECTED;
        }

        @Override
        public void shutdown() {
        }
    }

    static class EstablishingConnection
    implements ConnectTask {
        private final ConnectTask next;
        private final ConnectionOpenHandler openHandler;
        private final ProtocolConnectionConfiguration configuration;

        protected EstablishingConnection(ProtocolConnectionConfiguration configuration, ConnectionOpenHandler openHandler) {
            this.configuration = configuration;
            this.openHandler = openHandler;
            this.next = this;
        }

        protected EstablishingConnection(ProtocolConnectionConfiguration configuration, ConnectionOpenHandler openHandler, ConnectTask next) {
            this.configuration = configuration;
            this.openHandler = openHandler;
            this.next = next;
        }

        @Override
        public ConnectionOpenHandler getConnectionOpenedHandler() {
            return this.openHandler;
        }

        @Override
        public Connection connect() throws IOException {
            return ProtocolConnectionUtils.connectSync(this.configuration);
        }

        @Override
        public ConnectTask connectionClosed() {
            return this.next;
        }

        @Override
        public void shutdown() {
        }
    }

    public static interface ConnectTask {
        public ConnectionOpenHandler getConnectionOpenedHandler();

        public Connection connect() throws IOException;

        public ConnectTask connectionClosed();

        public void shutdown();
    }

    public static interface ConnectionOpenHandler {
        public void connectionOpened(Connection var1) throws IOException;
    }
}

