/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.xquery;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nux.xom.xquery.ResultSequence;
import nux.xom.xquery.XQueryException;
import nux.xom.xquery.XQueryUtil;

final class DefaultResultSequence
implements ResultSequence {
    private SequenceIterator results;
    private Configuration config;
    private HashMap alreadyConverted = null;
    private static final boolean DEBUG = XQueryUtil.getSystemProperty("nux.xom.xquery.XQuery.debug", false);
    private static final boolean PRESERVE_IDENTITIES = XQueryUtil.getSystemProperty("nux.xom.xquery.XQuery.preserveIdentities", true);
    private static final Element ATOMIC_VALUE = new Element("item:atomic-value", "http://dsd.lbl.gov/nux");
    private static final Method saxon85Method;
    private static final Method saxon86Method;
    private static final Method saxon86GenerateIdMethod;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        ATOMIC_VALUE.addAttribute(new Attribute("xsi:type", "http://www.w3.org/2001/XMLSchema-instance", ""));
        ATOMIC_VALUE.appendChild("");
        saxon85Method = DefaultResultSequence.findGetItemTypeMethod85();
        saxon86Method = DefaultResultSequence.findGetItemTypeMethod86();
        saxon86GenerateIdMethod = DefaultResultSequence.findGenerateIdMethod86();
    }

    DefaultResultSequence(SequenceIterator results, Configuration config) {
        this.results = results;
        this.config = config;
    }

    public Nodes toNodes() throws XQueryException {
        Node next;
        Nodes nodes = new Nodes();
        while ((next = this.next()) != null) {
            nodes.append(next);
        }
        return nodes;
    }

    public Node next() throws XQueryException {
        if (this.results != null) {
            Item item;
            try {
                item = this.results.next();
            }
            catch (TransformerException e) {
                throw new XQueryException(e);
            }
            if (item != null) {
                return this.convertItem(item);
            }
            this.results = null;
            this.config = null;
            this.alreadyConverted = null;
        }
        return null;
    }

    private Node convertItem(Item item) {
        Object base = item;
        while (base instanceof VirtualNode) {
            if (!((base = ((VirtualNode)base).getUnderlyingNode()) instanceof Node)) continue;
            return (Node)base;
        }
        if (DEBUG) {
            System.err.println("item.getClass=" + (item == null ? "null" : item.getClass().getName()));
        }
        if (item instanceof NodeInfo) {
            return this.convertTree((NodeInfo)item);
        }
        if (item instanceof AtomicValue) {
            return this.convertAtomicValue((AtomicValue)item);
        }
        throw new IllegalArgumentException("Oops! Expected atomic value but found non-atomic type: " + (item == null ? "null" : item.getClass().getName()));
    }

    private Node convertTree(NodeInfo node) {
        NodeInfo root;
        if (PRESERVE_IDENTITIES && this.alreadyConverted == null) {
            this.alreadyConverted = new HashMap();
        }
        Node value = this.convertNodeInfo(node);
        if (PRESERVE_IDENTITIES && node.getNodeKind() != 13 && !(root = node.getRoot()).isSameNodeInfo(node)) {
            if (DEBUG) {
                System.err.println("ROOT converting nodeinfo: " + root.getStringValue() + " : " + root);
            }
            this.convertNodeInfo(root);
        }
        return value;
    }

    private Node convertNodeInfo(NodeInfo node) {
        Attribute value;
        Object key = null;
        if (PRESERVE_IDENTITIES && (value = (Node)this.alreadyConverted.get(key = saxon86GenerateIdMethod == null ? node : new NodeInfoIdentityKey(node))) != null) {
            if (DEBUG) {
                System.err.println("FOUND already converted nodeinfo: " + node.getStringValue() + " : " + node);
            }
            return value;
        }
        if (DEBUG) {
            System.err.println("NEW  converting nodeinfo: " + node.getStringValue() + " : " + node);
        }
        switch (node.getNodeKind()) {
            case 2: {
                value = this.convertAttributeNodeInfo(node);
                break;
            }
            case 1: {
                value = this.convertElementNodeInfo(node);
                break;
            }
            case 9: {
                value = this.convertDocumentNodeInfo(node);
                break;
            }
            case 3: {
                value = new Text(node.getStringValue());
                break;
            }
            case 8: {
                value = new Comment(node.getStringValue());
                break;
            }
            case 7: {
                value = new ProcessingInstruction(node.getLocalPart(), node.getStringValue());
                break;
            }
            case 13: {
                value = this.convertAtomicValue((AtomicValue)new AnyURIValue((CharSequence)node.getStringValue()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal NodeInfo kind: " + node.getClass().getName());
            }
        }
        if (PRESERVE_IDENTITIES) {
            this.alreadyConverted.put(key, value);
        }
        return value;
    }

    private Attribute convertAttributeNodeInfo(NodeInfo node) {
        return new Attribute(node.getDisplayName(), node.getURI(), node.getStringValue());
    }

    private Document convertDocumentNodeInfo(NodeInfo node) {
        NodeInfo next;
        Document doc = new Document(new Element("fakeRoot"));
        doc.setBaseURI(node.getBaseURI());
        boolean hasRootElement = false;
        int i = 0;
        AxisIterator iter = node.iterateAxis((byte)3);
        while ((next = (NodeInfo)iter.next()) != null) {
            Node child = this.convertNodeInfo(next);
            if (child instanceof Element) {
                if (hasRootElement) {
                    throw new IllegalAddException("A XOM document must not have more than one root element.");
                }
                doc.setRootElement((Element)child);
                hasRootElement = true;
            } else {
                doc.insertChild(child, i);
            }
            ++i;
        }
        if (!hasRootElement) {
            throw new IllegalAddException("Missing document root element; A XOM document must have a root element.");
        }
        return doc;
    }

    private Element convertElementNodeInfo(NodeInfo node) {
        int nsCode;
        NodeInfo next;
        if (DEBUG) {
            System.err.println("converting element=" + node.getDisplayName());
        }
        Element elem = new Element(node.getDisplayName(), node.getURI());
        AxisIterator iter = node.iterateAxis((byte)2);
        ArrayList<String> prefixes = null;
        while ((next = (NodeInfo)iter.next()) != null) {
            elem.addAttribute((Attribute)this.convertNodeInfo(next));
            String prefix = next.getPrefix();
            if (prefix.length() == 0) continue;
            if (prefixes == null) {
                prefixes = new ArrayList<String>(1);
            }
            prefixes.add(prefix);
        }
        int[] namespaces = node.getDeclaredNamespaces(NodeInfo.EMPTY_NAMESPACE_LIST);
        int i = 0;
        NamePool pool = null;
        while (i < namespaces.length && (nsCode = namespaces[i]) != -1) {
            short uriCode = (short)(nsCode & 0xFFFF);
            if (uriCode != 0) {
                if (pool == null) {
                    pool = node.getNamePool();
                }
                String uri = pool.getURIFromURICode(uriCode);
                String prefix = pool.getPrefixFromNamespaceCode(nsCode);
                if (prefixes != null && prefixes.contains(prefix)) {
                    if (DEBUG) {
                        System.err.println("Safely ignoring additional namespace declaration for prefix=" + prefix + ", uri=" + uri);
                    }
                } else {
                    if (DEBUG) {
                        System.err.println("Adding additional namespace declaration for prefix=" + prefix + ", uri=" + uri);
                    }
                    elem.addNamespaceDeclaration(prefix, uri);
                }
            }
            ++i;
        }
        prefixes = null;
        namespaces = null;
        iter = node.iterateAxis((byte)3);
        while ((next = (NodeInfo)iter.next()) != null) {
            elem.appendChild(this.convertNodeInfo(next));
        }
        return elem;
    }

    private Node convertAtomicValue(AtomicValue value) {
        if (DEBUG) {
            System.err.println("atomicValue.getClass=" + value.getClass().getName());
        }
        Element elem = new Element(ATOMIC_VALUE);
        elem.getAttribute(0).setValue(this.getItemType(value));
        Text text = (Text)elem.getChild(0);
        text.setValue(value.getStringValue());
        return elem;
    }

    private String getItemType(AtomicValue value) {
        if (saxon85Method == null && saxon86Method == null) {
            try {
                return this.getItemType871(value);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (saxon86Method != null) {
            try {
                TypeHierarchy h = (TypeHierarchy)saxon86Method.invoke((Object)this.config.getNamePool(), null);
                return value.getItemType(h).toString();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (saxon85Method != null) {
            try {
                return saxon85Method.invoke((Object)value, null).toString();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        throw new RuntimeException("Unsupported saxon version?");
    }

    private String getItemType871(AtomicValue value) {
        return value.getItemType(this.config.getTypeHierarchy()).toString();
    }

    private static Method findGetItemTypeMethod86() {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.sf.saxon.om.NamePool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.getMethod("getTypeHierarchy", null);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Method findGetItemTypeMethod85() {
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("net.sf.saxon.value.AtomicValue");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.getMethod("getItemType", null);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Method findGenerateIdMethod86() {
        try {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("net.sf.saxon.om.NodeInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.getMethod("generateId", null);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String generateId86(NodeInfo node) {
        try {
            return saxon86GenerateIdMethod.invoke((Object)node, null).toString();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static boolean isAtomicValue(Node node) {
        if (node instanceof Element) {
            Element elem = (Element)node;
            return elem.getLocalName().equals("atomic-value") && elem.getNamespaceURI().equals("http://dsd.lbl.gov/nux");
        }
        return false;
    }

    private static final class NodeInfoIdentityKey {
        private final NodeInfo key;

        public NodeInfoIdentityKey(NodeInfo key) {
            this.key = key;
        }

        public boolean equals(Object other) {
            if (other instanceof NodeInfoIdentityKey) {
                return this.key.isSameNodeInfo(((NodeInfoIdentityKey)other).key);
            }
            return false;
        }

        public int hashCode() {
            return DefaultResultSequence.generateId86(this.key).hashCode();
        }
    }
}

