/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.tests;

import java.io.File;

abstract class CmdLineProgram {
    CmdLineProgram() {
    }

    protected void doMain(String[] args) {
        try {
            if (this.parseArguments(args) < 0) {
                return;
            }
            this.run();
        }
        catch (UsageException e) {
            System.err.println(String.valueOf(this.getProgramName()) + ": " + e.getMessage());
            System.err.println(this.getShortUsage());
            System.exit(-1);
        }
        catch (Throwable t) {
            System.err.print("Oopsla: ");
            t.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    protected abstract int parseArguments(String[] var1) throws Throwable;

    protected abstract void run() throws Throwable;

    protected abstract String getMailAddress();

    protected abstract String getProgramName();

    protected abstract String getVersion();

    protected abstract String getHomepage();

    protected String getOptions() {
        return "[OPTION]... [FILE]...";
    }

    protected String getShortUsage() {
        return "\nUsage: " + this.getProgramName() + " " + this.getOptions() + "\n\n" + "Try `" + this.getProgramName() + " --help' for detailed options.";
    }

    protected String getVersionInfo() {
        return "\n" + this.getProgramName() + " " + this.getVersion() + " [Java " + System.getProperty("java.version") + ", " + System.getProperty("java.vm.name") + "]" + "\n" + "See " + this.getHomepage() + " for the latest version.\n\n" + this.getLicense() + "\n\n" + "Originally written by " + this.getMailAddress() + ".";
    }

    protected String getLicense() {
        return "Copyright (c) 2005, The Regents of the University of California, through\nLawrence Berkeley National Laboratory (subject to receipt of any required\napprovals from the U.S. Dept. of Energy).  All rights reserved.\nSee the license file for more details.";
    }

    protected int parseIntGreaterThanZero(String arg, String optionName) {
        int val;
        try {
            val = Integer.parseInt(arg);
            if (val <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException exc) {
            throw new UsageException("Invalid option '" + optionName + "=" + arg + "'. " + "Argument must be integer > 0.", exc);
        }
        return val;
    }

    protected int parseInt(String arg, String optionName) {
        int val;
        try {
            val = Integer.parseInt(arg);
        }
        catch (NumberFormatException exc) {
            throw new UsageException("Invalid option '" + optionName + "=" + arg + "'. " + "Argument must be integer.", exc);
        }
        return val;
    }

    protected void checkValidity(String arg, String[] permitted, String optionName) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < permitted.length) {
            if (arg.equalsIgnoreCase(permitted[i])) {
                return;
            }
            str.append("'" + permitted[i] + "'");
            if (i < permitted.length - 1) {
                str.append("|");
            }
            ++i;
        }
        throw new UsageException("Invalid option '" + optionName + "=" + arg + "'. " + "Argument must be one of " + str + ".");
    }

    protected String[] parseNonOptionArguments(String[] args, int getOptind, boolean checkFile, int minArgs, int maxArgs) {
        if (minArgs < 0) {
            throw new IllegalArgumentException("minArgs must be >= 0");
        }
        if (maxArgs < 0) {
            maxArgs = Integer.MAX_VALUE;
        }
        int i = getOptind;
        while (i < args.length) {
            ++i;
        }
        if (getOptind > args.length - minArgs) {
            throw new UsageException("Further non-option arguments required but missing.");
        }
        if (getOptind < args.length - maxArgs) {
            throw new UsageException("Too many non-option arguments given; at most " + maxArgs + " allowed.");
        }
        String[] nonOptionArgs = new String[args.length - getOptind];
        int i2 = getOptind;
        int j = 0;
        while (i2 < args.length) {
            String nonOptionArg;
            nonOptionArgs[j] = nonOptionArg = args[i2];
            if (checkFile && !nonOptionArg.equals("-") && !new File(nonOptionArg).exists()) {
                throw new UsageException("File '" + nonOptionArg + "' not found.");
            }
            ++i2;
            ++j;
        }
        return nonOptionArgs;
    }

    static final class UsageException
    extends RuntimeException {
        public UsageException() {
        }

        public UsageException(String s) {
            super(s);
        }

        public UsageException(String message, Throwable cause) {
            super(message, cause);
        }

        public UsageException(Throwable cause) {
            super(cause);
        }
    }
}

