/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.Serializer;
import nu.xom.XPathException;
import nux.xom.binary.BinaryXMLCodec;
import nux.xom.pool.FileUtil;
import nux.xom.xquery.XQuery;
import nux.xom.xquery.XQueryUtil;

public final class XQueryBenchmark {
    public static boolean IS_BENCHMARK = false;
    public static int dummy = 0;

    private XQueryBenchmark() {
    }

    public static void generateTestData(String[] args) throws Exception {
        Document doc = new Builder().build(new File(args[0]));
        int times = Integer.parseInt(args[1]);
        Elements children = doc.getRootElement().getChildElements();
        int k = 0;
        while (k < times) {
            int i = 0;
            while (i < children.size()) {
                doc.getRootElement().appendChild(children.get(i).copy());
                ++i;
            }
            ++k;
        }
        FileOutputStream out = new FileOutputStream(args[2]);
        Serializer ser = new Serializer((OutputStream)out);
        ser.write(doc);
        ser.flush();
        out.close();
    }

    private static Document readDocument(String fileName) throws Exception {
        Document doc;
        System.out.print("Now reading " + fileName);
        long start = System.currentTimeMillis();
        if (fileName.endsWith(".bnux")) {
            byte[] data = FileUtil.toByteArray(new FileInputStream(fileName));
            doc = new BinaryXMLCodec().deserialize(data);
        } else {
            doc = new Builder().build(new File(fileName));
        }
        long end = System.currentTimeMillis();
        System.out.println(" ms=" + (end - start));
        return doc;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("See javadoc for help on usage.");
            return;
        }
        System.out.println("Environment: " + XQueryBenchmark.getSystemInfo());
        String str = "";
        int i = 0;
        while (i < args.length) {
            str = String.valueOf(str) + args[i] + " ";
            ++i;
        }
        System.out.println("Now running java nux.xom.tests.XQueryBenchmark " + str);
        int runs = Integer.parseInt(args[0]);
        int repeats = Integer.parseInt(args[1]);
        int mode = -1;
        if (args[2].equalsIgnoreCase("cache")) {
            mode = 0;
        }
        if (args[2].equalsIgnoreCase("nocache")) {
            mode = 1;
        }
        if (args[2].equalsIgnoreCase("xom")) {
            mode = 2;
        }
        boolean check = runs == 1;
        Document doc = XQueryBenchmark.readDocument(args[3]);
        int k = 0;
        while (k < repeats) {
            int q = 4;
            while (q < args.length) {
                Object[] expected;
                int[] types;
                String[] selects;
                Node[] contexts;
                if (args[q].endsWith(".xq")) {
                    System.out.println("Now reading " + args[q]);
                    contexts = new Node[]{doc};
                    selects = new String[]{FileUtil.toString(new FileInputStream(args[q]), null)};
                    types = new int[1];
                    expected = new Object[]{""};
                } else {
                    Document queries = XQueryBenchmark.readDocument(args[q]);
                    Nodes paths = XQueryUtil.xquery((Node)queries, "/paths/document/path");
                    contexts = new Node[paths.size()];
                    selects = new String[paths.size()];
                    types = new int[paths.size()];
                    expected = new Object[paths.size()];
                    int i2 = 0;
                    while (i2 < paths.size()) {
                        Element path = (Element)paths.get(i2);
                        Attribute ctxAttr = path.getAttribute("context");
                        contexts[i2] = ctxAttr == null ? doc : XQueryUtil.xquery((Node)doc, ctxAttr.getValue()).get(0);
                        selects[i2] = path.getAttribute("select").getValue();
                        types[i2] = 0;
                        if (path.getAttribute("type") != null) {
                            String[] flavours = new String[]{"count", "string", "double", "boolean"};
                            types[i2] = Arrays.asList(flavours).indexOf(path.getAttribute("type").getValue());
                        }
                        expected[i2] = path.getValue();
                        ++i2;
                    }
                }
                int i3 = 0;
                while (i3 < selects.length) {
                    int actualRuns = runs;
                    if (!selects[i3].equals("//*[contains(string(.),'Capulet')]")) {
                        System.out.print("query = " + selects[i3] + "  ");
                        if (actualRuns == 1) {
                            System.out.println("\nexplain = \n" + new XQuery(selects[i3], null).explain());
                        }
                        XQuery xquery = new XQuery(selects[i3], null);
                        long start = System.currentTimeMillis();
                        IS_BENCHMARK = true;
                        Nodes results = XQueryBenchmark.run(contexts[i3], selects[i3], actualRuns, mode, types[i3], xquery);
                        IS_BENCHMARK = false;
                        long end = System.currentTimeMillis();
                        if (check && results != null) {
                            int j = 0;
                            while (j < results.size()) {
                                System.out.println("node " + j + ": " + results.get(j).toXML());
                                ++j;
                            }
                            Node first = results.size() == 0 ? null : results.get(0);
                            String actual = null;
                            switch (types[i3]) {
                                case 0: {
                                    actual = String.valueOf(results.size());
                                    break;
                                }
                                case 1: {
                                    actual = first == null ? "" : first.getValue();
                                    break;
                                }
                                case 2: {
                                    actual = first == null ? "0.0" : new Double(first.getValue()).toString();
                                    break;
                                }
                                case 3: {
                                    actual = first == null ? "false" : (first.getValue().equals("true") ? "true" : "false");
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException();
                                }
                            }
                            if (expected[i3] instanceof String && ((String)expected[i3]).length() > 0 && !expected[i3].equals(actual)) {
                                System.out.print("expected=" + expected[i3]);
                                System.out.println(", actual=" + actual);
                                System.exit(0);
                            }
                            System.out.print(" result=" + actual + ",");
                        }
                        System.out.println(" ms=" + (end - start) + ", queries/sec=" + (float)actualRuns / ((float)(end - start) / 1000.0f));
                    }
                    ++i3;
                }
                ++q;
            }
            System.out.println("done with repetition " + k + "\n\n");
            if (k < repeats - 1) {
                Thread.sleep(3000L);
            }
            ++k;
        }
    }

    private static Nodes run(Node contextNode, String query, int runs, int mode, int type, XQuery xquery) throws Exception {
        Nodes results = null;
        int run = 0;
        while (run < runs) {
            switch (mode) {
                case -1: {
                    results = xquery.execute(contextNode).toNodes();
                    break;
                }
                case 0: {
                    results = XQueryUtil.xquery(contextNode, query);
                    break;
                }
                case 1: {
                    results = new XQuery(query, null).execute(contextNode).toNodes();
                    break;
                }
                case 2: {
                    try {
                        results = contextNode.query(query);
                        break;
                    }
                    catch (XPathException e) {
                        System.out.println("****** XOM can't handle this query: " + e.getMessage());
                        return null;
                    }
                }
                default: {
                    throw new IllegalStateException("unknown mode");
                }
            }
            ++run;
        }
        return results;
    }

    private static String getSystemInfo() {
        String str = "java " + System.getProperty("java.version") + ", " + System.getProperty("java.vm.name");
        str = String.valueOf(str) + ", " + System.getProperty("java.vendor") + ", " + System.getProperty("os.name");
        str = String.valueOf(str) + ", " + System.getProperty("os.version") + ", " + System.getProperty("os.arch");
        return str;
    }
}

