/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.File;
import java.io.FileWriter;
import nu.xom.Builder;
import nu.xom.Document;
import nux.xom.pool.DocumentMap;
import nux.xom.pool.PoolConfig;

final class DocumentMapFileMonitorTest {
    DocumentMapFileMonitorTest() {
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("nux.xom.pool.Pool.debug", "true");
        PoolConfig config = new PoolConfig();
        int k = -1;
        int numFiles = 1000;
        if (args.length > ++k) {
            numFiles = Math.max(1, Integer.parseInt(args[k]));
        }
        int threads = 1;
        if (args.length > ++k) {
            threads = Math.max(1, Integer.parseInt(args[k]));
        }
        if (args.length > ++k) {
            config.setCompressionLevel(Integer.parseInt(args[k]));
        }
        if (args.length > ++k) {
            config.setMaxEntries(Integer.parseInt(args[k]));
        }
        if (args.length > ++k) {
            config.setFileMonitoring(new Boolean(args[k]));
        }
        if (args.length > ++k) {
            config.setCapacity(Long.parseLong(args[k]));
        }
        if (args.length > ++k) {
            config.setMaxIdleTime(Long.parseLong(args[k]));
        }
        if (args.length > ++k) {
            config.setMaxLifeTime(Long.parseLong(args[k]));
        }
        final DocumentMap pool = new DocumentMap(config);
        final File[] files = new File[numFiles];
        new File("tmp").mkdir();
        int j = 0;
        while (j < numFiles) {
            files[j] = new File("tmp/file" + j + ".xml");
            System.out.println("writing " + files[j]);
            FileWriter out = new FileWriter(files[j]);
            out.write("<hello/>");
            out.flush();
            out.close();
            ++j;
        }
        j = 0;
        while (j < threads) {
            final int t = j++;
            Runnable runner = new Runnable(){

                public void run() {
                    try {
                        Builder builder = new Builder();
                        int i = 0;
                        while (i < files.length) {
                            System.out.println("t=" + t + ", index=" + i);
                            Document doc = builder.build(files[i]);
                            File key = files[i];
                            pool.putDocument(key, doc);
                            ++i;
                        }
                        System.out.println("done");
                    }
                    catch (Throwable t2) {
                        t2.printStackTrace();
                        System.exit(-1);
                    }
                }
            };
            new Thread(runner).start();
        }
        Thread.sleep(Long.MAX_VALUE);
    }
}

