/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyConfigInterface;
import com.metamatrix.jdbcspy.SpyLogger;
import java.io.PrintWriter;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class SpyLoggerForDataSource
extends SpyLogger {
    private static String footprint = "$Revision:   1.3.2.0  $";
    private PrintWriter dsLog;
    public boolean logCEL;

    public SpyLoggerForDataSource(DataSource dataSource) {
        try {
            this.dsLog = dataSource.getLogWriter();
            this.linelimit = 0;
            this.logTName = true;
            this.logIS = false;
            this.logLobs = false;
            this.logSingleRead = false;
            this.logCEL = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void readConfig(SpyConfigInterface spyConfigInterface) {
        Integer n;
        Boolean bl;
        String string;
        if (this.dsLog == null) {
            this.dsLog = spyConfigInterface.getLogWriter();
        }
        if ((string = spyConfigInterface.getClassnameToLoad()) != null) {
            try {
                Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((bl = spyConfigInterface.getLogTimestamp()) != null) {
            this.logTimestamp = bl;
        }
        if ((n = spyConfigInterface.getLogInputStreams()) != null) {
            switch (n) {
                case 1: {
                    this.logIS = true;
                    this.logSingleRead = true;
                    break;
                }
                case 2: {
                    this.logIS = false;
                    this.logSingleRead = false;
                    break;
                }
                case 3: {
                    this.logIS = true;
                    this.logSingleRead = false;
                }
            }
        }
        if ((n = spyConfigInterface.getLogLobs()) != null) {
            switch (n) {
                case 1: {
                    this.logLobs = true;
                    break;
                }
                case 2: {
                    this.logLobs = false;
                }
            }
        }
        this.logTName = spyConfigInterface.getLogThreadName();
        n = spyConfigInterface.getLineLimit();
        if (n != null) {
            this.linelimit = n;
        }
        if (this.linelimit < 0) {
            this.linelimit = 0;
        }
    }

    protected final PrintWriter getLog() {
        return this.dsLog;
    }

    final void enter() {
    }

    final void leave() {
    }

    public final XAException xaException(Throwable throwable) {
        if (throwable instanceof XAException) {
            this.printXaException((XAException)throwable);
            this.printStackTraceOfException(throwable);
            return (XAException)throwable.fillInStackTrace();
        }
        if (throwable instanceof RuntimeException) {
            this.println("***" + throwable.toString() + "***");
            this.printStackTraceOfException(throwable);
            throw (RuntimeException)throwable.fillInStackTrace();
        }
        if (throwable instanceof Error) {
            this.println("***" + throwable.toString() + "***");
            this.printStackTraceOfException(throwable);
            throw (Error)throwable.fillInStackTrace();
        }
        XAException xAException = new XAException(throwable.toString());
        xAException.errorCode = -3;
        this.printXaException(xAException);
        this.printStackTraceOfException(throwable);
        return xAException;
    }

    private void printXaException(XAException xAException) {
        this.println("*** XAException " + xAException + " " + this.xaRetCodeToString(xAException.errorCode) + " ***");
    }

    final String xidToString(Xid xid) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(xid.getFormatId());
        stringBuffer.append("-");
        stringBuffer.append(this.bytesToString(xid.getGlobalTransactionId()));
        stringBuffer.append("-");
        stringBuffer.append(this.bytesToString(xid.getBranchQualifier()));
        return stringBuffer.toString();
    }

    final String flagsToString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + "=");
        if (n == 0) {
            stringBuffer.append("TMNOFLAGS");
            return stringBuffer.toString();
        }
        boolean bl = false;
        if (((long)n & 1L) != 0L) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMREGISTER");
            bl = true;
        }
        if (((long)n & 2L) != 0L) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMNOMIGRATE");
            bl = true;
        }
        if (((long)n & 4L) != 0L) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMUSEASYNC");
            bl = true;
        }
        if (((long)n & 0x80000000L) != 0L) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMASYNC");
            bl = true;
        }
        if ((n & 0x40000000) != 0) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMONEPHASE");
            bl = true;
        }
        if ((n & 0x20000000) != 0) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMFAIL");
            bl = true;
        }
        if (((long)n & 0x10000000L) != 0L) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMNOWAIT");
            bl = true;
        }
        if ((n & 0x8000000) != 0) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMRESUME");
            bl = true;
        }
        if ((n & 0x4000000) != 0) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMSUCCESS");
            bl = true;
        }
        if ((n & 0x2000000) != 0) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMSUSPEND");
            bl = true;
        }
        if ((n & 0x1000000) != 0) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMSTARTRSCAN");
            bl = true;
        }
        if ((n & 0x800000) != 0) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMENDRSCAN");
            bl = true;
        }
        if (((long)n & 0x400000L) != 0L) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMMULTIPLE");
            bl = true;
        }
        if ((n & 0x200000) != 0) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMJOIN");
            bl = true;
        }
        if (((long)n & 0x100000L) != 0L) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("TMMIGRATE");
            bl = true;
        }
        return stringBuffer.toString();
    }

    final String xaRetCodeToString(int n) {
        switch (n) {
            case 100: {
                return n + "=XA_RBROLLBACK";
            }
            case 101: {
                return n + "=XA_RBCOMMFAIL";
            }
            case 102: {
                return n + "=XA_RBDEADLOCK";
            }
            case 103: {
                return n + "=XA_RBINTEGRITY";
            }
            case 104: {
                return n + "=XA_RBOTHER";
            }
            case 105: {
                return n + "=XA_RBPROTO";
            }
            case 106: {
                return n + "=XA_RBTIMEOUT";
            }
            case 107: {
                return n + "=XA_RBTRANSIENT";
            }
            case 9: {
                return n + "=XA_NOMIGRATE";
            }
            case 8: {
                return n + "=XA_HEURHAZ";
            }
            case 7: {
                return n + "=XA_HEURCOM";
            }
            case 6: {
                return n + "=XA_HEURRB";
            }
            case 5: {
                return n + "=XA_HEURMIX";
            }
            case 4: {
                return n + "=XA_RETRY";
            }
            case 3: {
                return n + "=XA_RDONLY";
            }
            case 0: {
                return n + "=XA_OK";
            }
            case -2: {
                return n + "=XAER_ASYNC";
            }
            case -3: {
                return n + "=XAER_RMERR";
            }
            case -4: {
                return n + "=XAER_NOTA";
            }
            case -5: {
                return n + "=XAER_INVAL";
            }
            case -6: {
                return n + "=XAER_PROTO";
            }
            case -7: {
                return n + "=XAER_RMFAIL";
            }
            case -8: {
                return n + "=XAER_DUPID";
            }
            case -9: {
                return n + "=XAER_OUTSIDE";
            }
        }
        return n + "=Unknown";
    }
}

