/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer.impl;

import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.util.Intervals;
import com.metamatrix.core.util.HashCodeUtil;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;

class ManagedBatch {
    public static final short PERSISTENT = 0;
    public static final short UNPINNED = 1;
    public static final short PINNED = 2;
    private TupleSourceID tupleSourceID;
    private int beginRow;
    private int endRow;
    private long size;
    private int location;
    private Intervals pinned;
    private int hashCode;
    private static int STACK_LEVELS_TO_OMIT = 2;
    private static int STACK_LEVELS_TO_CAPTURE = 5;
    private List whoCalledUs;
    private String sCallStackTimeStamp;

    public ManagedBatch(TupleSourceID tupleSourceID, int begin, int end, long size) {
        this.tupleSourceID = tupleSourceID;
        this.beginRow = begin;
        this.endRow = end;
        this.size = size;
        this.hashCode = HashCodeUtil.hashCode((int)tupleSourceID.hashCode(), (int)this.beginRow);
    }

    public TupleSourceID getTupleSourceID() {
        return this.tupleSourceID;
    }

    public int getBeginRow() {
        return this.beginRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public long getSize() {
        return this.size;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location;
    }

    public void setPinnedRows(int begin, int end) {
        if (this.pinned == null) {
            this.pinned = new Intervals();
        }
        this.pinned.addInterval(begin, end);
    }

    public void removePinnedRows(int begin, int end) {
        if (this.pinned != null) {
            this.pinned.removeInterval(begin, end);
        }
    }

    public boolean hasPinnedRows() {
        if (this.pinned == null) {
            return false;
        }
        return this.pinned.hasIntervals();
    }

    public void captureCallStack() {
        StackTraceElement[] elements = new Exception().getStackTrace();
        this.whoCalledUs = new LinkedList();
        for (int i = STACK_LEVELS_TO_OMIT; i < elements.length && i < STACK_LEVELS_TO_OMIT + STACK_LEVELS_TO_CAPTURE; ++i) {
            this.whoCalledUs.add(elements[i].toString());
        }
        this.sCallStackTimeStamp = new Timestamp(System.currentTimeMillis()).toString();
    }

    public List getCallStack() {
        return this.whoCalledUs;
    }

    public String getCallStackTimeStamp() {
        return this.sCallStackTimeStamp;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ManagedBatch)) {
            return false;
        }
        ManagedBatch other = (ManagedBatch)obj;
        return this.getTupleSourceID().equals(other.getTupleSourceID()) && this.getBeginRow() == other.getBeginRow();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ManagedBatch[" + this.tupleSourceID + ", " + this.beginRow + ", " + this.endRow + "]";
    }
}

