/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.function.source;

import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.function.FunctionMetadataSource;
import com.metamatrix.query.function.metadata.FunctionCategoryConstants;
import com.metamatrix.query.function.metadata.FunctionMethod;
import com.metamatrix.query.function.metadata.FunctionParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SystemSource
implements FunctionMetadataSource,
FunctionCategoryConstants {
    private static final String FUNCTION_CLASS = "com.metamatrix.query.function.FunctionMethods";
    private static final String XML_FUNCTION_CLASS = "com.metamatrix.query.function.source.XMLSystemFunctions";
    private List functions = new ArrayList();

    public SystemSource() {
        this.addArithmeticFunction("+", QueryPlugin.Util.getString("SystemSource.Add_desc"), "plus", QueryPlugin.Util.getString("SystemSource.Add_result_desc"));
        this.addArithmeticFunction("-", QueryPlugin.Util.getString("SystemSource.Subtract_desc"), "minus", QueryPlugin.Util.getString("SystemSource.Subtract_result_desc"));
        this.addArithmeticFunction("*", QueryPlugin.Util.getString("SystemSource.Multiply_desc"), "multiply", QueryPlugin.Util.getString("SystemSource.Multiply_result_desc"));
        this.addArithmeticFunction("/", QueryPlugin.Util.getString("SystemSource.Divide_desc"), "divide", QueryPlugin.Util.getString("SystemSource.Divide_result_desc"));
        this.addAbsFunction();
        this.addFloatFunction("ceiling", QueryPlugin.Util.getString("SystemSource.Ceiling_desc"));
        this.addFloatFunction("exp", QueryPlugin.Util.getString("SystemSource.Exp_desc"));
        this.addFloatFunction("floor", QueryPlugin.Util.getString("SystemSource.Floor_desc"));
        this.addFloatFunction("log", QueryPlugin.Util.getString("SystemSource.Log_desc"));
        this.addFloatFunction("log10", QueryPlugin.Util.getString("SystemSource.Log10_desc"));
        this.addRandFunction();
        this.addModFunction();
        this.addPowerFunction();
        this.addRoundFunction();
        this.addSignFunction();
        this.addSqrtFunction();
        this.addDoubleFunction("acos", QueryPlugin.Util.getString("SystemSource.Acos_desc"));
        this.addDoubleFunction("asin", QueryPlugin.Util.getString("SystemSource.Asin_desc"));
        this.addDoubleFunction("atan", QueryPlugin.Util.getString("SystemSource.Atan_desc"));
        this.addAtan2Function("atan2", QueryPlugin.Util.getString("SystemSource.Atan2_desc"));
        this.addDoubleFunction("cos", QueryPlugin.Util.getString("SystemSource.Cos_desc"));
        this.addDoubleFunction("cot", QueryPlugin.Util.getString("SystemSource.Cot_desc"));
        this.addDoubleFunction("degrees", QueryPlugin.Util.getString("SystemSource.Degrees_desc"));
        this.addPiFunction("pi", QueryPlugin.Util.getString("SystemSource.Pi_desc"));
        this.addDoubleFunction("radians", QueryPlugin.Util.getString("SystemSource.Radians_desc"));
        this.addDoubleFunction("sin", QueryPlugin.Util.getString("SystemSource.Sin_desc"));
        this.addDoubleFunction("tan", QueryPlugin.Util.getString("SystemSource.Tan_desc"));
        this.addBitFunction("bitand", QueryPlugin.Util.getString("SystemSource.Bitand_desc"), "bitand", 2, QueryPlugin.Util.getString("SystemSource.Bitand_result_desc"));
        this.addBitFunction("bitor", QueryPlugin.Util.getString("SystemSource.Bitor_desc"), "bitor", 2, QueryPlugin.Util.getString("SystemSource.Bitor_result_desc"));
        this.addBitFunction("bitxor", QueryPlugin.Util.getString("SystemSource.Bitxor_desc"), "bitxor", 2, QueryPlugin.Util.getString("SystemSource.Bitxor_result_desc"));
        this.addBitFunction("bitnot", QueryPlugin.Util.getString("SystemSource.Bitnot_desc"), "bitnot", 1, QueryPlugin.Util.getString("SystemSource.Bitnot_result_desc"));
        this.addConstantDateFunction("curdate", QueryPlugin.Util.getString("SystemSource.Curdate_desc"), "currentDate", "date");
        this.addConstantDateFunction("curtime", QueryPlugin.Util.getString("SystemSource.Curtime_desc"), "currentTime", "time");
        this.addConstantDateFunction("now", QueryPlugin.Util.getString("SystemSource.Now_desc"), "currentTimestamp", "timestamp");
        this.addDateFunction("dayname", "dayName", QueryPlugin.Util.getString("SystemSource.Dayname_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Dayname_result_ts_desc"), "string");
        this.addDateFunction("dayofmonth", "dayOfMonth", QueryPlugin.Util.getString("SystemSource.Dayofmonth_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Dayofmonth_result_ts_desc"), "integer");
        this.addDateFunction("dayofweek", "dayOfWeek", QueryPlugin.Util.getString("SystemSource.Dayofweek_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Dayofweek_result_ts_desc"), "integer");
        this.addDateFunction("dayofyear", "dayOfYear", QueryPlugin.Util.getString("SystemSource.Dayofyear_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Dayofyear_result_ts_desc"), "integer");
        this.addDateFunction("month", "month", QueryPlugin.Util.getString("SystemSource.Month_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Month_result_ts_desc"), "integer");
        this.addDateFunction("monthname", "monthName", QueryPlugin.Util.getString("SystemSource.Monthname_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Monthname_result_ts_desc"), "string");
        this.addDateFunction("week", "week", QueryPlugin.Util.getString("SystemSource.Week_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Week_result_ts_desc"), "integer");
        this.addDateFunction("year", "year", QueryPlugin.Util.getString("SystemSource.Year_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Year_result_ts_desc"), "integer");
        this.addTimeFunction("hour", "hour", QueryPlugin.Util.getString("SystemSource.Hour_result_t_desc"), QueryPlugin.Util.getString("SystemSource.Hour_result_ts_desc"), "integer");
        this.addTimeFunction("minute", "minute", QueryPlugin.Util.getString("SystemSource.Minute_result_t_desc"), QueryPlugin.Util.getString("SystemSource.Minute_result_ts_desc"), "integer");
        this.addTimeFunction("second", "second", QueryPlugin.Util.getString("SystemSource.Second_result_t_desc"), QueryPlugin.Util.getString("SystemSource.Second_result_ts_desc"), "integer");
        this.addQuarterFunction("quarter", "quarter", QueryPlugin.Util.getString("SystemSource.Quarter_result_d_desc"), QueryPlugin.Util.getString("SystemSource.Quarter_result_ts_desc"), "integer");
        this.addTimestampAddFunction();
        this.addTimestampDiffFunction();
        this.addTimeZoneFunctions();
        this.addTimestampCreateFunction();
        this.addStringFunction("length", QueryPlugin.Util.getString("SystemSource.Length_result"), "length", "integer");
        this.addStringFunction("ucase", QueryPlugin.Util.getString("SystemSource.Ucase_result"), "upperCase", "string");
        this.addStringFunction("lcase", QueryPlugin.Util.getString("SystemSource.Lcase_result"), "lowerCase", "string");
        this.addStringFunction("lower", QueryPlugin.Util.getString("SystemSource.Lower_result"), "lowerCase", "string");
        this.addStringFunction("upper", QueryPlugin.Util.getString("SystemSource.Upper_result"), "upperCase", "string");
        this.addStringFunction("ltrim", QueryPlugin.Util.getString("SystemSource.Left_result"), "leftTrim", "string");
        this.addStringFunction("rtrim", QueryPlugin.Util.getString("SystemSource.Right_result"), "rightTrim", "string");
        this.addConcatFunction();
        this.addSubstringFunction();
        this.addLeftRightFunctions();
        this.addLocateFunction();
        this.addReplaceFunction();
        this.addAsciiFunction();
        this.addChrFunction();
        this.addCharFunction();
        this.addInitCapFunction();
        this.addLpadFunction();
        this.addRpadFunction();
        this.addTranslateFunction();
        this.addRepeatFunction();
        this.addSpaceFunction();
        this.addInsertFunction();
        this.addClobFunction("ucase", QueryPlugin.Util.getString("SystemSource.UcaseClob_result"), "upperCase", "clob");
        this.addClobFunction("lcase", QueryPlugin.Util.getString("SystemSource.LcaseClob_result"), "lowerCase", "clob");
        this.addClobFunction("lower", QueryPlugin.Util.getString("SystemSource.LowerClob_result"), "lowerCase", "clob");
        this.addClobFunction("upper", QueryPlugin.Util.getString("SystemSource.UpperClob_result"), "upperCase", "clob");
        this.addConversionFunctions();
        this.addContextFunctions();
        this.addRelateFunctions();
        this.addRowLimitFunctions();
        this.addRowLimitExceptionFunctions();
        this.addDecodeFunctions();
        this.addLookupFunctions();
        this.addUserFunction();
        this.addEnvFunction();
        this.addCommandPayloadFunctions();
        this.addNvlFunctions();
        this.addIfNullFunctions();
        this.addFormatTimeFunction("formatTime", QueryPlugin.Util.getString("SystemSource.Formattime_desc"), "formatTime", QueryPlugin.Util.getString("SystemSource.Formattime_result_desc"));
        this.addFormatDateFunction("formatDate", QueryPlugin.Util.getString("SystemSource.Formatdate_desc"), "formatDate", QueryPlugin.Util.getString("SystemSource.Formatdate_result_desc"));
        this.addFormatTimestampFunction("formatTimestamp", QueryPlugin.Util.getString("SystemSource.Formattimestamp_desc"), "formatTimestamp", QueryPlugin.Util.getString("SystemSource.Formattimestamp_result_desc"));
        this.addFormatNumberFunctions();
        this.addParseTimeFunction("parseTime", QueryPlugin.Util.getString("SystemSource.Parsetime_desc"), "parseTime", QueryPlugin.Util.getString("SystemSource.Parsetime_result_desc"));
        this.addParseDateFunction("parseDate", QueryPlugin.Util.getString("SystemSource.Parsedate_desc"), "parseDate", QueryPlugin.Util.getString("SystemSource.Parsedate_result_desc"));
        this.addParseTimestampFunction("parseTimestamp", QueryPlugin.Util.getString("SystemSource.Parsetimestamp_desc"), "parseTimestamp", QueryPlugin.Util.getString("SystemSource.Parsetimestamp_result_desc"));
        this.addParseNumberFunctions();
        this.addXpathFunction();
    }

    private void addFormatNumberFunctions() {
        this.addFormatNumberFunction("formatInteger", QueryPlugin.Util.getString("SystemSource.Formatinteger_desc"), "formatInteger", "integer", "integer", QueryPlugin.Util.getString("SystemSource.Formatinteger_result_desc"));
        this.addFormatNumberFunction("formatLong", QueryPlugin.Util.getString("SystemSource.Formatlong_desc"), "formatLong", "long", "long", QueryPlugin.Util.getString("SystemSource.Formatlong_result_desc"));
        this.addFormatNumberFunction("formatDouble", QueryPlugin.Util.getString("SystemSource.Formatdouble_desc"), "formatDouble", "double", "double", QueryPlugin.Util.getString("SystemSource.Formatdouble_result_desc"));
        this.addFormatNumberFunction("formatFloat", QueryPlugin.Util.getString("SystemSource.Formatfloat_desc"), "formatFloat", "float", "float", QueryPlugin.Util.getString("SystemSource.Formatfloat_result_desc"));
        this.addFormatNumberFunction("formatBigInteger", QueryPlugin.Util.getString("SystemSource.Formatbiginteger_desc"), "formatBigInteger", "biginteger", "biginteger", QueryPlugin.Util.getString("SystemSource.Formatbiginteger_result_desc"));
        this.addFormatNumberFunction("formatBigDecimal", QueryPlugin.Util.getString("SystemSource.Formatbigdecimal_desc"), "formatBigDecimal", "bigdecimal", "bigdecimal", QueryPlugin.Util.getString("SystemSource.Formatbigdecimal_result_desc"));
    }

    private void addParseNumberFunctions() {
        this.addParseNumberFunction("parseInteger", QueryPlugin.Util.getString("SystemSource.Parseinteger_desc"), "parseInteger", "integer", "integer", QueryPlugin.Util.getString("SystemSource.Parseinteger_result_desc"));
        this.addParseNumberFunction("parseLong", QueryPlugin.Util.getString("SystemSource.Parselong_desc"), "parseLong", "long", "long", QueryPlugin.Util.getString("SystemSource.Parselong_result_desc"));
        this.addParseNumberFunction("parseDouble", QueryPlugin.Util.getString("SystemSource.Parsedouble_desc"), "parseDouble", "double", "double", QueryPlugin.Util.getString("SystemSource.Parsedouble_result_desc"));
        this.addParseNumberFunction("parseFloat", QueryPlugin.Util.getString("SystemSource.Parsefloat_desc"), "parseFloat", "float", "float", QueryPlugin.Util.getString("SystemSource.Parsefloat_result_desc"));
        this.addParseNumberFunction("parseBigInteger", QueryPlugin.Util.getString("SystemSource.Parsebiginteger_desc"), "parseBigInteger", "biginteger", "biginteger", QueryPlugin.Util.getString("SystemSource.Parsebiginteger_result_desc"));
        this.addParseNumberFunction("parseBigDecimal", QueryPlugin.Util.getString("SystemSource.Parsebigdecimal_desc"), "parseBigDecimal", "bigdecimal", "bigdecimal", QueryPlugin.Util.getString("SystemSource.Parsebigdecimal_result_desc"));
    }

    private void addArithmeticFunction(String functionName, String description, String methodName, String resultsDescription) {
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, "integer");
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, "long");
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, "float");
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, "double");
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, "biginteger");
        this.addTypedArithmeticFunction(functionName, description, methodName, resultsDescription, "bigdecimal");
    }

    private void addTypedArithmeticFunction(String functionName, String description, String methodName, String resultsDescription, String type) {
        this.functions.add(new FunctionMethod(functionName, description, "Numeric", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("op1", type, QueryPlugin.Util.getString("SystemSource.Arith_left_op")), new FunctionParameter("op2", type, QueryPlugin.Util.getString("SystemSource.Arith_right_op"))}, new FunctionParameter("result", type, resultsDescription)));
    }

    private void addAbsFunction() {
        this.addTypedAbsFunction("integer");
        this.addTypedAbsFunction("long");
        this.addTypedAbsFunction("float");
        this.addTypedAbsFunction("double");
        this.addTypedAbsFunction("biginteger");
        this.addTypedAbsFunction("bigdecimal");
    }

    private void addTypedAbsFunction(String type) {
        this.functions.add(new FunctionMethod("abs", QueryPlugin.Util.getString("SystemSource.Abs_desc"), "Numeric", FUNCTION_CLASS, "abs", new FunctionParameter[]{new FunctionParameter("number", type, QueryPlugin.Util.getString("SystemSource.Abs_arg"))}, new FunctionParameter("result", type, QueryPlugin.Util.getString("SystemSource.Abs_result_desc"))));
    }

    private void addRandFunction() {
        FunctionMethod rand = new FunctionMethod("rand", QueryPlugin.Util.getString("SystemSource.Rand_desc"), "Numeric", FUNCTION_CLASS, "rand", new FunctionParameter[]{new FunctionParameter("seed", "integer", QueryPlugin.Util.getString("SystemSource.Rand_arg"))}, new FunctionParameter("result", "double", QueryPlugin.Util.getString("SystemSource.Rand_result_desc")));
        rand.setNullDependent(true);
        this.functions.add(rand);
        this.functions.add(new FunctionMethod("rand", QueryPlugin.Util.getString("SystemSource.Rand_desc"), "Numeric", FUNCTION_CLASS, "rand", new FunctionParameter[0], new FunctionParameter("result", "double", QueryPlugin.Util.getString("SystemSource.Rand_result_desc")), 4));
    }

    private void addFloatFunction(String name, String description) {
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter("number", "float", QueryPlugin.Util.getString("SystemSource.Float_arg"))}, new FunctionParameter("result", "double", description)));
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter("number", "double", QueryPlugin.Util.getString("SystemSource.Double_arg"))}, new FunctionParameter("result", "double", description)));
    }

    private void addDoubleFunction(String name, String description) {
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter("number", "double", QueryPlugin.Util.getString("SystemSource.Double_arg2"))}, new FunctionParameter("result", "double", description)));
    }

    private void addAtan2Function(String name, String description) {
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[]{new FunctionParameter("number1", "double", QueryPlugin.Util.getString("SystemSource.Atan_arg1")), new FunctionParameter("number2", "double", QueryPlugin.Util.getString("SystemSource.Atan_arg2"))}, new FunctionParameter("result", "double", description)));
    }

    private void addPiFunction(String name, String description) {
        this.functions.add(new FunctionMethod(name, description, "Numeric", FUNCTION_CLASS, name, new FunctionParameter[0], new FunctionParameter("result", "double", description)));
    }

    private void addModFunction() {
        this.addTypedArithmeticFunction("mod", QueryPlugin.Util.getString("SystemSource.Mod_desc"), "mod", QueryPlugin.Util.getString("SystemSource.Mod_result_desc"), "integer");
        this.addTypedArithmeticFunction("mod", QueryPlugin.Util.getString("SystemSource.Mod_desc"), "mod", QueryPlugin.Util.getString("SystemSource.Mod_result_desc"), "long");
        this.addTypedArithmeticFunction("mod", QueryPlugin.Util.getString("SystemSource.Mod_desc"), "mod", QueryPlugin.Util.getString("SystemSource.Mod_result_desc"), "float");
        this.addTypedArithmeticFunction("mod", QueryPlugin.Util.getString("SystemSource.Mod_desc"), "mod", QueryPlugin.Util.getString("SystemSource.Mod_result_desc"), "double");
        this.addTypedArithmeticFunction("mod", QueryPlugin.Util.getString("SystemSource.Mod_desc"), "mod", QueryPlugin.Util.getString("SystemSource.Mod_result_desc"), "biginteger");
    }

    private void addPowerFunction() {
        this.addTypedPowerFunction("integer", "integer");
        this.addTypedPowerFunction("long", "long");
        this.addTypedPowerFunction("float", "float");
        this.addTypedPowerFunction("double", "double");
        this.addTypedPowerFunction("biginteger", "integer");
    }

    private void addTypedPowerFunction(String baseType, String powerType) {
        this.functions.add(new FunctionMethod("power", QueryPlugin.Util.getString("SystemSource.Power_desc"), "Numeric", FUNCTION_CLASS, "power", new FunctionParameter[]{new FunctionParameter("base", baseType, QueryPlugin.Util.getString("SystemSource.Power_arg1")), new FunctionParameter("power", powerType, QueryPlugin.Util.getString("SystemSource.Power_arg2"))}, new FunctionParameter("result", baseType, QueryPlugin.Util.getString("SystemSource.Power_result_desc"))));
    }

    private void addRoundFunction() {
        this.addTypedRoundFunction("integer");
        this.addTypedRoundFunction("float");
        this.addTypedRoundFunction("double");
        this.addTypedRoundFunction("bigdecimal");
    }

    private void addTypedRoundFunction(String roundType) {
        this.functions.add(new FunctionMethod("round", QueryPlugin.Util.getString("SystemSource.Round_desc"), "Numeric", FUNCTION_CLASS, "round", new FunctionParameter[]{new FunctionParameter("number", roundType, QueryPlugin.Util.getString("SystemSource.Round_arg1")), new FunctionParameter("places", "integer", QueryPlugin.Util.getString("SystemSource.Round_arg2"))}, new FunctionParameter("result", roundType, QueryPlugin.Util.getString("SystemSource.Round_result_desc"))));
    }

    private void addSignFunction() {
        this.addTypedSignFunction("integer");
        this.addTypedSignFunction("long");
        this.addTypedSignFunction("float");
        this.addTypedSignFunction("double");
        this.addTypedSignFunction("biginteger");
        this.addTypedSignFunction("bigdecimal");
    }

    private void addTypedSignFunction(String type) {
        this.functions.add(new FunctionMethod("sign", QueryPlugin.Util.getString("SystemSource.Sign_desc"), "Numeric", FUNCTION_CLASS, "sign", new FunctionParameter[]{new FunctionParameter("number", type, QueryPlugin.Util.getString("SystemSource.Sign_arg1"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Sign_result_desc"))));
    }

    private void addSqrtFunction() {
        this.addTypedSqrtFunction("integer");
        this.addTypedSqrtFunction("long");
        this.addTypedSqrtFunction("float");
        this.addTypedSqrtFunction("double");
    }

    private void addTypedSqrtFunction(String type) {
        this.functions.add(new FunctionMethod("sqrt", QueryPlugin.Util.getString("SystemSource.Sqrt_desc"), "Numeric", FUNCTION_CLASS, "sqrt", new FunctionParameter[]{new FunctionParameter("number", type, QueryPlugin.Util.getString("SystemSource.Sqrt_arg1"))}, new FunctionParameter("result", "double", QueryPlugin.Util.getString("SystemSource.Sqrt_result_desc"))));
    }

    private void addConstantDateFunction(String name, String description, String methodName, String returnType) {
        this.functions.add(new FunctionMethod(name, description, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[0], new FunctionParameter("result", returnType, description), 3));
    }

    private void addDateFunction(String name, String methodName, String dateDesc, String timestampDesc, String returnType) {
        this.functions.add(new FunctionMethod(name, dateDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("date", "date", dateDesc)}, new FunctionParameter("result", returnType, dateDesc)));
        this.functions.add(new FunctionMethod(name, timestampDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("timestamp", "timestamp", timestampDesc)}, new FunctionParameter("result", returnType, timestampDesc)));
    }

    private void addQuarterFunction(String name, String methodName, String dateDesc, String timestampDesc, String returnType) {
        this.functions.add(new FunctionMethod(name, dateDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("date", "date", dateDesc)}, new FunctionParameter("result", returnType, dateDesc)));
        this.functions.add(new FunctionMethod(name, timestampDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("timestamp", "timestamp", timestampDesc)}, new FunctionParameter("result", returnType, timestampDesc)));
    }

    private void addTimestampAddFunction() {
        this.functions.add(new FunctionMethod("timestampAdd", QueryPlugin.Util.getString("SystemSource.Timestampadd_d_desc"), "Datetime", FUNCTION_CLASS, "timestampAdd", new FunctionParameter[]{new FunctionParameter("interval", "string", QueryPlugin.Util.getString("SystemSource.Timestampadd_d_arg1")), new FunctionParameter("count", "integer", QueryPlugin.Util.getString("SystemSource.Timestampadd_d_arg2")), new FunctionParameter("timestamp", "date", QueryPlugin.Util.getString("SystemSource.Timestampadd_d_arg3"))}, new FunctionParameter("result", "date", QueryPlugin.Util.getString("SystemSource.Timestampadd_d_result_desc"))));
        this.functions.add(new FunctionMethod("timestampAdd", QueryPlugin.Util.getString("SystemSource.Timestampadd_t_desc"), "Datetime", FUNCTION_CLASS, "timestampAdd", new FunctionParameter[]{new FunctionParameter("interval", "string", QueryPlugin.Util.getString("SystemSource.Timestampadd_t_arg1")), new FunctionParameter("count", "integer", QueryPlugin.Util.getString("SystemSource.Timestampadd_t_arg2")), new FunctionParameter("timestamp", "time", QueryPlugin.Util.getString("SystemSource.Timestampadd_t_arg3"))}, new FunctionParameter("result", "time", QueryPlugin.Util.getString("SystemSource.Timestampadd_t_result_desc"))));
        this.functions.add(new FunctionMethod("timestampAdd", QueryPlugin.Util.getString("SystemSource.Timestampadd_ts_desc"), "Datetime", FUNCTION_CLASS, "timestampAdd", new FunctionParameter[]{new FunctionParameter("interval", "string", QueryPlugin.Util.getString("SystemSource.Timestampadd_ts_arg1")), new FunctionParameter("count", "integer", QueryPlugin.Util.getString("SystemSource.Timestampadd_ts_arg2")), new FunctionParameter("timestamp", "timestamp", QueryPlugin.Util.getString("SystemSource.Timestampadd_ts_arg3"))}, new FunctionParameter("result", "timestamp", QueryPlugin.Util.getString("SystemSource.Timestampadd_ts_result"))));
    }

    private void addTimestampDiffFunction() {
        this.functions.add(new FunctionMethod("timestampDiff", QueryPlugin.Util.getString("SystemSource.Timestampdiff_t_desc"), "Datetime", FUNCTION_CLASS, "timestampDiff", new FunctionParameter[]{new FunctionParameter("interval", "string", QueryPlugin.Util.getString("SystemSource.Timestampdiff_t_arg1")), new FunctionParameter("time1", "time", QueryPlugin.Util.getString("SystemSource.Timestampdiff_t_arg2")), new FunctionParameter("time2", "time", QueryPlugin.Util.getString("SystemSource.Timestampdiff_t_arg3"))}, new FunctionParameter("result", "long", QueryPlugin.Util.getString("SystemSource.Timestampdiff_t_result_desc"))));
        this.functions.add(new FunctionMethod("timestampDiff", QueryPlugin.Util.getString("SystemSource.Timestampdiff_ts_desc"), "Datetime", FUNCTION_CLASS, "timestampDiff", new FunctionParameter[]{new FunctionParameter("interval", "string", QueryPlugin.Util.getString("SystemSource.Timestampdiff_ts_arg1")), new FunctionParameter("timestamp1", "timestamp", QueryPlugin.Util.getString("SystemSource.Timestampdiff_ts_arg2")), new FunctionParameter("timestamp2", "timestamp", QueryPlugin.Util.getString("SystemSource.Timestampdiff_ts_arg3"))}, new FunctionParameter("result", "long", QueryPlugin.Util.getString("SystemSource.Timestampdiff_ts_result_desc"))));
    }

    private void addTimestampCreateFunction() {
        this.functions.add(new FunctionMethod("timestampCreate", QueryPlugin.Util.getString("SystemSource.TimestampCreate_desc"), "Datetime", FUNCTION_CLASS, "timestampCreate", new FunctionParameter[]{new FunctionParameter("date", "date", QueryPlugin.Util.getString("SystemSource.TimestampCreate_arg1")), new FunctionParameter("time", "time", QueryPlugin.Util.getString("SystemSource.TimestampCreate_arg2"))}, new FunctionParameter("result", "timestamp", QueryPlugin.Util.getString("SystemSource.TimestampCreate_result_desc"))));
    }

    private void addTimeFunction(String name, String methodName, String timeDesc, String timestampDesc, String returnType) {
        this.functions.add(new FunctionMethod(name, timeDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("time", "time", timeDesc)}, new FunctionParameter("result", returnType, timeDesc)));
        this.functions.add(new FunctionMethod(name, timestampDesc, "Datetime", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("timestamp", "timestamp", timestampDesc)}, new FunctionParameter("result", returnType, timestampDesc)));
    }

    private void addStringFunction(String name, String description, String methodName, String returnType) {
        this.functions.add(new FunctionMethod(name, description, "String", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Stringfunc_arg1"))}, new FunctionParameter("result", returnType, description)));
    }

    private void addClobFunction(String name, String description, String methodName, String returnType) {
        this.functions.add(new FunctionMethod(name, description, "String", 2, FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("clob", "clob", QueryPlugin.Util.getString("SystemSource.Clobfunc_arg1"))}, new FunctionParameter("result", returnType, description), false, 0));
    }

    private void addConcatFunction() {
        this.functions.add(new FunctionMethod("concat", QueryPlugin.Util.getString("SystemSource.Concat_desc"), "String", FUNCTION_CLASS, "concat", new FunctionParameter[]{new FunctionParameter("string1", "string", QueryPlugin.Util.getString("SystemSource.Concat_arg1")), new FunctionParameter("string2", "string", QueryPlugin.Util.getString("SystemSource.Concat_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Concat_result_desc"))));
        this.functions.add(new FunctionMethod("||", QueryPlugin.Util.getString("SystemSource.Concatop_desc"), "String", FUNCTION_CLASS, "concat", new FunctionParameter[]{new FunctionParameter("string1", "string", QueryPlugin.Util.getString("SystemSource.Concatop_arg1")), new FunctionParameter("string2", "string", QueryPlugin.Util.getString("SystemSource.Concatop_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Concatop_result_desc"))));
        FunctionMethod concat2 = new FunctionMethod("concat2", QueryPlugin.Util.getString("SystemSource.Concat_desc"), "String", FUNCTION_CLASS, "concat2", new FunctionParameter[]{new FunctionParameter("string1", "string", QueryPlugin.Util.getString("SystemSource.Concat_arg1")), new FunctionParameter("string2", "string", QueryPlugin.Util.getString("SystemSource.Concat_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Concat_result_desc")));
        concat2.setNullDependent(true);
        this.functions.add(concat2);
    }

    private void addSubstringFunction() {
        this.functions.add(new FunctionMethod("substring", QueryPlugin.Util.getString("SystemSource.Substring_desc"), "String", FUNCTION_CLASS, "substring", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Substring_arg1")), new FunctionParameter("index", "integer", QueryPlugin.Util.getString("SystemSource.Substring_arg2")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Substring_arg3"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Substring_result"))));
        this.functions.add(new FunctionMethod("substring", QueryPlugin.Util.getString("SystemSource.Susbstring2_desc"), "String", FUNCTION_CLASS, "substring", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Substring2_arg1")), new FunctionParameter("index", "integer", QueryPlugin.Util.getString("SystemSource.Substring2_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Substring2_result"))));
    }

    private void addLeftRightFunctions() {
        this.functions.add(new FunctionMethod("left", QueryPlugin.Util.getString("SystemSource.Left_desc"), "String", FUNCTION_CLASS, "left", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Left_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Left_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Left2_result"))));
        this.functions.add(new FunctionMethod("right", QueryPlugin.Util.getString("SystemSource.Right_desc"), "String", FUNCTION_CLASS, "right", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Right_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Right_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Right2_result"))));
    }

    private void addLocateFunction() {
        this.functions.add(new FunctionMethod("locate", QueryPlugin.Util.getString("SystemSource.Locate_desc"), "String", FUNCTION_CLASS, "locate", new FunctionParameter[]{new FunctionParameter("substring", "string", QueryPlugin.Util.getString("SystemSource.Locate_arg1")), new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Locate_arg2")), new FunctionParameter("index", "integer", QueryPlugin.Util.getString("SystemSource.Locate_arg3"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Locate_result"))));
        this.functions.add(new FunctionMethod("locate", QueryPlugin.Util.getString("SystemSource.Locate2_desc"), "String", FUNCTION_CLASS, "locate", new FunctionParameter[]{new FunctionParameter("substring", "string", QueryPlugin.Util.getString("SystemSource.Locate2_arg1")), new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Locate2_arg2"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Locate2_result"))));
    }

    private void addReplaceFunction() {
        this.functions.add(new FunctionMethod("replace", QueryPlugin.Util.getString("SystemSource.Replace_desc"), "String", FUNCTION_CLASS, "replace", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Replace_arg1")), new FunctionParameter("substring", "string", QueryPlugin.Util.getString("SystemSource.Replace_arg2")), new FunctionParameter("replacement", "string", QueryPlugin.Util.getString("SystemSource.Replace_arg3"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Replace_result"))));
    }

    private void addRepeatFunction() {
        this.functions.add(new FunctionMethod("repeat", QueryPlugin.Util.getString("SystemSource.Repeat_desc"), "String", FUNCTION_CLASS, "repeat", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Repeat_arg1")), new FunctionParameter("count", "integer", QueryPlugin.Util.getString("SystemSource.Repeat_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Repeat_result"))));
    }

    private void addSpaceFunction() {
        this.functions.add(new FunctionMethod("space", QueryPlugin.Util.getString("SystemSource.Space_desc"), "String", FUNCTION_CLASS, "space", new FunctionParameter[]{new FunctionParameter("count", "integer", QueryPlugin.Util.getString("SystemSource.Space_arg1"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Space_result"))));
    }

    private void addInsertFunction() {
        this.functions.add(new FunctionMethod("insert", QueryPlugin.Util.getString("SystemSource.Insert_desc"), "String", FUNCTION_CLASS, "insert", new FunctionParameter[]{new FunctionParameter("str1", "string", QueryPlugin.Util.getString("SystemSource.Insert_arg1")), new FunctionParameter("start", "integer", QueryPlugin.Util.getString("SystemSource.Insert_arg2")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Insert_arg3")), new FunctionParameter("str2", "string", QueryPlugin.Util.getString("SystemSource.Insert_arg4"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Insert_result"))));
    }

    private void addAsciiFunction() {
        this.functions.add(new FunctionMethod("ascii", QueryPlugin.Util.getString("SystemSource.Ascii_desc"), "String", FUNCTION_CLASS, "ascii", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Ascii_arg1"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Ascii_result"))));
        this.functions.add(new FunctionMethod("ascii", QueryPlugin.Util.getString("SystemSource.Ascii2_desc"), "String", FUNCTION_CLASS, "ascii", new FunctionParameter[]{new FunctionParameter("char", "char", QueryPlugin.Util.getString("SystemSource.Ascii2_arg1"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Ascii2_result"))));
    }

    private void addChrFunction() {
        this.functions.add(new FunctionMethod("chr", QueryPlugin.Util.getString("SystemSource.Chr_desc"), "String", FUNCTION_CLASS, "chr", new FunctionParameter[]{new FunctionParameter("code", "integer", QueryPlugin.Util.getString("SystemSource.Chr_arg1"))}, new FunctionParameter("result", "char", QueryPlugin.Util.getString("SystemSource.Chr_result"))));
    }

    private void addCharFunction() {
        this.functions.add(new FunctionMethod("char", QueryPlugin.Util.getString("SystemSource.Char_desc"), "String", FUNCTION_CLASS, "chr", new FunctionParameter[]{new FunctionParameter("code", "integer", QueryPlugin.Util.getString("SystemSource.Char_arg1"))}, new FunctionParameter("result", "char", QueryPlugin.Util.getString("SystemSource.Char_result"))));
    }

    private void addInitCapFunction() {
        this.functions.add(new FunctionMethod("initcap", QueryPlugin.Util.getString("SystemSource.Initcap_desc"), "String", FUNCTION_CLASS, "initCap", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Initcap_arg1"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Initcap_result"))));
    }

    private void addLpadFunction() {
        this.functions.add(new FunctionMethod("lpad", QueryPlugin.Util.getString("SystemSource.Lpad_desc"), "String", FUNCTION_CLASS, "lpad", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Lpad_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Lpad_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Lpad_result"))));
        this.functions.add(new FunctionMethod("lpad", QueryPlugin.Util.getString("SystemSource.Lpad2_desc"), "String", FUNCTION_CLASS, "lpad", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Lpad2_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Lpad2_arg2")), new FunctionParameter("char", "char", QueryPlugin.Util.getString("SystemSource.Lpad2_arg3"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Lpad2_result"))));
        this.functions.add(new FunctionMethod("lpad", QueryPlugin.Util.getString("SystemSource.Lpad3_desc"), "String", FUNCTION_CLASS, "lpad", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Lpad3_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Lpad3_arg2")), new FunctionParameter("char", "string", QueryPlugin.Util.getString("SystemSource.Lpad3_arg3"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Lpad3_result"))));
    }

    private void addRpadFunction() {
        this.functions.add(new FunctionMethod("rpad", QueryPlugin.Util.getString("SystemSource.Rpad1_desc"), "String", FUNCTION_CLASS, "rpad", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Rpad1_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Rpad1_arg2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Rpad1_result"))));
        this.functions.add(new FunctionMethod("rpad", QueryPlugin.Util.getString("SystemSource.Rpad2_desc"), "String", FUNCTION_CLASS, "rpad", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Rpad2_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Rpad2_arg2")), new FunctionParameter("char", "char", QueryPlugin.Util.getString("SystemSource.Rpad2_arg3"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Rpad2_result"))));
        this.functions.add(new FunctionMethod("rpad", QueryPlugin.Util.getString("SystemSource.Rpad3_desc"), "String", FUNCTION_CLASS, "rpad", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Rpad3_arg1")), new FunctionParameter("length", "integer", QueryPlugin.Util.getString("SystemSource.Rpad3_arg2")), new FunctionParameter("char", "string", QueryPlugin.Util.getString("SystemSource.Rpad3_arg3"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Rpad3_result"))));
    }

    private void addTranslateFunction() {
        this.functions.add(new FunctionMethod("translate", QueryPlugin.Util.getString("SystemSource.Translate_desc"), "String", FUNCTION_CLASS, "translate", new FunctionParameter[]{new FunctionParameter("string", "string", QueryPlugin.Util.getString("SystemSource.Translate_arg1")), new FunctionParameter("source", "string", QueryPlugin.Util.getString("SystemSource.Translate_arg2")), new FunctionParameter("destination", "string", QueryPlugin.Util.getString("SystemSource.Translate_arg3"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Translate_result"))));
    }

    private void addConversionFunctions() {
        this.addTypedConversionFunction("convert", "string");
        this.addTypedConversionFunction("convert", "boolean");
        this.addTypedConversionFunction("convert", "byte");
        this.addTypedConversionFunction("convert", "short");
        this.addTypedConversionFunction("convert", "char");
        this.addTypedConversionFunction("convert", "integer");
        this.addTypedConversionFunction("convert", "long");
        this.addTypedConversionFunction("convert", "biginteger");
        this.addTypedConversionFunction("convert", "float");
        this.addTypedConversionFunction("convert", "double");
        this.addTypedConversionFunction("convert", "bigdecimal");
        this.addTypedConversionFunction("convert", "date");
        this.addTypedConversionFunction("convert", "time");
        this.addTypedConversionFunction("convert", "timestamp");
        this.addTypedConversionFunction("convert", "object");
        this.addTypedConversionFunction("convert", "null");
        this.addTypedConversionFunction("convert", "blob");
        this.addTypedConversionFunction("convert", "clob");
        this.addTypedConversionFunction("convert", "xml");
        this.addTypedConversionFunction("cast", "string");
        this.addTypedConversionFunction("cast", "boolean");
        this.addTypedConversionFunction("cast", "byte");
        this.addTypedConversionFunction("cast", "short");
        this.addTypedConversionFunction("cast", "char");
        this.addTypedConversionFunction("cast", "integer");
        this.addTypedConversionFunction("cast", "long");
        this.addTypedConversionFunction("cast", "biginteger");
        this.addTypedConversionFunction("cast", "float");
        this.addTypedConversionFunction("cast", "double");
        this.addTypedConversionFunction("cast", "bigdecimal");
        this.addTypedConversionFunction("cast", "date");
        this.addTypedConversionFunction("cast", "time");
        this.addTypedConversionFunction("cast", "timestamp");
        this.addTypedConversionFunction("cast", "object");
        this.addTypedConversionFunction("cast", "null");
        this.addTypedConversionFunction("cast", "blob");
        this.addTypedConversionFunction("cast", "clob");
    }

    private void addTypedConversionFunction(String name, String sourceType) {
        this.functions.add(new FunctionMethod(name, QueryPlugin.Util.getString("SystemSource.Convert_desc", (Object)sourceType), "Conversion", FUNCTION_CLASS, "convert", new FunctionParameter[]{new FunctionParameter("value", sourceType, QueryPlugin.Util.getString("SystemSource.Convert_arg1")), new FunctionParameter("target", "string", QueryPlugin.Util.getString("SystemSource.Convert_arg2"))}, new FunctionParameter("result", "object", QueryPlugin.Util.getString("SystemSource.Convert_result"))));
    }

    private void addContextFunctions() {
        this.addTypedContextFunction("string");
        this.addTypedContextFunction("boolean");
        this.addTypedContextFunction("byte");
        this.addTypedContextFunction("short");
        this.addTypedContextFunction("char");
        this.addTypedContextFunction("integer");
        this.addTypedContextFunction("long");
        this.addTypedContextFunction("biginteger");
        this.addTypedContextFunction("float");
        this.addTypedContextFunction("double");
        this.addTypedContextFunction("bigdecimal");
        this.addTypedContextFunction("date");
        this.addTypedContextFunction("time");
        this.addTypedContextFunction("timestamp");
        this.addTypedContextFunction("object");
        this.addTypedContextFunction("null");
        this.addTypedContextFunction("blob");
        this.addTypedContextFunction("clob");
        this.addTypedContextFunction("xml");
    }

    private void addTypedContextFunction(String exprType) {
        this.addTypedContextFunction("string", exprType);
        this.addTypedContextFunction("boolean", exprType);
        this.addTypedContextFunction("byte", exprType);
        this.addTypedContextFunction("short", exprType);
        this.addTypedContextFunction("char", exprType);
        this.addTypedContextFunction("integer", exprType);
        this.addTypedContextFunction("long", exprType);
        this.addTypedContextFunction("biginteger", exprType);
        this.addTypedContextFunction("float", exprType);
        this.addTypedContextFunction("double", exprType);
        this.addTypedContextFunction("bigdecimal", exprType);
        this.addTypedContextFunction("date", exprType);
        this.addTypedContextFunction("time", exprType);
        this.addTypedContextFunction("timestamp", exprType);
        this.addTypedContextFunction("object", exprType);
        this.addTypedContextFunction("null", exprType);
        this.addTypedContextFunction("blob", exprType);
        this.addTypedContextFunction("clob", exprType);
        this.addTypedContextFunction("xml", exprType);
    }

    private void addTypedContextFunction(String contextType, String exprType) {
        this.functions.add(new FunctionMethod("context", QueryPlugin.Util.getString("SystemSource.Context_desc"), "Miscellaneous", FUNCTION_CLASS, "context", new FunctionParameter[]{new FunctionParameter("context", contextType, QueryPlugin.Util.getString("SystemSource.Context_arg1")), new FunctionParameter("element", exprType, QueryPlugin.Util.getString("SystemSource.Context_arg2"))}, new FunctionParameter("result", exprType, QueryPlugin.Util.getString("SystemSource.Context_result"))));
    }

    private void addRelateFunctions() {
        this.functions.add(new FunctionMethod("relate", QueryPlugin.Util.getString("SystemSource.Relate_desc"), "XML", FUNCTION_CLASS, "relate", new FunctionParameter[]{new FunctionParameter("relationshipFragment", "string", QueryPlugin.Util.getString("SystemSource.Relate_arg1")), new FunctionParameter("sourceFragment", "string", QueryPlugin.Util.getString("SystemSource.Relate_arg2")), new FunctionParameter("objectFragment", "string", QueryPlugin.Util.getString("SystemSource.Relate_arg3"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Relate_result"))));
        this.addTypedRelateFunctions("string");
        this.addTypedRelateFunctions("boolean");
        this.addTypedRelateFunctions("byte");
        this.addTypedRelateFunctions("short");
        this.addTypedRelateFunctions("char");
        this.addTypedRelateFunctions("integer");
        this.addTypedRelateFunctions("long");
        this.addTypedRelateFunctions("biginteger");
        this.addTypedRelateFunctions("float");
        this.addTypedRelateFunctions("double");
        this.addTypedRelateFunctions("bigdecimal");
        this.addTypedRelateFunctions("date");
        this.addTypedRelateFunctions("time");
        this.addTypedRelateFunctions("timestamp");
        this.addTypedRelateFunctions("object");
    }

    private void addTypedRelateFunctions(String exprType) {
        this.functions.add(new FunctionMethod("relatesource", QueryPlugin.Util.getString("SystemSource.RelateSource_desc"), "XML", FUNCTION_CLASS, "relateSource", new FunctionParameter[]{new FunctionParameter("expression", exprType, QueryPlugin.Util.getString("SystemSource.RelateSource_arg1"))}, new FunctionParameter("result", exprType, QueryPlugin.Util.getString("SystemSource.RelateSource_result"))));
        this.functions.add(new FunctionMethod("relatetarget", QueryPlugin.Util.getString("SystemSource.RelateTarget_desc"), "XML", FUNCTION_CLASS, "relateTarget", new FunctionParameter[]{new FunctionParameter("expression", exprType, QueryPlugin.Util.getString("SystemSource.RelateTarget_arg1"))}, new FunctionParameter("result", exprType, QueryPlugin.Util.getString("SystemSource.RelateTarget_result"))));
    }

    private void addRowLimitFunctions() {
        this.addTypedRowLimitFunction("string");
        this.addTypedRowLimitFunction("boolean");
        this.addTypedRowLimitFunction("byte");
        this.addTypedRowLimitFunction("short");
        this.addTypedRowLimitFunction("char");
        this.addTypedRowLimitFunction("integer");
        this.addTypedRowLimitFunction("long");
        this.addTypedRowLimitFunction("biginteger");
        this.addTypedRowLimitFunction("float");
        this.addTypedRowLimitFunction("double");
        this.addTypedRowLimitFunction("bigdecimal");
        this.addTypedRowLimitFunction("date");
        this.addTypedRowLimitFunction("time");
        this.addTypedRowLimitFunction("timestamp");
        this.addTypedRowLimitFunction("object");
        this.addTypedRowLimitFunction("null");
        this.addTypedRowLimitFunction("blob");
        this.addTypedRowLimitFunction("clob");
        this.addTypedRowLimitFunction("xml");
    }

    private void addRowLimitExceptionFunctions() {
        this.addTypedRowLimitExceptionFunction("string");
        this.addTypedRowLimitExceptionFunction("boolean");
        this.addTypedRowLimitExceptionFunction("byte");
        this.addTypedRowLimitExceptionFunction("short");
        this.addTypedRowLimitExceptionFunction("char");
        this.addTypedRowLimitExceptionFunction("integer");
        this.addTypedRowLimitExceptionFunction("long");
        this.addTypedRowLimitExceptionFunction("biginteger");
        this.addTypedRowLimitExceptionFunction("float");
        this.addTypedRowLimitExceptionFunction("double");
        this.addTypedRowLimitExceptionFunction("bigdecimal");
        this.addTypedRowLimitExceptionFunction("date");
        this.addTypedRowLimitExceptionFunction("time");
        this.addTypedRowLimitExceptionFunction("timestamp");
        this.addTypedRowLimitExceptionFunction("object");
        this.addTypedRowLimitExceptionFunction("null");
        this.addTypedRowLimitExceptionFunction("blob");
        this.addTypedRowLimitExceptionFunction("clob");
        this.addTypedRowLimitExceptionFunction("xml");
    }

    private void addTypedRowLimitFunction(String exprType) {
        this.functions.add(new FunctionMethod("rowlimit", QueryPlugin.Util.getString("SystemSource.Rowlimit_desc"), "Miscellaneous", FUNCTION_CLASS, "rowlimit", new FunctionParameter[]{new FunctionParameter("element", exprType, QueryPlugin.Util.getString("SystemSource.Rowlimit_arg1"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Rowlimit_result"))));
    }

    private void addTypedRowLimitExceptionFunction(String exprType) {
        this.functions.add(new FunctionMethod("rowlimitexception", QueryPlugin.Util.getString("SystemSource.RowlimitException_desc"), "Miscellaneous", FUNCTION_CLASS, "rowlimitexception", new FunctionParameter[]{new FunctionParameter("element", exprType, QueryPlugin.Util.getString("SystemSource.Rowlimit_arg1"))}, new FunctionParameter("result", "integer", QueryPlugin.Util.getString("SystemSource.Rowlimit_result"))));
    }

    private void addDecodeFunctions() {
        this.addDecodeFunction("decodeInteger", "integer");
        this.addDecodeFunction("decodeString", "string");
    }

    private void addDecodeFunction(String functionName, String resultType) {
        this.functions.add(new FunctionMethod(functionName, QueryPlugin.Util.getString("SystemSource.Decode1_desc"), "Miscellaneous", FUNCTION_CLASS, functionName, new FunctionParameter[]{new FunctionParameter("input", "string", QueryPlugin.Util.getString("SystemSource.Decode1_arg1")), new FunctionParameter("decodeString", "string", QueryPlugin.Util.getString("SystemSource.Decode1_arg2"))}, new FunctionParameter("result", resultType, QueryPlugin.Util.getString("SystemSource.Decode1_result"))));
        this.functions.add(new FunctionMethod(functionName, QueryPlugin.Util.getString("SystemSource.Decode2_desc"), "Miscellaneous", FUNCTION_CLASS, functionName, new FunctionParameter[]{new FunctionParameter("input", "string", QueryPlugin.Util.getString("SystemSource.Decode2_arg1")), new FunctionParameter("decodeString", "string", QueryPlugin.Util.getString("SystemSource.Decode2_arg2")), new FunctionParameter("delimiter", "string", QueryPlugin.Util.getString("SystemSource.Decode2_arg3"))}, new FunctionParameter("result", resultType, QueryPlugin.Util.getString("SystemSource.Decode2_result"))));
    }

    private void addLookupFunctions() {
        this.addTypedLookupFunction("string");
        this.addTypedLookupFunction("boolean");
        this.addTypedLookupFunction("byte");
        this.addTypedLookupFunction("short");
        this.addTypedLookupFunction("char");
        this.addTypedLookupFunction("integer");
        this.addTypedLookupFunction("long");
        this.addTypedLookupFunction("biginteger");
        this.addTypedLookupFunction("float");
        this.addTypedLookupFunction("double");
        this.addTypedLookupFunction("bigdecimal");
        this.addTypedLookupFunction("date");
        this.addTypedLookupFunction("time");
        this.addTypedLookupFunction("timestamp");
        this.addTypedLookupFunction("object");
        this.addTypedLookupFunction("null");
        this.addTypedLookupFunction("blob");
        this.addTypedLookupFunction("clob");
        this.addTypedLookupFunction("xml");
    }

    private void addTypedLookupFunction(String keyValueType) {
        this.functions.add(new FunctionMethod("lookup", QueryPlugin.Util.getString("SystemSource.Lookup_desc"), "Miscellaneous", 1, FUNCTION_CLASS, "lookup", new FunctionParameter[]{new FunctionParameter("codetable", "string", QueryPlugin.Util.getString("SystemSource.Lookup_arg1")), new FunctionParameter("returnelement", "string", QueryPlugin.Util.getString("SystemSource.Lookup_arg2")), new FunctionParameter("keyelement", "string", QueryPlugin.Util.getString("SystemSource.Lookup_arg3")), new FunctionParameter("keyvalue", keyValueType, QueryPlugin.Util.getString("SystemSource.Lookup_arg4"))}, new FunctionParameter("result", "object", QueryPlugin.Util.getString("SystemSource.Lookup_result")), true, 1));
    }

    private void addUserFunction() {
        this.functions.add(new FunctionMethod("user", QueryPlugin.Util.getString("SystemSource.User_desc"), "Miscellaneous", 1, FUNCTION_CLASS, "user", null, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.User_result")), false, 2));
    }

    private void addEnvFunction() {
        this.functions.add(new FunctionMethod("env", QueryPlugin.Util.getString("SystemSource.Env_desc"), "Miscellaneous", 1, FUNCTION_CLASS, "env", new FunctionParameter[]{new FunctionParameter("variablename", "string", QueryPlugin.Util.getString("SystemSource.Env_varname"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.Env_result")), false, 2));
    }

    private void addCommandPayloadFunctions() {
        this.functions.add(new FunctionMethod("commandpayload", QueryPlugin.Util.getString("SystemSource.CommandPayload_desc0"), "Miscellaneous", 1, FUNCTION_CLASS, "commandPayload", new FunctionParameter[0], new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.CommandPayload_result")), false, 3));
        this.functions.add(new FunctionMethod("commandpayload", QueryPlugin.Util.getString("SystemSource.CommandPayload_desc1"), "Miscellaneous", 1, FUNCTION_CLASS, "commandPayload", new FunctionParameter[]{new FunctionParameter("property", "string", QueryPlugin.Util.getString("SystemSource.CommandPayload_property"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.CommandPayload_result")), false, 3));
    }

    private void addNvlFunctions() {
        this.addNvlFunction("bigdecimal");
        this.addNvlFunction("biginteger");
        this.addNvlFunction("boolean");
        this.addNvlFunction("byte");
        this.addNvlFunction("char");
        this.addNvlFunction("date");
        this.addNvlFunction("double");
        this.addNvlFunction("float");
        this.addNvlFunction("integer");
        this.addNvlFunction("long");
        this.addNvlFunction("object");
        this.addNvlFunction("short");
        this.addNvlFunction("string");
        this.addNvlFunction("time");
        this.addNvlFunction("timestamp");
        this.addNvlFunction("blob");
        this.addNvlFunction("clob");
        this.addNvlFunction("xml");
    }

    private void addIfNullFunctions() {
        this.addIfNullFunction("bigdecimal");
        this.addIfNullFunction("biginteger");
        this.addIfNullFunction("boolean");
        this.addIfNullFunction("byte");
        this.addIfNullFunction("char");
        this.addIfNullFunction("date");
        this.addIfNullFunction("double");
        this.addIfNullFunction("float");
        this.addIfNullFunction("integer");
        this.addIfNullFunction("long");
        this.addIfNullFunction("object");
        this.addIfNullFunction("short");
        this.addIfNullFunction("string");
        this.addIfNullFunction("time");
        this.addIfNullFunction("timestamp");
        this.addIfNullFunction("blob");
        this.addIfNullFunction("clob");
        this.addIfNullFunction("xml");
    }

    private void addNvlFunction(String valueType) {
        FunctionMethod nvl = new FunctionMethod("nvl", QueryPlugin.Util.getString("SystemSource.Nvl_desc"), "Miscellaneous", FUNCTION_CLASS, "nvl", new FunctionParameter[]{new FunctionParameter("value", valueType, QueryPlugin.Util.getString("SystemSource.Nvl_arg1")), new FunctionParameter("valueIfNull", valueType, QueryPlugin.Util.getString("SystemSource.Nvl_arg2"))}, new FunctionParameter("result", valueType, QueryPlugin.Util.getString("SystemSource.Nvl_result")));
        nvl.setNullDependent(true);
        this.functions.add(nvl);
    }

    private void addIfNullFunction(String valueType) {
        FunctionMethod ifnull = new FunctionMethod("ifnull", QueryPlugin.Util.getString("SystemSource.Ifnull_desc"), "Miscellaneous", FUNCTION_CLASS, "nvl", new FunctionParameter[]{new FunctionParameter("value", valueType, QueryPlugin.Util.getString("SystemSource.Ifnull_arg1")), new FunctionParameter("valueIfNull", valueType, QueryPlugin.Util.getString("SystemSource.Ifnull_arg2"))}, new FunctionParameter("result", valueType, QueryPlugin.Util.getString("SystemSource.Ifnull_result")));
        ifnull.setNullDependent(true);
        this.functions.add(ifnull);
    }

    private void addFormatTimeFunction(String functionName, String description, String methodName, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("time", "time", QueryPlugin.Util.getString("SystemSource.Formattime_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Formattime_arg2"))}, new FunctionParameter("result", "string", resultDesc)));
    }

    private void addFormatDateFunction(String functionName, String description, String methodName, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("date", "date", QueryPlugin.Util.getString("SystemSource.Formatdate_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Formatdate_arg2"))}, new FunctionParameter("result", "string", resultDesc)));
    }

    private void addFormatTimestampFunction(String functionName, String description, String methodName, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("timestamp", "timestamp", QueryPlugin.Util.getString("SystemSource.Formattimestamp_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Formattimestamp_arg2"))}, new FunctionParameter("result", "string", resultDesc)));
    }

    private void addParseTimeFunction(String functionName, String description, String methodName, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("time", "string", QueryPlugin.Util.getString("SystemSource.Parsetime_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Parsetime_arg2"))}, new FunctionParameter("result", "time", resultDesc)));
    }

    private void addParseDateFunction(String functionName, String description, String methodName, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("date", "string", QueryPlugin.Util.getString("SystemSource.Parsedate_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Parsedate_arg2"))}, new FunctionParameter("result", "date", resultDesc)));
    }

    private void addParseTimestampFunction(String functionName, String description, String methodName, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter("timestamp", "string", QueryPlugin.Util.getString("SystemSource.Parsetimestamp_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Parsetimestamp_arg2"))}, new FunctionParameter("result", "timestamp", resultDesc)));
    }

    private void addFormatNumberFunction(String functionName, String description, String methodName, String inputParam, String dataType, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(inputParam, dataType, QueryPlugin.Util.getString("SystemSource.Formatnumber_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Formatnumber_arg2"))}, new FunctionParameter("result", "string", resultDesc)));
    }

    private void addParseNumberFunction(String functionName, String description, String methodName, String inputParam, String dataType, String resultDesc) {
        this.functions.add(new FunctionMethod(functionName, description, "Conversion", FUNCTION_CLASS, methodName, new FunctionParameter[]{new FunctionParameter(inputParam, "string", QueryPlugin.Util.getString("SystemSource.Parsenumber_arg1")), new FunctionParameter("format", "string", QueryPlugin.Util.getString("SystemSource.Parsenumber_arg2"))}, new FunctionParameter("result", dataType, resultDesc)));
    }

    private void addBitFunction(String functionName, String description, String methodName, int parameters, String resultDescription) {
        FunctionParameter[] paramArray = null;
        if (parameters == 1) {
            paramArray = new FunctionParameter[]{new FunctionParameter("integer", "integer", QueryPlugin.Util.getString("SystemSource.Bitfunc_arg1"))};
        } else if (parameters == 2) {
            paramArray = new FunctionParameter[]{new FunctionParameter("integer1", "integer", QueryPlugin.Util.getString("SystemSource.Bitfunc2_arg1")), new FunctionParameter("integer2", "integer", QueryPlugin.Util.getString("SystemSource.Bitfunc2_arg2"))};
        }
        this.functions.add(new FunctionMethod(functionName, description, "Numeric", FUNCTION_CLASS, methodName, paramArray, new FunctionParameter("result", "integer", resultDescription)));
    }

    private void addXpathFunction() {
        this.functions.add(new FunctionMethod("xpathValue", QueryPlugin.Util.getString("SystemSource.xpath_description"), "XML", XML_FUNCTION_CLASS, "xpathValue", new FunctionParameter[]{new FunctionParameter("document", "string", QueryPlugin.Util.getString("SystemSource.xpath_param1")), new FunctionParameter("xpath", "string", QueryPlugin.Util.getString("SystemSource.xpath_param2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.xpath_result"))));
        this.functions.add(new FunctionMethod("xpathValue", QueryPlugin.Util.getString("SystemSource.xpath_description"), "XML", XML_FUNCTION_CLASS, "xpathValue", new FunctionParameter[]{new FunctionParameter("document", "xml", QueryPlugin.Util.getString("SystemSource.xpath_param1")), new FunctionParameter("xpath", "string", QueryPlugin.Util.getString("SystemSource.xpath_param2"))}, new FunctionParameter("result", "string", QueryPlugin.Util.getString("SystemSource.xpath_result"))));
    }

    private void addTimeZoneFunctions() {
        this.functions.add(new FunctionMethod("modifyTimeZone", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_description"), "Datetime", FUNCTION_CLASS, "modifyTimeZone", new FunctionParameter[]{new FunctionParameter("timestamp", "timestamp", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_param1")), new FunctionParameter("startTimeZone", "string", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_param2")), new FunctionParameter("endTimeZone", "string", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_param3"))}, new FunctionParameter("result", "timestamp", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_result"))));
        this.functions.add(new FunctionMethod("modifyTimeZone", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_description"), "Datetime", FUNCTION_CLASS, "modifyTimeZone", new FunctionParameter[]{new FunctionParameter("timestamp", "timestamp", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_param1")), new FunctionParameter("endTimeZone", "string", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_param3"))}, new FunctionParameter("result", "timestamp", QueryPlugin.Util.getString("SystemSource.modifyTimeZone_result"))));
    }

    public Collection getFunctionMethods() {
        return this.functions;
    }

    public Class getInvocationClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public void reloadMethods() {
    }
}

