/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.xsd.ui.wizards;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.xsd.XsdUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.internal.ui.viewsupport.RelationalObjectBuilder;
import com.metamatrix.modeler.xsd.ui.ModelerXsdUiConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;

public class GenerateVirtualFromXsdHelper {
    private static final String SPACER = "_";
    private static final String NAME = "name";
    private static final String ANY = "Any";
    private static final String DEFAULT_SQL = "Select * FROM";
    private final RelationalObjectBuilder builder;
    private final StringNameValidator nameValidator = new StringNameValidator();
    private final DatatypeManager dtMgr;
    private final MultiStatus status;
    private final Resource resource;
    private final Collection types;
    private final Stack recursionStack = new Stack();
    private final Stack elementStack = new Stack();
    private String currentRootName = null;
    private IProgressMonitor monitor;
    public static boolean HEADLESS = false;

    public GenerateVirtualFromXsdHelper(MultiStatus status, Resource resource, Collection types) {
        ArgCheck.isNotNull((Object)status);
        ArgCheck.isNotNull((Object)resource);
        this.status = status;
        this.resource = resource;
        this.builder = new RelationalObjectBuilder(resource);
        this.types = types;
        this.dtMgr = HEADLESS ? null : ModelerCore.getBuiltInTypesManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(IProgressMonitor monitor) {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)this.getString("CreateVirtualModelFromSchemaWizard.undoTitle"), (Object)this);
        try {
            try {
                if (this.resource != null && !this.types.isEmpty()) {
                    int nTables = 0;
                    String sSize = Integer.toString(this.types.size());
                    ArrayList tableNames = new ArrayList();
                    Iterator iter = this.types.iterator();
                    while (iter.hasNext()) {
                        ++nTables;
                        XSDConcreteComponent next = (XSDConcreteComponent)iter.next();
                        String tableName = this.createTableFromContent(next, tableNames);
                        if (!this.elementStack.isEmpty()) {
                            this.elementStack.clear();
                        }
                        if (monitor == null) continue;
                        monitor.worked(1);
                        monitor.subTask(this.getString("CreateVirtualModelFromSchemaWizard.incrementalProgress", new Object[]{Integer.toString(nTables), sSize, tableName}));
                    }
                }
                Object var10_10 = null;
                if (!requiredStart) return;
            }
            catch (ModelerCoreException exc) {
                this.addStatus(4, exc.getMessage(), exc);
                Object var10_11 = null;
                if (!requiredStart) return;
                if (!monitor.isCanceled()) {
                    ModelerCore.commitTxn();
                    return;
                }
                ModelerCore.rollbackTxn();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (!requiredStart) throw throwable;
            if (!monitor.isCanceled()) {
                ModelerCore.commitTxn();
                throw throwable;
            }
            ModelerCore.rollbackTxn();
            throw throwable;
        }
        if (!monitor.isCanceled()) {
            ModelerCore.commitTxn();
            return;
        }
        ModelerCore.rollbackTxn();
    }

    public void doBuild(IProgressMonitor monitor) {
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
        String message = this.getString("CreateVirtualModelFromSchemaWizard.msg");
        try {
            this.monitor.beginTask(message, this.types.size() * 10);
            if (!this.monitor.isCanceled()) {
                this.execute(this.monitor);
            }
            this.monitor.done();
        }
        catch (Exception e) {
            this.addStatus(4, this.getString("CreateVirtualModelFromSchemaWizard.createError"), e);
        }
    }

    private String getString(String key, Object[] args) {
        if (HEADLESS) {
            return key;
        }
        return ModelerXsdUiConstants.Util.getString(key, args);
    }

    private String getString(String key) {
        return this.getString(key, new Object[0]);
    }

    private String createTableFromContent(XSDConcreteComponent content, Collection tableNames) throws ModelerCoreException {
        XSDModelGroup group;
        XSDComplexTypeDefinition ctd;
        String tableDesc = XsdUtil.getDescription((XSDConcreteComponent)content);
        String tableName = ModelerCore.getModelEditor().getName((EObject)content);
        while (tableName.indexOf(46) > -1) {
            tableName = tableName.replace('.', '_');
        }
        String tmp = this.nameValidator.createValidUniqueName(tableName, tableNames);
        if (tmp != null) {
            tableName = tmp;
        }
        tableNames.add(tableName);
        EObject vTable = this.builder.createBaseTable(tableName, (Object)this.resource, false, tableDesc);
        this.builder.createXPathNIS(vTable, content);
        ArrayList columnsList = new ArrayList();
        ArrayList columnNames = new ArrayList();
        XSDComplexTypeDefinition xSDComplexTypeDefinition = ctd = content instanceof XSDComplexTypeDefinition ? (XSDComplexTypeDefinition)content : null;
        if (content instanceof XSDElementDeclaration) {
            this.elementStack.push(content);
            XSDTypeDefinition type = ((XSDElementDeclaration)content).getTypeDefinition();
            if (type instanceof XSDComplexTypeDefinition) {
                ctd = (XSDComplexTypeDefinition)type;
            } else {
                this.processContent((XSDConcreteComponent)type, this.resource, vTable, columnsList, columnNames);
            }
        }
        if ((group = XsdUtil.getCompositor((XSDComplexTypeDefinition)ctd)) != null) {
            Iterator particles = group.getParticles().iterator();
            while (particles != null && particles.hasNext()) {
                XSDParticle nextPart = (XSDParticle)particles.next();
                this.processContent((XSDConcreteComponent)nextPart.getContent(), this.resource, vTable, columnsList, columnNames);
            }
        } else if (ctd != null && ctd.getContent() instanceof XSDTypeDefinition) {
            this.processContent((XSDConcreteComponent)ctd.getContent(), this.resource, vTable, columnsList, columnNames);
        } else if (ctd != null && ctd.getContent() instanceof XSDAttributeDeclaration) {
            this.processContent((XSDConcreteComponent)ctd.getContent(), this.resource, vTable, columnsList, columnNames);
        } else {
            String contentType = ctd == null || ctd.getContent() == null ? "null" : ctd.getContent().getClass().getName();
            String msg = this.getString("CreateVirtualModelFromSchemaWizard.invalidContent", new Object[]{contentType});
            this.addStatus(4, msg, null);
        }
        if (!columnsList.isEmpty()) {
            this.builder.addColumns((Object)vTable, columnsList);
        }
        this.builder.createTransformation(vTable, DEFAULT_SQL);
        return tableName;
    }

    private void processContent(XSDConcreteComponent content, Resource resource, EObject vTable, Collection columnList, Collection columnNames) throws ModelerCoreException {
        if (content instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = this.resolveElement((XSDElementDeclaration)content);
            XSDElementDeclaration parentElement = this.elementStack.isEmpty() ? null : (XSDElementDeclaration)this.elementStack.peek();
            this.currentRootName = parentElement == null ? element.getName() : parentElement.getName() + SPACER + element.getName();
            this.elementStack.push(element);
            XSDTypeDefinition typeDefn = element.getType();
            if (typeDefn instanceof XSDComplexTypeDefinition) {
                this.addColumnsForComplexType((XSDComplexTypeDefinition)typeDefn, resource, vTable, columnList, columnNames);
            } else {
                this.processContent((XSDConcreteComponent)typeDefn, resource, vTable, columnList, columnNames);
            }
            if (!this.elementStack.isEmpty()) {
                this.elementStack.pop();
            }
        } else if (content instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)content;
            if (complexType.getName() != null) {
                this.currentRootName = complexType.getName();
            }
            this.addColumnsForComplexType(complexType, resource, vTable, columnList, columnNames);
        } else if (content instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition simpleTypeDefn = (XSDSimpleTypeDefinition)content;
            this.createColumn(columnNames, columnList, vTable, simpleTypeDefn);
        } else if (content instanceof XSDAttributeDeclaration) {
            XSDAttributeDeclaration attr = this.resolveAttribute((XSDAttributeDeclaration)content);
            XSDSimpleTypeDefinition simpleTypeDefn = attr.getTypeDefinition();
            XSDElementDeclaration parentElement = this.elementStack.isEmpty() ? null : (XSDElementDeclaration)this.elementStack.peek();
            this.currentRootName = parentElement == null ? attr.getName() : parentElement.getName() + SPACER + attr.getName();
            this.createColumn(columnNames, columnList, vTable, simpleTypeDefn);
        } else if (content instanceof XSDAttributeUse) {
            XSDAttributeDeclaration attr = this.resolveAttribute(((XSDAttributeUse)content).getAttributeDeclaration());
            XSDSimpleTypeDefinition simpleTypeDefn = attr.getTypeDefinition();
            XSDElementDeclaration parentElement = this.elementStack.isEmpty() ? null : (XSDElementDeclaration)this.elementStack.peek();
            this.currentRootName = parentElement == null ? attr.getName() : parentElement.getName() + SPACER + attr.getName();
            this.createColumn(columnNames, columnList, vTable, simpleTypeDefn);
        } else if (content instanceof XSDAttributeGroupDefinition) {
            XSDAttributeGroupDefinition attGroup = (XSDAttributeGroupDefinition)content;
            Iterator atts = attGroup.getAttributeUses().iterator();
            while (atts.hasNext()) {
                this.processContent((XSDConcreteComponent)atts.next(), resource, vTable, columnList, columnNames);
            }
        } else if (content instanceof XSDWildcard) {
            String tableName = this.getName(vTable);
            this.currentRootName = tableName == null ? ANY : tableName + SPACER + ANY;
            String tmp = this.nameValidator.createValidUniqueName(this.currentRootName, columnNames);
            if (tmp != null) {
                this.currentRootName = tmp;
            }
            this.createColumn(columnNames, columnList, vTable, null);
        } else {
            String contentType = content == null ? "null" : content.getClass().getName();
            String msg = this.getString("CreateVirtualModelFromSchemaWizard.unexpectedContent", new Object[]{contentType});
            this.addStatus(4, msg, null);
        }
    }

    private String getName(EObject eObj) {
        if (eObj == null) {
            return null;
        }
        EStructuralFeature name = eObj.eClass().getEStructuralFeature(NAME);
        if (name != null) {
            return (String)eObj.eGet(name);
        }
        return null;
    }

    private void createColumn(Collection columnNames, Collection columnList, EObject vTable, XSDSimpleTypeDefinition simpleTypeDefn) throws ModelerCoreException {
        String tmp;
        XSDSimpleTypeDefinition builtInType;
        boolean isAny = simpleTypeDefn == null;
        if (HEADLESS) {
            boolean done = false;
            while (!done && builtInType != null && builtInType != builtInType.getBaseTypeDefinition()) {
                XSDSimpleTypeDefinition tmp2 = builtInType.getBaseTypeDefinition();
                if (tmp2 == null || tmp2.getName() != null && tmp2.getName().equals("anySimpleType")) {
                    done = true;
                    continue;
                }
                builtInType = builtInType.getBaseTypeDefinition();
            }
        } else {
            for (builtInType = simpleTypeDefn; builtInType != null && !this.dtMgr.isEnterpriseDatatype((EObject)builtInType) && builtInType != builtInType.getBaseTypeDefinition(); builtInType = builtInType.getBaseTypeDefinition()) {
            }
        }
        if (isAny && !HEADLESS) {
            String msg = this.getString("CreateVirtualModelFromSchemaWizard.wildcard", new Object[]{this.currentRootName});
            this.addStatus(1, msg, null);
            builtInType = (XSDSimpleTypeDefinition)this.dtMgr.getAnySimpleType();
        }
        if (builtInType == null) {
            String msg = this.getString("CreateVirtualModelFromSchemaWizard.noDt", new Object[]{this.currentRootName});
            this.addStatus(4, msg, null);
            return;
        }
        if (this.currentRootName == null) {
            this.currentRootName = builtInType.getName();
        }
        if ((tmp = this.nameValidator.createValidUniqueName(this.currentRootName, columnNames)) != null) {
            this.currentRootName = tmp;
        }
        columnNames.add(this.currentRootName);
        String columnDesc = XsdUtil.getDescription((XSDConcreteComponent)simpleTypeDefn);
        EObject nextCol = this.builder.createColumn(this.currentRootName, (Object)vTable, columnDesc, builtInType, simpleTypeDefn);
        if (nextCol != null) {
            this.builder.createColXPathNIS(nextCol, this.elementStack);
            columnList.add(nextCol);
        }
    }

    private void addColumnsForComplexType(XSDComplexTypeDefinition complexTypeDefn, Resource resource, EObject vTable, Collection columnsList, Collection columnNames) throws ModelerCoreException {
        if (this.recursionStack.contains(complexTypeDefn)) {
            return;
        }
        this.recursionStack.push(complexTypeDefn);
        XSDModelGroup group = XsdUtil.getCompositor((XSDComplexTypeDefinition)complexTypeDefn);
        XSDComplexTypeContent content = complexTypeDefn.getContent();
        if (group != null) {
            this.processModelGroup(group, resource, vTable, columnsList, columnNames);
        } else if (content instanceof XSDComplexTypeDefinition) {
            this.addColumnsForComplexType((XSDComplexTypeDefinition)content, resource, vTable, columnsList, columnNames);
        } else if (content instanceof XSDSimpleTypeDefinition) {
            this.processContent((XSDConcreteComponent)content, resource, vTable, columnsList, columnNames);
        } else if (content instanceof XSDWildcard) {
            this.processContent((XSDConcreteComponent)content, resource, vTable, columnsList, columnNames);
        } else if (content != null) {
            String contentType = content.getClass().getName();
            String msg = this.getString("CreateVirtualModelFromSchemaWizard.unexpectedContent", new Object[]{contentType});
            this.addStatus(4, msg, null);
        }
        Iterator atts = complexTypeDefn.getAttributeContents().iterator();
        while (atts.hasNext()) {
            XSDConcreteComponent next = (XSDConcreteComponent)atts.next();
            this.processContent(next, resource, vTable, columnsList, columnNames);
        }
        if (!this.recursionStack.isEmpty()) {
            this.recursionStack.pop();
        }
    }

    private void processModelGroup(XSDModelGroup group, Resource resource, EObject vTable, Collection columnsList, Collection columnNames) throws ModelerCoreException {
        if (group == null) {
            return;
        }
        Iterator particles = group.getParticles().iterator();
        while (particles.hasNext()) {
            XSDParticle nextPart = (XSDParticle)particles.next();
            XSDParticleContent partContent = nextPart.getContent();
            if (partContent instanceof XSDElementDeclaration) {
                XSDElementDeclaration elementContent = this.resolveElement((XSDElementDeclaration)partContent);
                this.processContent((XSDConcreteComponent)elementContent, resource, vTable, columnsList, columnNames);
                continue;
            }
            if (partContent instanceof XSDAttributeDeclaration) {
                XSDAttributeDeclaration attr = (XSDAttributeDeclaration)partContent;
                this.currentRootName = attr.getName();
                this.processContent((XSDConcreteComponent)attr, resource, vTable, columnsList, columnNames);
                continue;
            }
            if (partContent instanceof XSDModelGroupDefinition) {
                XSDModelGroup childGroup = ((XSDModelGroupDefinition)partContent).getModelGroup();
                this.processModelGroup(childGroup, resource, vTable, columnsList, columnNames);
                continue;
            }
            if (partContent instanceof XSDWildcard) {
                this.processContent((XSDConcreteComponent)partContent, resource, vTable, columnsList, columnNames);
                continue;
            }
            String contentType = partContent == null ? "null" : partContent.getClass().getName();
            String msg = this.getString("CreateVirtualModelFromSchemaWizard.unexpectedContent", new Object[]{contentType});
            this.addStatus(4, msg, null);
        }
    }

    private XSDElementDeclaration resolveElement(XSDElementDeclaration element) {
        if (element == null || element.getResolvedElementDeclaration() == element) {
            return element;
        }
        return this.resolveElement(element.getResolvedElementDeclaration());
    }

    private XSDAttributeDeclaration resolveAttribute(XSDAttributeDeclaration attr) {
        if (attr == null || attr.getResolvedAttributeDeclaration() == attr) {
            return attr;
        }
        return this.resolveAttribute(attr.getResolvedAttributeDeclaration());
    }

    private void addStatus(int severity, String message, Throwable ex) {
        Status sts = new Status(severity, "com.metamatrix.modeler.xsd.ui", 0, message, ex);
        this.status.add((IStatus)sts);
    }
}

