/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.BehavioredClassifier;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Component;
import org.eclipse.uml2.Enumeration;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.PackageableElement;
import org.eclipse.uml2.Port;
import org.eclipse.uml2.PrimitiveType;
import org.eclipse.uml2.Realization;
import org.eclipse.uml2.RedefinableElement;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.internal.operation.NamespaceOperations;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class ComponentOperations
extends UML2Operations {
    public static final String copyright = "Copyright (c) IBM Corporation and others.";
    static /* synthetic */ java.lang.Class class$0;
    static /* synthetic */ java.lang.Class class$1;
    static /* synthetic */ java.lang.Class class$2;

    private ComponentOperations() {
    }

    public static Class createOwnedClass(Component component, String name, boolean isAbstract) {
        if (component == null) {
            throw new IllegalArgumentException(String.valueOf(component));
        }
        if (ComponentOperations.isEmpty(name)) {
            throw new IllegalArgumentException(String.valueOf(name));
        }
        Class ownedClass = (Class)component.createOwnedMember(UML2Package.eINSTANCE.getClass_());
        ownedClass.setName(name);
        ownedClass.setIsAbstract(isAbstract);
        return ownedClass;
    }

    public static Enumeration createOwnedEnumeration(Component component, String name) {
        if (component == null) {
            throw new IllegalArgumentException(String.valueOf(component));
        }
        if (ComponentOperations.isEmpty(name)) {
            throw new IllegalArgumentException(String.valueOf(name));
        }
        Enumeration ownedEnumeration = (Enumeration)component.createOwnedMember(UML2Package.eINSTANCE.getEnumeration());
        ownedEnumeration.setName(name);
        return ownedEnumeration;
    }

    public static Package createOwnedPackage(Component component, String name) {
        if (component == null) {
            throw new IllegalArgumentException(String.valueOf(component));
        }
        if (ComponentOperations.isEmpty(name)) {
            throw new IllegalArgumentException(String.valueOf(name));
        }
        Package ownedPackage = (Package)component.createOwnedMember(UML2Package.eINSTANCE.getPackage());
        ownedPackage.setName(name);
        return ownedPackage;
    }

    public static PrimitiveType createOwnedPrimitiveType(Component component, String name) {
        if (component == null) {
            throw new IllegalArgumentException(String.valueOf(component));
        }
        if (ComponentOperations.isEmpty(name)) {
            throw new IllegalArgumentException(String.valueOf(name));
        }
        PrimitiveType ownedPrimitiveType = (PrimitiveType)component.createOwnedMember(UML2Package.eINSTANCE.getPrimitiveType());
        ownedPrimitiveType.setName(name);
        return ownedPrimitiveType;
    }

    public static EList getProvideds(Component component) {
        UniqueEList provideds = new UniqueEList();
        if (component != null) {
            provideds.addAll((Collection)component.getImplementedInterfaces());
            Iterator realizations = component.getRealizations().iterator();
            while (realizations.hasNext()) {
                Classifier realizingClassifier = ((Realization)realizations.next()).getRealizingClassifier();
                java.lang.Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = java.lang.Class.forName("org.eclipse.uml2.Interface");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isInstance(realizingClassifier)) {
                    provideds.add((Object)realizingClassifier);
                    continue;
                }
                java.lang.Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = java.lang.Class.forName("org.eclipse.uml2.BehavioredClassifier");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz2.isInstance(realizingClassifier)) continue;
                provideds.addAll((Collection)((BehavioredClassifier)realizingClassifier).getImplementedInterfaces());
            }
            Iterator ownedPorts = component.getOwnedPorts().iterator();
            while (ownedPorts.hasNext()) {
                provideds.addAll((Collection)((Port)ownedPorts.next()).getProvideds());
            }
        }
        return provideds;
    }

    public static EList getRequireds(Component component) {
        UniqueEList requireds = new UniqueEList();
        if (component != null) {
            requireds.addAll((Collection)component.getUsedInterfaces());
            Iterator realizations = component.getRealizations().iterator();
            while (realizations.hasNext()) {
                Classifier realizingClassifier = ((Realization)realizations.next()).getRealizingClassifier();
                if (realizingClassifier == null) continue;
                requireds.addAll((Collection)realizingClassifier.getUsedInterfaces());
            }
            Iterator ownedPorts = component.getOwnedPorts().iterator();
            while (ownedPorts.hasNext()) {
                requireds.addAll((Collection)((Port)ownedPorts.next()).getRequireds());
            }
        }
        return requireds;
    }

    public static EList getOwnedMembers(Component component) {
        UniqueEList ownedMembers = new UniqueEList();
        if (component != null) {
            ownedMembers.addAll((Collection)component.getOwnedRules());
            ownedMembers.addAll((Collection)component.getOwnedUseCases());
            ownedMembers.addAll((Collection)component.getOwnedBehaviors());
            ownedMembers.addAll((Collection)component.getOwnedTriggers());
            ownedMembers.addAll((Collection)component.getOwnedAttributes());
            ownedMembers.addAll((Collection)component.getOwnedConnectors());
            ownedMembers.addAll((Collection)component.getOwnedPorts());
            ownedMembers.addAll((Collection)component.getOwnedOperations());
            ownedMembers.addAll((Collection)component.getNestedClassifiers());
            ownedMembers.addAll((Collection)component.getOwnedReceptions());
            ownedMembers.addAll((Collection)component.getOwnedMembers());
        }
        return ownedMembers;
    }

    public static Set getNamesOfMember(Component component, NamedElement element) {
        HashSet<String> namesOfMember = new HashSet<String>();
        if (ComponentOperations.getOwnedMembers(component).contains((Object)element)) {
            if (!ComponentOperations.isEmpty(element.getName())) {
                namesOfMember.add(element.getName());
            }
        } else {
            return NamespaceOperations.getNamesOfMember(component, element);
        }
        return Collections.unmodifiableSet(namesOfMember);
    }

    public static Set importMembers(Component component, Set imps) {
        HashSet<PackageableElement> importMembers = new HashSet<PackageableElement>();
        Iterator excludeCollisions = component.excludeCollisions(imps).iterator();
        block0: while (excludeCollisions.hasNext()) {
            PackageableElement excludeCollision = (PackageableElement)excludeCollisions.next();
            Iterator ownedMembers = ComponentOperations.getOwnedMembers(component).iterator();
            while (ownedMembers.hasNext()) {
                PackageableElement ownedMember = (PackageableElement)ownedMembers.next();
                if (!excludeCollision.isDistinguishableFrom(ownedMember, component)) continue block0;
            }
            importMembers.add(excludeCollision);
        }
        return Collections.unmodifiableSet(importMembers);
    }

    public static Set inherit(Component component, Set inhs) {
        HashSet<NamedElement> inherit = new HashSet<NamedElement>();
        Iterator i = inhs.iterator();
        block2: while (i.hasNext()) {
            NamedElement inh = (NamedElement)i.next();
            Iterator ownedMembers = ComponentOperations.getOwnedMembers(component).iterator();
            while (ownedMembers.hasNext()) {
                NamedElement ownedMember = (NamedElement)ownedMembers.next();
                java.lang.Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = java.lang.Class.forName("org.eclipse.uml2.RedefinableElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isInstance(ownedMember) && ((RedefinableElement)ownedMember).getRedefinedElements().contains((Object)inh)) continue block2;
            }
            inherit.add(inh);
        }
        return Collections.unmodifiableSet(inherit);
    }
}

