/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.ui.refactor;

import com.metamatrix.modeler.core.refactor.ResourceRefactorCommand;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.ui.UiConstants;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.widget.MessageLabel;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class FileFolderRenameDialog
extends SelectionDialog {
    private static final String TITLE_PREFIX = UiConstants.Util.getString("FileFolderRenameDialog.titlePrefix.text");
    private static final String MESSAGE_LABEL = UiConstants.Util.getString("FileFolderRenameDialog.messageLabel.text") + ' ';
    private static final String MODEL_FILE = UiConstants.Util.getString("FileFolderRenameDialog.modelFile.text") + ' ';
    private static final String SCHEMA_FILE = UiConstants.Util.getString("FileFolderRenameDialog.schemaFile.text") + ' ';
    private static final String VDB_FILE = UiConstants.Util.getString("FileFolderRenameDialog.vdbDefinitionFile.text") + ' ';
    private static final String FOLDER = UiConstants.Util.getString("FileFolderRenameDialog.folder.text") + ' ';
    private static final int WIDTH = 500;
    private static final int HEIGHT = 100;
    private IResource resource;
    private ResourceRefactorCommand command;
    private Text txtOldNameNewName;
    private String sNewName;
    private MessageLabel messageLabel;
    private String sOriginalName;

    public FileFolderRenameDialog(Shell parent, ResourceRefactorCommand command, IResource resource) {
        super(parent);
        this.command = command;
        this.resource = resource;
        this.setTitle(TITLE_PREFIX + ' ' + this.getResourceType());
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        GridLayout gridLayout = new GridLayout();
        parent.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gd = new GridData(768);
        gd.widthHint = 500;
        gd.heightHint = 100;
        parent.setLayoutData((Object)gd);
        Composite pnlNewName = new Composite(parent, 0);
        GridLayout gridLayout2 = new GridLayout();
        pnlNewName.setLayout((Layout)gridLayout2);
        gridLayout2.numColumns = 4;
        GridData gd2 = new GridData(768);
        pnlNewName.setLayoutData((Object)gd2);
        WidgetFactory.createLabel((Composite)pnlNewName, (String)MESSAGE_LABEL);
        this.sOriginalName = this.getResourceName();
        this.txtOldNameNewName = WidgetFactory.createTextField((Composite)pnlNewName, (int)768, (String)this.sOriginalName);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = 3;
        this.txtOldNameNewName.setLayoutData((Object)gd3);
        this.messageLabel = new MessageLabel(parent);
        this.messageLabel.setAlignment(16384);
        this.messageLabel.setErrorStatus(null);
        this.messageLabel.setFont(parent.getFont());
        GridData messageLabelGridData = new GridData();
        messageLabelGridData.horizontalAlignment = 4;
        messageLabelGridData.verticalAlignment = 4;
        this.messageLabel.setLayoutData((Object)messageLabelGridData);
        this.registerControls();
        return parent;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btnNew = super.createButton(parent, id, label, defaultButton);
        Integer iId = (Integer)btnNew.getData();
        if (iId == 0) {
            btnNew.setEnabled(false);
        }
        return btnNew;
    }

    public String getNewName() {
        return this.sNewName;
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        super.create();
    }

    private String getResourceType() {
        String sResourceType = "";
        if (ModelUtil.isXsdFile((IResource)this.resource)) {
            sResourceType = SCHEMA_FILE;
        } else if (ModelUtilities.isModelFile((IResource)this.resource)) {
            sResourceType = MODEL_FILE;
        } else if (ModelUtil.isVdbArchiveFile((IResource)this.resource)) {
            sResourceType = VDB_FILE;
        } else if (this.resource.getType() == 2) {
            sResourceType = FOLDER;
        }
        return sResourceType;
    }

    private String getResourceName() {
        return this.resource.getFullPath().removeFileExtension().lastSegment();
    }

    private void setErrorMessage(final IStatus status) {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (FileFolderRenameDialog.this.messageLabel != null && !FileFolderRenameDialog.this.messageLabel.isDisposed()) {
                    FileFolderRenameDialog.this.messageLabel.setErrorStatus(status);
                }
            }
        });
    }

    private void registerControls() {
        this.txtOldNameNewName.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
            }

            public void focusLost(FocusEvent event) {
                FileFolderRenameDialog.this.sNewName = FileFolderRenameDialog.this.txtOldNameNewName.getText();
                FileFolderRenameDialog.this.command.setNewName(FileFolderRenameDialog.this.sNewName);
                IStatus status = FileFolderRenameDialog.this.command.canExecute();
                FileFolderRenameDialog.this.setErrorMessage(status);
                FileFolderRenameDialog.this.getButton(0).setEnabled(status.isOK());
            }
        });
        this.txtOldNameNewName.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                FileFolderRenameDialog.this.sNewName = FileFolderRenameDialog.this.txtOldNameNewName.getText();
                FileFolderRenameDialog.this.command.setNewName(FileFolderRenameDialog.this.sNewName);
                IStatus status = FileFolderRenameDialog.this.command.canExecute();
                FileFolderRenameDialog.this.setErrorMessage(status);
                FileFolderRenameDialog.this.getButton(0).setEnabled(status.isOK());
            }
        });
    }
}

