/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.transformation.InputSet;
import com.metamatrix.metamodels.transformation.SqlAlias;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metadata.runtime.ColumnRecord;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.core.metadata.runtime.ProcedureParameterRecord;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnSetAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.internal.core.metadata.runtime.ColumnRecordImpl;
import com.metamatrix.modeler.internal.core.metadata.runtime.TableRecordImpl;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlConstants;
import com.metamatrix.modeler.internal.transformation.util.SqlConverter;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.aspects.sql.InputParameterSqlAspect;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadataFactory;
import com.metamatrix.modeler.transformation.validation.SqlTransformationResult;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.query.o.h.aa;
import com.metamatrix.query.o.h.g;
import com.metamatrix.query.o.h.k;
import com.metamatrix.query.o.i.a;
import com.metamatrix.query.o.i.b;
import com.metamatrix.query.o.i.c;
import com.metamatrix.query.o.i.d;
import com.metamatrix.query.o.i.e;
import com.metamatrix.query.o.i.f;
import com.metamatrix.query.o.i.i;
import com.metamatrix.query.o.i.n;
import com.metamatrix.query.o.i.q;
import com.metamatrix.query.o.j.ag;
import com.metamatrix.query.o.j.al;
import com.metamatrix.query.o.j.am;
import com.metamatrix.query.o.j.ao;
import com.metamatrix.query.o.j.ar;
import com.metamatrix.query.o.j.h;
import com.metamatrix.query.o.j.j;
import com.metamatrix.query.o.j.l;
import com.metamatrix.query.o.j.p;
import com.metamatrix.query.o.j.r;
import com.metamatrix.query.o.j.s;
import com.metamatrix.query.o.j.x;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class TransformationSqlHelper
implements SqlConstants {
    private static final TransformationSqlHelper INSTANCE = new TransformationSqlHelper();
    private static final String NEW_CONVERSION_NAME = "conversion";
    static /* synthetic */ Class class$java$lang$String;

    public static TransformationSqlHelper getInstance() {
        return INSTANCE;
    }

    public static boolean canAddGroupToSelectSql(EObject transMappingRoot) {
        boolean canUpdate = false;
        if (TransformationHelper.isValidQuery(transMappingRoot) || TransformationHelper.isValidSetQuery(transMappingRoot) || TransformationHelper.isSelectFromString(transMappingRoot) || TransformationHelper.isInitialSelect(transMappingRoot) || TransformationHelper.isEmptySelect(transMappingRoot)) {
            canUpdate = true;
        }
        return canUpdate;
    }

    public static boolean canRemoveGroupFromSelectSql(EObject transMappingRoot) {
        boolean canUpdate = false;
        if (TransformationHelper.isValidQuery(transMappingRoot) || TransformationHelper.isInitialSelect(transMappingRoot) || TransformationHelper.isEmptySelect(transMappingRoot)) {
            canUpdate = true;
        }
        return canUpdate;
    }

    public static void updateAllSqlOnSqlAliasGroupAdded(EObject transMappingRoot, EObject sqlAliasGroup, boolean addElemsToSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupAdded(transMappingRoot, sqlAliasGroup, addElemsToSelect, source);
    }

    public static void updateAllSqlOnSqlAliasGroupsAdded(EObject transMappingRoot, List sqlAliasGroups, boolean addElemsToSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupsAdded(transMappingRoot, sqlAliasGroups, addElemsToSelect, source);
    }

    public static void updateAllSqlOnSqlAliasGroupRemoved(EObject transMappingRoot, EObject sqlAliasGroup, boolean removeElemsFromSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupRemoved(transMappingRoot, sqlAliasGroup, removeElemsFromSelect, source);
    }

    public static void updateAllSqlOnSqlAliasGroupsRemoved(EObject transMappingRoot, List sqlAliasGroups, boolean removeElemsFromSelect, Object source) {
        TransformationSqlHelper.updateSelectSqlOnSqlAliasGroupsRemoved(transMappingRoot, sqlAliasGroups, removeElemsFromSelect, source);
    }

    public static void updateAllSqlOnElementsRemoved(EObject transMappingRoot, List elementEObjs, Object source) {
        TransformationSqlHelper.updateSqlOnElementsRemoved(transMappingRoot, elementEObjs, source);
    }

    public static void updateSelectSqlOnSqlAliasGroupAdded(EObject transMappingRoot, EObject sqlAliasGroup, boolean addElemsToSelect, Object source) {
        if (SqlAspectHelper.isTable((EObject)sqlAliasGroup) && (TransformationHelper.isParsableQuery(transMappingRoot) || TransformationHelper.isInitialSelect(transMappingRoot)) && sqlAliasGroup != null) {
            ArrayList<EObject> groups = new ArrayList<EObject>(1);
            groups.add(sqlAliasGroup);
            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
            TransformationSqlHelper.addSqlAliasGroupsToSelectStatement(transMappingRoot, groups, addElemsToSelect, source, validator);
        }
    }

    public static void updateSelectSqlOnSqlAliasGroupsAdded(EObject transMappingRoot, List sqlAliasGroups, boolean addElemsToSelect, Object source) {
        if (TransformationHelper.isParsableQuery(transMappingRoot) || TransformationHelper.isInitialSelect(transMappingRoot) || TransformationHelper.isEmptySelect(transMappingRoot) || TransformationHelper.isSelectFromString(transMappingRoot)) {
            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
            TransformationSqlHelper.addSqlAliasGroupsToSelectStatement(transMappingRoot, sqlAliasGroups, addElemsToSelect, source, validator);
        }
    }

    public static void updateSelectSqlOnSqlAliasGroupRemoved(EObject transMappingRoot, EObject sqlAliasGroup, boolean removeElemsFromSelect, Object source) {
        if (SqlAspectHelper.isTable((EObject)sqlAliasGroup)) {
            if (source == null) {
                source = TransformationSqlHelper.getInstance();
            }
            if ((TransformationHelper.isParsableQuery(transMappingRoot) || TransformationHelper.isInitialSelect(transMappingRoot)) && sqlAliasGroup != null) {
                ArrayList<EObject> groups = new ArrayList<EObject>(1);
                groups.add(sqlAliasGroup);
                TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
                TransformationSqlHelper.removeSqlAliasGroupsFromSelectStatement(transMappingRoot, groups, removeElemsFromSelect, source, validator);
            }
        }
    }

    public static void updateSelectSqlOnSqlAliasGroupsRemoved(EObject transMappingRoot, List sqlAliasGroups, boolean removeElemsFromSelect, Object source) {
        if (TransformationHelper.isParsableQuery(transMappingRoot)) {
            if (source == null) {
                source = TransformationSqlHelper.getInstance();
            }
            TransformationValidator validator = new TransformationValidator((SqlTransformationMappingRoot)transMappingRoot, false);
            TransformationSqlHelper.removeSqlAliasGroupsFromSelectStatement(transMappingRoot, sqlAliasGroups, removeElemsFromSelect, source, validator);
        }
    }

    public static void updateSqlOnElementsRemoved(EObject transMappingRoot, List elementEObjs, Object source) {
        if (TransformationHelper.isParsableQuery(transMappingRoot)) {
            if (source == null) {
                source = TransformationSqlHelper.getInstance();
            }
            TransformationSqlHelper.removeElementsFromStatement(transMappingRoot, elementEObjs, source);
        }
    }

    public static void updateUnionSelectOnGroupsAdded(EObject transMappingRoot, List sourceGroups, boolean useAll, Object txnSource) {
        if (TransformationHelper.isParsableQuery(transMappingRoot) || TransformationHelper.isParsableSetQuery(transMappingRoot) || TransformationHelper.isInitialSelect(transMappingRoot) || TransformationHelper.isEmptySelect(transMappingRoot)) {
            l command = SqlMappingRootCache.getSelectCommand(transMappingRoot);
            if (command != null) {
                if (command instanceof ar) {
                    r newQuery = TransformationSqlHelper.createSetQueryAddUnionSources((ar)command, sourceGroups, useAll);
                    TransformationHelper.setSelectSqlString(transMappingRoot, newQuery.toString(), false, txnSource);
                }
            } else {
                r newQuery = TransformationSqlHelper.createSetQueryAddUnionSources(new r(0), sourceGroups, useAll);
                TransformationHelper.setSelectSqlString(transMappingRoot, newQuery.toString(), false, txnSource);
            }
        }
    }

    public static void updateUnionSelectAddGroupsToSegment(EObject transMappingRoot, List sourceGroups, int nSegmentIndex, Object txnSource) {
        l command;
        if (TransformationHelper.isParsableSetQuery(transMappingRoot) && (command = SqlMappingRootCache.getSelectCommand(transMappingRoot)) != null && command instanceof r) {
            r newSetQuery = (r)((Object)command.clone());
            List queries = ((r)command).jk();
            ar queryCommand = (ar)queries.get(nSegmentIndex);
            if (queryCommand instanceof ag) {
                ag query = (ag)queryCommand;
                ag newQuery = TransformationSqlHelper.createQueryAddGroupsToFrom(query, sourceGroups);
                newSetQuery.jf();
                for (int i2 = 0; i2 < queries.size(); ++i2) {
                    if (i2 == nSegmentIndex) {
                        newSetQuery.je(newQuery);
                        continue;
                    }
                    newSetQuery.je((ar)queries.get(i2));
                }
                TransformationHelper.setSelectSqlString(transMappingRoot, newSetQuery.toString(), false, txnSource);
            }
        }
    }

    private static void addSqlAliasGroupsToSelectStatement(EObject transMappingRoot, List sqlAliasGroups, boolean addElemsToSelect, Object txnSource, TransformationValidator validator) {
        if (transMappingRoot == null || sqlAliasGroups == null) {
            return;
        }
        if (txnSource == null) {
            txnSource = TransformationSqlHelper.getInstance();
        }
        boolean isValid = SqlMappingRootCache.isSelectValid(transMappingRoot);
        l command = SqlMappingRootCache.getSelectCommand(transMappingRoot);
        if (isValid && command instanceof ag) {
            ag query = (ag)command;
            ag newQuery = TransformationSqlHelper.createQueryAddSqlAliasGroups(query, sqlAliasGroups, addElemsToSelect, 0, validator);
            TransformationHelper.setSelectSqlString(transMappingRoot, newQuery.toString(), false, txnSource);
        } else if (TransformationHelper.isInitialSelect(transMappingRoot) || TransformationHelper.isEmptySelect(transMappingRoot)) {
            EObject targetGrp = TransformationHelper.getTransformationLinkTarget(transMappingRoot);
            if (!TransformationHelper.isSqlProcedure(targetGrp)) {
                ag qry = TransformationSqlHelper.createDefaultQuery(null);
                qry = TransformationSqlHelper.createQueryAddSqlAliasGroups(qry, sqlAliasGroups, addElemsToSelect, 0, validator);
                TransformationHelper.setSelectSqlString(transMappingRoot, qry.toString(), false, txnSource);
            } else if (sqlAliasGroups.size() == 1) {
                SqlAlias sqlAlias = (SqlAlias)sqlAliasGroups.get(0);
                EObject aliasedEObject = sqlAlias.getAliasedObject();
                if (TransformationHelper.isSqlProcedure(aliasedEObject)) {
                    x proc = TransformationSqlHelper.createStoredProc((EObject)sqlAlias);
                    if (proc != null) {
                        com.metamatrix.query.o.f.d cCommand = TransformationSqlHelper.createVirtualProcCommmandForCommand(proc);
                        TransformationHelper.setSelectSqlString(transMappingRoot, cCommand.toString(), false, txnSource);
                    }
                } else {
                    ag qry = TransformationSqlHelper.createDefaultQuery(null);
                    qry = TransformationSqlHelper.createQueryAddSqlAliasGroups(qry, sqlAliasGroups, addElemsToSelect, 0, validator);
                    com.metamatrix.query.o.f.d cCommand = TransformationSqlHelper.createVirtualProcCommmandForCommand((l)qry);
                    TransformationHelper.setSelectSqlString(transMappingRoot, cCommand.toString(), false, txnSource);
                }
            } else {
                ag qry = TransformationSqlHelper.createDefaultQuery(null);
                qry = TransformationSqlHelper.createQueryAddSqlAliasGroups(qry, sqlAliasGroups, addElemsToSelect, 0, validator);
                com.metamatrix.query.o.f.d cCommand = TransformationSqlHelper.createVirtualProcCommmandForCommand((l)qry);
                TransformationHelper.setSelectSqlString(transMappingRoot, cCommand.toString(), false, txnSource);
            }
        } else if (TransformationHelper.isSelectFromString(transMappingRoot)) {
            StringBuffer sb = new StringBuffer(TransformationHelper.getSelectSqlString(transMappingRoot));
            sb.append(" ");
            List clausesToAdd = TransformationSqlHelper.createFromClauses(sqlAliasGroups);
            Iterator iter = clausesToAdd.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            TransformationHelper.setSelectSqlString(transMappingRoot, sb.toString(), false, txnSource);
        }
    }

    public static com.metamatrix.query.o.f.d createVirtualProcCommmandForCommand(l command) {
        com.metamatrix.query.o.f.c cmdStmt;
        com.metamatrix.query.o.f.e block = new com.metamatrix.query.o.f.e();
        if (command.gm() == 6) {
            if (command.gf().size() > 0) {
                com.metamatrix.query.o.j.b subquery = new com.metamatrix.query.o.j.b("PROC", command);
                j from = new j();
                from.f1((al)subquery);
                s select = new s();
                select.kp((b)new q());
                ag query = new ag(select, from, null, null, null);
                query.gi(true);
                block.l(new com.metamatrix.query.o.f.c((l)query));
            } else {
                cmdStmt = new com.metamatrix.query.o.f.c(command);
                block.l(cmdStmt);
                s select = new s();
                select.kp((b)new d("RESULT", (com.metamatrix.query.o.i.j)new n("RESULT", (com.metamatrix.query.o.i.s)new c(Boolean.TRUE))));
                ag query = new ag(select, null, null, null, null);
                query.gi(true);
                block.l(new com.metamatrix.query.o.f.c((l)query));
            }
        } else {
            cmdStmt = new com.metamatrix.query.o.f.c(command);
            block.l(cmdStmt);
        }
        com.metamatrix.query.o.f.d cCommand = new com.metamatrix.query.o.f.d(block);
        cCommand.g3(false);
        return cCommand;
    }

    private static ag createQueryAddSqlAliasGroupElemsToSelect(ag resolvedQuery, List addedSqlAliasGroups) {
        ag result = null;
        if (!TransformationSqlHelper.isSelectStar(resolvedQuery.js())) {
            result = (ag)((Object)resolvedQuery.clone());
            s select = resolvedQuery.js();
            List currentSelectSymbols = select.ky();
            List newElementSymbols = TransformationSqlHelper.createElemSymbols(addedSqlAliasGroups);
            ArrayList selectSymbols = new ArrayList();
            selectSymbols.addAll(currentSelectSymbols);
            selectSymbols.addAll(newElementSymbols);
            List newSelectSymbols = TransformationSqlHelper.renameConflictingSymbols(selectSymbols);
            if (newSelectSymbols.size() == 0) {
                newSelectSymbols.add(new q());
                select.km(newSelectSymbols);
            } else {
                select.km(newSelectSymbols);
            }
            result.jv(select);
        }
        return result;
    }

    private static ag createQueryAddSqlAliasGroupsToFrom(ag resolvedQuery, List sqlAliasGroups) {
        ag result = null;
        if (resolvedQuery != null && sqlAliasGroups != null) {
            result = (ag)((Object)resolvedQuery.clone());
            j from = resolvedQuery.jy();
            j newFrom = from != null ? (j)from.clone() : new j();
            ArrayList currentGroupSymbols = new ArrayList();
            com.metamatrix.query.o.h.d.eh((com.metamatrix.query.o.d)resolvedQuery, currentGroupSymbols);
            List clausesToAdd = TransformationSqlHelper.createFromClauses(sqlAliasGroups);
            Iterator iter = clausesToAdd.iterator();
            while (iter.hasNext()) {
                al nextFromClause = (al)iter.next();
                if (TransformationSqlHelper.fromClauseExistsInFrom(newFrom, nextFromClause)) continue;
                newFrom.f1(nextFromClause);
            }
            result.jm(newFrom);
        }
        return result;
    }

    private static ag createQueryAddGroupsToFrom(ag query, List grpEObjs) {
        ag result = null;
        if (query != null && grpEObjs != null) {
            result = (ag)((Object)query.clone());
            j from = query.jy();
            j newFrom = from != null ? (j)from.clone() : new j();
            for (int i2 = 0; i2 < grpEObjs.size(); ++i2) {
                EObject grpEObj = (EObject)grpEObjs.get(i2);
                al fClause = TransformationSqlHelper.createFromClause(grpEObj);
                newFrom.f1(fClause);
            }
            result.jm(newFrom);
        }
        return result;
    }

    private static ag createQueryAddSqlAliasGroups(ag resolvedQuery, List sqlAliasGroups, boolean addGroupElemsToSelect, int cmdType, TransformationValidator validator) {
        ag result = null;
        if (resolvedQuery != null && sqlAliasGroups != null) {
            SqlTransformationResult resolverResult;
            result = TransformationSqlHelper.createQueryAddSqlAliasGroupsToFrom(resolvedQuery, sqlAliasGroups);
            SqlTransformationResult parserResult = TransformationValidator.parseSQL(result.toString());
            ag resultQuery = (ag)parserResult.getCommand();
            boolean isResolvable = false;
            boolean isValid = false;
            if (resultQuery != null && (isResolvable = (resolverResult = validator.resolveCommand((l)resultQuery, cmdType)).isResolvable())) {
                SqlTransformationResult validationResult = validator.validateCommand((l)resultQuery);
                isValid = validationResult.isValidatable();
            }
            if (isValid) {
                s select = resultQuery.js();
                result = TransformationSqlHelper.isSelectStar(select) ? TransformationSqlHelper.createQueryFixNameConflicts(resultQuery) : (addGroupElemsToSelect ? TransformationSqlHelper.createQueryAddSqlAliasGroupElemsToSelect(resultQuery, sqlAliasGroups) : resultQuery);
            }
        }
        return result;
    }

    private static r createSetQueryAddUnionSources(ar queryCommand, List unionSourceGrps, boolean useAll) {
        r result = null;
        if (queryCommand != null) {
            if (queryCommand instanceof ag) {
                result = new r(0);
                result.je((ag)((Object)queryCommand.clone()));
            } else if (queryCommand instanceof r) {
                result = (r)((Object)queryCommand.clone());
            }
            Iterator iter = unionSourceGrps.iterator();
            while (iter.hasNext()) {
                EObject sourceGroup = (EObject)iter.next();
                ag qry = TransformationSqlHelper.createDefaultQuery(sourceGroup);
                result.jc(qry, useAll);
            }
        }
        return result;
    }

    private static void removeSqlAliasGroupsFromSelectStatement(EObject transMappingRoot, List sqlAliasGroups, boolean removeElemsFromSelect, Object txnSource, TransformationValidator validator) {
        if (transMappingRoot == null || sqlAliasGroups == null) {
            return;
        }
        if (txnSource == null) {
            txnSource = TransformationSqlHelper.getInstance();
        }
        boolean isValid = SqlMappingRootCache.isSelectValid(transMappingRoot);
        l command = SqlMappingRootCache.getSelectCommand(transMappingRoot);
        if (isValid && command instanceof ag) {
            ag query = (ag)command;
            ag newQuery = TransformationSqlHelper.createQueryRemoveSqlAliasGroups(query, sqlAliasGroups, removeElemsFromSelect, 0, validator);
            TransformationHelper.setSelectSqlString(transMappingRoot, newQuery.toString(), false, txnSource);
        } else {
            TransformationSqlHelper.rebuildQueryRemovingSqlAliasGroups(transMappingRoot, sqlAliasGroups);
        }
    }

    private static void removeElementsFromStatement(EObject transMappingRoot, List elementEObjs, Object txnSource) {
        ag query;
        ag newQuery;
        if (transMappingRoot == null || elementEObjs == null) {
            return;
        }
        if (txnSource == null) {
            txnSource = TransformationSqlHelper.getInstance();
        }
        boolean isValid = SqlMappingRootCache.isSelectValid(transMappingRoot);
        l command = SqlMappingRootCache.getSelectCommand(transMappingRoot);
        if (isValid && command instanceof ag && (newQuery = TransformationSqlHelper.createQueryRemoveElems(query = (ag)command, elementEObjs)) != null) {
            TransformationHelper.setSelectSqlString(transMappingRoot, newQuery.toString(), false, txnSource);
        }
    }

    private static void rebuildQueryRemovingSqlAliasGroups(EObject transMappingRoot, List sqlAliasGroups) {
        if (transMappingRoot == null || sqlAliasGroups == null) {
            return;
        }
    }

    private static ag createQueryRemoveSqlAliasGroupElemsFromSelect(ag resolvedQuery, List removeSqlAliasGroups) {
        ag result = null;
        if (TransformationSqlHelper.hasSqlAliasGroupAttributes(resolvedQuery, removeSqlAliasGroups)) {
            result = (ag)((Object)resolvedQuery.clone());
            List aliasGroupSymbols = TransformationSqlHelper.createGroupSymbols(removeSqlAliasGroups);
            s select = resolvedQuery.js();
            List currentSelectSymbols = select.ky();
            ArrayList<Object> newSelectSymbols = new ArrayList<Object>(currentSelectSymbols.size());
            Iterator iter = currentSelectSymbols.iterator();
            while (iter.hasNext()) {
                b selectSymbol = (b)iter.next();
                Collection symbolGroups = aa.ha((com.metamatrix.query.o.d)selectSymbol);
                Iterator symbolGroupIter = symbolGroups.iterator();
                boolean removeSymbol = false;
                while (symbolGroupIter.hasNext()) {
                    f symbGroup = (f)symbolGroupIter.next();
                    Iterator removeGroupIter = aliasGroupSymbols.iterator();
                    while (removeGroupIter.hasNext()) {
                        f removeGroupSymbol = (f)removeGroupIter.next();
                        if (!symbGroup.equals((Object)removeGroupSymbol)) continue;
                        removeSymbol = true;
                        break;
                    }
                    if (!removeSymbol) continue;
                    break;
                }
                if (removeSymbol) continue;
                newSelectSymbols.add(selectSymbol);
            }
            if (newSelectSymbols.size() == 0) {
                newSelectSymbols.add(new q());
                select.km(newSelectSymbols);
            } else {
                select.km(newSelectSymbols);
            }
            result.jv(select);
        }
        return result;
    }

    protected static ag createQueryRemoveElems(ag resolvedQuery, List removeElements) {
        ag result = resolvedQuery;
        ArrayList<String> removeNames = new ArrayList<String>(removeElements.size());
        Iterator iter = removeElements.iterator();
        while (iter.hasNext()) {
            Object remElem = iter.next();
            if (!(remElem instanceof EObject) || !SqlAspectHelper.isColumn((EObject)((EObject)remElem))) continue;
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)((EObject)remElem));
            removeNames.add(columnAspect.getName((EObject)remElem));
        }
        if (TransformationSqlHelper.hasSqlElemSymbols(resolvedQuery, removeElements)) {
            result = (ag)((Object)resolvedQuery.clone());
            s select = resolvedQuery.js();
            List currentSelectSymbols = resolvedQuery.gf();
            List newSelectSymbols = TransformationSqlHelper.removeSymbols(currentSelectSymbols, removeNames);
            select.km(newSelectSymbols);
            result.jv(select);
        }
        if (result.jp() != null) {
            am groupBy = result.jp();
            List currentGroupBySymbols = groupBy.k1();
            List newGroupBySymbols = TransformationSqlHelper.removeSymbols(currentGroupBySymbols, removeNames);
            groupBy.k5(newGroupBySymbols);
            if (groupBy.k0() == 0) {
                result.jt(null);
            } else {
                result.jt(groupBy);
            }
        }
        if (result.i8() != null) {
            h orderBy = result.i8();
            Iterator iter2 = orderBy.fn().iterator();
            while (iter2.hasNext()) {
                com.metamatrix.query.o.i.j seSymbol;
                String name;
                Object next = iter2.next();
                if (!(next instanceof com.metamatrix.query.o.i.j) || !removeNames.contains(name = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol = (com.metamatrix.query.o.i.j)next, false))) continue;
                iter2.remove();
            }
            if (orderBy.fp() == 0) {
                result.jb(null);
            } else {
                result.jb(orderBy);
            }
        }
        return result;
    }

    private static List removeSymbols(List currentSymbols, List symbolNamesToRemove) {
        if (currentSymbols == null || symbolNamesToRemove == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<com.metamatrix.query.o.i.j> result = new ArrayList<com.metamatrix.query.o.i.j>(currentSymbols.size());
        Iterator iter = currentSymbols.iterator();
        while (iter.hasNext()) {
            com.metamatrix.query.o.i.j seSymbol;
            String symName;
            Object next = iter.next();
            if (!(next instanceof com.metamatrix.query.o.i.j) || symbolNamesToRemove.contains(symName = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol = (com.metamatrix.query.o.i.j)next, false))) continue;
            result.add(seSymbol);
        }
        return result;
    }

    private static ag createQueryRemoveSqlAliasGroupsFromFrom(ag resolvedQuery, List removedSqlAliasGrps) {
        ag result = null;
        if (resolvedQuery != null) {
            result = (ag)((Object)resolvedQuery.clone());
            j from = resolvedQuery.jy();
            List currentFromClauses = from.fy();
            ArrayList<al> newFromClauses = new ArrayList<al>(currentFromClauses.size());
            Iterator iter = currentFromClauses.iterator();
            while (iter.hasNext()) {
                al fromClause = (al)iter.next();
                boolean removeIt = false;
                Iterator removeSqlAliasGrpIter = removedSqlAliasGrps.iterator();
                while (removeSqlAliasGrpIter.hasNext()) {
                    EObject removeGroupEObj = (EObject)removeSqlAliasGrpIter.next();
                    if (fromClause instanceof p) {
                        f gSymbol = ((p)fromClause).cu();
                        f removeGroupSymbol = TransformationSqlHelper.createGroupSymbol(removeGroupEObj);
                        if (gSymbol == null || !gSymbol.equals((Object)removeGroupSymbol)) continue;
                        removeIt = true;
                        break;
                    }
                    if (!(fromClause instanceof com.metamatrix.query.o.j.b)) continue;
                    com.metamatrix.query.o.j.b sqf = (com.metamatrix.query.o.j.b)fromClause;
                    if (!(removeGroupEObj instanceof SqlAlias) || !TransformationSqlHelper.isMatch(sqf, (SqlAlias)removeGroupEObj)) continue;
                    removeIt = true;
                    break;
                }
                if (removeIt) continue;
                newFromClauses.add(fromClause);
            }
            from.fz(newFromClauses);
            result.jm(from);
        }
        return result;
    }

    public static boolean fromClauseExistsInFrom(j theFrom, al theFromClause) {
        boolean exists = false;
        f theGroupSymbol = null;
        if (theFromClause != null) {
            if (theFromClause instanceof p) {
                theGroupSymbol = ((p)theFromClause).cu();
            } else if (theFromClause instanceof com.metamatrix.query.o.j.b) {
                theGroupSymbol = ((com.metamatrix.query.o.j.b)theFromClause).c4();
            }
        }
        if (theFrom != null && theGroupSymbol != null) {
            List currentFromClauses = theFrom.fy();
            Iterator iter = currentFromClauses.iterator();
            while (iter.hasNext()) {
                al nextFromClause = (al)iter.next();
                f nextGroupSymbol = null;
                if (nextFromClause instanceof p) {
                    nextGroupSymbol = ((p)nextFromClause).cu();
                } else if (nextFromClause instanceof com.metamatrix.query.o.j.b) {
                    nextGroupSymbol = ((com.metamatrix.query.o.j.b)nextFromClause).c4();
                }
                if (!theGroupSymbol.equals((Object)nextGroupSymbol)) continue;
                exists = true;
                break;
            }
        }
        return exists;
    }

    public static boolean isMatch(com.metamatrix.query.o.j.b subqueryFrom, SqlAlias sqlAlias) {
        boolean isMatch = false;
        if (subqueryFrom != null && sqlAlias != null) {
            l fromClauseQuery = subqueryFrom.n();
            String fromClauseName = subqueryFrom.c6();
            if (fromClauseQuery instanceof x) {
                x fromClauseProc = (x)fromClauseQuery;
                String fromClauseProcName = fromClauseProc.h5();
                String sqlAliasName = sqlAlias.getAlias();
                EObject sqlAliasEObj = sqlAlias.getAliasedObject();
                if (fromClauseName != null && fromClauseName.equalsIgnoreCase(sqlAliasName) && TransformationHelper.isSqlProcedure(sqlAliasEObj)) {
                    com.metamatrix.query.m.a procInfo = TransformationSqlHelper.getProcInfo(TransformationHelper.getSqlEObjectFullName(sqlAliasEObj), sqlAliasEObj);
                    String sqlAliasProcName = procInfo.b();
                    if (fromClauseProcName != null && fromClauseProcName.equalsIgnoreCase(sqlAliasProcName)) {
                        isMatch = true;
                    }
                }
            }
        }
        return isMatch;
    }

    public static boolean isMatch(x storedProc, SqlAlias sqlAlias) {
        boolean isMatch = false;
        if (storedProc != null && sqlAlias != null) {
            com.metamatrix.query.m.a procInfo;
            String sqlAliasProcName;
            String procName = storedProc.h5();
            String sqlAliasName = sqlAlias.getAlias();
            EObject sqlAliasEObj = sqlAlias.getAliasedObject();
            if (procName != null && procName.equalsIgnoreCase(sqlAliasName) && TransformationHelper.isSqlProcedure(sqlAliasEObj) && procName.equalsIgnoreCase(sqlAliasProcName = (procInfo = TransformationSqlHelper.getProcInfo(TransformationHelper.getSqlEObjectFullName(sqlAliasEObj), sqlAliasEObj)).b())) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    private static ag createQueryRemoveSqlAliasGroups(ag resolvedQuery, List sqlAliasGroups, boolean removeGroupElemsFromSelect, int cmdType, TransformationValidator validator) {
        ag result = null;
        if (resolvedQuery != null && sqlAliasGroups != null) {
            if (!TransformationSqlHelper.isSelectStar(resolvedQuery.js()) && TransformationSqlHelper.hasSqlAliasGroupAttributes(resolvedQuery, sqlAliasGroups)) {
                result = removeGroupElemsFromSelect ? TransformationSqlHelper.createQueryRemoveSqlAliasGroupElemsFromSelect(resolvedQuery, sqlAliasGroups) : resolvedQuery;
            }
            ag resultQuery = null;
            boolean isValid = false;
            if (result != null) {
                SqlTransformationResult resolverResult;
                SqlTransformationResult parserResult = TransformationValidator.parseSQL(result.toString());
                resultQuery = (ag)parserResult.getCommand();
                boolean isResolvable = false;
                if (result != null && (isResolvable = (resolverResult = validator.resolveCommand((l)resultQuery, cmdType)).isResolvable())) {
                    SqlTransformationResult validationResult = validator.validateCommand((l)resultQuery);
                    isValid = validationResult.isValidatable();
                }
            } else {
                resultQuery = resolvedQuery;
                isValid = true;
            }
            if (isValid) {
                result = TransformationSqlHelper.createQueryRemoveSqlAliasGroupsFromFrom(resolvedQuery, sqlAliasGroups);
            }
        }
        return result;
    }

    public static ag createQueryFixNameConflicts(ag resolvedQuery) {
        ag modifiedQuery = null;
        if (resolvedQuery != null) {
            modifiedQuery = (ag)((Object)resolvedQuery.clone());
            if (TransformationSqlHelper.hasProjectedSymbolNameConflict((l)resolvedQuery)) {
                List currentSymbols = resolvedQuery.js().ky();
                List newSymbols = TransformationSqlHelper.renameConflictingSymbols(currentSymbols);
                s newSelect = new s(newSymbols);
                modifiedQuery.jv(newSelect);
            }
        }
        return modifiedQuery;
    }

    public static ag createDefaultQuery(EObject source) {
        al clause;
        s newSelect = new s();
        newSelect.kp((b)new q());
        j newFrom = new j();
        if (source != null && (clause = TransformationSqlHelper.createFromClause(source)) != null) {
            newFrom.f1(clause);
        }
        ag query = new ag();
        query.jv(newSelect);
        query.jm(newFrom);
        return query;
    }

    public static boolean hasProjectedSymbolNameConflict(l command) {
        boolean hasConflict = false;
        if (command != null) {
            ArrayList<String> attrNames = new ArrayList<String>();
            List symbols = command.gf();
            Iterator symbolIter = symbols.iterator();
            while (symbolIter.hasNext()) {
                com.metamatrix.query.o.i.j seSymbol = (com.metamatrix.query.o.i.j)symbolIter.next();
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol, false);
                String uniqueName = TransformationSqlHelper.getUniqueName(name, attrNames);
                if (!uniqueName.equals(name)) {
                    hasConflict = true;
                    break;
                }
                attrNames.add(uniqueName);
            }
        }
        return hasConflict;
    }

    public static List getProjectedSymbolNames(l command) {
        if (command == null) {
            return Collections.EMPTY_LIST;
        }
        List projectedSymbols = command.gf();
        ArrayList<String> symbolNames = null;
        if (projectedSymbols == null || projectedSymbols.isEmpty()) {
            symbolNames = Collections.EMPTY_LIST;
        } else {
            symbolNames = new ArrayList<String>(projectedSymbols.size());
            Iterator symbolIter = projectedSymbols.iterator();
            while (symbolIter.hasNext()) {
                com.metamatrix.query.o.i.j symbol = (com.metamatrix.query.o.i.j)symbolIter.next();
                String shortName = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                if (shortName == null) continue;
                symbolNames.add(shortName);
            }
        }
        return symbolNames;
    }

    public static String getSingleElementSymbolShortName(com.metamatrix.query.o.i.j symbol, boolean showExpression) {
        String symbolName = "";
        if (symbol != null) {
            if (symbol instanceof n) {
                com.metamatrix.query.o.i.s expr = ((n)symbol).a6();
                if (expr instanceof e) {
                    e func = (e)expr;
                    if (func.bv()) {
                        Collection elementSymbols = k.fb((com.metamatrix.query.o.d)func, true);
                        if (elementSymbols.size() == 1) {
                            a element = (a)elementSymbols.iterator().next();
                            symbolName = element.a3();
                        } else {
                            symbolName = showExpression ? symbol.toString() : symbol.a3();
                        }
                    } else {
                        symbolName = showExpression ? symbol.toString() : symbol.a3();
                    }
                } else {
                    symbolName = showExpression ? symbol.toString() : symbol.a3();
                }
            } else {
                symbolName = symbol.a3();
            }
        }
        return symbolName;
    }

    public static List getProjectedSymbolUniqueNames(l command) {
        ArrayList<String> uniqueNames = new ArrayList<String>();
        List selectNames = TransformationSqlHelper.getProjectedSymbolNames(command);
        Iterator iter = selectNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!uniqueNames.contains(name)) {
                uniqueNames.add(name);
                continue;
            }
            String uniqueName = TransformationSqlHelper.getUniqueName(name, uniqueNames);
            uniqueNames.add(uniqueName);
        }
        return uniqueNames;
    }

    public static List getProjectedSymbolAndProcInputUniqueNames(l command) {
        List uniqueNames = TransformationSqlHelper.getProjectedSymbolUniqueNames(command);
        List paramNames = TransformationSqlHelper.getProcedureInputParamNames(command);
        uniqueNames.addAll(paramNames);
        return uniqueNames;
    }

    public static List getProcedureInputParamNames(l command) {
        List params = TransformationSqlHelper.getProcedureInputParams(command);
        ArrayList<String> result = new ArrayList<String>(params.size());
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            ao param = (ao)iter.next();
            String paramName = null;
            if (param.s() == null) {
                paramName = param.r() != null ? param.r() : "?";
            } else {
                com.metamatrix.query.o.i.s exp = param.s();
                if (exp instanceof a) {
                    paramName = ((a)exp).a3();
                }
            }
            if (paramName == null || TransformationSqlHelper.containsIgnoreCase(result, paramName)) continue;
            result.add(paramName);
        }
        return result;
    }

    private static boolean containsIgnoreCase(List strList, String str) {
        boolean contains = false;
        Iterator iter = strList.iterator();
        while (iter.hasNext()) {
            String listStr = (String)iter.next();
            if (listStr == null || !listStr.equalsIgnoreCase(str)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static List getProcedureInputParams(l command) {
        if (command == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ao> inputParams = new ArrayList<ao>();
        if (command instanceof x) {
            List procInParams = ((x)command).ii();
            inputParams.addAll(procInParams);
        }
        List commands = com.metamatrix.query.o.h.c.ee((com.metamatrix.query.o.d)command);
        Iterator iter = commands.iterator();
        while (iter.hasNext()) {
            l currentCommand = (l)iter.next();
            if (!(currentCommand instanceof x)) continue;
            List params = ((x)currentCommand).ii();
            Iterator pIter = params.iterator();
            while (pIter.hasNext()) {
                ao parm = (ao)pIter.next();
                if (TransformationSqlHelper.spParamListContains(inputParams, parm)) continue;
                inputParams.add(parm);
            }
        }
        return inputParams;
    }

    private static boolean spParamListContains(List spParams, ao newParam) {
        boolean containsParam = false;
        if (spParams != null) {
            Iterator iter = spParams.iterator();
            while (iter.hasNext()) {
                ao param = (ao)iter.next();
                if (!param.equals(newParam)) continue;
                Object id1 = param.j();
                Object id2 = newParam.j();
                if (id1 == null || !id1.equals(id2)) continue;
                containsParam = true;
            }
        }
        return containsParam;
    }

    public static Map getProcInputParamEObjects(x storedProc) {
        HashMap<String, EObject> symbolEObjMap = new HashMap<String, EObject>();
        if (storedProc != null) {
            List inputParams = storedProc.ii();
            Iterator iter = inputParams.iterator();
            while (iter.hasNext()) {
                ao param = (ao)iter.next();
                a symbol = param.w();
                String name = symbol.a3();
                EObject eObj = TransformationSqlHelper.getElementSymbolEObject(symbol);
                if (eObj == null) continue;
                symbolEObjMap.put(name, eObj);
            }
        }
        return symbolEObjMap;
    }

    public static String getUniqueName(String name, Collection collection) {
        if (collection == null) {
            collection = Collections.EMPTY_SET;
        }
        String result = name;
        int incr = 1;
        boolean nameIsInCollection = false;
        block0: do {
            nameIsInCollection = false;
            Iterator i2 = collection.iterator();
            while (i2.hasNext()) {
                if (!result.equalsIgnoreCase((String)i2.next())) continue;
                nameIsInCollection = true;
                result = name + "_" + incr;
                ++incr;
                continue block0;
            }
        } while (nameIsInCollection);
        return result;
    }

    public static Map getProjectedSymbolUniqueTypes(l command) {
        if (command != null) {
            HashMap<String, Object> symbolTypeMap = new HashMap<String, Object>();
            List symbols = command.gf();
            Iterator symbolIter = symbols.iterator();
            while (symbolIter.hasNext()) {
                com.metamatrix.query.o.i.j symbol = (com.metamatrix.query.o.i.j)symbolIter.next();
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                Object typeObj = TransformationSqlHelper.getElementSymbolType(symbol);
                Set currentNames = symbolTypeMap.size() != 0 ? symbolTypeMap.keySet() : Collections.EMPTY_SET;
                String uniqueName = TransformationSqlHelper.getUniqueName(name, currentNames);
                symbolTypeMap.put(uniqueName, typeObj);
            }
            return symbolTypeMap;
        }
        return Collections.EMPTY_MAP;
    }

    public static Map getProjectedSymbolAndProcInputUniqueTypes(l command) {
        if (command != null) {
            Map symbolTypeMap = TransformationSqlHelper.getProjectedSymbolUniqueTypes(command);
            List inputParams = TransformationSqlHelper.getProcedureInputParams(command);
            Iterator iter = inputParams.iterator();
            while (iter.hasNext()) {
                ao param = (ao)iter.next();
                a symbol = param.w();
                String name = symbol.a3();
                Object eObj = TransformationSqlHelper.getElementSymbolType((com.metamatrix.query.o.i.j)symbol);
                symbolTypeMap.put(name, eObj);
            }
            return symbolTypeMap;
        }
        return Collections.EMPTY_MAP;
    }

    public static Map getProjectedSymbolEObjects(l command) {
        HashMap<String, EObject> symbolEObjMap = new HashMap<String, EObject>();
        if (command != null) {
            List symbols = command.gf();
            Iterator symbolIter = symbols.iterator();
            while (symbolIter.hasNext()) {
                com.metamatrix.query.o.i.j symbol = (com.metamatrix.query.o.i.j)symbolIter.next();
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                EObject eObj = null;
                if (symbol instanceof a) {
                    eObj = TransformationSqlHelper.getElementSymbolEObject((a)symbol);
                }
                Set currentNames = symbolEObjMap.size() != 0 ? symbolEObjMap.keySet() : Collections.EMPTY_SET;
                String uniqueName = TransformationSqlHelper.getUniqueName(name, currentNames);
                if (eObj == null) continue;
                symbolEObjMap.put(uniqueName, eObj);
            }
        }
        return symbolEObjMap;
    }

    public static Map getProjectedSymbolAndProcInputEObjects(l command) {
        Map projectedSymbolEObjMap = TransformationSqlHelper.getProjectedSymbolEObjects(command);
        if (command != null) {
            List inputParams = TransformationSqlHelper.getProcedureInputParams(command);
            Iterator iter = inputParams.iterator();
            while (iter.hasNext()) {
                ao param = (ao)iter.next();
                a symbol = param.w();
                String name = symbol.a3();
                EObject eObj = TransformationSqlHelper.getElementSymbolEObject(symbol);
                if (eObj == null) continue;
                projectedSymbolEObjMap.put(name, eObj);
            }
        }
        return projectedSymbolEObjMap;
    }

    public static Map getProjectedSymbolLengths(l command, boolean hasXMLDocSource) {
        HashMap symbolLengthMap = new HashMap();
        if (command != null) {
            List symbols = command.gf();
            Iterator symbolIter = symbols.iterator();
            while (symbolIter.hasNext()) {
                com.metamatrix.query.o.i.j symbol = (com.metamatrix.query.o.i.j)symbolIter.next();
                String name = TransformationSqlHelper.getSingleElementSymbolShortName(symbol, false);
                Object typeObj = TransformationSqlHelper.getElementSymbolType(symbol);
                boolean xmlDocSourceCase = hasXMLDocSource && command instanceof com.metamatrix.query.o.f.d;
                Set currentNames = symbolLengthMap.size() != 0 ? symbolLengthMap.keySet() : Collections.EMPTY_SET;
                String uniqueName = TransformationSqlHelper.getUniqueName(name, currentNames);
                TransformationSqlHelper.updateTypeLengthMap(symbolLengthMap, uniqueName, typeObj, symbol, xmlDocSourceCase);
            }
        }
        return symbolLengthMap;
    }

    public static Map getProjectedSymbolAndProcInputLengths(l command, boolean hasXMLDocSource) {
        Map symbolLengthMap = TransformationSqlHelper.getProjectedSymbolLengths(command, hasXMLDocSource);
        if (command != null) {
            List inputParams = TransformationSqlHelper.getProcedureInputParams(command);
            Iterator paramIter = inputParams.iterator();
            while (paramIter.hasNext()) {
                ao param = (ao)paramIter.next();
                a symbol = param.w();
                String name = symbol.a3();
                Object typeObj = TransformationSqlHelper.getElementSymbolType((com.metamatrix.query.o.i.j)symbol);
                boolean xmlDocSourceCase = hasXMLDocSource && command instanceof com.metamatrix.query.o.f.d;
                TransformationSqlHelper.updateTypeLengthMap(symbolLengthMap, name, typeObj, (com.metamatrix.query.o.i.j)symbol, xmlDocSourceCase);
            }
        }
        return symbolLengthMap;
    }

    private static void updateTypeLengthMap(Map theMap, String name, Object typeObj, com.metamatrix.query.o.i.j symbol, boolean xmlDocSourceCase) {
        if (typeObj != null && typeObj instanceof XSDSimpleTypeDefinition) {
            String dtName = ((XSDSimpleTypeDefinition)typeObj).getName();
            if (("string".equals(dtName) || "char".equals(dtName)) && ModelerCore.getWorkspaceDatatypeManager().isBuiltInDatatype((EObject)((XSDSimpleTypeDefinition)typeObj))) {
                int length = TransformationSqlHelper.getElementSymbolLength(symbol);
                theMap.put(name, new Integer(length));
            } else {
                theMap.put(name, new Integer(-1));
            }
        } else if (typeObj != null) {
            if (typeObj instanceof Class) {
                if (xmlDocSourceCase) {
                    theMap.put(name, new Integer(Integer.MAX_VALUE));
                } else {
                    String className = ((Class)typeObj).getName();
                    if (className.equalsIgnoreCase("java.lang.String")) {
                        int stringLength = TransformationSqlHelper.getSymbolLength(symbol);
                        if (stringLength > 0) {
                            theMap.put(name, new Integer(stringLength));
                        } else {
                            theMap.put(name, new Integer(ModelerCore.getTransformationPreferences().getDefaultStringLength()));
                        }
                    } else if (className.equalsIgnoreCase("java.lang.Character")) {
                        theMap.put(name, new Integer(1));
                    } else {
                        theMap.put(name, new Integer(-1));
                    }
                }
            }
        } else {
            theMap.put(name, new Integer(-1));
        }
    }

    private static e isStringFunction(com.metamatrix.query.o.i.j symbol) {
        n expressionSymbol = null;
        e function = null;
        if (symbol instanceof d && ((d)symbol).a4() instanceof n) {
            expressionSymbol = (n)((d)symbol).a4();
        } else if (symbol instanceof n) {
            expressionSymbol = (n)symbol;
        }
        if (expressionSymbol != null && expressionSymbol.a6() instanceof e) {
            function = (e)expressionSymbol.a6();
            if (function.bx().equalsIgnoreCase("CONCAT") || function.bx().equalsIgnoreCase("||")) {
                return function;
            }
            if (TransformationSqlHelper.isDecodeOrSubString(function)) {
                return function;
            }
            return null;
        }
        return function;
    }

    private static boolean isDecodeOrSubString(e function) {
        return function.bx().equalsIgnoreCase("decodestring") || function.bx().equalsIgnoreCase("substring");
    }

    private static int concatSymbolLength(com.metamatrix.query.o.i.s exprObject) {
        com.metamatrix.query.o.i.s[] args = null;
        a elSymbol = null;
        int stringLength = 0;
        if (exprObject instanceof e) {
            e myFunc = (e)exprObject;
            if (TransformationSqlHelper.isDecodeOrSubString(myFunc)) {
                return stringLength += TransformationSqlHelper.getMaxStringLength(myFunc);
            }
            if (myFunc.bx().equalsIgnoreCase("chr")) {
                return ++stringLength;
            }
            args = myFunc.bz();
            for (int i2 = 0; i2 < args.length; ++i2) {
                com.metamatrix.query.o.i.s symbol = args[i2];
                if (symbol instanceof e) {
                    stringLength += TransformationSqlHelper.concatSymbolLength(symbol);
                }
                if (symbol instanceof a && (elSymbol = (a)symbol) != null) {
                    Object mID = elSymbol.bf();
                    if (mID != null && mID instanceof ColumnRecord) {
                        int length = ((ColumnRecord)mID).getLength();
                        stringLength += length;
                    } else if (mID != null && mID instanceof ProcedureParameterRecord) {
                        int length = ((ProcedureParameterRecord)mID).getLength();
                        stringLength += length;
                    } else {
                        stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength();
                    }
                }
                if (!(symbol instanceof c)) continue;
                c constant = (c)args[i2];
                Object value = constant.bp();
                if (value != null && value instanceof String) {
                    stringLength += ((String)value).length();
                    continue;
                }
                stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength();
            }
        } else if (exprObject instanceof a) {
            elSymbol = (a)exprObject;
            if (elSymbol != null) {
                Object mID = elSymbol.bf();
                if (mID != null && mID instanceof ColumnRecord) {
                    int length = ((ColumnRecord)mID).getLength();
                    stringLength += length;
                } else if (mID != null && mID instanceof ProcedureParameterRecord) {
                    int length = ((ProcedureParameterRecord)mID).getLength();
                    stringLength += length;
                } else {
                    stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength();
                }
            }
        } else if (exprObject instanceof c) {
            c constant = (c)exprObject;
            Object value = constant.bp();
            stringLength = value != null && value instanceof String ? (stringLength += ((String)value).length()) : (stringLength += ModelerCore.getTransformationPreferences().getDefaultStringLength());
        }
        return stringLength += 0;
    }

    public static int getSymbolLength(com.metamatrix.query.o.i.j symbol) {
        int stringLength = 0;
        e function = null;
        function = TransformationSqlHelper.isStringFunction(symbol);
        if (function != null) {
            if (!TransformationSqlHelper.isDecodeOrSubString(function)) {
                com.metamatrix.query.o.i.s[] args = function.bz();
                a elSymbol = null;
                for (int i2 = 0; i2 < args.length; ++i2) {
                    c constant;
                    com.metamatrix.query.o.i.s exprSymbol = args[i2];
                    if (exprSymbol instanceof e) {
                        stringLength += TransformationSqlHelper.concatSymbolLength(exprSymbol);
                    }
                    if (exprSymbol instanceof a && (elSymbol = (a)exprSymbol) != null) {
                        stringLength += TransformationSqlHelper.concatSymbolLength((com.metamatrix.query.o.i.s)elSymbol);
                    }
                    if (!(exprSymbol instanceof c) || (constant = (c)exprSymbol) == null) continue;
                    stringLength += TransformationSqlHelper.concatSymbolLength(constant);
                }
            } else if (TransformationSqlHelper.isDecodeOrSubString(function)) {
                stringLength += TransformationSqlHelper.getMaxStringLength(function);
            }
        } else {
            stringLength += 0;
        }
        return stringLength;
    }

    private static int getMaxStringLength(e function) {
        com.metamatrix.query.o.i.s[] args = function.bz();
        com.metamatrix.query.o.i.s exprSymbol = args[0];
        if (function.bx().equalsIgnoreCase("decodestring")) {
            return TransformationSqlHelper.getDecodeLength(function);
        }
        return TransformationSqlHelper.concatSymbolLength(exprSymbol);
    }

    private static int getDecodeLength(e function) {
        c constSym;
        Object constObj;
        a elmSymbol;
        com.metamatrix.query.o.i.s[] args = function.bz();
        com.metamatrix.query.o.i.s exprSymbol = null;
        int maxLength = 0;
        exprSymbol = args[0];
        if (exprSymbol instanceof a && (elmSymbol = (a)exprSymbol) != null) {
            int length;
            Object mID = elmSymbol.bf();
            maxLength = mID != null && mID instanceof ColumnRecord ? (length = ((ColumnRecord)mID).getLength()) : (mID != null && mID instanceof ProcedureParameterRecord ? (length = ((ProcedureParameterRecord)mID).getLength()) : ModelerCore.getTransformationPreferences().getDefaultStringLength());
        }
        if ((exprSymbol = args[1]) instanceof c && (constObj = (constSym = (c)exprSymbol).bp()) != null && constObj instanceof String) {
            String decodes = (String)constObj;
            String delimiter = ",";
            if (args.length == 3 && (constObj = (constSym = (c)(exprSymbol = args[2])).bp()) != null && constObj instanceof String) {
                delimiter = (String)constObj;
            }
            StringTokenizer strTok = new StringTokenizer(decodes, delimiter);
            while (strTok.hasMoreTokens()) {
                String word = strTok.nextToken().trim();
                if (word.length() <= maxLength) continue;
                maxLength = word.length();
            }
        }
        return maxLength;
    }

    public static List getProjectedSymbolTypes(l command) {
        ArrayList<Object> selectTypes = new ArrayList<Object>();
        if (command != null) {
            List symbols = command.gf();
            Iterator iter = symbols.iterator();
            while (iter.hasNext()) {
                com.metamatrix.query.o.i.j symbol = (com.metamatrix.query.o.i.j)iter.next();
                selectTypes.add(TransformationSqlHelper.getElementSymbolType(symbol));
            }
        }
        return selectTypes;
    }

    public static Map getRenamedSymbolsMap(List symbols) {
        HashMap<String, com.metamatrix.query.o.i.j> renameMap = new HashMap<String, com.metamatrix.query.o.i.j>();
        ArrayList<Object> seSymbols = new ArrayList<Object>();
        Iterator symbolIter = symbols.iterator();
        while (symbolIter.hasNext()) {
            b sSymbol = (b)symbolIter.next();
            if (sSymbol instanceof i) {
                List meSymbols = ((i)sSymbol).az();
                if (meSymbols == null) continue;
                Iterator meIter = meSymbols.iterator();
                while (meIter.hasNext()) {
                    a eSymbol = (a)meIter.next();
                    if (eSymbol == null) continue;
                    seSymbols.add(eSymbol);
                }
                continue;
            }
            if (!(sSymbol instanceof com.metamatrix.query.o.i.j)) continue;
            seSymbols.add(sSymbol);
        }
        ArrayList<String> elementNames = new ArrayList<String>();
        symbolIter = seSymbols.iterator();
        while (symbolIter.hasNext()) {
            String name;
            com.metamatrix.query.o.i.j seSymbol = (com.metamatrix.query.o.i.j)symbolIter.next();
            String uniqueName = name = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol, false);
            com.metamatrix.query.o.i.j underlyingSymbol = seSymbol;
            if (seSymbol instanceof d) {
                underlyingSymbol = ((d)seSymbol).a4();
            }
            if (underlyingSymbol instanceof a) {
                a eSymbol = (a)underlyingSymbol;
                uniqueName = TransformationSqlHelper.getUniqueName(name, elementNames);
                Object idObj = eSymbol.bf();
                if (idObj != null && idObj instanceof MetadataRecord) {
                    elementNames.add(uniqueName);
                }
            } else if (underlyingSymbol instanceof n) {
                uniqueName = TransformationSqlHelper.getUniqueName(name, elementNames);
                elementNames.add(uniqueName);
            }
            if (uniqueName.equals(name)) continue;
            renameMap.put(uniqueName, seSymbol);
        }
        return renameMap;
    }

    private static List createFromClauses(List sqlAliases) {
        ArrayList<com.metamatrix.query.o.j.d> result = new ArrayList<com.metamatrix.query.o.j.d>(sqlAliases.size());
        Iterator iter = sqlAliases.iterator();
        while (iter.hasNext()) {
            com.metamatrix.query.o.j.b clause;
            SqlAlias sqlAlias = (SqlAlias)iter.next();
            EObject aliasedEObject = sqlAlias.getAliasedObject();
            if (TransformationHelper.isSqlTable(aliasedEObject)) {
                f gSymbol = TransformationSqlHelper.createGroupSymbol((EObject)sqlAlias);
                result.add(new p(gSymbol));
                continue;
            }
            if (!TransformationHelper.isSqlProcedure(aliasedEObject) || (clause = TransformationSqlHelper.createSubqueryFromClause((EObject)sqlAlias)) == null) continue;
            result.add(clause);
        }
        return result;
    }

    private static al createFromClause(EObject eObject) {
        ArgCheck.isNotNull((Object)eObject);
        EObject theEObj = eObject;
        if (eObject instanceof SqlAlias) {
            theEObj = ((SqlAlias)eObject).getAliasedObject();
        }
        com.metamatrix.query.o.j.d fromClause = null;
        if (TransformationHelper.isSqlTable(theEObj)) {
            fromClause = new p(TransformationSqlHelper.createGroupSymbol(eObject));
        } else if (TransformationHelper.isSqlProcedure(theEObj)) {
            fromClause = TransformationSqlHelper.createSubqueryFromClause(eObject);
        }
        return fromClause;
    }

    private static List createGroupSymbols(List groupEObjs) {
        ArrayList<f> result = new ArrayList<f>(groupEObjs.size());
        Iterator iter = groupEObjs.iterator();
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            f gSymbol = TransformationSqlHelper.createGroupSymbol(eObj);
            if (gSymbol == null) continue;
            result.add(gSymbol);
        }
        return result;
    }

    private static com.metamatrix.query.o.j.b createSubqueryFromClause(EObject eObj) {
        x storedProc;
        ArgCheck.isNotNull((Object)eObj);
        com.metamatrix.query.o.j.b subqueryFromClause = null;
        String aliasName = null;
        if (eObj instanceof SqlAlias) {
            SqlAlias sqlAlias = (SqlAlias)eObj;
            aliasName = sqlAlias.getAlias();
            eObj = sqlAlias.getAliasedObject();
        }
        if ((storedProc = TransformationSqlHelper.createStoredProc(eObj)) != null) {
            subqueryFromClause = aliasName != null ? new com.metamatrix.query.o.j.b(aliasName, storedProc) : new com.metamatrix.query.o.j.b("Proc", storedProc);
        }
        return subqueryFromClause;
    }

    public static x createStoredProc(EObject eObj) {
        ArgCheck.isNotNull((Object)eObj);
        x storedProc = null;
        if (eObj instanceof SqlAlias) {
            SqlAlias sqlAlias = (SqlAlias)eObj;
            eObj = sqlAlias.getAliasedObject();
        }
        if (TransformationHelper.isSqlProcedure(eObj)) {
            SqlColumnSetAspect rsAspect;
            List rsCols;
            SqlProcedureAspect procedureAspect = (SqlProcedureAspect)AspectManager.getSqlAspect((EObject)eObj);
            String procFullName = procedureAspect.getFullName(eObj);
            storedProc = new x();
            storedProc.ig(procFullName);
            List procParams = procedureAspect.getParameters(eObj);
            List spParams = TransformationSqlHelper.createSPParams(procParams);
            Iterator iter = spParams.iterator();
            while (iter.hasNext()) {
                storedProc.it((ao)iter.next());
            }
            EObject results = (EObject)procedureAspect.getResult(eObj);
            if (SqlAspectHelper.isProcedureResultSet((EObject)results) && (rsCols = (rsAspect = (SqlColumnSetAspect)SqlAspectHelper.getSqlAspect((EObject)results)).getColumns(results)).size() > 0) {
                ao param = new ao(spParams.size(), 5, "RESULT");
                param.g("RESULT", class$java$lang$String == null ? (class$java$lang$String = TransformationSqlHelper.class$("java.lang.String")) : class$java$lang$String, "RESULT");
                storedProc.it(param);
            }
        }
        return storedProc;
    }

    public static f createGroupSymbol(EObject groupEObj) {
        f gSymbol = null;
        String aliasName = null;
        if (groupEObj instanceof SqlAlias) {
            SqlAlias sqlAlias = (SqlAlias)groupEObj;
            aliasName = sqlAlias.getAlias();
            groupEObj = sqlAlias.getAliasedObject();
        }
        if (SqlAspectHelper.isTable((EObject)groupEObj)) {
            SqlTableAspect tableAspect = (SqlTableAspect)AspectManager.getSqlAspect((EObject)groupEObj);
            boolean hasResource = groupEObj.eResource() != null;
            String tableFullName = tableAspect.getName(groupEObj);
            if (hasResource) {
                tableFullName = tableAspect.getFullName(groupEObj);
            }
            String tableShortName = tableAspect.getName(groupEObj);
            Object groupID = null;
            if (hasResource) {
                groupID = TransformationSqlHelper.getGroupID(tableFullName, groupEObj);
            }
            gSymbol = aliasName != null && !aliasName.equalsIgnoreCase(tableShortName) ? new f(aliasName, tableFullName) : new f(tableFullName);
            if (groupID != null) {
                gSymbol.au(groupID);
            }
        } else if (groupEObj instanceof InputSet) {
            String inputSetFullName = "InputSet";
            String inputSetShortName = "InputSet";
            gSymbol = aliasName != null && !aliasName.equalsIgnoreCase(inputSetShortName) ? new f(aliasName, inputSetFullName) : new f(inputSetFullName);
        }
        return gSymbol;
    }

    private static Object getElementID(String elementFullName, EObject elmntObj) {
        ColumnRecordImpl elemID = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)elmntObj);
        elemID = new ColumnRecordImpl(sqlAspect, elmntObj);
        return elemID;
    }

    private static Object getGroupID(String groupFullName, EObject grpObj) {
        TableRecordImpl groupID = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)grpObj);
        groupID = new TableRecordImpl(sqlAspect, grpObj);
        return groupID;
    }

    private static com.metamatrix.query.m.a getProcInfo(String procFullName, EObject procObj) {
        com.metamatrix.query.m.a procInfo = null;
        try {
            com.metamatrix.query.m.e resolver = TransformationMetadataFactory.getInstance().getModelerMetadata(procObj);
            procInfo = resolver.getStoredProcedureInfoForProcedure(procFullName);
        }
        catch (QueryMetadataException e2) {
            String message = TransformationPlugin.Util.getString("TransformationSqlHelper.groupIDNotFoundError", (Object)procFullName);
            TransformationPlugin.Util.log(2, (Throwable)e2, message);
        }
        catch (MetaMatrixComponentException e3) {
            String message = TransformationPlugin.Util.getString("TransformationSqlHelper.groupIDNotFoundError", (Object)procFullName);
            TransformationPlugin.Util.log(2, (Throwable)e3, message);
        }
        return procInfo;
    }

    private static List createElemSymbols(List sqlAliasGroups) {
        ArrayList result = new ArrayList();
        Iterator iter = sqlAliasGroups.iterator();
        while (iter.hasNext()) {
            SqlAlias groupSqlAlias = (SqlAlias)iter.next();
            result.addAll(TransformationSqlHelper.createElemSymbols(groupSqlAlias));
        }
        return result;
    }

    private static List createElemSymbols(SqlAlias groupSqlAlias) {
        ArrayList<com.metamatrix.query.o.i.j> result = new ArrayList<com.metamatrix.query.o.i.j>();
        f groupSymbol = TransformationSqlHelper.createGroupSymbol((EObject)groupSqlAlias);
        EObject groupEObj = groupSqlAlias.getAliasedObject();
        if (SqlAspectHelper.isTable((EObject)groupEObj)) {
            SqlTableAspect tableAspect = (SqlTableAspect)AspectManager.getSqlAspect((EObject)groupEObj);
            List columns = tableAspect.getColumns(groupEObj);
            Iterator columnIter = columns.iterator();
            com.metamatrix.query.o.i.j seSymbol = null;
            while (columnIter.hasNext()) {
                EObject columnEObj = (EObject)columnIter.next();
                seSymbol = TransformationSqlHelper.createElemSymbol(columnEObj, groupSymbol);
                result.add(seSymbol);
            }
        }
        return result;
    }

    public static com.metamatrix.query.o.i.j createElemSymbol(EObject elemEObj, f parentGroupSymbol) {
        InputParameterSqlAspect aspect;
        a seSymbol = null;
        boolean isUUIDGroup = false;
        String tableName = parentGroupSymbol.ak();
        if (tableName == null) {
            tableName = "";
        } else if (SqlConverter.isStringifiedUUID(tableName)) {
            isUUIDGroup = true;
        }
        String columnAliasName = null;
        if (elemEObj instanceof SqlAlias) {
            SqlAlias columnAlias = (SqlAlias)elemEObj;
            columnAliasName = columnAlias.getAlias();
            elemEObj = columnAlias.getAliasedObject();
        }
        if (TransformationHelper.isSqlInputParameter(elemEObj)) {
            aspect = (InputParameterSqlAspect)AspectManager.getSqlAspect((EObject)elemEObj);
            String fullName = null;
            fullName = isUUIDGroup ? TransformationHelper.getSqlEObjectUUID(elemEObj) : tableName + "." + aspect.getName(elemEObj);
            a element = new a(fullName);
            element.bm(parentGroupSymbol);
            if (aspect != null) {
                String rtType = aspect.getRuntimeType(elemEObj);
                if (rtType != null) {
                    Class clazz = DataTypeManager.getDataTypeClass((String)rtType);
                    element.bb((Object)new com.metamatrix.query.m.d(fullName.toUpperCase(), clazz));
                    element.bh(clazz);
                } else {
                    element.bb((Object)new com.metamatrix.query.m.d(fullName.toUpperCase(), DataTypeManager.DefaultDataClasses.NULL));
                    element.bh(DataTypeManager.DefaultDataClasses.NULL);
                }
            } else {
                element.bb((Object)new com.metamatrix.query.m.d(fullName.toUpperCase(), DataTypeManager.DefaultDataClasses.NULL));
                element.bh(DataTypeManager.DefaultDataClasses.NULL);
            }
            seSymbol = element;
        } else if (SqlAspectHelper.isColumn((EObject)elemEObj)) {
            SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)elemEObj);
            String colShortName = columnAspect.getName(elemEObj);
            String colUUID = TransformationHelper.getSqlEObjectUUID(elemEObj);
            Object elemID = TransformationSqlHelper.getElementID(colUUID, elemEObj);
            if (columnAliasName != null) {
                a elemSymbol = null;
                elemSymbol = isUUIDGroup ? new a(colUUID) : new a(tableName + "." + colShortName);
                elemSymbol.bm(parentGroupSymbol);
                if (elemID != null) {
                    elemSymbol.bb(elemID);
                }
                seSymbol = new d(columnAliasName, (com.metamatrix.query.o.i.j)elemSymbol);
            } else {
                a elemSymbol = null;
                elemSymbol = isUUIDGroup ? new a(colUUID) : new a(tableName + "." + colShortName);
                elemSymbol.bm(parentGroupSymbol);
                if (elemID != null) {
                    elemSymbol.bb(elemID);
                }
                seSymbol = elemSymbol;
            }
        } else if (TransformationHelper.isSqlProcedureParameter(elemEObj)) {
            aspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)elemEObj);
            String paramName = null;
            paramName = isUUIDGroup ? TransformationHelper.getSqlEObjectUUID(elemEObj) : TransformationHelper.getSqlEObjectFullName(elemEObj);
            a element = new a(paramName);
            element.bm(parentGroupSymbol);
            if (aspect != null) {
                String rtType = aspect.getRuntimeType(elemEObj);
                if (rtType != null) {
                    Class clazz = DataTypeManager.getDataTypeClass((String)rtType);
                    element.bb((Object)new com.metamatrix.query.m.d(paramName.toUpperCase(), clazz));
                    element.bh(clazz);
                } else {
                    element.bb((Object)new com.metamatrix.query.m.d(paramName.toUpperCase(), DataTypeManager.DefaultDataClasses.NULL));
                    element.bh(DataTypeManager.DefaultDataClasses.NULL);
                }
            } else {
                element.bb((Object)new com.metamatrix.query.m.d(paramName.toUpperCase(), DataTypeManager.DefaultDataClasses.NULL));
                element.bh(DataTypeManager.DefaultDataClasses.NULL);
            }
            seSymbol = element;
        }
        return seSymbol;
    }

    public static List renameConflictingSymbols(List seSymbols) {
        ArrayList<Object> newSymbols = new ArrayList<Object>();
        Map renamedSymbolsMap = TransformationSqlHelper.getRenamedSymbolsMap(seSymbols);
        if (renamedSymbolsMap.size() != 0) {
            HashMap workingRenSymMap = new HashMap(renamedSymbolsMap);
            for (int i2 = 0; i2 < seSymbols.size(); ++i2) {
                b currentSelectSymbol = (b)seSymbols.get(i2);
                if (currentSelectSymbol instanceof i) {
                    boolean shouldExpand = TransformationSqlHelper.shouldExpand((i)currentSelectSymbol, workingRenSymMap);
                    if (shouldExpand) {
                        List multiElemSymbols = ((i)currentSelectSymbol).az();
                        Iterator iter = multiElemSymbols.iterator();
                        while (iter.hasNext()) {
                            com.metamatrix.query.o.i.j renamedSymbol = TransformationSqlHelper.renameSymbolUsingMap((com.metamatrix.query.o.i.j)iter.next(), workingRenSymMap);
                            newSymbols.add(renamedSymbol);
                        }
                        continue;
                    }
                    newSymbols.add(currentSelectSymbol);
                    continue;
                }
                if (!(currentSelectSymbol instanceof com.metamatrix.query.o.i.j)) continue;
                com.metamatrix.query.o.i.j renamedSymbol = TransformationSqlHelper.renameSymbolUsingMap((com.metamatrix.query.o.i.j)currentSelectSymbol, workingRenSymMap);
                newSymbols.add(renamedSymbol);
            }
        } else {
            newSymbols.addAll(seSymbols);
        }
        return newSymbols;
    }

    private static boolean shouldExpand(i multiElemSymbol, Map renamedSymbolsMap) {
        boolean shouldExpand = false;
        List multiElemSymbols = multiElemSymbol.az();
        Collection renamedSymbols = renamedSymbolsMap.values();
        Iterator iter = renamedSymbols.iterator();
        while (iter.hasNext()) {
            if (!multiElemSymbols.contains(iter.next())) continue;
            shouldExpand = true;
            break;
        }
        return shouldExpand;
    }

    private static com.metamatrix.query.o.i.j renameSymbolUsingMap(com.metamatrix.query.o.i.j seSymbol, Map renamedSymbolsMap) {
        com.metamatrix.query.o.i.j resultSymbol = seSymbol;
        if (seSymbol != null) {
            Iterator renamedIter = renamedSymbolsMap.keySet().iterator();
            while (renamedIter.hasNext()) {
                String newName = (String)renamedIter.next();
                com.metamatrix.query.o.i.j renamedSymbol = (com.metamatrix.query.o.i.j)renamedSymbolsMap.get(newName);
                if (!renamedSymbol.equals((Object)seSymbol)) continue;
                if (seSymbol instanceof d) {
                    seSymbol.ai(newName);
                    resultSymbol = seSymbol;
                } else {
                    resultSymbol = new d(newName, seSymbol);
                }
                renamedSymbolsMap.remove(newName);
                break;
            }
        }
        return resultSymbol;
    }

    private static List createSPParams(List procParams) {
        ArrayList<ao> spparams = new ArrayList<ao>(procParams.size());
        int index = 0;
        block6: for (int i2 = 0; i2 < procParams.size(); ++i2) {
            EObject paramObject = (EObject)procParams.get(i2);
            SqlAspect sqlAspect = SqlAspectHelper.getSqlAspect((EObject)paramObject);
            if (!(sqlAspect instanceof SqlProcedureParameterAspect)) continue;
            SqlProcedureParameterAspect paramAspect = (SqlProcedureParameterAspect)sqlAspect;
            int direction = paramAspect.getType(paramObject);
            String name = paramAspect.getName(paramObject);
            switch (direction) {
                case 0: {
                    ao spparam1 = new ao(index, (com.metamatrix.query.o.i.s)new a(name));
                    spparam1.o(name);
                    spparam1.v(1);
                    spparams.add(spparam1);
                    ++index;
                    continue block6;
                }
                case 2: {
                    ao spparam2 = new ao(index, (com.metamatrix.query.o.i.s)new a(name));
                    spparam2.o(name);
                    spparam2.v(3);
                    spparams.add(spparam2);
                    ++index;
                    continue block6;
                }
                case 1: {
                    ao spparam3 = new ao(index, (com.metamatrix.query.o.i.s)new a(name));
                    spparam3.o(name);
                    spparam3.v(2);
                    spparams.add(spparam3);
                    ++index;
                    continue block6;
                }
                case 3: {
                    ao spparam4 = new ao(index, (com.metamatrix.query.o.i.s)new a(name));
                    spparam4.o(name);
                    spparam4.v(4);
                    spparams.add(spparam4);
                    ++index;
                }
            }
        }
        return spparams;
    }

    public static String getGroupSymbolShortName(f gSymbol) {
        String shortName = null;
        if (gSymbol != null) {
            String symbolDefn = gSymbol.ar();
            String symbolName = gSymbol.ak();
            if (symbolDefn != null) {
                shortName = symbolName;
            } else {
                EObject eObj = TransformationSqlHelper.getGroupSymbolEObject(gSymbol);
                shortName = TransformationHelper.getSqlEObjectName(eObj);
            }
        }
        return shortName;
    }

    public static Collection getGroupSymbols(l command) {
        Collection allGrps = com.metamatrix.query.o.h.d.ei((com.metamatrix.query.o.d)command, false);
        ArrayList<f> result = new ArrayList<f>(allGrps.size());
        Iterator iter = allGrps.iterator();
        while (iter.hasNext()) {
            f gSymbol = (f)iter.next();
            if (TransformationSqlHelper.containsGroupSymbol(result, gSymbol)) continue;
            result.add(gSymbol);
        }
        return result;
    }

    private static boolean containsGroupSymbol(Collection symbols, f gSymbol) {
        boolean result = false;
        String gSymbName = gSymbol.am();
        String gSymbDefn = gSymbol.ar();
        Iterator iter = symbols.iterator();
        while (iter.hasNext()) {
            f listSymbol = (f)iter.next();
            String lSymbName = listSymbol.am();
            String lSymbDefn = listSymbol.ar();
            if (lSymbDefn == null && gSymbDefn == null) {
                if (!lSymbName.equals(gSymbName)) continue;
                result = true;
                break;
            }
            if (lSymbDefn == null || gSymbDefn == null || !lSymbDefn.equalsIgnoreCase(gSymbDefn) || !lSymbName.equals(gSymbName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static int getReferenceCount(Object transMappingRoot, int type) {
        l command = TransformationHelper.getCommand(transMappingRoot, type);
        int refCount = 0;
        if (command != null) {
            ArrayList refs = new ArrayList();
            g.ev((com.metamatrix.query.o.d)command, refs);
            refCount = refs.size();
        }
        return refCount;
    }

    public static EObject getElementSymbolEObject(a symbol) {
        Object elemObj;
        EObject result = null;
        if (symbol != null && (elemObj = symbol.bf()) != null) {
            if (elemObj instanceof MetadataRecord) {
                result = ((MetadataRecord)elemObj).getEObject();
            } else if (TransformationHelper.isSqlColumn(elemObj)) {
                result = (EObject)elemObj;
            }
        }
        return result;
    }

    public static EObject getElementSymbolEObject(a symbol, l command) {
        Object elemObj;
        EObject result = null;
        if (symbol != null && (elemObj = symbol.bf()) != null) {
            if (elemObj instanceof MetadataRecord) {
                result = ((MetadataRecord)elemObj).getEObject();
            } else if (elemObj instanceof com.metamatrix.query.m.d) {
                String elemSymbolName = symbol.a3();
                f elemGrpSymbol = symbol.bc();
                List subQryFromClauses = com.metamatrix.query.o.h.a.eb((com.metamatrix.query.o.d)command);
                Iterator sqFromIter = subQryFromClauses.iterator();
                block0: while (sqFromIter.hasNext()) {
                    l sqCommand;
                    com.metamatrix.query.o.j.b clause = (com.metamatrix.query.o.j.b)((Object)sqFromIter.next());
                    f sqGrpSymbol = clause.c4();
                    if (sqGrpSymbol == null || elemGrpSymbol == null || !sqGrpSymbol.ak().equals(elemGrpSymbol.ak()) || !((sqCommand = clause.n()) instanceof x)) continue;
                    List resultSetParams = TransformationHelper.getProcedureResultSetParameters((x)sqCommand);
                    Iterator paramIter = resultSetParams.iterator();
                    while (paramIter.hasNext()) {
                        SqlColumnAspect sqlColAspect;
                        String colName;
                        Object param = paramIter.next();
                        if (!TransformationHelper.isSqlColumn(param) || (colName = (sqlColAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect((EObject)((EObject)param))).getName((EObject)param)) == null || !colName.equalsIgnoreCase(elemSymbolName)) continue;
                        result = (EObject)param;
                        continue block0;
                    }
                }
            }
        }
        return result;
    }

    public static Object getElementSymbolType(com.metamatrix.query.o.i.j symbol) {
        Class datatype = null;
        if (symbol instanceof d) {
            symbol = ((d)symbol).a4();
        }
        if (symbol instanceof a) {
            a eSymbol = (a)symbol;
            Object idObj = eSymbol.bf();
            if (idObj instanceof MetadataRecord) {
                EObject recordEObj = ((MetadataRecord)idObj).getEObject();
                if (recordEObj != null && TransformationHelper.isSqlColumn(recordEObj)) {
                    SqlColumnAspect columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)recordEObj);
                    datatype = columnAspect.getDatatype(recordEObj);
                }
            } else if (idObj instanceof com.metamatrix.query.m.d) {
                datatype = ((com.metamatrix.query.m.d)idObj).e();
            } else if (idObj == null) {
                datatype = eSymbol.ag();
            }
        } else if (symbol instanceof n) {
            n exSymbol = (n)symbol;
            datatype = exSymbol.ag();
        }
        return datatype;
    }

    public static int getElementSymbolLength(com.metamatrix.query.o.i.j symbol) {
        a eSymbol;
        EObject eObj;
        int length = -1;
        if (symbol instanceof d) {
            symbol = ((d)symbol).a4();
        }
        if (symbol instanceof a && (eObj = TransformationSqlHelper.getElementSymbolEObject(eSymbol = (a)symbol)) != null) {
            length = TransformationHelper.getSqlColumnLength(eObj);
        }
        return length;
    }

    public static List getElementSymbolEObjects(Collection elemSymbols, l command) {
        ArrayList<EObject> result = Collections.EMPTY_LIST;
        if (elemSymbols != null) {
            result = new ArrayList<EObject>(elemSymbols.size());
            Iterator iter = elemSymbols.iterator();
            while (iter.hasNext()) {
                a eSymbol = (a)iter.next();
                EObject elemEObj = TransformationSqlHelper.getElementSymbolEObject(eSymbol, command);
                if (elemEObj == null) continue;
                result.add(elemEObj);
            }
        }
        return result;
    }

    public static EObject getGroupSymbolEObject(f symbol) {
        Object groupObj;
        EObject result = null;
        if (symbol != null && (groupObj = symbol.aq()) != null) {
            if (groupObj instanceof MetadataRecord) {
                result = ((MetadataRecord)groupObj).getEObject();
            } else if (TransformationHelper.isSqlProcedureResultSet(groupObj)) {
                result = (EObject)groupObj;
            }
        }
        return result;
    }

    public static List getGroupSymbolEObjects(Collection groupSymbols) {
        ArrayList<EObject> result = Collections.EMPTY_LIST;
        if (groupSymbols != null) {
            result = new ArrayList<EObject>(groupSymbols.size());
            Iterator iter = groupSymbols.iterator();
            while (iter.hasNext()) {
                f gSymbol = (f)iter.next();
                EObject grpEObj = TransformationSqlHelper.getGroupSymbolEObject(gSymbol);
                if (grpEObj == null) continue;
                result.add(grpEObj);
            }
        }
        return result;
    }

    public static EObject getStoredProcedureEObject(x storedProc) {
        Object procID;
        EObject result = null;
        if (storedProc != null && (procID = storedProc.iq()) != null && procID instanceof MetadataRecord) {
            result = ((MetadataRecord)procID).getEObject();
        }
        return result;
    }

    public static boolean hasSqlAliasGroupAttributes(ag query, List sqlAliasGroups) {
        boolean result = false;
        List aliasGroupSymbols = TransformationSqlHelper.createGroupSymbols(sqlAliasGroups);
        if (!TransformationSqlHelper.isSelectStar(query.js())) {
            Collection selectElements = k.fb(query.js(), true);
            Iterator iter = selectElements.iterator();
            while (iter.hasNext()) {
                a selectElem = (a)iter.next();
                Collection symbolGroups = aa.ha((com.metamatrix.query.o.d)selectElem);
                Iterator symbolGroupIter = symbolGroups.iterator();
                while (symbolGroupIter.hasNext()) {
                    f groupSymbol = (f)symbolGroupIter.next();
                    if (!aliasGroupSymbols.contains(groupSymbol)) continue;
                    result = true;
                    break;
                }
                if (!result) continue;
                break;
            }
        }
        return result;
    }

    public static boolean hasSqlElemSymbols(ag query, List elemEObjs) {
        boolean result = false;
        List projSymbolNames = TransformationSqlHelper.getProjectedSymbolNames((l)query);
        Iterator iter = elemEObjs.iterator();
        while (iter.hasNext()) {
            SqlColumnAspect columnAspect;
            Object elem = iter.next();
            if (!(elem instanceof EObject) || !SqlAspectHelper.isColumn((EObject)((EObject)elem)) || !projSymbolNames.contains((columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)((EObject)elem))).getName((EObject)elem))) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isSelectStar(s select) {
        b singleSelectSymbol;
        boolean result = false;
        List currentSelectSymbols = select.ky();
        if (currentSelectSymbols.size() == 1 && (singleSelectSymbol = (b)currentSelectSymbols.get(0)) instanceof q) {
            result = true;
        }
        return result;
    }

    public static n convert(n exprSymbol, String newTypeName) {
        n newExpressionSymbol = (n)exprSymbol.clone();
        com.metamatrix.query.o.i.s expr = exprSymbol.a6();
        Class originalTypeClass = expr.ag();
        String originalTypeName = DataTypeManager.getDataTypeName((Class)originalTypeClass);
        if (!originalTypeName.equalsIgnoreCase(newTypeName)) {
            if (TransformationSqlHelper.isConvertFunction(exprSymbol)) {
                com.metamatrix.query.o.i.s convExpr = TransformationSqlHelper.getConvertedExpr(exprSymbol);
                Class convExprTypeClass = convExpr.ag();
                String convExprTypeName = DataTypeManager.getDataTypeName((Class)convExprTypeClass);
                boolean isExplicit = DataTypeManager.isExplicitConversion((String)convExprTypeName, (String)newTypeName);
                boolean isImplicit = DataTypeManager.isImplicitConversion((String)convExprTypeName, (String)newTypeName);
                if (isExplicit || isImplicit) {
                    e func = TransformationSqlHelper.getConversion(convExprTypeName, newTypeName, convExpr);
                    newExpressionSymbol.a7((com.metamatrix.query.o.i.s)func);
                } else {
                    e convertFunction = TransformationSqlHelper.getConversion(originalTypeName, newTypeName, expr);
                    newExpressionSymbol.a7((com.metamatrix.query.o.i.s)convertFunction);
                }
            } else {
                e convertFunction = TransformationSqlHelper.getConversion(originalTypeName, newTypeName, expr);
                newExpressionSymbol.a7((com.metamatrix.query.o.i.s)convertFunction);
            }
        }
        return newExpressionSymbol;
    }

    public static d convert(a elementSymbol, String newTypeName, String aliasName) {
        Class originalTypeClass = elementSymbol.ag();
        String originalTypeName = DataTypeManager.getDataTypeName((Class)originalTypeClass);
        e convertFunction = TransformationSqlHelper.getConversion(originalTypeName, newTypeName, (com.metamatrix.query.o.i.s)elementSymbol);
        n exprSymbol = new n(NEW_CONVERSION_NAME, (com.metamatrix.query.o.i.s)convertFunction);
        d newSymbol = null;
        newSymbol = aliasName != null ? new d(aliasName, (com.metamatrix.query.o.i.j)exprSymbol) : new d(elementSymbol.a3(), (com.metamatrix.query.o.i.j)exprSymbol);
        return newSymbol;
    }

    public static e getConversion(String originalTypeName, String newTypeName, com.metamatrix.query.o.i.s expression) {
        Class originalType = DataTypeManager.getDataTypeClass((String)originalTypeName);
        com.metamatrix.query.function.b library = com.metamatrix.query.function.g.b();
        com.metamatrix.query.function.a fd = library.f("convert", new Class[]{originalType, DataTypeManager.DefaultDataClasses.STRING});
        e conversion = new e(fd.c(), new com.metamatrix.query.o.i.s[]{expression, new c(newTypeName)});
        conversion.bu(DataTypeManager.getDataTypeClass((String)newTypeName));
        conversion.bt(fd);
        return conversion;
    }

    public static boolean isConvertFunction(n exprSymbol) {
        String fName;
        com.metamatrix.query.o.i.s expr = exprSymbol.a6();
        return expr instanceof e && (fName = ((e)expr).bx()).equalsIgnoreCase("CONVERT");
    }

    public static com.metamatrix.query.o.i.s getConvertedExpr(n exprSymbol) {
        if (TransformationSqlHelper.isConvertFunction(exprSymbol)) {
            com.metamatrix.query.o.i.s expr = exprSymbol.a6();
            com.metamatrix.query.o.i.s fExp = ((e)expr).bw(0);
            return fExp;
        }
        return null;
    }

    public static d convertElementSymbol(a symbol, String targetTypeStr, String aliasName) {
        return TransformationSqlHelper.convert(symbol, targetTypeStr, aliasName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static n convertExpressionSymbol(n symbol, String targetTypeStr) {
        d aSymbol;
        com.metamatrix.query.o.i.j aseSymbol;
        if (!TransformationSqlHelper.isConvertFunction(symbol)) return TransformationSqlHelper.convert(symbol, targetTypeStr);
        com.metamatrix.query.o.i.s cExpr = TransformationSqlHelper.getConvertedExpr(symbol);
        if (!(cExpr instanceof com.metamatrix.query.o.i.j)) return null;
        com.metamatrix.query.o.i.j seSymbol = (com.metamatrix.query.o.i.j)cExpr;
        String seSymbolTypeStr = DataTypeManager.getDataTypeName((Class)seSymbol.ag());
        boolean isExplicitConv = DataTypeManager.isExplicitConversion((String)seSymbolTypeStr, (String)targetTypeStr);
        boolean isImplicitConv = DataTypeManager.isImplicitConversion((String)seSymbolTypeStr, (String)targetTypeStr);
        if (!isImplicitConv && !isExplicitConv) return TransformationSqlHelper.convert(symbol, targetTypeStr);
        if (seSymbol instanceof n) {
            return TransformationSqlHelper.convertExpressionSymbol((n)seSymbol, targetTypeStr);
        }
        if (!(seSymbol instanceof a) || !((aseSymbol = (aSymbol = TransformationSqlHelper.convertElementSymbol((a)seSymbol, targetTypeStr, null)).a4()) instanceof n)) return null;
        return (n)aseSymbol;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

