/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.dh.DHPrivateKey;
import iaik.security.dh.DHPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public final class DHKeyFactory
extends KeyFactorySpi {
    static /* synthetic */ Class d;
    static /* synthetic */ Class b;
    static /* synthetic */ Class c;
    static /* synthetic */ Class a;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof javax.crypto.interfaces.DHPublicKey) {
            BigInteger bigInteger = ((javax.crypto.interfaces.DHPublicKey)key).getY();
            DHParameterSpec dHParameterSpec = ((javax.crypto.interfaces.DHPublicKey)key).getParams();
            return new DHPublicKey(bigInteger, dHParameterSpec);
        }
        if (key instanceof javax.crypto.interfaces.DHPrivateKey) {
            BigInteger bigInteger = ((javax.crypto.interfaces.DHPrivateKey)key).getX();
            DHParameterSpec dHParameterSpec = ((javax.crypto.interfaces.DHPrivateKey)key).getParams();
            return new DHPrivateKey(bigInteger, dHParameterSpec);
        }
        throw new InvalidKeyException("Only keys of type DHPublicKey and DHPrivateKey can be translated.");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof DHPublicKey) {
            if ((a != null ? a : (a = DHKeyFactory.a("javax.crypto.spec.DHPublicKeySpec"))).isAssignableFrom(clazz)) {
                DHPublicKey dHPublicKey = (DHPublicKey)key;
                DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
                return new DHPublicKeySpec(dHPublicKey.getY(), dHParameterSpec.getP(), dHParameterSpec.getG());
            }
            if ((c != null ? c : (c = DHKeyFactory.a("java.security.spec.X509EncodedKeySpec"))).isAssignableFrom(clazz)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("Can't convert key to KeySpec.");
        }
        if (key instanceof DHPrivateKey) {
            DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
            if ((b != null ? b : (b = DHKeyFactory.a("javax.crypto.spec.DHPrivateKeySpec"))).isAssignableFrom(clazz)) {
                DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
                return new DHPrivateKeySpec(dHPrivateKey.getX(), dHParameterSpec.getP(), dHParameterSpec.getG());
            }
            if ((d != null ? d : (d = DHKeyFactory.a("java.security.spec.PKCS8EncodedKeySpec"))).isAssignableFrom(clazz)) {
                return new PKCS8EncodedKeySpec(dHPrivateKey.getEncoded());
            }
            throw new InvalidKeySpecException("Can't convert key to KeySpec.");
        }
        throw new InvalidKeySpecException("Can only convert DH keys.");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DHPublicKeySpec) {
                return new DHPublicKey((DHPublicKeySpec)keySpec);
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new DHPublicKey(((EncodedKeySpec)((X509EncodedKeySpec)keySpec)).getEncoded());
            }
            throw new InvalidKeySpecException("Only DH key specs allowed.");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Invalid KeySpec.");
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DHPrivateKeySpec) {
                return new DHPrivateKey((DHPrivateKeySpec)keySpec);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new DHPrivateKey(((EncodedKeySpec)((PKCS8EncodedKeySpec)keySpec)).getEncoded());
            }
            throw new InvalidKeySpecException("Only DH key specs allowed.");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Invalid KeySpec.");
        }
    }
}

