/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseFunctionEscape;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.base.BaseSQLScanner;
import com.metamatrix.jdbc.base.BaseSQLToken;
import com.metamatrix.jdbc.base.BaseSQLTreeNode;
import com.metamatrix.util.UtilVectorUnsynced;
import java.sql.SQLException;

final class BaseSQLParser {
    private static String footprint = "$Revision:   3.24.1.1  $";
    protected BaseExceptions exceptions;
    protected BaseSQL sqlProcessor;
    BaseSQLScanner scanner;
    private BaseSQLTreeNode nodeSubParse;
    BaseSQLTreeNode nodeUpdateTable;
    UtilVectorUnsynced tableInfo;
    boolean parsingOJEscape;
    private int processLevel;
    private boolean intoIsOptional;
    private BaseEscapeTranslator escapeTranslator;

    public BaseSQLParser() {
        this.escapeTranslator = null;
        this.processLevel = 1;
        this.intoIsOptional = false;
    }

    public BaseSQLParser(BaseEscapeTranslator baseEscapeTranslator, int n) {
        this.escapeTranslator = baseEscapeTranslator;
        this.processLevel = n;
        this.intoIsOptional = false;
    }

    public BaseSQLParser(BaseEscapeTranslator baseEscapeTranslator, int n, boolean bl) {
        this.escapeTranslator = baseEscapeTranslator;
        this.processLevel = n;
        this.intoIsOptional = bl;
    }

    void setUp(BaseSQL baseSQL, BaseExceptions baseExceptions) {
        this.sqlProcessor = baseSQL;
        this.exceptions = baseExceptions;
    }

    public BaseSQLTreeNode parse(String string, char c) throws SQLException {
        BaseSQLTreeNode baseSQLTreeNode = null;
        this.scanner = new BaseSQLScanner();
        this.scanner.setup(string, '\'', c);
        this.tossLeadingWhiteSpace();
        baseSQLTreeNode = this.parseSQL() ? this.nodeSubParse : new BaseSQLTreeNode(1016, string);
        return baseSQLTreeNode;
    }

    private void tossLeadingWhiteSpace() throws SQLException {
        this.matchWhiteSpaceOrComment();
        this.nodeSubParse = null;
    }

    private boolean parseSQL() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1001);
        if (this.processLevel == 0) {
            BaseSQLTreeNode baseSQLTreeNode2 = new BaseSQLTreeNode(1006);
            baseSQLTreeNode2.setNextChild(new BaseSQLTreeNode(1016, this.scanner.getSQL()));
            baseSQLTreeNode.setNextChild(baseSQLTreeNode2);
            this.nodeSubParse = baseSQLTreeNode;
            bl = true;
        } else if (this.processLevel == 1) {
            if (this.parseUnknownStatement()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            }
        } else {
            this.parseStatementList();
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseStatement() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        if (this.parseSelectStatement() || this.parseInsertStatement() || this.parseUpdateStatement() || this.parseCreateStatement() || this.parseDeleteStatement() || this.parseUnknownStatement()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1002);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private void parseStatementList() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        BaseSQLTreeNode baseSQLTreeNode = null;
        boolean bl2 = true;
        while (bl2) {
            if (this.parseStatement()) {
                if (baseSQLTreeNode == null) {
                    baseSQLTreeNode = this.nodeSubParse;
                } else {
                    baseSQLTreeNode.addNextSibling(this.nodeSubParse);
                }
                if (!this.parseStatementSeparator()) continue;
                baseSQLTreeNode.addNextSibling(this.nodeSubParse);
                if (!this.matchEndOfStatementTerminal()) continue;
                baseSQLTreeNode.addNextSibling(this.nodeSubParse);
                bl = true;
                bl2 = false;
                continue;
            }
            if (!this.matchEndOfStatementTerminal()) continue;
            bl = true;
            bl2 = false;
        }
        this.nodeSubParse = bl ? baseSQLTreeNode : null;
    }

    private boolean parseStatementSeparator() throws SQLException {
        this.nodeSubParse = null;
        if (this.matchSemicolonTerminal()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1015);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
        }
        return true;
    }

    private boolean parseCreateStatement() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        if (this.matchCreateTable()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1039);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.parseAlmostAnything(true, true, null)) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            }
        }
        if (!bl) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean parseSelectStatement() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        if (this.parseQueryExpression()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1003);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.parseOrderByClause()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.parseForClause()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean parseQueryExpression() throws SQLException {
        if ((this.processLevel & 4) == 0 && ((this.processLevel & 2) == 0 || this.getEscapeTranslationNeeded(8208) != 2)) {
            return false;
        }
        boolean bl = false;
        this.nodeSubParse = null;
        boolean bl2 = false;
        UtilVectorUnsynced utilVectorUnsynced = null;
        if (this.matchSelectTerminal()) {
            if ((this.processLevel & 0x10) != 0) {
                if (this.tableInfo == null) {
                    utilVectorUnsynced = this.tableInfo = new UtilVectorUnsynced();
                } else {
                    this.tableInfo = null;
                }
            }
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1022);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.parseList()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.parseFromClause()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    if (this.parseWhereClause()) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        if (this.parseGroupByClause()) {
                            baseSQLTreeNode.setNextChild(this.nodeSubParse);
                            if (this.parseHavingClause()) {
                                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                                if (this.parseSetOperation()) {
                                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                                    this.nodeSubParse = baseSQLTreeNode;
                                    bl = true;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (bl) {
            this.tableInfo = utilVectorUnsynced;
        } else {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseDeleteStatement() throws SQLException {
        if ((this.processLevel & 4) == 0) {
            return false;
        }
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        if (this.matchDeleteTerminal()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1048);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchFromTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
            }
            if (this.parseQualifiedName()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.parseWhereClause()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean parseInsertStatement() throws SQLException {
        if ((this.processLevel & 4) == 0) {
            return false;
        }
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        if (this.matchInsertTerminal()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1004);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            boolean bl2 = this.matchIntoTerminal();
            if (bl2 || this.intoIsOptional) {
                if (bl2) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                }
                if (this.parseQualifiedName()) {
                    if (this.sqlProcessor != null) {
                        this.sqlProcessor.setUpdateTableNode(this.nodeSubParse);
                    }
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    if (this.parseColumnList()) {
                        if (this.sqlProcessor != null) {
                            this.sqlProcessor.setUpdateNamesNode(this.nodeSubParse);
                        }
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        if (this.matchValuesTerminal()) {
                            baseSQLTreeNode.setNextChild(this.nodeSubParse);
                            if (this.parseParenthesizedExpression()) {
                                if (this.sqlProcessor != null) {
                                    this.sqlProcessor.setUpdateValuesNode(this.nodeSubParse);
                                }
                                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                                this.nodeSubParse = baseSQLTreeNode;
                                bl = true;
                            }
                        } else if (this.parseSubQuery()) {
                            baseSQLTreeNode.setNextChild(this.nodeSubParse);
                            this.nodeSubParse = baseSQLTreeNode;
                            bl = true;
                        } else if (this.matchDefaultTerminal()) {
                            baseSQLTreeNode.setNextChild(this.nodeSubParse);
                            if (this.matchValuesTerminal()) {
                                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                                this.nodeSubParse = baseSQLTreeNode;
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        if (!bl) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean parseUpdateStatement() throws SQLException {
        if ((this.processLevel & 4) == 0) {
            return false;
        }
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        if (this.matchUpdateTerminal()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1005);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.parseQualifiedName()) {
                if (this.sqlProcessor != null) {
                    this.sqlProcessor.setUpdateTableNode(this.nodeSubParse);
                }
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.matchSetTerminal()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    if (this.parseList()) {
                        if (this.sqlProcessor != null) {
                            this.sqlProcessor.setUpdateNameValuesNode(this.nodeSubParse);
                        }
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        if (this.parseWhereClause()) {
                            baseSQLTreeNode.setNextChild(this.nodeSubParse);
                            this.nodeSubParse = baseSQLTreeNode;
                            bl = true;
                        }
                    }
                }
            }
        }
        if (!bl) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean parseQualifiedName() throws SQLException {
        boolean bl;
        block7: {
            bl = false;
            if (this.matchIdentifierOrUnknownKeyword(false)) {
                BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016);
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                while (this.matchDotTerminal() || this.matchColonTerminal()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    while (this.matchDotTerminal() || this.matchColonTerminal()) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    }
                    if (this.matchIdentifierOrUnknownKeyword(false)) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        continue;
                    }
                    bl = false;
                    break block7;
                }
                if (this.matchSemicolonTerminal()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.matchAnyToken();
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode;
                    bl = true;
                } else {
                    this.nodeSubParse = baseSQLTreeNode;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseUnknownStatement() throws SQLException {
        this.nodeSubParse = null;
        BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1006);
        this.parseUnknownStatementComponents();
        baseSQLTreeNode.setNextChild(this.nodeSubParse);
        this.nodeSubParse = baseSQLTreeNode;
        return true;
    }

    private void parseUnknownStatementComponents() throws SQLException {
        this.nodeSubParse = null;
        boolean bl = false;
        BaseSQLTreeNode baseSQLTreeNode = null;
        BaseSQLTreeNode baseSQLTreeNode2 = null;
        int[] nArray = new int[]{8, 10, 11, 1};
        while (!bl) {
            if (this.matchAlmostAnyTokens(nArray)) {
                if (baseSQLTreeNode == null) {
                    baseSQLTreeNode = this.nodeSubParse;
                } else {
                    if (baseSQLTreeNode2 == null) {
                        baseSQLTreeNode.addNextSibling(this.nodeSubParse);
                    } else {
                        baseSQLTreeNode2.addNextSibling(this.nodeSubParse);
                    }
                    baseSQLTreeNode2 = this.nodeSubParse;
                }
                this.nodeSubParse = null;
            }
            if (this.matchEndOfStatementTerminal()) {
                if (baseSQLTreeNode == null) {
                    baseSQLTreeNode = this.nodeSubParse;
                } else {
                    if (baseSQLTreeNode2 == null) {
                        baseSQLTreeNode.addNextSibling(this.nodeSubParse);
                    } else {
                        baseSQLTreeNode2.addNextSibling(this.nodeSubParse);
                    }
                    baseSQLTreeNode2 = this.nodeSubParse;
                }
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
                continue;
            }
            if (!(this.matchParameterTerminal() || this.parseEscape() || this.parseParenthesizedExpression())) {
                this.matchAnyToken();
            }
            if (baseSQLTreeNode == null) {
                baseSQLTreeNode = this.nodeSubParse;
                continue;
            }
            if (baseSQLTreeNode2 == null) {
                baseSQLTreeNode.addNextSibling(this.nodeSubParse);
            } else {
                baseSQLTreeNode2.addNextSibling(this.nodeSubParse);
            }
            baseSQLTreeNode2 = this.nodeSubParse;
        }
    }

    private boolean parseList() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        if (this.parseAlmostAnything(true, false, null)) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1014);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseFromClause() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        if (this.matchFromTerminal()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1008);
            int n = 0;
            if (this.tableInfo != null) {
                n = this.tableInfo.size();
            }
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if ((this.processLevel & 0x10) != 0 && (this.parseOuterJoinEscape() || this.parseTableReference())) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            }
            if (!bl) {
                if (this.tableInfo != null) {
                    this.tableInfo.setSize(n);
                }
                if (this.parseList()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode;
                    bl = true;
                }
            }
        } else {
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseWhereClause() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1009);
        if (this.matchWhereTerminal()) {
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.parsePredicate()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            }
        } else {
            this.nodeSubParse = baseSQLTreeNode;
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parsePredicate() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1041);
        if ((this.processLevel & 8) != 0) {
            if (this.matchNotTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
            }
            if (this.parsePredicateType()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                bl = true;
                if (this.parseRestOfPredicate()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                }
            } else {
                this.scanner.scanPosition = n;
                if (this.matchLeftParenTerminal()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    if (this.parsePredicate()) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        if (this.matchRightParenTerminal()) {
                            bl = true;
                            baseSQLTreeNode.setNextChild(this.nodeSubParse);
                            if (this.parseRestOfPredicate()) {
                                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                            }
                        }
                    }
                }
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            if (this.parseAlmostAnything(true, false, null)) {
                bl = true;
            } else {
                this.scanner.scanPosition = n;
            }
        } else {
            this.nodeSubParse = baseSQLTreeNode;
        }
        return bl;
    }

    private boolean parseRestOfPredicate() throws SQLException {
        boolean bl = false;
        BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016);
        if (this.parseTruthPart()) {
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            bl = true;
        }
        if (this.matchAndTerminal() || this.matchOrTerminal()) {
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.parsePredicate()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                bl = true;
            } else {
                bl = false;
            }
        }
        this.nodeSubParse = bl ? baseSQLTreeNode : null;
        return bl;
    }

    private boolean parseTruthPart() throws SQLException {
        boolean bl = false;
        int n = this.scanner.scanPosition;
        BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016);
        if (this.matchIsTerminal()) {
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchNotTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
            }
            if (this.matchTrueTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                bl = true;
            } else if (this.matchFalseTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                bl = true;
            } else if (this.matchUnknownTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                bl = true;
            }
        }
        if (bl) {
            this.nodeSubParse = baseSQLTreeNode;
        } else {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean parsePredicateType() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1042);
        if (this.parseComparisonPredicate()) {
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            bl = true;
        } else {
            this.scanner.scanPosition = n;
            if (this.parseBetweenPredicate()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                bl = true;
            } else {
                this.scanner.scanPosition = n;
                if (this.parseInPredicate()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    bl = true;
                } else {
                    this.scanner.scanPosition = n;
                    if (this.parseLikePredicate()) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        bl = true;
                    } else if (this.parseNullPredicate()) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        bl = true;
                    }
                }
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
        } else {
            this.nodeSubParse = baseSQLTreeNode;
        }
        return bl;
    }

    private boolean parseNullPredicate() throws SQLException {
        boolean bl = false;
        int n = this.scanner.scanPosition;
        Object[] objectArray = new Object[]{"is"};
        BaseSQLTreeNode baseSQLTreeNode = null;
        if (this.parseValueExpression(objectArray)) {
            baseSQLTreeNode = new BaseSQLTreeNode(1016);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchIsTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.matchNotTerminal()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                }
                if (this.matchNullTerminal()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    bl = true;
                }
            }
        }
        if (bl) {
            this.nodeSubParse = baseSQLTreeNode;
        } else {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean parseComparisonPredicate() throws SQLException {
        boolean bl = false;
        int n = this.scanner.scanPosition;
        Object[] objectArray = new Object[]{new Integer(3), new Integer(7)};
        if (this.parseValueExpression(objectArray)) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1043);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchCompareOpTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                Object[] objectArray2 = new Object[]{new Integer(13)};
                if (this.parseValueExpression(objectArray2)) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    bl = true;
                }
            }
            this.nodeSubParse = baseSQLTreeNode;
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseBetweenPredicate() throws SQLException {
        boolean bl = false;
        int n = this.scanner.scanPosition;
        Object[] objectArray = new Object[]{"not", "between"};
        if (this.parseValueExpression(objectArray)) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1044);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchNotTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
            }
            if (this.matchBetweenTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                Object[] objectArray2 = new Object[]{"and"};
                if (this.parseValueExpression(objectArray2)) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    if (this.matchAndTerminal()) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        Object[] objectArray3 = new Object[]{new Integer(13)};
                        if (this.parseValueExpression(objectArray3)) {
                            baseSQLTreeNode.setNextChild(this.nodeSubParse);
                            this.nodeSubParse = baseSQLTreeNode;
                            bl = true;
                        }
                    }
                }
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseInPredicate() throws SQLException {
        boolean bl = false;
        BaseSQLTreeNode baseSQLTreeNode = null;
        int n = this.scanner.scanPosition;
        Object[] objectArray = new Object[]{"in", "not"};
        if (this.parseValueExpression(objectArray)) {
            baseSQLTreeNode = new BaseSQLTreeNode(1045);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchNotTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
            }
            if (this.matchInTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.parseSubQuery()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                } else if (this.matchLeftParenTerminal()) {
                    BaseSQLTreeNode baseSQLTreeNode2 = new BaseSQLTreeNode(1007);
                    baseSQLTreeNode.setNextChild(baseSQLTreeNode2);
                    baseSQLTreeNode2.setNextChild(this.nodeSubParse);
                    Object[] objectArray2 = new Object[]{new Integer(1), new Integer(13)};
                    bl = true;
                    boolean bl2 = true;
                    do {
                        if (this.parseValueExpression(objectArray2)) {
                            baseSQLTreeNode2.setNextChild(this.nodeSubParse);
                            if (this.matchCommaTerminal()) {
                                baseSQLTreeNode2.setNextChild(this.nodeSubParse);
                                continue;
                            }
                            if (this.matchRightParenTerminal()) {
                                baseSQLTreeNode2.setNextChild(this.nodeSubParse);
                                bl2 = false;
                                continue;
                            }
                            bl = false;
                            continue;
                        }
                        bl = false;
                    } while (bl && bl2);
                }
            }
        }
        if (bl) {
            this.nodeSubParse = baseSQLTreeNode;
        } else {
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean parseLikePredicate() throws SQLException {
        boolean bl = false;
        BaseSQLTreeNode baseSQLTreeNode = null;
        int n = this.scanner.scanPosition;
        Object[] objectArray = new Object[]{"like", "not"};
        if (this.parseValueExpression(objectArray)) {
            baseSQLTreeNode = new BaseSQLTreeNode(1046);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchNotTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
            }
            if (this.matchLikeTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                Object[] objectArray2 = new Object[]{"escape", new Integer(13)};
                if (this.parseValueExpression(objectArray2)) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    if (this.matchEscapeTerminal()) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        this.matchAnyToken();
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    }
                    bl = true;
                }
            }
        }
        if (bl) {
            this.nodeSubParse = baseSQLTreeNode;
        } else {
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean parseValueExpression(Object[] objectArray) throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1047);
        if (this.parseAlmostAnything(true, false, objectArray)) {
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            bl = true;
        }
        if (!bl) {
            this.scanner.scanPosition = n;
        } else {
            this.nodeSubParse = baseSQLTreeNode;
        }
        return bl;
    }

    private boolean parseGroupByClause() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        if (this.matchGroupBy()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1010);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.parseAlmostAnything(true, false, null)) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseHavingClause() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        if (this.matchHavingTerminal()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1013);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.parsePredicate()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseForClause() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        if (this.matchForTerminal()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1040);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchUpdateTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.matchOfTerminal()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    if (this.parseList()) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        this.nodeSubParse = baseSQLTreeNode;
                        this.sqlProcessor.hasForUpdate(true);
                        bl = true;
                    }
                } else {
                    this.nodeSubParse = baseSQLTreeNode;
                    this.sqlProcessor.hasForUpdate(true);
                    bl = true;
                }
            } else if (this.matchReadTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.matchOnlyTerminal()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode;
                    this.sqlProcessor.hasForReadOnly(true);
                    bl = true;
                }
            }
        } else {
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean parseSetOperation() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        if (this.parseSetOperator()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1011);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.parseAllPart()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.parseCorrespondingClause()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    if (this.parseSetOperationLastPart()) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        this.nodeSubParse = baseSQLTreeNode;
                        bl = true;
                    }
                }
            }
        } else {
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseCorrespondingClause() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        if (this.matchCorrespondingTerminal()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.parseByPart()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseByPart() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        if (this.matchByTerminal()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.parseParenthesizedExpression()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            }
        } else {
            this.nodeSubParse = null;
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseSetOperationLastPart() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        if (this.parseQueryExpression()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
            bl = true;
        } else if (this.parseAlmostAnything(true, false, null)) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseOrderByClause() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        if (this.matchOrderByTerminal()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1012);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.parseAlmostAnything(true, false, null)) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseAllPart() throws SQLException {
        this.nodeSubParse = null;
        if (this.matchAllTerminal()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
        }
        return true;
    }

    private boolean parseColumnList() throws SQLException {
        this.nodeSubParse = null;
        if (this.parseParenthesizedExpression()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
        }
        return true;
    }

    private boolean parseSetOperator() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        if (this.matchUnionTerminal()) {
            bl = true;
        } else if (this.matchIntersectTerminal()) {
            bl = true;
        } else if (this.matchExceptTerminal()) {
            bl = true;
        } else {
            this.nodeSubParse = null;
        }
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseAlmostAnything(boolean bl, boolean bl2, Object[] objectArray) throws SQLException {
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        BaseSQLTreeNode baseSQLTreeNode = null;
        while (bl4) {
            this.nodeSubParse = null;
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    boolean bl6 = objectArray[i] instanceof Integer ? this.matchTerminal((Integer)objectArray[i], 1016, true) : this.matchKeywordTerminal((String)objectArray[i], true);
                    if (!bl6) continue;
                    bl5 = true;
                    bl4 = false;
                    bl3 = true;
                }
            }
            if (bl5) continue;
            if (this.matchIdentifierOrUnknownKeyword(bl2) || this.matchDotTerminal() || this.matchColonTerminal() || this.matchUnknownTokenTerminal() || this.matchStringLiteralTerminal() || this.parseEscape() || this.matchParameterTerminal() || this.matchCommaTerminal() || this.matchCompareOpTerminal() || this.matchEqualOperatorTerminal() || this.parseSubQuery() || this.parseParenthesizedExpression()) {
                if (baseSQLTreeNode == null) {
                    baseSQLTreeNode = this.nodeSubParse;
                } else {
                    baseSQLTreeNode.addNextSibling(this.nodeSubParse);
                }
                bl3 = true;
                continue;
            }
            if (!bl) {
                this.nodeSubParse = null;
                bl3 = true;
            }
            bl4 = false;
        }
        this.nodeSubParse = !bl3 ? null : baseSQLTreeNode;
        return bl3;
    }

    private boolean parseParenthesizedExpression() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        if (this.matchLeftParenTerminal()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1007);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            BaseSQLTreeNode baseSQLTreeNode2 = this.nodeSubParse;
            if (this.parseAlmostAnything(false, true, null)) {
                baseSQLTreeNode2.setNextChild(this.nodeSubParse);
                if (this.matchRightParenTerminal()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean parseSubQuery() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        if (this.matchLeftParenTerminal()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1007);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            BaseSQLTreeNode baseSQLTreeNode2 = this.nodeSubParse;
            if (this.parseQueryExpression()) {
                baseSQLTreeNode2.setNextChild(this.nodeSubParse);
                if (this.matchRightParenTerminal()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseEscape() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        if ((this.processLevel & 2) == 0) {
            return false;
        }
        int n = this.scanner.scanPosition;
        if (!this.matchLeftBraceTerminal(0)) {
            this.scanner.scanPosition = n;
            return false;
        }
        this.scanner.scanPosition = n;
        if (this.parseCallEscape() || this.parseFunctionEscape() || this.parseOuterJoinEscape() || this.parseTimeEscape() || this.parseDateEscape() || this.parseTimestampEscape() || this.parseEscapeEscape()) {
            bl = true;
        } else if (this.supportBraceAsCommentSymbol() && this.parseCommentInBrace()) {
            bl = true;
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseTimeEscape() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        int n2 = this.getEscapeTranslationNeeded(8193);
        if (this.matchLeftBraceTerminal(n2)) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(8193);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchTTerminal(n2)) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.parseRemainingStringLiteralEscape(baseSQLTreeNode, n2)) {
                    this.nodeSubParse = baseSQLTreeNode;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseDateEscape() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        int n2 = this.getEscapeTranslationNeeded(8194);
        if (this.matchLeftBraceTerminal(n2)) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(8194);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchDTerminal(n2)) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.parseRemainingStringLiteralEscape(baseSQLTreeNode, n2)) {
                    this.nodeSubParse = baseSQLTreeNode;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseTimestampEscape() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        int n2 = this.getEscapeTranslationNeeded(8196);
        if (this.matchLeftBraceTerminal(n2)) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(8196);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchTsTerminal(n2)) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.parseRemainingStringLiteralEscape(baseSQLTreeNode, n2)) {
                    this.nodeSubParse = baseSQLTreeNode;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseEscapeEscape() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        int n2 = this.getEscapeTranslationNeeded(8212);
        if (this.matchLeftBraceTerminal(n2)) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(8212);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchEscapeTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.parseRemainingStringLiteralEscape(baseSQLTreeNode, n2)) {
                    this.nodeSubParse = baseSQLTreeNode;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseRemainingStringLiteralEscape(BaseSQLTreeNode baseSQLTreeNode, int n) throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n2 = this.scanner.scanPosition;
        if (n == 2) {
            if (this.matchStringLiteralTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.matchRightBraceTerminal(n)) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    bl = true;
                }
            }
        } else {
            this.parseRestOfEscape(n);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            baseSQLTreeNode.type = 1016;
            bl = true;
        }
        if (!bl) {
            this.scanner.scanPosition = n2;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseFunctionEscape() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        int n2 = this.getEscapeTranslationNeeded(8200);
        if (this.matchLeftBraceTerminal(n2)) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(8200);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchFnTerminal(n2)) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (n2 == 2) {
                    if (this.matchScalarFunctionNameTerminal()) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        if (this.parseEscapeParameterList()) {
                            baseSQLTreeNode.setNextChild(this.nodeSubParse);
                            if (this.matchRightBraceTerminal(n2)) {
                                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                                this.nodeSubParse = baseSQLTreeNode;
                                bl = true;
                            }
                        }
                    }
                } else {
                    this.parseRestOfEscape(n2);
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode;
                    baseSQLTreeNode.type = 1016;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseCallEscape() throws SQLException {
        BaseSQLTreeNode baseSQLTreeNode;
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        int n2 = this.getEscapeTranslationNeeded(8210);
        if (this.matchLeftBraceTerminal(n2)) {
            baseSQLTreeNode = new BaseSQLTreeNode(8210);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchParameterTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.matchEqualOperatorTerminal()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    if (this.matchCallTerminal()) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        if (this.parseRemainingCallEscape(baseSQLTreeNode, n2)) {
                            this.nodeSubParse = baseSQLTreeNode;
                            bl = true;
                        }
                    }
                }
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
            n2 = this.getEscapeTranslationNeeded(8209);
            if (this.matchLeftBraceTerminal(n2)) {
                baseSQLTreeNode = new BaseSQLTreeNode(8209);
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.matchCallTerminal()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    if (this.parseRemainingCallEscape(baseSQLTreeNode, n2)) {
                        this.nodeSubParse = baseSQLTreeNode;
                        bl = true;
                    }
                }
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseRemainingCallEscape(BaseSQLTreeNode baseSQLTreeNode, int n) throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n2 = this.scanner.scanPosition;
        if (n == 2) {
            if (this.parseQualifiedName()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.parseEscapeParameterList()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    if (this.matchRightBraceTerminal(n)) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        bl = true;
                    }
                }
            }
        } else {
            this.parseRestOfEscape(n);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            baseSQLTreeNode.type = 1016;
            bl = true;
        }
        if (!bl) {
            this.scanner.scanPosition = n2;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseOuterJoinEscape() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        this.parsingOJEscape = true;
        int n = this.scanner.scanPosition;
        int n2 = this.getEscapeTranslationNeeded(8208);
        if (this.matchLeftBraceTerminal(n2)) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(8208);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchOjTerminal(n2)) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (n2 == 2) {
                    if (this.parseOuterJoin()) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        if (this.matchRightBraceTerminal(n2)) {
                            baseSQLTreeNode.setNextChild(this.nodeSubParse);
                            this.nodeSubParse = baseSQLTreeNode;
                            bl = true;
                        }
                    }
                } else {
                    this.parseRestOfEscape(n2);
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode;
                    baseSQLTreeNode.type = 1016;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        this.parsingOJEscape = false;
        return bl;
    }

    private boolean parseOuterJoin() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        int n2 = 0;
        if (this.tableInfo != null) {
            n2 = this.tableInfo.size();
        }
        if (this.parseTableReference()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.parseJoinType(baseSQLTreeNode)) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.parseOuterJoinOrTableReference()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    if (this.matchOnTerminal()) {
                        baseSQLTreeNode.setNextChild(this.nodeSubParse);
                        if (this.parseSearchCondition()) {
                            baseSQLTreeNode.setNextChild(this.nodeSubParse);
                            this.nodeSubParse = baseSQLTreeNode;
                            bl = true;
                        }
                    }
                }
            }
        }
        if (!bl) {
            if (this.tableInfo != null) {
                this.tableInfo.setSize(n2);
            }
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseOuterJoinOrTableReference() throws SQLException {
        this.nodeSubParse = null;
        int n = 0;
        if (this.tableInfo != null) {
            n = this.tableInfo.size();
        }
        if (this.parseOuterJoin()) {
            return true;
        }
        if (this.tableInfo != null) {
            this.tableInfo.setSize(n);
        }
        return this.parseTableReference();
    }

    private boolean parseJoinType(BaseSQLTreeNode baseSQLTreeNode) throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        BaseSQLTreeNode baseSQLTreeNode2 = new BaseSQLTreeNode(1016);
        if (this.matchLeftTerminal()) {
            baseSQLTreeNode.type = 1035;
            baseSQLTreeNode2.setNextChild(this.nodeSubParse);
            bl = true;
        } else if (this.matchRightTerminal()) {
            baseSQLTreeNode.type = 1036;
            baseSQLTreeNode2.setNextChild(this.nodeSubParse);
            bl = true;
        } else if (this.matchFullTerminal()) {
            baseSQLTreeNode.type = 1037;
            baseSQLTreeNode2.setNextChild(this.nodeSubParse);
            bl = true;
        }
        if (bl) {
            bl = false;
            if (this.matchKeywordTerminal("outer", false)) {
                baseSQLTreeNode2.setNextChild(this.nodeSubParse);
                if (this.matchKeywordTerminal("join", false)) {
                    baseSQLTreeNode2.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode2;
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseTableReference() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        if (this.parseQualifiedName()) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1023);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            Object[] objectArray = null;
            if ((this.processLevel & 0x10) != 0 && this.tableInfo != null && !this.lookAheadForVerboseJoinOutsideOJEscape()) {
                objectArray = new Object[2];
                objectArray[0] = this.nodeSubParse;
                this.tableInfo.add((Object)objectArray);
            }
            if (this.parseCorrelationName()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                bl = true;
                if (this.tableInfo != null && objectArray != null && !this.lookAheadForVerboseJoinOutsideOJEscape()) {
                    objectArray[1] = this.nodeSubParse;
                }
            }
            if ((this.processLevel & 0x10) != 0 && this.matchCommaTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.parseTableReference()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                }
            }
            if (bl) {
                this.nodeSubParse = baseSQLTreeNode;
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean lookAheadForVerboseJoinOutsideOJEscape() throws SQLException {
        if (this.parsingOJEscape) {
            return false;
        }
        boolean bl = false;
        BaseSQLTreeNode baseSQLTreeNode = this.nodeSubParse;
        int n = this.scanner.scanPosition;
        if (this.matchTerminal(9, 1016, false) && (this.nodeSubParse.value.equalsIgnoreCase("CROSS") || this.nodeSubParse.value.equalsIgnoreCase("LEFT") || this.nodeSubParse.value.equalsIgnoreCase("RIGHT") || this.nodeSubParse.value.equalsIgnoreCase("FULL") || this.nodeSubParse.value.equalsIgnoreCase("INNER") || this.nodeSubParse.value.equalsIgnoreCase("ON"))) {
            bl = true;
        }
        this.nodeSubParse = baseSQLTreeNode;
        this.scanner.scanPosition = n;
        return bl;
    }

    private boolean parseCorrelationName() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        bl = this.matchIdentifierOrUnknownKeyword(false) ? true : true;
        if (!bl) {
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean parseSearchCondition() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1038);
        int n = this.scanner.scanPosition;
        if (this.parseAlmostAnything(true, false, null)) {
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
            bl = true;
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = baseSQLTreeNode;
        }
        return bl;
    }

    private boolean parseEscapeParameterList() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1007);
        int n = this.scanner.scanPosition;
        if (this.matchLeftParenTerminal()) {
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            if (this.matchRightParenTerminal()) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            } else {
                this.parseEscapeParameters();
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                if (this.matchRightParenTerminal()) {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode;
                    bl = true;
                }
            }
        } else {
            this.nodeSubParse = baseSQLTreeNode;
            bl = true;
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private void parseEscapeParameters() throws SQLException {
        this.nodeSubParse = null;
        this.parseEscapeParameter();
        BaseSQLTreeNode baseSQLTreeNode = this.nodeSubParse;
        if (this.matchCommaTerminal()) {
            baseSQLTreeNode.addNextSibling(this.nodeSubParse);
            this.parseEscapeParameters();
            baseSQLTreeNode.addNextSibling(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
        } else {
            this.nodeSubParse = baseSQLTreeNode;
        }
    }

    private void parseEscapeParameter() throws SQLException {
        this.nodeSubParse = null;
        BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1024);
        this.parseEscapeParameterComponents();
        baseSQLTreeNode.setNextChild(this.nodeSubParse);
        this.nodeSubParse = baseSQLTreeNode;
    }

    private void parseEscapeParameterComponents() throws SQLException {
        this.nodeSubParse = null;
        if (this.matchIdentifierOrUnknownKeyword(true) || this.matchUnknownTokenTerminal() || this.matchStringLiteralTerminal() || this.matchDotTerminal() || this.matchColonTerminal() || this.matchParameterTerminal() || this.matchSemicolonTerminal() || this.matchEqualOperatorTerminal() || this.parseSubQuery() || this.parseEscape() || this.parseParenthesizedExpression()) {
            BaseSQLTreeNode baseSQLTreeNode = this.nodeSubParse;
            this.parseEscapeParameterComponents();
            baseSQLTreeNode.addNextSibling(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
        }
    }

    private void parseRestOfEscape(int n) throws SQLException {
        this.nodeSubParse = null;
        BaseSQLTreeNode baseSQLTreeNode = null;
        int[] nArray = new int[]{8, 10, 12};
        if (this.matchAlmostAnyTokens(nArray)) {
            if (baseSQLTreeNode == null) {
                baseSQLTreeNode = this.nodeSubParse;
            } else {
                baseSQLTreeNode.addNextSibling(this.nodeSubParse);
            }
            this.nodeSubParse = null;
        }
        if (this.matchEndOfStatementTerminal() || this.matchRightBraceTerminal(n)) {
            if (baseSQLTreeNode == null) {
                baseSQLTreeNode = this.nodeSubParse;
            } else {
                baseSQLTreeNode.addNextSibling(this.nodeSubParse);
            }
            this.nodeSubParse = baseSQLTreeNode;
        } else {
            if (!this.parseEscape() && !this.matchParameterTerminal()) {
                this.matchAnyToken();
            }
            if (baseSQLTreeNode == null) {
                baseSQLTreeNode = this.nodeSubParse;
            } else {
                baseSQLTreeNode.addNextSibling(this.nodeSubParse);
            }
            this.parseRestOfEscape(n);
            baseSQLTreeNode.addNextSibling(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
        }
    }

    private boolean matchGroupBy() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        if (this.matchKeywordTerminal("group", false)) {
            BaseSQLTreeNode baseSQLTreeNode = this.nodeSubParse;
            if (this.matchKeywordTerminal("by", false)) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean matchHavingTerminal() throws SQLException {
        return this.matchKeywordTerminal("having", false);
    }

    private boolean matchForTerminal() throws SQLException {
        return this.matchKeywordTerminal("for", false);
    }

    private boolean matchOfTerminal() throws SQLException {
        return this.matchKeywordTerminal("of", false);
    }

    private boolean matchReadTerminal() throws SQLException {
        return this.matchKeywordTerminal("read", false);
    }

    private boolean matchOnlyTerminal() throws SQLException {
        return this.matchKeywordTerminal("only", false);
    }

    private boolean matchOrderByTerminal() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        if (this.matchKeywordTerminal("order", false)) {
            BaseSQLTreeNode baseSQLTreeNode = this.nodeSubParse;
            if (this.matchKeywordTerminal("by", false)) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean matchUnionTerminal() throws SQLException {
        return this.matchKeywordTerminal("union", false);
    }

    private boolean matchIntersectTerminal() throws SQLException {
        return this.matchKeywordTerminal("intersect", false);
    }

    private boolean matchExceptTerminal() throws SQLException {
        return this.matchKeywordTerminal("except", false);
    }

    private boolean matchByTerminal() throws SQLException {
        return this.matchKeywordTerminal("by", false);
    }

    private boolean matchCreateTable() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        if (this.matchKeywordTerminal("create", false)) {
            BaseSQLTreeNode baseSQLTreeNode = this.nodeSubParse;
            if (this.matchKeywordTerminal("table", false)) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean matchSelectTerminal() throws SQLException {
        return this.matchKeywordTerminal("select", false);
    }

    private boolean matchFromTerminal() throws SQLException {
        return this.matchKeywordTerminal("from", false);
    }

    private boolean matchWhereTerminal() throws SQLException {
        return this.matchKeywordTerminal("where", false);
    }

    private boolean matchNotTerminal() throws SQLException {
        return this.matchKeywordTerminal("not", false);
    }

    private boolean matchNullTerminal() throws SQLException {
        return this.matchKeywordTerminal("null", false);
    }

    private boolean matchExistsTerminal() throws SQLException {
        return this.matchKeywordTerminal("exists", false);
    }

    private boolean matchBetweenTerminal() throws SQLException {
        return this.matchKeywordTerminal("between", false);
    }

    private boolean matchLikeTerminal() throws SQLException {
        return this.matchKeywordTerminal("like", false);
    }

    private boolean matchInTerminal() throws SQLException {
        return this.matchKeywordTerminal("in", false);
    }

    private boolean matchAllTerminal() throws SQLException {
        return this.matchKeywordTerminal("all", false);
    }

    private boolean matchCorrespondingTerminal() throws SQLException {
        return this.matchKeywordTerminal("corresponding", false);
    }

    private boolean matchAndTerminal() throws SQLException {
        return this.matchKeywordTerminal("and", false);
    }

    private boolean matchOrTerminal() throws SQLException {
        return this.matchKeywordTerminal("or", false);
    }

    private boolean matchIsTerminal() throws SQLException {
        return this.matchKeywordTerminal("is", false);
    }

    private boolean matchTrueTerminal() throws SQLException {
        return this.matchKeywordTerminal("true", false);
    }

    private boolean matchFalseTerminal() throws SQLException {
        return this.matchKeywordTerminal("false", false);
    }

    private boolean matchUnknownTerminal() throws SQLException {
        return this.matchKeywordTerminal("unknown", false);
    }

    private boolean matchInsertTerminal() throws SQLException {
        return this.matchKeywordTerminal("insert", false);
    }

    private boolean matchDeleteTerminal() throws SQLException {
        return this.matchKeywordTerminal("delete", false);
    }

    private boolean matchSetTerminal() throws SQLException {
        return this.matchKeywordTerminal("set", false);
    }

    private boolean matchIntoTerminal() throws SQLException {
        return this.matchKeywordTerminal("into", false);
    }

    private boolean matchUpdateTerminal() throws SQLException {
        return this.matchKeywordTerminal("update", false);
    }

    private boolean matchValuesTerminal() throws SQLException {
        return this.matchKeywordTerminal("values", false);
    }

    private boolean matchDefaultTerminal() throws SQLException {
        return this.matchKeywordTerminal("default", false);
    }

    private boolean matchOnTerminal() throws SQLException {
        return this.matchKeywordTerminal("ON", false);
    }

    private boolean matchNaturalTerminal() throws SQLException {
        return this.matchKeywordTerminal("NATURAL", false);
    }

    private boolean matchCrossTerminal() throws SQLException {
        return this.matchKeywordTerminal("CROSS", false);
    }

    private boolean matchInnerTerminal() throws SQLException {
        return this.matchKeywordTerminal("INNER", false);
    }

    private boolean matchJoinTerminal() throws SQLException {
        return this.matchKeywordTerminal("JOIN", false);
    }

    private boolean matchUsingTerminal() throws SQLException {
        return this.matchKeywordTerminal("USING", false);
    }

    private boolean matchLeftTerminal() throws SQLException {
        return this.matchKeywordTerminal("left", false);
    }

    private boolean matchRightTerminal() throws SQLException {
        return this.matchKeywordTerminal("right", false);
    }

    private boolean matchFullTerminal() throws SQLException {
        return this.matchKeywordTerminal("full", false);
    }

    private boolean matchOuterTerminal() throws SQLException {
        return this.matchKeywordTerminal("OUTER", false);
    }

    private boolean matchOuterJoinTerminal() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        if (this.matchKeywordTerminal("outer", false)) {
            BaseSQLTreeNode baseSQLTreeNode = this.nodeSubParse;
            if (this.matchKeywordTerminal("join", false)) {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
                bl = true;
            }
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        return bl;
    }

    private boolean matchOjTerminal(int n) throws SQLException {
        boolean bl = this.matchKeywordTerminal("OJ", false);
        if (bl && n == 1) {
            this.nodeSubParse.value = " ";
            this.nodeSubParse.type = 1020;
        }
        return bl;
    }

    private boolean matchCallTerminal() throws SQLException {
        return this.matchKeywordTerminal("CALL", false);
    }

    private boolean matchFnTerminal(int n) throws SQLException {
        boolean bl = this.matchKeywordTerminal("FN", false);
        if (bl && n == 1) {
            this.nodeSubParse.value = " ";
            this.nodeSubParse.type = 1020;
        }
        return bl;
    }

    private boolean matchDTerminal(int n) throws SQLException {
        boolean bl = this.matchKeywordTerminal("D", false);
        if (bl && n == 1) {
            this.nodeSubParse.value = " ";
            this.nodeSubParse.type = 1020;
        }
        return bl;
    }

    private boolean matchTTerminal(int n) throws SQLException {
        boolean bl = this.matchKeywordTerminal("T", false);
        if (bl && n == 1) {
            this.nodeSubParse.value = " ";
            this.nodeSubParse.type = 1020;
        }
        return bl;
    }

    private boolean matchTsTerminal(int n) throws SQLException {
        boolean bl = this.matchKeywordTerminal("TS", false);
        if (bl && n == 1) {
            this.nodeSubParse.value = " ";
            this.nodeSubParse.type = 1020;
        }
        return bl;
    }

    private boolean matchEscapeTerminal() throws SQLException {
        return this.matchKeywordTerminal("ESCAPE", false);
    }

    private boolean matchScalarFunctionNameTerminal() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        BaseSQLToken baseSQLToken = this.scanner.getNextToken();
        if (baseSQLToken.type == 9) {
            int n2 = BaseFunctionEscape.validateScalarFunctionName(baseSQLToken.value);
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(n2, baseSQLToken.value);
            this.matchWhiteSpaceOrComment();
            if (this.nodeSubParse == null) {
                this.nodeSubParse = baseSQLTreeNode;
            } else {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
            }
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean matchStringLiteralTerminal() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        BaseSQLToken baseSQLToken = this.scanner.getNextToken();
        if (baseSQLToken.type == 14) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016, baseSQLToken.value);
            this.matchWhiteSpaceOrComment();
            if (this.nodeSubParse == null) {
                this.nodeSubParse = baseSQLTreeNode;
            } else {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
            }
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean matchIdentifierOrUnknownKeyword(boolean bl) throws SQLException {
        boolean bl2 = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        BaseSQLToken baseSQLToken = this.scanner.getNextToken();
        if (baseSQLToken.type == 9 || baseSQLToken.type == 4) {
            boolean bl3;
            boolean bl4 = (this.processLevel & 8) != 0;
            boolean bl5 = bl3 = (this.processLevel & 0x10) != 0;
            if (!(!bl && (baseSQLToken.value.equalsIgnoreCase("SELECT") || baseSQLToken.value.equalsIgnoreCase("FROM") || baseSQLToken.value.equalsIgnoreCase("WHERE") || baseSQLToken.value.equalsIgnoreCase("GROUP") || baseSQLToken.value.equalsIgnoreCase("ORDER") || baseSQLToken.value.equalsIgnoreCase("UNION") || baseSQLToken.value.equalsIgnoreCase("EXCEPT") || baseSQLToken.value.equalsIgnoreCase("HAVING") || baseSQLToken.value.equalsIgnoreCase("INTERSECT") || baseSQLToken.value.equalsIgnoreCase("VALUES") || baseSQLToken.value.equalsIgnoreCase("LEFT") || baseSQLToken.value.equalsIgnoreCase("RIGHT") || baseSQLToken.value.equalsIgnoreCase("FULL") || baseSQLToken.value.equalsIgnoreCase("FOR") || baseSQLToken.value.equalsIgnoreCase("ON") || baseSQLToken.value.equalsIgnoreCase("UPDATE") || baseSQLToken.value.equalsIgnoreCase("INSERT") || baseSQLToken.value.equalsIgnoreCase("DELETE") || baseSQLToken.value.equalsIgnoreCase("CREATE") || baseSQLToken.value.equalsIgnoreCase("ALTER") || baseSQLToken.value.equalsIgnoreCase("DROP") || bl4 && baseSQLToken.value.equalsIgnoreCase("AND") || bl4 && baseSQLToken.value.equalsIgnoreCase("OR") || bl4 && baseSQLToken.value.equalsIgnoreCase("IS") || bl3 && baseSQLToken.value.equalsIgnoreCase("CROSS") || bl3 && baseSQLToken.value.equalsIgnoreCase("NATURAL") || bl3 && baseSQLToken.value.equalsIgnoreCase("INNER") || bl3 && baseSQLToken.value.equalsIgnoreCase("USING")))) {
                BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016, baseSQLToken.value);
                this.matchWhiteSpaceOrComment();
                if (this.nodeSubParse == null) {
                    this.nodeSubParse = baseSQLTreeNode;
                } else {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode;
                }
                bl2 = true;
            }
        }
        if (!bl2) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl2;
    }

    private boolean matchUnknownTokenTerminal() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        BaseSQLToken baseSQLToken = this.scanner.getNextToken();
        if (baseSQLToken.type == 16) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016, baseSQLToken.value);
            this.matchWhiteSpaceOrComment();
            if (this.nodeSubParse == null) {
                this.nodeSubParse = baseSQLTreeNode;
            } else {
                baseSQLTreeNode.setNextChild(this.nodeSubParse);
                this.nodeSubParse = baseSQLTreeNode;
            }
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private boolean matchTerminal(int n, int n2, boolean bl) throws SQLException {
        boolean bl2 = false;
        this.nodeSubParse = null;
        int n3 = this.scanner.scanPosition;
        BaseSQLToken baseSQLToken = this.scanner.getNextToken();
        if (baseSQLToken.type == n) {
            if (bl) {
                this.scanner.scanPosition = n3;
            } else {
                BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(n2, baseSQLToken.value);
                this.matchWhiteSpaceOrComment();
                if (this.nodeSubParse == null) {
                    this.nodeSubParse = baseSQLTreeNode;
                } else {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode;
                }
            }
            bl2 = true;
        }
        if (!bl2) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n3;
        }
        return bl2;
    }

    private boolean matchSemicolonTerminal() throws SQLException {
        return this.matchTerminal(15, 1016, false);
    }

    private boolean matchColonTerminal() throws SQLException {
        return this.matchTerminal(18, 1016, false);
    }

    private boolean matchEqualOperatorTerminal() throws SQLException {
        return this.matchTerminal(7, 1016, false);
    }

    private boolean matchParameterTerminal() throws SQLException {
        if ((this.processLevel & 1) != 0) {
            return this.matchTerminal(8, 1018, false);
        }
        return false;
    }

    private boolean matchCommaTerminal() throws SQLException {
        return this.matchTerminal(1, 1019, false);
    }

    private boolean matchCompareOpTerminal() throws SQLException {
        if (this.matchTerminal(3, 1019, false)) {
            return true;
        }
        return this.matchEqualOperatorTerminal();
    }

    private boolean matchDotTerminal() throws SQLException {
        return this.matchTerminal(5, 1016, false);
    }

    private boolean matchLeftParenTerminal() throws SQLException {
        return this.matchTerminal(11, 1016, false);
    }

    private boolean matchRightParenTerminal() throws SQLException {
        return this.matchTerminal(13, 1016, false);
    }

    private boolean matchLeftBraceTerminal(int n) throws SQLException {
        boolean bl = this.matchTerminal(10, 1016, false);
        if (bl && n == 1) {
            this.nodeSubParse.value = " ";
            this.nodeSubParse.type = 1020;
        }
        return bl;
    }

    private boolean matchRightBraceTerminal(int n) throws SQLException {
        boolean bl = this.matchTerminal(12, 1016, false);
        if (bl && n == 1) {
            this.nodeSubParse.value = " ";
            this.nodeSubParse.type = 1020;
        }
        return bl;
    }

    private boolean matchEndOfStatementTerminal() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        this.matchWhiteSpaceOrComment();
        BaseSQLToken baseSQLToken = this.scanner.getNextToken();
        if (baseSQLToken.type == 6) {
            this.nodeSubParse = new BaseSQLTreeNode(1016, null);
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl;
    }

    private void matchAnyToken() throws SQLException {
        BaseSQLToken baseSQLToken = this.scanner.getNextToken();
        BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016, baseSQLToken.value);
        this.matchWhiteSpaceOrComment();
        if (this.nodeSubParse == null) {
            this.nodeSubParse = baseSQLTreeNode;
        } else {
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
        }
    }

    private boolean matchKeywordTerminal(String string, boolean bl) throws SQLException {
        boolean bl2 = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        BaseSQLToken baseSQLToken = this.scanner.getNextToken();
        if (baseSQLToken.type == 9 && baseSQLToken.value.equalsIgnoreCase(string)) {
            if (bl) {
                this.scanner.scanPosition = n;
            } else {
                BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1016, baseSQLToken.value);
                this.matchWhiteSpaceOrComment();
                if (this.nodeSubParse == null) {
                    this.nodeSubParse = baseSQLTreeNode;
                } else {
                    baseSQLTreeNode.setNextChild(this.nodeSubParse);
                    this.nodeSubParse = baseSQLTreeNode;
                }
            }
            bl2 = true;
        }
        if (!bl2) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
        return bl2;
    }

    private void matchWhiteSpaceOrComment() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        BaseSQLToken baseSQLToken = this.scanner.getNextToken();
        if (baseSQLToken.type == 17) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1020, baseSQLToken.value);
            this.matchWhiteSpaceOrComment();
            if (this.nodeSubParse != null) {
                baseSQLTreeNode.setRightSibling(this.nodeSubParse);
            }
            this.nodeSubParse = baseSQLTreeNode;
            bl = true;
        } else if (baseSQLToken.type == 2) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(1021, baseSQLToken.value);
            this.matchWhiteSpaceOrComment();
            if (this.nodeSubParse != null) {
                baseSQLTreeNode.setRightSibling(this.nodeSubParse);
            }
            this.nodeSubParse = baseSQLTreeNode;
            bl = true;
        }
        if (!bl) {
            this.nodeSubParse = null;
            this.scanner.scanPosition = n;
        }
    }

    private boolean matchAlmostAnyTokens(int[] nArray) throws SQLException {
        this.nodeSubParse = null;
        StringBuffer stringBuffer = new StringBuffer(128);
        boolean bl = false;
        while (!bl) {
            int n = this.scanner.scanPosition;
            BaseSQLToken baseSQLToken = this.scanner.getNextToken();
            if (baseSQLToken.type == 6) {
                this.scanner.scanPosition = n;
                bl = true;
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != baseSQLToken.type) continue;
                    this.scanner.scanPosition = n;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            stringBuffer.append(baseSQLToken.value);
        }
        if (stringBuffer.length() > 0) {
            this.nodeSubParse = new BaseSQLTreeNode(1016, new String(stringBuffer));
            return true;
        }
        return false;
    }

    private int getEscapeTranslationNeeded(int n) {
        if (n == 8208 && (this.processLevel & 0x10) != 0) {
            return 2;
        }
        if (this.escapeTranslator == null) {
            return 0;
        }
        return this.escapeTranslator.getTranslationNeeded(n);
    }

    private boolean parseCommentInBrace() throws SQLException {
        boolean bl = false;
        this.nodeSubParse = null;
        int n = this.scanner.scanPosition;
        int n2 = 0;
        this.scanner.matchComment = false;
        if (this.matchLeftBraceTerminal(n2)) {
            BaseSQLTreeNode baseSQLTreeNode = new BaseSQLTreeNode(8194);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            this.parseRestOfEscape(n2);
            baseSQLTreeNode.setNextChild(this.nodeSubParse);
            this.nodeSubParse = baseSQLTreeNode;
            baseSQLTreeNode.type = 1016;
            bl = true;
        }
        if (!bl) {
            this.scanner.scanPosition = n;
            this.nodeSubParse = null;
        }
        this.scanner.matchComment = true;
        return bl;
    }

    private boolean supportBraceAsCommentSymbol() {
        if (this.escapeTranslator == null) {
            return false;
        }
        return this.escapeTranslator.supportBraceAsCommentSymbol();
    }
}

